/*
 * Decompiled with CFR 0.152.
 */
package org.das2.math;

import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Event;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import org.das2.math.AppletUI;
import org.das2.math.CubicAlgorithm;
import org.das2.math.QuadraticAlgorithm;
import org.das2.math.QuarticAlgorithm;
import org.das2.math.RealWindow;
import org.das2.math.RealWindowGraphics;
import org.das2.math.Triangulation;
import org.das2.math.TriangulationAlgorithm;

public class Triangulator
extends Applet
implements Runnable {
    Thread[] triangulateThread;
    int nPoints = 10;
    Triangulation[] triangulation;
    TriangulationAlgorithm[] algorithm;
    RealWindow w;
    RealWindowGraphics rWG;
    AppletUI appUI;
    public static final int On2 = 0;
    public static final int On3 = 1;
    public static final int On4 = 2;
    Panel canvases;
    static final int nAlgorithms = 3;

    public void init() {
        int i;
        this.setBackground(Color.lightGray);
        this.resize(600, 350);
        this.w = new RealWindow(0.0f, 0.0f, 1.0f, 1.0f);
        this.triangulation = new Triangulation[3];
        this.triangulation[0] = new Triangulation(this.nPoints);
        this.triangulation[0].randomPoints(this.w);
        for (int i2 = 1; i2 < 3; ++i2) {
            this.triangulation[i2] = new Triangulation(this.nPoints);
            this.triangulation[i2].copyPoints(this.triangulation[0]);
        }
        this.algorithm = new TriangulationAlgorithm[3];
        this.algorithm[0] = new QuadraticAlgorithm(this.triangulation[0], this.w, this.nPoints);
        this.algorithm[1] = new CubicAlgorithm(this.triangulation[1], this.w, this.nPoints);
        this.algorithm[2] = new QuarticAlgorithm(this.triangulation[2], this.w, this.nPoints);
        this.triangulateThread = new Thread[3];
        Panel heading = new Panel();
        heading.setLayout(new BorderLayout());
        heading.add("Center", new Label("The Triangulator", 1));
        Panel algHeadings = new Panel();
        algHeadings.setLayout(new GridLayout(0, 3));
        for (i = 0; i < 3; ++i) {
            algHeadings.add(new Label(this.algorithm[i].algName, 1));
        }
        heading.add("South", algHeadings);
        this.canvases = new Panel();
        this.canvases.setLayout(new GridLayout(0, 3));
        for (i = 0; i < 3; ++i) {
            this.canvases.add(this.algorithm[i].canvas());
        }
        this.setLayout(new BorderLayout());
        this.add("North", heading);
        this.add("Center", this.canvases);
        this.appUI = new AppletUI(this.algorithm);
        this.add("South", this.appUI);
    }

    public void run() {
        String threadName = Thread.currentThread().getName();
        int algNo = Integer.parseInt(threadName.substring(threadName.length() - 1));
        this.algorithm[algNo].triangulate(this.triangulation[algNo]);
    }

    public Insets insets() {
        return new Insets(5, 10, 5, 15);
    }

    private synchronized void startTriangulate() {
        int i;
        for (i = 0; i < this.triangulateThread.length; ++i) {
            if (this.triangulateThread[i] == null || !this.triangulateThread[i].isAlive()) continue;
            this.stop();
        }
        for (i = 0; i < this.triangulateThread.length; ++i) {
            if (!this.algorithm[i].control().getRun()) continue;
            this.triangulateThread[i] = new Thread((Runnable)this, "Triangulation-" + String.valueOf(i));
            this.triangulateThread[i].setPriority(1);
            this.triangulateThread[i].start();
        }
    }

    private synchronized void newPoints() {
        int i;
        this.stop();
        int max = 0;
        int alg = -1;
        for (i = 0; i < 3; ++i) {
            if (!this.algorithm[i].control().getRun() || this.algorithm[i].control().getNPoints() <= max) continue;
            max = this.algorithm[i].control().getNPoints();
            alg = i;
        }
        if (alg != -1) {
            this.triangulation[alg].setNPoints(this.algorithm[alg].control().getNPoints());
            this.triangulation[alg].randomPoints(this.w);
        }
        for (i = 0; i < 3; ++i) {
            if (!this.algorithm[i].control().getRun() || i == alg) continue;
            this.triangulation[i].setNPoints(this.algorithm[i].control().getNPoints());
            this.triangulation[i].copyPoints(this.triangulation[alg]);
        }
        for (i = 0; i < 3; ++i) {
            if (!this.algorithm[i].control().getRun()) continue;
            this.algorithm[i].reset();
            this.algorithm[i].canvas().repaint();
        }
    }

    public synchronized void stop() {
        for (int i = 0; i < this.triangulateThread.length; ++i) {
            if (this.triangulateThread[i] == null) continue;
            try {
                this.triangulateThread[i].stop();
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                // empty catch block
            }
            this.triangulateThread[i] = null;
        }
    }

    int getValue(TextField tF) {
        int i;
        try {
            i = Integer.valueOf(tF.getText());
        }
        catch (NumberFormatException e) {
            i = 0;
        }
        return i;
    }

    public boolean handleEvent(Event evt) {
        if (evt.id == 1001) {
            if ("Start".equals(evt.arg)) {
                this.startTriangulate();
                return true;
            }
            if ("Stop".equals(evt.arg)) {
                this.stop();
                return true;
            }
            if ("New".equals(evt.arg)) {
                this.newPoints();
            } else {
                if ("Manual".equals(evt.arg)) {
                    for (int i = 0; i < 3; ++i) {
                        this.algorithm[i].control().setManualAnimateMode();
                    }
                    return true;
                }
                if ("Auto".equals(evt.arg)) {
                    for (int i = 0; i < 3; ++i) {
                        this.algorithm[i].control().setAutomaticAnimateMode();
                    }
                    return true;
                }
            }
        } else {
            if (evt.id == 501) {
                for (int i = 0; i < 3; ++i) {
                    if (this.algorithm[i].control().mode() != 1) continue;
                    this.algorithm[i].nextStep();
                }
                return true;
            }
            if (evt.id == 503) {
                return true;
            }
        }
        return false;
    }
}

