/*
 * Decompiled with CFR 0.152.
 */
package org.das2.math;

import org.das2.math.TriangulationAlgorithm;

class AnimateControl {
    TriangulationAlgorithm triAlg;
    static final int automatic = 0;
    static final int manual = 1;
    int animateMode = 0;
    int pause = 10;
    static final int algorithm = 0;
    static final int triangles = 1;
    static final int points = 2;
    static final int circles = 3;
    static final int nEntities = 4;
    boolean run;
    boolean[] animate;
    int nPoints;

    AnimateControl(TriangulationAlgorithm algorithm) {
        this.triAlg = algorithm;
        this.animate = new boolean[4];
        for (int i = 0; i < 4; ++i) {
            this.animate[i] = true;
        }
        this.run = true;
    }

    AnimateControl(TriangulationAlgorithm algorithm, int nPoints) {
        this(algorithm);
        this.nPoints = nPoints;
    }

    public void setAnimate(int entity, boolean v) {
        this.animate[entity] = v;
        if (!v) {
            this.triAlg.canvas().needToClear = true;
        }
    }

    public boolean animate(int entity) {
        return this.animate[entity];
    }

    public int mode() {
        return this.animateMode;
    }

    public void setManualAnimateMode() {
        this.animateMode = 1;
    }

    public void setAutomaticAnimateMode() {
        this.animateMode = 0;
    }

    public int getPause() {
        return this.pause;
    }

    public void setPause(int p) {
        this.pause = p;
    }

    public int getNPoints() {
        return this.nPoints;
    }

    public void setNPoints(int n) {
        this.nPoints = n;
    }

    public void setRun(boolean v) {
        this.run = v;
    }

    public boolean getRun() {
        return this.run;
    }
}

