/*
 * Decompiled with CFR 0.152.
 */
package org.das2.graph;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.datum.DatumUtil;
import org.das2.datum.DatumVector;
import org.das2.datum.TimeLocationUnits;
import org.das2.datum.TimeUtil;
import org.das2.datum.Units;
import org.das2.datum.format.DatumFormatter;
import org.das2.datum.format.DatumFormatterFactory;
import org.das2.datum.format.DefaultDatumFormatterFactory;
import org.das2.datum.format.TimeDatumFormatter;
import org.das2.util.DasMath;

public class TickVDescriptor {
    DatumVector tickV;
    DatumVector minorTickV;
    Units units = null;
    DatumFormatter datumFormatter;
    private static final DatumFormatter DEFAULT_LOG_FORMATTER;

    protected TickVDescriptor() {
    }

    public TickVDescriptor(double[] minorTicks, double[] ticks, Units units) {
        this.tickV = DatumVector.newDatumVector(ticks, units);
        this.minorTickV = DatumVector.newDatumVector(minorTicks, units);
        this.units = units;
        this.datumFormatter = DefaultDatumFormatterFactory.getInstance().defaultFormatter();
    }

    public static TickVDescriptor newTickVDescriptor(DatumVector majorTicks, DatumVector minorTicks) {
        Units units = majorTicks.getUnits();
        double[] minor = minorTicks.toDoubleArray(units);
        double[] major = majorTicks.toDoubleArray(units);
        return new TickVDescriptor(minor, major, units);
    }

    public static TickVDescriptor newTickVDescriptor(List majorTicks, List minorTicks) {
        if (majorTicks.size() == 0 && minorTicks.size() == 0) {
            throw new IllegalArgumentException("need at least one major or minor tick");
        }
        Datum d = majorTicks.size() > 0 ? (Datum)majorTicks.get(0) : (Datum)minorTicks.get(0);
        Units u = d.getUnits();
        double[] major = new double[majorTicks.size()];
        for (int i = 0; i < major.length; ++i) {
            major[i] = ((Datum)majorTicks.get(i)).doubleValue(u);
        }
        double[] minor = new double[minorTicks.size()];
        for (int i = 0; i < minor.length; ++i) {
            minor[i] = ((Datum)minorTicks.get(i)).doubleValue(u);
        }
        return new TickVDescriptor(minor, major, u);
    }

    public DatumVector getMajorTicks() {
        return this.tickV;
    }

    public DatumVector getMinorTicks() {
        return this.minorTickV;
    }

    public DatumFormatter getFormatter() {
        return this.datumFormatter;
    }

    public Datum findTick(Datum xDatum, double direction, boolean minor) {
        int i;
        if (this.tickV == null) {
            return xDatum;
        }
        int majorLen = this.tickV.getLength();
        int minorLen = this.minorTickV.getLength();
        double[] ticks = new double[majorLen + minorLen];
        for (i = 0; i < majorLen; ++i) {
            ticks[i] = this.tickV.doubleValue(i, this.units);
        }
        for (i = 0; i < minorLen; ++i) {
            ticks[i + majorLen] = this.minorTickV.doubleValue(i, this.units);
        }
        int iclose = 0;
        double close = Double.MAX_VALUE;
        double x = xDatum.doubleValue(this.units);
        for (int i2 = 0; i2 < ticks.length; ++i2) {
            if (direction < 0.0 && ticks[i2] < x && x - ticks[i2] < close) {
                iclose = i2;
                close = x - ticks[i2];
            } else if (direction > 0.0 && x < ticks[i2] && ticks[i2] - x < close) {
                iclose = i2;
                close = ticks[i2] - x;
            }
            if (direction != 0.0 || !(Math.abs(ticks[i2] - x) < close)) continue;
            iclose = i2;
            close = Math.abs(ticks[i2] - x);
        }
        return Datum.create(ticks[iclose], this.units);
    }

    public DatumRange enclosingRange(DatumRange dr, boolean minor) {
        Datum s2;
        Datum s1 = this.findTick(dr.min(), 0.0, minor);
        if (s1.equals(s2 = this.findTick(dr.max(), 0.0, minor))) {
            s1 = this.findTick(dr.min(), -1.0, true);
            s2 = this.findTick(dr.max(), 1.0, true);
        }
        return new DatumRange(s1, s2);
    }

    public void setFormatter(DatumFormatter datumFormatter) {
        this.datumFormatter = datumFormatter;
    }

    public String toString() {
        String s = "tickV=" + this.getMajorTicks();
        s = s + ",minor=" + this.getMinorTicks();
        return s;
    }

    public static TickVDescriptor bestTickVLinear(Datum min, Datum max, int nTicksMin, int nTicksMax, boolean fin) {
        double mag;
        int targetTicks;
        TickVDescriptor res = new TickVDescriptor();
        res.units = min.getUnits();
        double minimum = min.doubleValue(res.units);
        double maximum = max.doubleValue(res.units);
        double maj = (maximum - minimum) / (double)((targetTicks = Math.max(Math.min(6, nTicksMax), nTicksMin)) - 1);
        double absissa = maj / (mag = DasMath.exp10(Math.floor(DasMath.log10(maj))));
        if (absissa < 1.666) {
            absissa = 1.0;
        } else if (absissa < 3.333) {
            absissa = 2.0;
        } else if (absissa < 9.0) {
            absissa = 5.0;
        } else {
            absissa = 1.0;
            mag *= 10.0;
        }
        double axisLengthData = maximum - minimum;
        int minorPerMajor = absissa == 5.0 ? 5 : (absissa == 2.0 ? 2 : 10);
        double minorTickSize = absissa * mag / (double)minorPerMajor;
        double majorTickSize = minorTickSize * (double)minorPerMajor;
        double firstTick = majorTickSize * Math.ceil((minimum - axisLengthData) / majorTickSize - 0.01);
        double lastTick = majorTickSize * Math.floor((maximum + axisLengthData) / majorTickSize + 0.01);
        int nTicks = 1 + (int)Math.round((lastTick - firstTick) / majorTickSize);
        double[] result = new double[nTicks];
        for (int i = 0; i < nTicks; ++i) {
            result[i] = firstTick + (double)(i * minorPerMajor) * minorTickSize;
        }
        res.tickV = DatumVector.newDatumVector(result, res.units);
        int ifirst = nTicks / 3;
        int ilast = 2 * nTicks / 3;
        res.datumFormatter = DatumUtil.bestFormatter(res.units.createDatum(result[ifirst]), res.units.createDatum(result[ilast]), ilast - ifirst);
        double firstMinor = firstTick;
        double lastMinor = lastTick;
        int nMinor = (int)((lastMinor - firstMinor) / minorTickSize + 0.5);
        double[] minorTickV = new double[nMinor];
        for (int i = 0; i < nMinor; ++i) {
            minorTickV[i] = firstMinor + (double)i * minorTickSize;
        }
        res.minorTickV = DatumVector.newDatumVector(minorTickV, res.units);
        return res;
    }

    public static TickVDescriptor bestTickVLogNew(Datum minD, Datum maxD, int nTicksMin, int nTicksMax, boolean fin) {
        int i;
        TickVDescriptor ticks = new TickVDescriptor();
        ticks.units = minD.getUnits();
        double min = minD.doubleValue(ticks.units);
        double max = maxD.doubleValue(ticks.units);
        if (max <= 0.0) {
            max = 100.0;
        }
        if (min <= 0.0) {
            min = max / 1000.0;
        }
        double logMin = DasMath.log10(min);
        double logMax = DasMath.log10(max);
        int ntick0 = (int)(Math.floor(logMax * 0.999) - Math.ceil(logMin * 1.001) + 1.0);
        if (ntick0 < 2) {
            int ii;
            TickVDescriptor result = TickVDescriptor.bestTickVLinear(minD, maxD, nTicksMin, nTicksMax, fin);
            DatumVector majortics = result.getMajorTicks();
            Units u = majortics.getUnits();
            for (ii = 0; ii < majortics.getLength() && majortics.get(ii).doubleValue(u) <= 0.0; ++ii) {
            }
            majortics = majortics.getSubVector(ii, majortics.getLength());
            DatumVector minortics = result.getMinorTicks();
            while (ii < minortics.getLength() && minortics.get(ii).doubleValue(u) <= 0.0) {
                ++ii;
            }
            minortics = minortics.getSubVector(ii, minortics.getLength());
            DatumFormatter df = result.datumFormatter;
            result = TickVDescriptor.newTickVDescriptor(majortics, minortics);
            result.datumFormatter = df;
            return result;
        }
        if (ntick0 > nTicksMax) {
            double[] minorTickV;
            Units units = minD.getUnits();
            Datum logMinD = units.createDatum(DasMath.log10(min));
            Datum logMaxD = units.createDatum(DasMath.log10(max));
            TickVDescriptor linTicks = TickVDescriptor.bestTickVLinear(logMinD, logMaxD, nTicksMin, nTicksMax, fin);
            double[] tickV = linTicks.tickV.toDoubleArray(linTicks.units);
            int i2 = 0;
            for (int i3 = 0; i3 < tickV.length; ++i3) {
                if (tickV[i3] % 1.0 != 0.0) continue;
                tickV[i2++] = DasMath.exp10(tickV[i3]);
            }
            double[] t = tickV;
            tickV = new double[i2];
            for (int i4 = 0; i4 < i2; ++i4) {
                tickV[i4] = t[i4];
            }
            int idx = 0;
            if (tickV[1] / tickV[0] <= 10.00001) {
                minorTickV = new double[(tickV.length + 1) * 9];
                for (int j = 2; j < 10; ++j) {
                    minorTickV[idx++] = (double)j * (tickV[0] / 10.0);
                }
                for (int i5 = 0; i5 < tickV.length; ++i5) {
                    for (int j = 2; j < 10; ++j) {
                        minorTickV[idx++] = (double)j * tickV[i5];
                    }
                }
            } else {
                minorTickV = linTicks.minorTickV.toDoubleArray(linTicks.units);
                for (int i6 = 0; i6 < minorTickV.length; ++i6) {
                    minorTickV[i6] = DasMath.exp10(minorTickV[i6]);
                }
            }
            linTicks.tickV = DatumVector.newDatumVector(tickV, linTicks.units);
            linTicks.minorTickV = DatumVector.newDatumVector(minorTickV, linTicks.units);
            linTicks.datumFormatter = DEFAULT_LOG_FORMATTER;
            return linTicks;
        }
        double min3 = min / (max / min);
        double max3 = max * (max / min);
        double dMinTick = DasMath.roundNFractionalDigits(DasMath.log10(min3), 4);
        int minTick = (int)Math.ceil(dMinTick);
        double dMaxTick = DasMath.roundNFractionalDigits(DasMath.log10(max3), 4);
        int maxTick = (int)Math.floor(dMaxTick);
        int nTicks = maxTick - minTick + 1;
        double[] major = new double[nTicks];
        for (int i7 = 0; i7 < nTicks; ++i7) {
            major[i7] = i7 + minTick;
        }
        double[] minors = new double[]{2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0};
        ticks.datumFormatter = DEFAULT_LOG_FORMATTER;
        int firstMinorTickCycle = (int)Math.floor(DasMath.log10(min3));
        int lastMinorTickCycle = (int)Math.floor(DasMath.log10(max3));
        double[] minorTickV = null;
        int idx = 0;
        minorTickV = new double[(lastMinorTickCycle - firstMinorTickCycle + 1) * minors.length];
        for (i = firstMinorTickCycle; i <= lastMinorTickCycle; ++i) {
            for (int j = 0; j < minors.length; ++j) {
                minorTickV[idx++] = DasMath.exp10(i) * minors[j];
            }
        }
        ticks.minorTickV = DatumVector.newDatumVector(minorTickV, ticks.units);
        for (i = 0; i < major.length; ++i) {
            major[i] = DasMath.exp10(major[i]);
        }
        ticks.tickV = DatumVector.newDatumVector(major, ticks.units);
        return ticks;
    }

    private static int getMantissa(int sizeLimit, int unitsPerDecade, int exclude) {
        int[] tt = new int[]{1, 2, 3, 5, 6, 10, 12, 15, 20, 25, 30, 45, 60, 90, 100, 200, 500, 1000, 2000, 5000, 10000};
        int biggest = 1;
        for (int i = 0; i < tt.length && tt[i] <= sizeLimit; ++i) {
            if (unitsPerDecade % tt[i] != 0 || exclude != 0 && tt[i] % exclude == 0) continue;
            biggest = tt[i];
        }
        return biggest;
    }

    private static List getMantissas(int divisionsPerDecade, int exclude, int include) {
        int[] tt = new int[]{1, 2, 3, 5, 6, 10, 12, 15, 20, 25, 30, 45, 60, 90, 100, 200, 500, 1000, 2000, 5000, 10000};
        boolean biggest = true;
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (int i = 0; i < tt.length && tt[i] < divisionsPerDecade; ++i) {
            boolean excl;
            boolean incl = include != 0 && tt[i] % include == 0;
            boolean bl = excl = exclude != 0 && tt[i] % exclude == 0;
            if (excl && !incl || divisionsPerDecade % tt[i] != 0) continue;
            result.add(new Integer(tt[i]));
        }
        return result;
    }

    private static TickVDescriptor countOffTicks2(Datum minD, Datum maxD, TimeUtil.TimeDigit units, TimeUtil.TimeDigit biggerUnits, int biggerUnitsCount, long unitLengthNanos, int mantissa, boolean fin) {
        Datum first;
        DatumRange range = new DatumRange(minD, maxD);
        Datum majorTickLength = Units.nanoseconds.createDatum(unitLengthNanos * (long)mantissa);
        if (units == TimeUtil.TD_YEAR) {
            int iyear = TimeUtil.toTimeArray(minD)[0];
            iyear = iyear / biggerUnitsCount * biggerUnitsCount;
            first = TimeUtil.createTimeDatum(iyear, 1, 1, 0, 0, 0, 0);
        } else {
            int[] digits = TimeUtil.toTimeArray(minD);
            first = TimeUtil.prev(units.getOrdinal() - 1, minD);
        }
        Datum next = TimeUtil.next(biggerUnits.getOrdinal(), first);
        for (int i = 1; i < biggerUnitsCount; ++i) {
            next = TimeUtil.next(biggerUnits.getOrdinal(), next);
        }
        next = next.subtract(majorTickLength.divide(2.0));
        ArrayList<Datum> majorTicks = new ArrayList<Datum>();
        ArrayList<Datum> minorTicks = new ArrayList<Datum>();
        Datum d = first;
        TimeUtil.TimeDigit minorUnits = units;
        int minorMantissa = 1;
        TimeUtil.TimeDigit majorUnits = units;
        int majorMantissa = mantissa;
        if (majorMantissa == 1) {
            minorUnits = TimeUtil.TimeDigit.fromOrdinal(majorUnits.getOrdinal() + 1);
            minorMantissa = majorUnits == TimeUtil.TD_MONTH ? 10 : majorUnits.divisions() / 4;
        }
        Datum nextMajorTick = TimeUtil.next(majorUnits, majorMantissa, d);
        if (minorMantissa == 0) {
            throw new RuntimeException("minorMantissa==0");
        }
        while (d.le(maxD)) {
            while (d.le(next)) {
                if (DatumRangeUtil.sloppyContains(range, d)) {
                    majorTicks.add(d);
                }
                nextMajorTick = TimeUtil.next(majorUnits, majorMantissa, d);
                while (d.lt(nextMajorTick)) {
                    if (DatumRangeUtil.sloppyContains(range, d)) {
                        minorTicks.add(d);
                    }
                    d = TimeUtil.next(minorUnits, minorMantissa, d);
                }
            }
            next = next.add(majorTickLength.divide(2.0));
            while (d.le(next)) {
                while (d.lt(nextMajorTick)) {
                    if (DatumRangeUtil.sloppyContains(range, d) && d.lt(next)) {
                        minorTicks.add(d);
                    }
                    d = TimeUtil.next(minorUnits, minorMantissa, d);
                }
                nextMajorTick = TimeUtil.next(majorUnits, majorMantissa, d);
            }
            d = next;
            next = TimeUtil.next(majorUnits, majorMantissa, next);
            next = next.subtract(majorTickLength.divide(2.0));
        }
        return TickVDescriptor.newTickVDescriptor(majorTicks, minorTicks);
    }

    private static boolean checkMono(DatumVector ticks) {
        Datum d = ticks.get(0);
        for (int i = 1; i < ticks.getLength(); ++i) {
            if (ticks.get(i).lt(d)) {
                return false;
            }
            d = ticks.get(i);
        }
        return true;
    }

    public static TickVDescriptor bestTickVTimeOrdinal(Datum minD, Datum maxD, int nTicksMin, int nTicksMax, boolean fin) {
        int lessThanIndex;
        Datum lengthMin = maxD.subtract(minD).divide(nTicksMax + 1);
        Datum lengthMax = maxD.subtract(minD).divide(Math.max(1, nTicksMin - 1));
        long lengthNanosMax = (long)lengthMax.doubleValue(Units.nanoseconds);
        double lengthDaysMax = lengthMax.doubleValue(Units.days);
        long lengthNanosMin = (long)lengthMin.doubleValue(Units.nanoseconds);
        double lengthDaysMin = lengthMin.doubleValue(Units.days);
        TimeUtil.TimeDigit[] units = new TimeUtil.TimeDigit[]{TimeUtil.TD_NANO, TimeUtil.TD_SECOND, TimeUtil.TD_MINUTE, TimeUtil.TD_HOUR, TimeUtil.TD_DAY, TimeUtil.TD_MONTH, TimeUtil.TD_YEAR};
        long[] lengths = new long[]{1L, 1000000000L, 60000000000L, 3600000000000L, 86400000000000L, 2592000000000000L, 31536000000000000L};
        int[] excludeFactors = new int[]{0, 6, 6, 0, 3, 0, 0};
        int[] includeFactors = new int[]{0, 30, 30, 0, 15, 0, 0};
        for (lessThanIndex = 0; lessThanIndex < units.length && lengths[lessThanIndex] < lengthNanosMax; ++lessThanIndex) {
        }
        int biggestUnitIndex = --lessThanIndex;
        for (lessThanIndex = 0; lessThanIndex < units.length && lengths[lessThanIndex] < lengthNanosMin; ++lessThanIndex) {
        }
        int smallestUnitIndex = --lessThanIndex;
        TickVDescriptor bestTickV = null;
        TickVDescriptor secondBestTickV = null;
        TimeUtil.TimeDigit bestUnit = null;
        TimeUtil.TimeDigit secondBestUnit = null;
        block2: for (int iunit = smallestUnitIndex; bestTickV == null && iunit <= biggestUnitIndex; ++iunit) {
            List mantissas;
            int factors;
            TimeUtil.TimeDigit biggerUnits = units[lessThanIndex] == TimeUtil.TD_YEAR ? TimeUtil.TD_YEAR : units[lessThanIndex + 1];
            if (units[iunit] != TimeUtil.TD_YEAR) {
                factors = (int)(lengths[iunit + 1] / lengths[iunit]);
                mantissas = TickVDescriptor.getMantissas(factors, excludeFactors[lessThanIndex], includeFactors[lessThanIndex]);
            } else {
                factors = 10;
                mantissas = TickVDescriptor.getMantissas(factors, excludeFactors[lessThanIndex], includeFactors[lessThanIndex]);
            }
            for (int imant = 0; imant < mantissas.size(); ++imant) {
                int nticks;
                int mantissa = (Integer)mantissas.get(imant);
                int biggerUnitsCount = units[iunit] == biggerUnits ? mantissa : 1;
                DatumRange visibleRange = new DatumRange(minD, maxD);
                DatumRange ticksRange = fin ? DatumRangeUtil.rescale(visibleRange, -1.0, 2.0) : visibleRange;
                TickVDescriptor test = TickVDescriptor.countOffTicks2(ticksRange.min(), ticksRange.max(), units[iunit], biggerUnits, biggerUnitsCount, lengths[lessThanIndex], mantissa, fin);
                int n = nticks = fin ? test.tickV.getLength() / 3 : test.tickV.getLength();
                if (nticks <= nTicksMax && nticks >= nTicksMin) {
                    bestTickV = test;
                    bestUnit = units[iunit];
                    continue block2;
                }
                if (nticks < nTicksMin) continue;
                secondBestTickV = test;
                secondBestUnit = units[iunit];
            }
        }
        if (bestTickV == null) {
            bestUnit = secondBestUnit;
            bestTickV = secondBestTickV;
        }
        TickVDescriptor ticks = bestTickV;
        if (bestUnit == null) {
            throw new IllegalArgumentException("failed to find best unit");
        }
        ticks.datumFormatter = TimeDatumFormatter.formatterForScale(bestUnit.getOrdinal(), new DatumRange(minD, maxD));
        return ticks;
    }

    public static TickVDescriptor bestTickVTime(Datum minD, Datum maxD, int nTicksMin, int nTicksMax, boolean fin) {
        Datum length = maxD.subtract(minD);
        Datum minute = Datum.create(60.0, Units.seconds);
        if (maxD.subtract(minD).lt(minute)) {
            Datum base = TimeUtil.prevMidnight(minD);
            Units offUnits = Units.seconds;
            Datum offMin = minD.subtract(base).convertTo(offUnits);
            Datum offMax = maxD.subtract(base).convertTo(offUnits);
            TickVDescriptor offTicks = TickVDescriptor.bestTickVLinear(offMin, offMax, nTicksMin, nTicksMax, fin);
            DatumVector minorTicks = offTicks.getMinorTicks().add(base);
            DatumVector majorTicks = offTicks.getMajorTicks().add(base);
            TickVDescriptor result = TickVDescriptor.newTickVDescriptor(majorTicks, minorTicks);
            result.datumFormatter = DatumUtil.bestFormatter(majorTicks);
            return result;
        }
        if (maxD.subtract(minD).gt(Datum.create(3650, Units.days))) {
            int yearMin = TimeUtil.toTimeStruct((Datum)minD).year;
            int yearMax = TimeUtil.toTimeStruct((Datum)maxD).year;
            TickVDescriptor yearTicks = TickVDescriptor.bestTickVLinear(Units.dimensionless.createDatum(yearMin), Units.dimensionless.createDatum(yearMax), nTicksMin, nTicksMax, fin);
            yearTicks.units = minD.getUnits();
            double[] tickV = yearTicks.tickV.toDoubleArray(Units.dimensionless);
            for (int i = 0; i < tickV.length; ++i) {
                int iyear = (int)tickV[i];
                tickV[i] = TimeUtil.convert(iyear, 1, 1, 0, 0, 0.0, (TimeLocationUnits)yearTicks.units);
            }
            yearTicks.tickV = DatumVector.newDatumVector(tickV, yearTicks.units);
            double[] minorTickV = yearTicks.minorTickV.toDoubleArray(Units.dimensionless);
            for (int i = 0; i < minorTickV.length; ++i) {
                int iyear = (int)minorTickV[i];
                minorTickV[i] = TimeUtil.convert(iyear, 1, 1, 0, 0, 0.0, (TimeLocationUnits)yearTicks.units);
            }
            yearTicks.minorTickV = DatumVector.newDatumVector(minorTickV, yearTicks.units);
            Datum t1 = yearTicks.getMajorTicks().get(0);
            int nticks = yearTicks.getMajorTicks().getLength();
            Datum t2 = yearTicks.getMajorTicks().get(nticks - 1);
            yearTicks.datumFormatter = DatumUtil.bestTimeFormatter(t1, t2, nticks);
            return yearTicks;
        }
        return TickVDescriptor.bestTickVTimeOrdinal(minD, maxD, nTicksMin, nTicksMax, fin);
    }

    static {
        try {
            DatumFormatterFactory factory = DefaultDatumFormatterFactory.getInstance();
            DEFAULT_LOG_FORMATTER = factory.newFormatter("0E0");
        }
        catch (ParseException pe) {
            throw new RuntimeException(pe);
        }
    }
}

