/*
 * Decompiled with CFR 0.152.
 */
package org.das2.graph;

import java.awt.EventQueue;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FileOutputStream;
import java.util.logging.Logger;
import javax.swing.JFileChooser;
import org.das2.DasApplication;
import org.das2.DasException;
import org.das2.components.propertyeditor.Editable;
import org.das2.dataset.DataSet;
import org.das2.dataset.DataSetConsumer;
import org.das2.dataset.DataSetDescriptor;
import org.das2.dataset.NoDataInIntervalException;
import org.das2.dataset.TableDataSet;
import org.das2.dataset.TableUtil;
import org.das2.dataset.VectorDataSet;
import org.das2.dataset.VectorUtil;
import org.das2.graph.DasAxis;
import org.das2.graph.DasPlot;
import org.das2.graph.DasRendererUpdateEvent;
import org.das2.graph.DataLoader;
import org.das2.graph.XAxisDataLoader;
import org.das2.system.DasLogger;
import org.das2.util.DasExceptionHandler;
import org.das2.util.monitor.ProgressMonitor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class Renderer
implements DataSetConsumer,
Editable {
    String dataSetId;
    protected DataSet ds;
    private DasAxis.Memento xmemento;
    private DasAxis.Memento ymemento;
    DasPlot parent;
    DataLoader loader;
    private Exception lastException;
    protected static Logger logger = DasLogger.getLogger(DasLogger.GRAPHICS_LOG);
    private String PROPERTY_ACTIVE = "active";
    private String PROPERTY_DATASET = "dataSet";
    private boolean dumpDataSet;
    private boolean overloading = false;
    private boolean active = true;
    protected PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    protected Renderer(DataSetDescriptor dsd) {
        this.loader = new XAxisDataLoader(this, dsd);
    }

    protected Renderer(DataSet ds) {
        this.ds = ds;
        this.loader = null;
    }

    protected Renderer() {
        this((DataSetDescriptor)null);
    }

    public DasPlot getParent() {
        return this.parent;
    }

    protected void invalidateParentCacheImage() {
        if (this.parent != null) {
            this.parent.invalidateCacheImage();
        }
    }

    public DataSet getDataSet() {
        return this.ds;
    }

    public DataSet getConsumedDataSet() {
        return this.ds;
    }

    public boolean isDumpDataSet() {
        return this.dumpDataSet;
    }

    public void setDumpDataSet(boolean dumpDataSet) {
        this.dumpDataSet = dumpDataSet;
        if (dumpDataSet) {
            try {
                if (this.ds == null) {
                    this.setDumpDataSet(false);
                    throw new DasException("data set is null");
                }
                JFileChooser chooser = new JFileChooser();
                int xx = chooser.showSaveDialog(this.getParent());
                if (xx == 0) {
                    File file = chooser.getSelectedFile();
                    if (this.ds instanceof TableDataSet) {
                        TableUtil.dumpToAsciiStream((TableDataSet)this.ds, new FileOutputStream(file));
                    } else if (this.ds instanceof VectorDataSet) {
                        VectorUtil.dumpToAsciiStream((VectorDataSet)this.ds, new FileOutputStream(file));
                    } else {
                        throw new DasException("don't know how to serialize data set: " + this.ds);
                    }
                }
                this.setDumpDataSet(false);
            }
            catch (Exception e) {
                DasExceptionHandler.handle(e);
            }
            this.dumpDataSet = dumpDataSet;
        }
    }

    public void setLastException(Exception e) {
        this.lastException = e;
    }

    public Exception getLastException() {
        return this.lastException;
    }

    public void setDataSet(DataSet ds) {
        logger.finer("Renderer.setDataSet: " + ds);
        DataSet oldDs = this.ds;
        if (oldDs != ds) {
            this.ds = ds;
            this.refresh();
            this.invalidateParentCacheImage();
            this.propertyChangeSupport.firePropertyChange(this.PROPERTY_DATASET, oldDs, ds);
        }
    }

    public void setException(Exception e) {
        logger.finer("Renderer.setException: " + e);
        Exception oldException = this.lastException;
        this.lastException = e;
        if (this.parent != null && oldException != e) {
            this.refresh();
            this.invalidateParentCacheImage();
        }
    }

    public void setDataSetID(String id) throws DasException {
        if (id == null) {
            throw new NullPointerException("Null dataPath not allowed");
        }
        if (id.equals("")) {
            this.setDataSetDescriptor(null);
            return;
        }
        try {
            DataSetDescriptor dsd = DataSetDescriptor.create(id);
            this.setDataSetDescriptor(dsd);
        }
        catch (DasException ex) {
            ex.printStackTrace();
            throw ex;
        }
    }

    public String getDataSetID() {
        if (this.getDataSetDescriptor() == null) {
            return "";
        }
        return this.getDataSetDescriptor().getDataSetID();
    }

    protected AffineTransform getAffineTransform(DasAxis xAxis, DasAxis yAxis) {
        if (this.xmemento == null) {
            logger.fine("unable to calculate AT, because old transform is not defined.");
            return null;
        }
        AffineTransform at = new AffineTransform();
        at = xAxis.getAffineTransform(this.xmemento, at);
        at = yAxis.getAffineTransform(this.ymemento, at);
        return at;
    }

    public abstract void render(Graphics var1, DasAxis var2, DasAxis var3, ProgressMonitor var4);

    public boolean acceptContext(int x, int y) {
        return false;
    }

    protected void renderException(Graphics g, DasAxis xAxis, DasAxis yAxis, Exception e) {
        String message;
        String s;
        FontMetrics fm = g.getFontMetrics();
        if (e instanceof NoDataInIntervalException) {
            s = "no data in interval";
            message = e.getMessage();
        } else {
            s = e.getMessage();
            message = "";
            if (s == null || s.length() < 10) {
                s = e.toString();
            }
        }
        if (!message.equals("")) {
            s = s + ":!c" + message;
        }
        this.parent.postMessage(this, s, 2, null, null);
    }

    public void updatePlotImage(DasAxis xAxis, DasAxis yAxis, ProgressMonitor monitor) throws DasException {
    }

    protected void refreshImage() {
        if (this.getParent() != null) {
            this.refresh();
        }
    }

    public void update() {
        if (this.getParent() != null) {
            this.getParent().repaint();
        }
        logger.fine("Renderer.update");
        if (this.parent != null) {
            EventQueue eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
            DasRendererUpdateEvent drue = new DasRendererUpdateEvent(this.parent, this);
            eventQueue.postEvent(drue);
        } else {
            logger.fine("update but parent was null");
        }
    }

    protected void updateImmediately() {
        logger.finer("entering Renderer.updateImmediately");
        if (this.parent == null || !this.parent.isDisplayable()) {
            return;
        }
        if (this.loader != null) {
            this.loader.update();
        }
        this.refresh();
    }

    protected void refresh() {
        if (!this.isActive()) {
            return;
        }
        logger.fine("entering Renderer.refresh");
        if (this.parent == null) {
            logger.fine("null parent in refresh");
            return;
        }
        if (!this.parent.isDisplayable()) {
            logger.fine("parent not displayable");
            return;
        }
        Runnable run = new Runnable(){

            public void run() {
                logger.fine("update plot image");
                try {
                    if (Renderer.this.parent == null) {
                        return;
                    }
                    ProgressMonitor progressPanel = DasApplication.getDefaultApplication().getMonitorFactory().getMonitor(Renderer.this.parent, "Rebinning data set", "updatePlotImage");
                    Renderer.this.updatePlotImage(Renderer.this.parent.getXAxis(), Renderer.this.parent.getYAxis(), progressPanel);
                    Renderer.this.xmemento = Renderer.this.parent.getXAxis().getMemento();
                    Renderer.this.ymemento = Renderer.this.parent.getYAxis().getMemento();
                    Renderer.this.lastException = null;
                }
                catch (DasException de) {
                    logger.warning("exception: " + de);
                    Renderer.this.ds = null;
                }
                catch (RuntimeException re) {
                    logger.warning("exception: " + re);
                    re.printStackTrace();
                    Renderer.this.parent.invalidateCacheImage();
                    Renderer.this.parent.repaint();
                    throw re;
                }
                logger.fine("invalidate parent cacheImage and repaint");
                Renderer.this.parent.invalidateCacheImage();
                Renderer.this.parent.repaint();
            }
        };
        boolean async = false;
        if (EventQueue.isDispatchThread()) {
            if (async) {
                new Thread(run, "updatePlotImage").start();
            } else {
                run.run();
            }
        } else {
            run.run();
        }
    }

    public void setDataSetDescriptor(DataSetDescriptor dsd) {
        if (this.loader == null) {
            logger.warning("installing loader--danger!");
            this.loader = new XAxisDataLoader(this, dsd);
        }
        if (this.loader instanceof XAxisDataLoader) {
            ((XAxisDataLoader)this.loader).setDataSetDescriptor(dsd);
            if (this.parent != null) {
                this.parent.markDirty();
                this.parent.update();
            }
        } else {
            throw new RuntimeException("loader is not based on DataSetDescriptor");
        }
        this.ds = null;
    }

    public DataLoader getDataLoader() {
        return this.loader;
    }

    public void setDataSetLoader(DataLoader loader) {
        this.loader = loader;
        if (loader != null) {
            loader.update();
        }
    }

    public DataSetDescriptor getDataSetDescriptor() {
        if (this.loader == null) {
            return null;
        }
        if (this.loader instanceof XAxisDataLoader) {
            return ((XAxisDataLoader)this.loader).getDataSetDescriptor();
        }
        return null;
    }

    protected void installRenderer() {
    }

    protected void uninstallRenderer() {
    }

    protected Element getDOMElement(Document document) {
        return null;
    }

    public boolean isOverloading() {
        return this.overloading;
    }

    public void setOverloading(boolean overloading) {
        this.overloading = overloading;
        this.update();
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        boolean oldValue = this.active;
        this.active = active;
        this.propertyChangeSupport.firePropertyChange(this.PROPERTY_ACTIVE, oldValue, active);
        this.update();
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.removePropertyChangeListener(l);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }
}

