/*
 * Decompiled with CFR 0.152.
 */
package org.das2.graph;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.das2.dataset.VectorDataSet;
import org.das2.datum.Units;
import org.das2.graph.DasAxis;
import org.das2.graph.DasColorBar;
import org.das2.graph.DefaultPlotSymbol;
import org.das2.graph.FillStyle;
import org.das2.graph.PlotSymbol;
import org.das2.graph.Renderer;
import org.das2.util.monitor.ProgressMonitor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PlotSymbolRenderer
extends Renderer {
    Image psymImage;
    Image[] coloredPsyms;
    int cmx;
    int cmy;
    private PlotSymbol psym = DefaultPlotSymbol.CIRCLES;
    public static final String PROP_PSYM = "psym";
    private double symsize = 1.0;
    public static final String PROP_SYMSIZE = "symSize";
    private Color color = Color.BLACK;
    public static final String PROP_COLOR = "color";
    private String colorByDataSetId;
    public static final String PROP_COLORBYDATASETID = "colorByDataSetId";
    public static final String PROP_COLORBAR = "colorBar";
    private DasColorBar colorBar;

    public PlotSymbolRenderer() {
        this.updatePsym();
    }

    public void render(Graphics g, DasAxis xAxis, DasAxis yAxis, ProgressMonitor mon) {
        VectorDataSet vds = (VectorDataSet)this.getDataSet();
        if (vds == null) {
            return;
        }
        Units yunits = vds.getYUnits();
        Units xunits = vds.getXUnits();
        VectorDataSet colorByDataSet = null;
        if (this.colorByDataSetId != null) {
            colorByDataSet = (VectorDataSet)vds.getPlanarView(this.colorByDataSetId);
        }
        if (this.colorBar != null && colorByDataSet != null) {
            Units cunits = this.colorBar.getUnits();
            for (int i = 0; i < vds.getXLength(); ++i) {
                double yy = vds.getDouble(i, yunits);
                if (!yunits.isValid(yy)) continue;
                double xx = xAxis.transform(vds.getXTagDouble(i, xunits), xunits);
                yy = yAxis.transform(yy, yunits);
                int icolor = this.colorBar.indexColorTransform(colorByDataSet.getDouble(i, cunits), cunits);
                g.drawImage(this.coloredPsyms[icolor], (int)xx - this.cmx, (int)yy - this.cmy, this.parent);
            }
        } else {
            for (int i = 0; i < vds.getXLength(); ++i) {
                double yy = vds.getDouble(i, yunits);
                if (!yunits.isValid(yy)) continue;
                double xx = xAxis.transform(vds.getXTagDouble(i, xunits), xunits);
                yy = yAxis.transform(yy, yunits);
                g.drawImage(this.psymImage, (int)xx - this.cmx, (int)yy - this.cmy, this.parent);
            }
        }
    }

    private void updatePsym() {
        BufferedImage image = new BufferedImage((int)this.symsize, (int)this.symsize, 2);
        Graphics2D g = (Graphics2D)image.getGraphics();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(this.color);
        this.cmx = (int)(this.symsize / 2.0);
        this.cmy = (int)(this.symsize / 2.0);
        this.psym.draw(g, this.symsize / 2.0, this.symsize / 2.0, (float)this.symsize, FillStyle.STYLE_FILL);
        this.psymImage = image;
        if (this.colorBar != null) {
            IndexColorModel model = this.colorBar.getIndexColorModel();
            this.coloredPsyms = new Image[model.getMapSize()];
            for (int i = 0; i < model.getMapSize(); ++i) {
                Color c = new Color(model.getRGB(i));
                image = new BufferedImage((int)this.symsize, (int)this.symsize, 2);
                g = (Graphics2D)image.getGraphics();
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g.setColor(c);
                this.psym.draw(g, this.symsize / 2.0, this.symsize / 2.0, (float)this.symsize, FillStyle.STYLE_FILL);
                this.coloredPsyms[i] = image;
            }
        }
        this.refresh();
    }

    public PlotSymbol getPsym() {
        return this.psym;
    }

    public void setPsym(PlotSymbol newpsym) {
        PlotSymbol oldpsym = this.psym;
        this.psym = newpsym;
        this.updatePsym();
        this.propertyChangeSupport.firePropertyChange(PROP_PSYM, oldpsym, newpsym);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public double getSymSize() {
        return this.symsize;
    }

    public void setSymSize(double newsymsize) {
        double oldsymsize = this.symsize;
        this.symsize = newsymsize;
        this.updatePsym();
        this.propertyChangeSupport.firePropertyChange(PROP_SYMSIZE, new Double(oldsymsize), new Double(newsymsize));
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color newcolor) {
        Color oldcolor = this.color;
        this.color = newcolor;
        this.updatePsym();
        this.propertyChangeSupport.firePropertyChange(PROP_COLOR, oldcolor, newcolor);
    }

    public String getColorByDataSetId() {
        return this.colorByDataSetId;
    }

    public void setColorByDataSetId(String newcolorByDataSetId) {
        String oldcolorByDataSetId = this.colorByDataSetId;
        this.colorByDataSetId = newcolorByDataSetId;
        this.propertyChangeSupport.firePropertyChange(PROP_COLORBYDATASETID, oldcolorByDataSetId, newcolorByDataSetId);
    }

    public DasColorBar getColorBar() {
        return this.colorBar;
    }

    public void setColorBar(DasColorBar colorBar) {
        DasColorBar oldcolorBar = this.colorBar;
        this.colorBar = colorBar;
        colorBar.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (PlotSymbolRenderer.this.colorByDataSetId != null) {
                    PlotSymbolRenderer.this.refresh();
                }
            }
        });
        this.updatePsym();
        this.propertyChangeSupport.firePropertyChange(PROP_COLORBAR, oldcolorBar, colorBar);
    }

    protected void installRenderer() {
    }

    protected void uninstallRenderer() {
    }

    protected Element getDOMElement(Document document) {
        return null;
    }
}

