/*
 * Decompiled with CFR 0.152.
 */
package org.das2.graph;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import org.das2.DasException;
import org.das2.dataset.DataSetDescriptor;
import org.das2.dataset.DataSetUtil;
import org.das2.dataset.NoDataInIntervalException;
import org.das2.dataset.RebinDescriptor;
import org.das2.dataset.TableDataSet;
import org.das2.dataset.VectorDataSet;
import org.das2.dataset.WritableTableDataSet;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.Units;
import org.das2.graph.DasAxis;
import org.das2.graph.GraphUtil;
import org.das2.graph.Renderer;
import org.das2.util.monitor.ProgressMonitor;

public class ImageVectorDataSetRenderer
extends Renderer {
    GeneralPath path;
    Datum xTagWidth;
    BufferedImage plotImage;
    Rectangle plotImageBounds;
    DatumRange imageXRange;
    DatumRange imageYRange;
    TableDataSet hist;
    private Color color = Color.BLACK;
    int saturationHitCount = 5;
    private boolean print300dpi;

    public ImageVectorDataSetRenderer(DataSetDescriptor dsd) {
        super(dsd);
    }

    public synchronized void render(Graphics g1, DasAxis xAxis, DasAxis yAxis, ProgressMonitor mon) {
        if (this.ds == null) {
            this.parent.postMessage(this, "no data set", 0, null, null);
            return;
        }
        if (!xAxis.getUnits().isConvertableTo(this.ds.getXUnits())) {
            this.parent.postMessage(this, "inconvertable xaxis units", 0, null, null);
            return;
        }
        if (!yAxis.getUnits().isConvertableTo(this.ds.getYUnits())) {
            this.parent.postMessage(this, "inconvertable yaxis units", 0, null, null);
            return;
        }
        Graphics2D g2 = (Graphics2D)g1;
        if (this.plotImage == null) {
            if (this.getLastException() != null) {
                if (this.getLastException() instanceof NoDataInIntervalException) {
                    this.parent.postMessage(this, "no data in interval:!c" + this.getLastException().getMessage(), 1, null, null);
                } else {
                    this.parent.postException(this, this.getLastException());
                }
            } else if (this.getDataSet() == null) {
                this.parent.postMessage(this, "no data set", 0, null, null);
            } else if (this.getDataSet().getXLength() == 0) {
                this.parent.postMessage(this, "empty data set", 0, null, null);
            }
        } else if (this.plotImage != null) {
            Point2D.Float p = new Point2D.Float(this.plotImageBounds.x, this.plotImageBounds.y);
            int x = (int)(((Point2D)p).getX() + 0.5);
            int y = (int)(((Point2D)p).getY() + 0.5);
            if (this.parent.getCanvas().isPrintingThread() && this.print300dpi) {
                AffineTransform atinv;
                AffineTransformOp atop = new AffineTransformOp(AffineTransform.getScaleInstance(4.0, 4.0), 1);
                BufferedImage image300 = atop.filter(this.plotImage, null);
                try {
                    atinv = atop.getTransform().createInverse();
                }
                catch (NoninvertibleTransformException ex) {
                    throw new RuntimeException(ex);
                }
                atinv.translate(x * 4, y * 4);
                g2.drawImage(image300, atinv, this.getParent());
            } else {
                g2.drawImage((Image)this.plotImage, x, y, this.getParent());
            }
        }
    }

    private void ghostlyImage2(DasAxis xAxis, DasAxis yAxis, VectorDataSet ds, Rectangle plotImageBounds2) {
        int ny = plotImageBounds2.height;
        int nx = plotImageBounds2.width;
        logger.fine("create Image");
        BufferedImage image = new BufferedImage(nx, ny, 2);
        Graphics2D g = (Graphics2D)image.getGraphics();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(this.color);
        g.setStroke(new BasicStroke(1.0f / (float)this.saturationHitCount));
        g.translate(-plotImageBounds2.x, -plotImageBounds2.y);
        this.imageXRange = GraphUtil.invTransformRange(xAxis, plotImageBounds2.x, plotImageBounds2.x + plotImageBounds2.width);
        this.imageYRange = GraphUtil.invTransformRange(yAxis, plotImageBounds2.y, plotImageBounds2.y + plotImageBounds2.height);
        DatumRange visibleRange = this.imageXRange;
        boolean xmono = Boolean.TRUE == ds.getProperty("xMonotonic");
        int firstIndex = xmono ? DataSetUtil.getPreviousColumn(ds, visibleRange.min()) : 0;
        int lastIndex = xmono ? DataSetUtil.getNextColumn(ds, visibleRange.max()) : ds.getXLength();
        int STATE_LINETO = -991;
        int STATE_MOVETO = -992;
        int state = -992;
        int ix0 = 0;
        int iy0 = 0;
        if (ds.getXLength() > 0) {
            for (int i = firstIndex; i <= lastIndex; ++i) {
                if (ds.getDatum(i).isFill()) {
                    state = -992;
                    continue;
                }
                int iy = (int)yAxis.transform(ds.getDatum(i));
                int ix = (int)xAxis.transform(ds.getXTagDatum(i));
                switch (state) {
                    case -992: {
                        g.fillRect(ix, iy, 1, 1);
                        ix0 = ix;
                        iy0 = iy;
                        break;
                    }
                    case -991: {
                        g.draw(new Line2D.Float(ix0, iy0, ix, iy));
                        g.fillRect(ix, iy, 1, 1);
                        ix0 = ix;
                        iy0 = iy;
                    }
                }
                state = -991;
            }
        }
        logger.fine("done");
        this.plotImage = image;
    }

    private TableDataSet histogram(RebinDescriptor ddx, RebinDescriptor ddy, VectorDataSet ds) {
        ddx.setOutOfBoundsAction(-3);
        ddy.setOutOfBoundsAction(-3);
        WritableTableDataSet tds = WritableTableDataSet.newSimple(ddx.numberOfBins(), ddx.getUnits(), ddy.numberOfBins(), ddy.getUnits(), Units.dimensionless);
        if (ds.getXLength() > 0) {
            Units xunits = ddx.getUnits();
            Units yunits = ddy.getUnits();
            Units zunits = Units.dimensionless;
            int n = DataSetUtil.getNextColumn(ds, ddx.binStop(ddx.numberOfBins() - 1));
            for (int i = DataSetUtil.getPreviousColumn(ds, ddx.binStart(0)); i <= n; ++i) {
                int ix = ddx.whichBin(ds.getXTagDouble(i, xunits), xunits);
                int iy = ddy.whichBin(ds.getDouble(i, yunits), yunits);
                if (ix == -1 || iy == -1) continue;
                double d = tds.getDouble(ix, iy, zunits);
                tds.setDouble(ix, iy, d + 1.0, zunits);
            }
        }
        return tds;
    }

    private void ghostlyImage(DasAxis xAxis, DasAxis yAxis, VectorDataSet ds, Rectangle plotImageBounds2) {
        DatumRange xrange = new DatumRange(xAxis.invTransform(plotImageBounds2.x), xAxis.invTransform(plotImageBounds2.x + plotImageBounds2.width));
        DatumRange yrange = new DatumRange(yAxis.invTransform(plotImageBounds2.y + plotImageBounds2.height), yAxis.invTransform(plotImageBounds2.y));
        RebinDescriptor ddx = new RebinDescriptor(xrange.min(), xrange.max(), plotImageBounds2.width, xAxis.isLog());
        RebinDescriptor ddy = new RebinDescriptor(yrange.min(), yrange.max(), plotImageBounds2.height, yAxis.isLog());
        TableDataSet newHist = this.histogram(ddx, ddy, ds);
        int h = ddy.numberOfBins();
        int w = ddx.numberOfBins();
        int[] raster = new int[h * w];
        int colorInt = this.color.getRGB() & 0xFFFFFF;
        for (int i = 0; i < w; ++i) {
            for (int j = 0; j < h; ++j) {
                int icolor;
                int index = i - 0 + (h - j - 1) * w;
                int alpha = 255 * (int)newHist.getDouble(i, j, Units.dimensionless) / this.saturationHitCount;
                raster[index] = icolor = alpha << 24 | colorInt;
            }
        }
        this.plotImage = new BufferedImage(w, h, 2);
        WritableRaster r = this.plotImage.getRaster();
        r.setDataElements(0, 0, w, h, raster);
        this.imageXRange = xrange;
        this.imageYRange = yrange;
    }

    public synchronized void updatePlotImage(DasAxis xAxis, DasAxis yAxis, ProgressMonitor monitor) throws DasException {
        int lastIndex;
        super.updatePlotImage(xAxis, yAxis, monitor);
        long t0 = System.currentTimeMillis();
        VectorDataSet ds1 = (VectorDataSet)this.getDataSet();
        if (ds1 == null) {
            return;
        }
        if (!xAxis.getUnits().isConvertableTo(ds1.getXUnits())) {
            this.parent.postMessage(this, "inconvertable xaxis units", 0, null, null);
            return;
        }
        if (!yAxis.getUnits().isConvertableTo(ds1.getYUnits())) {
            this.parent.postMessage(this, "inconvertable yaxis units", 0, null, null);
            return;
        }
        this.plotImageBounds = this.parent.getCacheImageBounds();
        if (this.plotImageBounds == null) {
            return;
        }
        DatumRange visibleRange = xAxis.getDatumRange();
        boolean xmono = Boolean.TRUE == ds1.getProperty("xMonotonic");
        int firstIndex = xmono ? DataSetUtil.getPreviousColumn(ds1, visibleRange.min()) : 0;
        int n = lastIndex = xmono ? DataSetUtil.getNextColumn(ds1, visibleRange.max()) : ds1.getXLength();
        if (lastIndex - firstIndex > 20 * xAxis.getColumn().getWidth()) {
            logger.fine("rendering with histogram");
            this.ghostlyImage(xAxis, yAxis, ds1, this.plotImageBounds);
        } else {
            logger.fine("rendinging with lines");
            this.ghostlyImage2(xAxis, yAxis, ds1, this.plotImageBounds);
        }
        logger.fine("done updatePlotImage");
    }

    public void setSaturationHitCount(int d) {
        if (d > 10) {
            d = 10;
        }
        this.saturationHitCount = d;
        this.update();
    }

    public int getSaturationHitCount() {
        return this.saturationHitCount;
    }

    public void setColor(Color color) {
        this.color = color;
        this.refreshImage();
    }

    public Color getColor() {
        return this.color;
    }

    public boolean acceptContext(int x, int y) {
        x = (int)((double)x - this.parent.getCacheImageBounds().getX());
        y = (int)((double)y - this.parent.getCacheImageBounds().getY());
        int i0 = Math.max(x - 2, 0);
        int j0 = Math.max(y - 2, 0);
        if (this.plotImage == null) {
            return false;
        }
        int i1 = Math.min(x + 3, this.plotImage.getWidth());
        int j1 = Math.min(y + 3, this.plotImage.getHeight());
        for (int i = i0; i < i1; ++i) {
            for (int j = j0; j < j1; ++j) {
                if ((this.plotImage.getRGB(i, j) & 0xFF000000) <= 0) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isPrint300dpi() {
        return this.print300dpi;
    }

    public void setPrint300dpi(boolean print300dpi) {
        this.print300dpi = print300dpi;
    }
}

