/*
 * Decompiled with CFR 0.152.
 */
package org.das2.graph;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.text.DecimalFormat;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JTabbedPane;
import javax.xml.parsers.DocumentBuilderFactory;
import org.das2.dasml.FormBase;
import org.das2.dataset.ConstantDataSetDescriptor;
import org.das2.dataset.DataSet;
import org.das2.dataset.DataSetUtil;
import org.das2.dataset.TableDataSet;
import org.das2.dataset.TableUtil;
import org.das2.dataset.VectorDataSet;
import org.das2.dataset.XTagsVectorDataSet;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.Units;
import org.das2.datum.UnitsUtil;
import org.das2.graph.DasAxis;
import org.das2.graph.DasCanvas;
import org.das2.graph.DasColorBar;
import org.das2.graph.DasColumn;
import org.das2.graph.DasPlot;
import org.das2.graph.DasRow;
import org.das2.graph.ImageVectorDataSetRenderer;
import org.das2.graph.Psym;
import org.das2.graph.Renderer;
import org.das2.graph.SpectrogramRenderer;
import org.das2.graph.SymbolLineRenderer;
import org.w3c.dom.Document;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;

public class GraphUtil {
    public static DasPlot newDasPlot(DasCanvas canvas, DatumRange x, DatumRange y) {
        DasAxis xaxis = new DasAxis(x.min(), x.max(), 2);
        DasAxis yaxis = new DasAxis(y.min(), y.max(), 3);
        DasRow row = new DasRow(canvas, null, 0.0, 1.0, 2.0, -3.0, 0, 0);
        DasColumn col = new DasColumn(canvas, null, 0.0, 1.0, 5.0, -3.0, 0, 0);
        DasPlot result = new DasPlot(xaxis, yaxis);
        canvas.add(result, row, col);
        return result;
    }

    public static void serializeCanvas(DasCanvas canvas, OutputStream out) {
        try {
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            document.appendChild(canvas.getDOMElement(document));
            StringWriter writer = new StringWriter();
            DOMImplementationLS ls = (DOMImplementationLS)document.getImplementation().getFeature("LS", "3.0");
            LSOutput output = ls.createLSOutput();
            output.setEncoding("UTF-8");
            output.setByteStream(out);
            LSSerializer serializer = ls.createLSSerializer();
            serializer.write(document, output);
            out.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static JTabbedPane loadCanvas(InputStream in) throws Exception {
        FormBase form = new FormBase(in, null, true);
        return form;
    }

    public static GeneralPath getPath(DasAxis xAxis, DasAxis yAxis, VectorDataSet xds, boolean histogram) {
        return GraphUtil.getPath(xAxis, yAxis, new XTagsVectorDataSet(xds), xds, histogram);
    }

    public static GeneralPath getPath(DasAxis xAxis, DasAxis yAxis, VectorDataSet xds, VectorDataSet yds, boolean histogram) {
        double xSampleWidth;
        Datum xSampleWidthDatum;
        GeneralPath newPath = new GeneralPath();
        Units xUnits = xAxis.getUnits();
        Units yUnits = yAxis.getUnits();
        double xmax = xAxis.getDataMaximum().doubleValue(xUnits);
        double xmin = xAxis.getDataMinimum().doubleValue(xUnits);
        double ymax = yAxis.getDataMaximum().doubleValue(yUnits);
        double ymin = yAxis.getDataMinimum().doubleValue(yUnits);
        if (xds.getProperty("xTagWidth") != null) {
            xSampleWidthDatum = (Datum)xds.getProperty("xTagWidth");
            xSampleWidth = xSampleWidthDatum.doubleValue(xUnits.getOffsetUnits());
        } else if (xds.getProperty("xSampleWidth") != null) {
            xSampleWidthDatum = (Datum)xds.getProperty("xSampleWidth");
            xSampleWidth = xSampleWidthDatum.doubleValue(xUnits.getOffsetUnits());
        } else {
            String xSampleWidthString = (String)xds.getProperty("x_sample_width");
            if (xSampleWidthString != null) {
                double xSampleWidthSeconds = Double.parseDouble(xSampleWidthString);
                xSampleWidth = Units.seconds.convertDoubleTo(xUnits.getOffsetUnits(), xSampleWidthSeconds);
            } else {
                xSampleWidth = 1.0E31;
            }
        }
        double t0 = -1.7976931348623157E308;
        double x0 = -1.7976931348623157E308;
        double y0 = -1.7976931348623157E308;
        double i0 = -1.7976931348623157E308;
        double j0 = -1.7976931348623157E308;
        boolean skippedLast = true;
        int n = xds.getXLength();
        for (int index = 0; index < n; ++index) {
            double t = xds.getXTagDouble(index, xUnits);
            double x = xds.getDouble(index, yUnits);
            double y = yds.getDouble(index, yUnits);
            double i = xAxis.transform(x, xUnits);
            double j = yAxis.transform(y, yUnits);
            if (yUnits.isFill(y) || Double.isNaN(y)) {
                skippedLast = true;
            } else if (skippedLast || t - t0 > xSampleWidth) {
                newPath.moveTo((float)i, (float)j);
                skippedLast = false;
            } else {
                if (histogram) {
                    double i1 = (i0 + i) / 2.0;
                    newPath.lineTo((float)i1, (float)j0);
                    newPath.lineTo((float)i1, (float)j);
                    newPath.lineTo((float)i, (float)j);
                } else {
                    newPath.lineTo((float)i, (float)j);
                }
                skippedLast = false;
            }
            t0 = t;
            x0 = x;
            y0 = y;
            i0 = i;
            j0 = j;
        }
        return newPath;
    }

    public static AffineTransform calculateAT(DasAxis xaxis0, DasAxis yaxis0, DasAxis xaxis1, DasAxis yaxis1) {
        return GraphUtil.calculateAT(xaxis0.getDatumRange(), yaxis0.getDatumRange(), xaxis1, yaxis1);
    }

    public static AffineTransform calculateAT(DatumRange xaxis0, DatumRange yaxis0, DasAxis xaxis1, DasAxis yaxis1) {
        AffineTransform at = new AffineTransform();
        double dmin0 = xaxis1.transform(xaxis0.min());
        double dmax0 = xaxis1.transform(xaxis0.max());
        double dmin1 = xaxis1.transform(xaxis1.getDataMinimum());
        double dmax1 = xaxis1.transform(xaxis1.getDataMaximum());
        double scalex = (dmin0 - dmax0) / (dmin1 - dmax1);
        double transx = -1.0 * dmin1 * scalex + dmin0;
        at.translate(transx, 0.0);
        at.scale(scalex, 1.0);
        if (at.getDeterminant() == 0.0) {
            return null;
        }
        dmin0 = yaxis1.transform(yaxis0.min());
        dmax0 = yaxis1.transform(yaxis0.max());
        dmin1 = yaxis1.transform(yaxis1.getDataMinimum());
        dmax1 = yaxis1.transform(yaxis1.getDataMaximum());
        double scaley = (dmin0 - dmax0) / (dmin1 - dmax1);
        double transy = -1.0 * dmin1 * scaley + dmin0;
        at.translate(0.0, transy);
        at.scale(1.0, scaley);
        return at;
    }

    public static DasAxis guessYAxis(DataSet dsz) {
        DasAxis result;
        boolean log = false;
        if (dsz.getProperty("yScaleType") != null && dsz.getProperty("yScaleType").equals("log")) {
            log = true;
        }
        if (dsz instanceof TableDataSet) {
            TableDataSet ds = (TableDataSet)dsz;
            Units yunits = ds.getYUnits();
            DatumRange yrange = DataSetUtil.yRange(dsz);
            Datum dy = TableUtil.guessYTagWidth(ds);
            if (UnitsUtil.isRatiometric(dy.getUnits())) {
                log = true;
            }
            result = new DasAxis(yrange.min(), yrange.max(), 3, log);
        } else if (dsz instanceof VectorDataSet) {
            VectorDataSet ds = (VectorDataSet)dsz;
            Units yunits = ds.getYUnits();
            DatumRange range = DataSetUtil.yRange(dsz);
            if (range.width().doubleValue(yunits.getOffsetUnits()) == 0.0 && (range = range.include(yunits.createDatum(0))).width().doubleValue(yunits.getOffsetUnits()) == 0.0) {
                range = new DatumRange(0.0, 10.0, yunits);
            }
            result = new DasAxis(range.min(), range.max(), 3, log);
        } else {
            throw new IllegalArgumentException("not supported: " + dsz);
        }
        if (dsz.getProperty("yLabel") != null) {
            result.setLabel((String)dsz.getProperty("yLabel"));
        }
        return result;
    }

    public static DasAxis guessXAxis(DataSet ds) {
        Datum min = ds.getXTagDatum(0);
        Datum max = ds.getXTagDatum(ds.getXLength() - 1);
        return new DasAxis(min, max, 2);
    }

    public static DasAxis guessZAxis(DataSet dsz) {
        if (!(dsz instanceof TableDataSet)) {
            throw new IllegalArgumentException("only TableDataSet supported");
        }
        TableDataSet ds = (TableDataSet)dsz;
        Units zunits = ds.getZUnits();
        DatumRange range = DataSetUtil.zRange(ds);
        boolean log = false;
        if (dsz.getProperty("zScaleType") != null && dsz.getProperty("zScaleType").equals("log")) {
            log = true;
            if (range.min().doubleValue(range.getUnits()) <= 0.0) {
                double max = range.max().doubleValue(range.getUnits());
                range = new DatumRange(max / 1000.0, max, range.getUnits());
            }
        }
        DasAxis result = new DasAxis(range.min(), range.max(), 3, log);
        if (dsz.getProperty("zLabel") != null) {
            result.setLabel((String)dsz.getProperty("zLabel"));
        }
        return result;
    }

    public static Renderer guessRenderer(DataSet ds) {
        Renderer rend = null;
        if (ds instanceof VectorDataSet) {
            if (ds.getXLength() > 10000) {
                rend = new ImageVectorDataSetRenderer(new ConstantDataSetDescriptor(ds));
            } else {
                rend = new SymbolLineRenderer();
                rend.setDataSet(ds);
                ((SymbolLineRenderer)rend).setPsym(Psym.DOTS);
                ((SymbolLineRenderer)rend).setSymSize(2.0);
            }
        } else if (ds instanceof TableDataSet) {
            Units zunits = ((TableDataSet)ds).getZUnits();
            DasAxis zaxis = GraphUtil.guessZAxis(ds);
            DasColorBar colorbar = new DasColorBar(zaxis.getDataMinimum(), zaxis.getDataMaximum(), zaxis.isLog());
            colorbar.setLabel(zaxis.getLabel());
            rend = new SpectrogramRenderer(new ConstantDataSetDescriptor(ds), colorbar);
        }
        return rend;
    }

    public static DasPlot guessPlot(DataSet ds) {
        DasAxis xaxis = GraphUtil.guessXAxis(ds);
        DasAxis yaxis = GraphUtil.guessYAxis(ds);
        DasPlot plot = new DasPlot(xaxis, yaxis);
        plot.addRenderer(GraphUtil.guessRenderer(ds));
        return plot;
    }

    public static DasPlot visualize(DataSet ds, String title, String xlabel, String ylabel) {
        DasPlot p = GraphUtil.visualize(ds);
        p.setTitle(title);
        p.getXAxis().setLabel(xlabel);
        p.getYAxis().setLabel(ylabel);
        return p;
    }

    public static DasPlot visualize(DataSet ds) {
        JFrame jframe = new JFrame("DataSetUtil.visualize");
        DasCanvas canvas = new DasCanvas(400, 400);
        jframe.getContentPane().add(canvas);
        DasPlot result = GraphUtil.guessPlot(ds);
        canvas.add(result, DasRow.create(canvas), DasColumn.create(canvas, null, "5em", "100%-10em"));
        jframe.pack();
        jframe.setVisible(true);
        jframe.setDefaultCloseOperation(3);
        return result;
    }

    public static DasPlot visualize(DataSet ds, boolean ylog) {
        DatumRange xRange = DataSetUtil.xRange(ds);
        DatumRange yRange = DataSetUtil.yRange(ds);
        JFrame jframe = new JFrame("DataSetUtil.visualize");
        DasCanvas canvas = new DasCanvas(400, 400);
        jframe.getContentPane().add(canvas);
        DasPlot result = GraphUtil.guessPlot(ds);
        canvas.add(result, DasRow.create(canvas), DasColumn.create(canvas, null, "5em", "100%-10em"));
        Units xunits = result.getXAxis().getUnits();
        result.getXAxis().setDatumRange(xRange.zoomOut(1.1));
        Units yunits = result.getYAxis().getUnits();
        if (ylog) {
            result.getYAxis().setDatumRange(yRange);
            result.getYAxis().setLog(true);
        } else {
            result.getYAxis().setDatumRange(yRange.zoomOut(1.1));
        }
        jframe.pack();
        jframe.setVisible(true);
        jframe.setDefaultCloseOperation(3);
        return result;
    }

    public static GeneralPath reducePath(PathIterator it, GeneralPath result) {
        float[] p = new float[6];
        float x0 = Float.MAX_VALUE;
        float y0 = Float.MAX_VALUE;
        float sx0 = 0.0f;
        float sy0 = 0.0f;
        int nx0 = 0;
        int ny0 = 0;
        float ax0 = Float.NaN;
        float ay0 = Float.NaN;
        int type0 = -999;
        float xres = 1.0f;
        float yres = 1.0f;
        String[] types = new String[]{"M", "L", "QUAD", "CUBIC", "CLOSE"};
        int points = 0;
        int inCount = 0;
        while (!it.isDone()) {
            ++inCount;
            int type = it.currentSegment(p);
            it.next();
            float dx = p[0] - x0;
            float dy = p[1] - y0;
            if ((type == 0 || type == type0) && Math.abs(dx) < xres && Math.abs(dy) < yres) {
                sx0 += p[0];
                sy0 += p[1];
                ++nx0;
                ++ny0;
                continue;
            }
            x0 = 0.5f + (float)((int)Math.floor(p[0]));
            y0 = 0.5f + (float)((int)Math.floor(p[1]));
            ax0 = nx0 > 0 ? sx0 / (float)nx0 : p[0];
            ay0 = ny0 > 0 ? sy0 / (float)ny0 : p[1];
            sx0 = p[0];
            sy0 = p[1];
            nx0 = 1;
            ny0 = 1;
            switch (type0) {
                case 1: {
                    result.lineTo(ax0, ay0);
                    ++points;
                    break;
                }
                case 0: {
                    result.moveTo(ax0, ay0);
                    break;
                }
                case -999: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("not supported");
                }
            }
            type0 = type;
        }
        ax0 = nx0 > 0 ? sx0 / (float)nx0 : p[0];
        ay0 = ny0 > 0 ? sy0 / (float)ny0 : p[1];
        switch (type0) {
            case 1: {
                result.lineTo(ax0, ay0);
                ++points;
                break;
            }
            case 0: {
                result.moveTo(ax0, ay0);
                break;
            }
            case -999: {
                break;
            }
            default: {
                throw new IllegalArgumentException("not supported");
            }
        }
        return result;
    }

    public static double pointsAlongCurve(PathIterator it, double[] pathlen, Point2D.Double[] result, double[] orientation, boolean stopAtMoveTo) {
        float[] point = new float[6];
        float fx0 = Float.NaN;
        float fy0 = Float.NaN;
        double slen = 0.0;
        int pathlenIndex = 0;
        if (pathlen == null) {
            pathlen = new double[]{};
        }
        while (!it.isDone()) {
            int type = it.currentSegment(point);
            it.next();
            if (!Float.isNaN(fx0) && type == 0 && stopAtMoveTo) break;
            if (3 == type) {
                throw new IllegalArgumentException("cubicto not supported");
            }
            if (2 == type) {
                throw new IllegalArgumentException("quadto not supported");
            }
            if (1 == type) {
                // empty if block
            }
            if (Float.isNaN(fx0)) {
                fx0 = point[0];
                fy0 = point[1];
                continue;
            }
            double thislen = (float)Point.distance(fx0, fy0, point[0], point[1]);
            if (thislen == 0.0) continue;
            slen += thislen;
            while (pathlenIndex < pathlen.length && slen >= pathlen[pathlenIndex]) {
                double alpha = 1.0 - (slen - pathlen[pathlenIndex]) / thislen;
                double dx = point[0] - fx0;
                double dy = point[1] - fy0;
                if (result != null) {
                    result[pathlenIndex] = new Point2D.Double((double)fx0 + dx * alpha, (double)fy0 + dy * alpha);
                }
                if (orientation != null) {
                    orientation[pathlenIndex] = Math.atan2(dy, dx);
                }
                ++pathlenIndex;
            }
            fx0 = point[0];
            fy0 = point[1];
        }
        double remaining = pathlenIndex > 0 ? slen - pathlen[pathlenIndex - 1] : slen;
        if (result != null) {
            while (pathlenIndex < result.length) {
                result[pathlenIndex] = null;
                ++pathlenIndex;
            }
        }
        return remaining;
    }

    public static String getATScaleTranslateString(AffineTransform at) {
        DecimalFormat nf = new DecimalFormat("0.00");
        if (at == null) {
            return "null";
        }
        if (!at.isIdentity()) {
            String atDesc = "scaleX:" + nf.format(at.getScaleX()) + " translateX:" + nf.format(at.getTranslateX());
            atDesc = atDesc + "!cscaleY:" + nf.format(at.getScaleY()) + " translateY:" + nf.format(at.getTranslateY());
            return atDesc;
        }
        return "identity";
    }

    public static double[] getSlopeIntercept(double x0, double y0, double x1, double y1) {
        double slope = (y1 - y0) / (x1 - x0);
        double intercept = y0 - slope * x0;
        return new double[]{slope, intercept};
    }

    public static Color getRicePaperColor() {
        return new Color(255, 255, 255, 128);
    }

    public static String describe(GeneralPath path, boolean enumeratePoints) {
        PathIterator it = path.getPathIterator(null);
        int count = 0;
        int lineToCount = 0;
        double[] coords = new double[6];
        while (!it.isDone()) {
            int type = it.currentSegment(coords);
            if (type == 1) {
                ++lineToCount;
            }
            if (enumeratePoints) {
                // empty if block
            }
            ++count;
            it.next();
        }
        return "count: " + count + "  lineToCount: " + lineToCount;
    }

    static String toString(Line2D line) {
        return "" + line.getX1() + "," + line.getY1() + " " + line.getX2() + "," + line.getY2();
    }

    public static Point2D lineIntersection(Line2D line1, Line2D line2, boolean noBoundsCheck) {
        Point2D.Double result = null;
        double a1 = line1.getY2() - line1.getY1();
        double b1 = line1.getX1() - line1.getX2();
        double c1 = line1.getX2() * line1.getY1() - line1.getX1() * line1.getY2();
        double a2 = line2.getY2() - line2.getY1();
        double b2 = line2.getX1() - line2.getX2();
        double c2 = line2.getX2() * line2.getY1() - line2.getX1() * line2.getY2();
        double denom = a1 * b2 - a2 * b1;
        if (denom != 0.0) {
            result = new Point2D.Double((b1 * c2 - b2 * c1) / denom, (a2 * c1 - a1 * c2) / denom);
            if (noBoundsCheck || (((Point2D)result).getX() - line1.getX1()) * (line1.getX2() - ((Point2D)result).getX()) >= 0.0 && (((Point2D)result).getY() - line1.getY1()) * (line1.getY2() - ((Point2D)result).getY()) >= 0.0 && (((Point2D)result).getX() - line2.getX1()) * (line2.getX2() - ((Point2D)result).getX()) >= 0.0 && (((Point2D)result).getY() - line2.getY1()) * (line2.getY2() - ((Point2D)result).getY()) >= 0.0) {
                return result;
            }
            return null;
        }
        return null;
    }

    public static Point2D lineRectangleIntersection(Point2D p0, Point2D p1, Rectangle2D r0) {
        PathIterator it = r0.getPathIterator(null);
        Line2D.Double line = new Line2D.Double(p0, p1);
        float[] c0 = new float[6];
        float[] c1 = new float[6];
        it.currentSegment(c0);
        it.next();
        while (!it.isDone()) {
            Line2D.Double seg;
            Point2D result;
            int type = it.currentSegment(c1);
            if (type == 1 && (result = GraphUtil.lineIntersection(line, seg = new Line2D.Double(c0[0], c0[1], c1[0], c1[1]), false)) != null) {
                return result;
            }
            it.next();
            c0[0] = c1[0];
            c0[1] = c1[1];
        }
        return null;
    }

    public static double[] transformRange(DasAxis axis, DatumRange range) {
        double x2;
        double x1 = axis.transform(range.min());
        if (x1 > (x2 = axis.transform(range.max()))) {
            double t = x2;
            x2 = x1;
            x1 = t;
        }
        return new double[]{x1, x2};
    }

    public static DatumRange invTransformRange(DasAxis axis, double x1, double x2) {
        Datum d2;
        Datum d1 = axis.invTransform(x1);
        if (d1.gt(d2 = axis.invTransform(x2))) {
            Datum t = d2;
            d2 = d1;
            d1 = t;
        }
        return new DatumRange(d1, d2);
    }

    public static Icon colorIcon(Color iconColor, int w, int h) {
        BufferedImage image = new BufferedImage(w, h, 2);
        Graphics g = image.getGraphics();
        Color save = g.getColor();
        if (iconColor.getAlpha() != 255) {
            for (int j = 0; j < 4; ++j) {
                for (int i = 0; i < 4; ++i) {
                    g.setColor((i - j) % 2 == 0 ? Color.GRAY : Color.WHITE);
                    g.fillRect(0 + i * 4, 0 + j * 4, 4, 4);
                }
            }
        }
        g.setColor(iconColor);
        g.fillRect(0, 0, w, h);
        return new ImageIcon(image);
    }
}

