/*
 * Decompiled with CFR 0.152.
 */
package org.das2.graph;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import org.das2.dataset.DataSetDescriptor;
import org.das2.dataset.VectorDataSet;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumUtil;
import org.das2.datum.UnitsConverter;
import org.das2.event.LabelDragRenderer;
import org.das2.event.MouseModule;
import org.das2.graph.DasAxis;
import org.das2.graph.DasColumn;
import org.das2.graph.DasPlot;
import org.das2.graph.DasRow;
import org.das2.graph.Renderer;
import org.das2.system.DasLogger;
import org.das2.util.monitor.ProgressMonitor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EventsRenderer
extends Renderer {
    int[] eventMap;
    private ColorSpecifier colorSpecifier = null;
    public static final TextSpecifier DEFAULT_TEXT_SPECIFIER = new TextSpecifier(){

        public String getText(DatumRange dr, Datum d) {
            Datum sy = DatumUtil.asOrderOneUnits(dr.width());
            return "" + dr + " (" + sy + ")!c" + d;
        }
    };
    private Color color = new Color(100, 100, 100, 180);
    private String widthPlaneId = "xTagWidth";
    private TextSpecifier textSpecifier = DEFAULT_TEXT_SPECIFIER;

    public EventsRenderer(DataSetDescriptor dsd) {
        super(dsd);
    }

    public EventsRenderer() {
    }

    public void setColorSpecifier(ColorSpecifier spec) {
        this.colorSpecifier = spec;
    }

    public ColorSpecifier getColorSpecifier() {
        return this.colorSpecifier;
    }

    protected Element getDOMElement(Document document) {
        return null;
    }

    protected void installRenderer() {
        MouseModule mm = this.getMouseModule();
        this.parent.getDasMouseInputAdapter().addMouseModule(mm);
        this.parent.getDasMouseInputAdapter().setPrimaryModule(mm);
    }

    private MouseModule getMouseModule() {
        return new MouseModule(this.parent, new DragRenderer(this.parent), "event lookup");
    }

    public void render(Graphics g1, DasAxis xAxis, DasAxis yAxis, ProgressMonitor mon) {
        VectorDataSet vds = (VectorDataSet)this.getDataSet();
        if (vds == null || vds.getXLength() == 0) {
            DasLogger.getLogger(DasLogger.GRAPHICS_LOG).fine("null data set");
            return;
        }
        Graphics2D g = (Graphics2D)g1.create();
        g.setColor(this.color);
        if (vds == null && this.getLastException() != null) {
            this.renderException(g, xAxis, yAxis, this.getLastException());
        } else {
            VectorDataSet widthsDs = (VectorDataSet)vds.getPlanarView(this.widthPlaneId);
            if (widthsDs == null) {
                throw new IllegalArgumentException("no width plane named \"" + this.widthPlaneId + "\" found");
            }
            DasColumn column = xAxis.getColumn();
            DasRow row = this.parent.getRow();
            this.eventMap = new int[column.getWidth()];
            for (int k = 0; k < this.eventMap.length; ++k) {
                this.eventMap[k] = -1;
            }
            if (vds.getXLength() > 0) {
                UnitsConverter uc = UnitsConverter.getConverter(widthsDs.getYUnits(), xAxis.getUnits().getOffsetUnits());
                int ivds0 = 0;
                int ivds1 = vds.getXLength();
                for (int i = ivds0; i < ivds1; ++i) {
                    int iwidth;
                    Datum x = vds.getXTagDatum(i);
                    int ix = (int)xAxis.transform(x);
                    if (uc != null) {
                        Datum y = widthsDs.getDatum(i);
                        iwidth = (int)xAxis.transform(x.add(y)) - ix;
                    } else {
                        iwidth = 1;
                    }
                    if (this.colorSpecifier != null) {
                        Datum sz = vds.getDatum(i);
                        g.setColor(this.colorSpecifier.getColor(sz));
                    }
                    if (column.getDMinimum() >= ix + iwidth && column.getDMaximum() <= ix) continue;
                    if (iwidth == 0) {
                        iwidth = 1;
                    }
                    g.fill(new Rectangle(ix, row.getDMinimum(), iwidth, row.getHeight()));
                    int im = ix - column.getDMinimum();
                    int em0 = im - 1;
                    int em1 = im + iwidth + 1;
                    for (int k = em0; k < em1; ++k) {
                        if (k < 0 || k >= this.eventMap.length) continue;
                        this.eventMap[k] = i;
                    }
                }
                for (int k1 = 1; k1 <= 2; ++k1) {
                    for (int k2 = -1; k2 <= 1; k2 += 2) {
                        int em0 = k2 == 1 ? 0 : this.eventMap.length - 1;
                        int em1 = k2 == 1 ? this.eventMap.length - k1 : k1;
                        for (int k = em0; k != em1; k += k2) {
                            if (this.eventMap[k] != -1) continue;
                            this.eventMap[k] = this.eventMap[k + k2];
                        }
                    }
                }
            }
        }
        g.dispose();
    }

    protected void uninstallRenderer() {
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = new Color(color.getRed(), color.getGreen(), color.getBlue(), 180);
        super.invalidateParentCacheImage();
    }

    public void setWidthPlaneId(String id) {
        this.widthPlaneId = id;
    }

    public String getWidthPlaneId() {
        return this.widthPlaneId;
    }

    public TextSpecifier getTextSpecifier() {
        return this.textSpecifier;
    }

    public void setTextSpecifier(TextSpecifier textSpecifier) {
        TextSpecifier oldTextSpecifier = this.textSpecifier;
        this.textSpecifier = textSpecifier;
        this.propertyChangeSupport.firePropertyChange("textSpecifier", oldTextSpecifier, textSpecifier);
    }

    private class DragRenderer
    extends LabelDragRenderer {
        DasAxis xaxis;
        DasAxis yaxis;
        DasPlot parent;

        DragRenderer(DasPlot parent) {
            super(parent);
            this.xaxis = parent.getXAxis();
            this.yaxis = parent.getYAxis();
            this.parent = parent;
            this.setTooltip(true);
        }

        public Rectangle[] renderDrag(Graphics g, Point p1, Point p2) {
            VectorDataSet vds = (VectorDataSet)EventsRenderer.this.getDataSet();
            if (vds == null) {
                return new Rectangle[0];
            }
            if (vds.getXLength() == 0) {
                return new Rectangle[0];
            }
            int ix = (int)p2.getX() - this.parent.getColumn().getDMinimum();
            if (ix < 0 || ix >= EventsRenderer.this.eventMap.length) {
                this.setLabel(null);
            } else {
                int i = EventsRenderer.this.eventMap[ix];
                if (i >= 0) {
                    Datum sx = vds.getXTagDatum(i);
                    Datum sz = vds.getDatum(i);
                    VectorDataSet widthsDs = (VectorDataSet)vds.getPlanarView(EventsRenderer.this.widthPlaneId);
                    DatumRange dr = new DatumRange(sx, sx.add(widthsDs.getDatum(i)));
                    this.setLabel(EventsRenderer.this.textSpecifier.getText(dr, sz));
                } else {
                    this.setLabel(null);
                }
            }
            return super.renderDrag(g, p1, p2);
        }
    }

    public static interface TextSpecifier {
        public String getText(DatumRange var1, Datum var2);
    }

    public static interface ColorSpecifier {
        public Color getColor(Datum var1);
    }
}

