/*
 * Decompiled with CFR 0.152.
 */
package org.das2.graph;

import org.das2.dataset.DataSetDescriptor;
import org.das2.dataset.DataSetUpdateEvent;
import org.das2.dataset.DataSetUpdateListener;
import org.das2.datum.DatumRange;
import org.das2.datum.Units;
import org.das2.graph.DasAxis;
import org.das2.graph.DasPlot;
import org.das2.graph.EventsRenderer;
import org.das2.graph.XAxisDataLoader;

public class DasEventsIndicator
extends DasPlot
implements DataSetUpdateListener {
    EventsRenderer renderer;

    public DasEventsIndicator(DataSetDescriptor dsd, DasAxis axis, DasAxis yAxis, String planeId) {
        super(axis, yAxis);
        this.renderer = new EventsRenderer(dsd);
        this.addRenderer(this.renderer);
    }

    public static DasEventsIndicator create(DataSetDescriptor dsd, DasAxis axis, String planeId) {
        DasAxis yAxis = new DasAxis(new DatumRange(0.0, 1.0, Units.dimensionless), 3);
        yAxis.setVisible(false);
        return new DasEventsIndicator(dsd, axis, yAxis, planeId);
    }

    public void setDataSetDescriptor(DataSetDescriptor dsd) {
        this.renderer.setDataSetDescriptor(dsd);
    }

    public DataSetDescriptor getDataSetDescriptor() {
        return this.renderer.getDataSetDescriptor();
    }

    public void dataSetUpdated(DataSetUpdateEvent e) {
        ((XAxisDataLoader)this.renderer.getDataLoader()).dataSetUpdated(e);
    }
}

