/*
 * Decompiled with CFR 0.152.
 */
package org.das2.graph;

import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.text.ParseException;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.event.EventListenerList;
import org.das2.DasApplication;
import org.das2.DasNameException;
import org.das2.DasPropertyException;
import org.das2.NameContext;
import org.das2.components.propertyeditor.Displayable;
import org.das2.components.propertyeditor.Enumeration;
import org.das2.dasml.FormBase;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.datum.TimeUtil;
import org.das2.datum.Units;
import org.das2.event.DataRangeSelectionEvent;
import org.das2.event.DataRangeSelectionListener;
import org.das2.event.HorizontalSliceSelectionRenderer;
import org.das2.event.MouseModule;
import org.das2.event.MousePointSelectionEvent;
import org.das2.graph.DasAxis;
import org.das2.graph.DasColumn;
import org.das2.graph.DasRow;
import org.das2.graph.Renderer;
import org.das2.util.DasExceptionHandler;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DasColorBar
extends DasAxis {
    public static final String PROPERTY_TYPE = "type";
    public static final String PROPERTY_FILL_COLOR = "fillColor";
    private BufferedImage image;
    private Type type;
    private static int fillColor = Color.LIGHT_GRAY.getRGB();
    private int fillColorIndex;
    private int ncolor;
    private static final int COLORTABLE_SIZE = 240;

    public DasColorBar(Datum min, Datum max, boolean isLog) {
        this(min, max, 4, isLog);
    }

    public DasColorBar(Datum min, Datum max, int orientation, boolean isLog) {
        super(min, max, orientation, isLog);
        this.setLayout(new ColorBarLayoutManager());
        this.setType(Type.COLOR_WEDGE);
    }

    public int rgbTransform(double x, Units units) {
        int icolor = (int)this.transform(x, units, 0, this.ncolor);
        if (units.isFill(x)) {
            return fillColor;
        }
        icolor = icolor < 0 ? 0 : icolor;
        icolor = icolor >= this.ncolor ? this.ncolor - 1 : icolor;
        return this.type.getRGB(icolor);
    }

    public int indexColorTransform(double x, Units units) {
        if (units.isFill(x)) {
            return this.fillColorIndex;
        }
        int icolor = (int)this.transform(x, units, 0, this.ncolor);
        icolor = icolor < 0 ? 0 : icolor;
        icolor = icolor >= this.ncolor ? this.ncolor - 1 : icolor;
        return icolor;
    }

    public IndexColorModel getIndexColorModel() {
        return new IndexColorModel(8, this.type.getColorCount() + 1, this.type.colorTable, 0, true, -1, 0);
    }

    public int getFillColorIndex() {
        return this.fillColorIndex;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        if (this.type == type) {
            return;
        }
        Type oldValue = this.type;
        this.type = type;
        this.ncolor = type.getColorCount();
        this.image = null;
        this.fillColorIndex = this.getType().getColorCount();
        fillColor = this.getType().getRGB(this.fillColorIndex);
        this.markDirty();
        this.update();
        this.firePropertyChange(PROPERTY_TYPE, oldValue, type);
    }

    protected void paintComponent(Graphics g) {
        int x = Math.round(this.getColumn().getDMinimum());
        int y = Math.round(this.getRow().getDMinimum());
        int width = Math.round(this.getColumn().getDMaximum()) - x;
        int height = Math.round(this.getRow().getDMaximum()) - y;
        this.image = this.isHorizontal() ? this.type.getHorizontalScaledImage(width, height) : this.type.getVerticalScaledImage(width, height);
        g.translate(-this.getX(), -this.getY());
        if (!this.isHorizontal()) {
            ++y;
        }
        g.drawImage(this.image, x, y, this);
        g.translate(this.getX(), this.getY());
        super.paintComponent(g);
    }

    protected Rectangle getAxisBounds() {
        int x = Math.round(this.getColumn().getDMinimum());
        int y = Math.round(this.getRow().getDMinimum());
        int width = Math.round(this.getColumn().getDMaximum()) - x;
        int height = Math.round(this.getRow().getDMaximum()) - y;
        Rectangle rc = new Rectangle(x, y, width, height);
        Rectangle bounds = super.getAxisBounds();
        bounds.add(rc);
        return bounds;
    }

    public static DasColumn getColorBarColumn(DasColumn column) {
        return new DasColumn(null, column, 1.0, 1.0, 1.0, 2.0, 0, 0);
    }

    static DasColorBar processColorbarElement(Element element, FormBase form) throws DasPropertyException, DasNameException, ParseException {
        String columnString;
        Datum dataMaximum;
        Datum dataMinimum;
        String name = element.getAttribute("name");
        boolean log = element.getAttribute("log").equals("true");
        String unitStr = element.getAttribute("units");
        if (unitStr == null) {
            unitStr = "";
        }
        if (unitStr.equals("TIME")) {
            String min = element.getAttribute("dataMinimum");
            String max = element.getAttribute("dataMaximum");
            dataMinimum = min == null || min.equals("") ? TimeUtil.create("1979-02-26") : TimeUtil.create(min);
            dataMaximum = max == null || max.equals("") ? TimeUtil.create("1979-02-27") : TimeUtil.create(max);
        } else {
            Units units = Units.getByName(unitStr);
            String min = element.getAttribute("dataMinimum");
            String max = element.getAttribute("dataMaximum");
            dataMinimum = min == null || min.equals("") ? Datum.create(1.0, units) : Datum.create(Double.parseDouble(min), units);
            dataMaximum = max == null || max.equals("") ? Datum.create(10.0, units) : Datum.create(Double.parseDouble(max), units);
        }
        int orientation = DasColorBar.parseOrientationString(element.getAttribute("orientation"));
        DasColorBar cb = new DasColorBar(dataMinimum, dataMaximum, orientation, log);
        String rowString = element.getAttribute("row");
        if (!rowString.equals("")) {
            DasRow row = (DasRow)form.checkValue(rowString, DasRow.class, "<row>");
            cb.setRow(row);
        }
        if (!(columnString = element.getAttribute("column")).equals("")) {
            DasColumn column = (DasColumn)form.checkValue(columnString, DasColumn.class, "<column>");
            cb.setColumn(column);
        }
        cb.setLabel(element.getAttribute("label"));
        cb.setOppositeAxisVisible(!element.getAttribute("oppositeAxisVisible").equals("false"));
        cb.setTickLabelsVisible(!element.getAttribute("tickLabelsVisible").equals("false"));
        cb.setType(Type.parse(element.getAttribute(PROPERTY_TYPE)));
        cb.setDasName(name);
        DasApplication app = form.getDasApplication();
        NameContext nc = app.getNameContext();
        nc.put(name, cb);
        return cb;
    }

    public Element getDOMElement(Document document) {
        Element element = document.createElement("colorbar");
        String minimumStr = this.getDataMinimum().toString();
        element.setAttribute("dataMinimum", minimumStr);
        String maximumStr = this.getDataMaximum().toString();
        element.setAttribute("dataMaximum", maximumStr);
        element.setAttribute("name", this.getDasName());
        element.setAttribute("row", this.getRow().getDasName());
        element.setAttribute("column", this.getColumn().getDasName());
        element.setAttribute("label", this.getLabel());
        element.setAttribute("log", Boolean.toString(this.isLog()));
        element.setAttribute("tickLabelsVisible", Boolean.toString(this.isTickLabelsVisible()));
        element.setAttribute("oppositeAxisVisible", Boolean.toString(this.isOppositeAxisVisible()));
        element.setAttribute("animated", Boolean.toString(this.isAnimated()));
        element.setAttribute("orientation", DasColorBar.orientationToString(this.getOrientation()));
        element.setAttribute(PROPERTY_TYPE, this.getType().toString());
        return element;
    }

    public static DasColorBar createNamedColorBar(String name) {
        DasColorBar cb = new DasColorBar(Datum.create(1.0, Units.dimensionless), Datum.create(10.0, Units.dimensionless), false);
        if (name == null) {
            name = "colorbar_" + Integer.toHexString(System.identityHashCode(cb));
        }
        try {
            cb.setDasName(name);
        }
        catch (DasNameException dne) {
            DasExceptionHandler.handle(dne);
        }
        return cb;
    }

    public Shape getActiveRegion() {
        int x = Math.round(this.getColumn().getDMinimum());
        int y = Math.round(this.getRow().getDMinimum());
        int width = Math.round(this.getColumn().getDMaximum()) - x;
        int height = Math.round(this.getRow().getDMaximum()) - y;
        Rectangle bounds = this.primaryInputPanel.getBounds();
        bounds.translate(this.getX(), this.getY());
        Rectangle middleBounds = new Rectangle(x, y, width, height);
        bounds.add(middleBounds);
        if (this.isOppositeAxisVisible()) {
            Rectangle secondaryBounds = this.secondaryInputPanel.getBounds();
            secondaryBounds.translate(this.getX(), this.getY());
            bounds.add(secondaryBounds);
        }
        return bounds;
    }

    public MouseModule getRepaletteMouseModule(Renderer r) {
        return new ColorBarRepaletteMouseModule(r, this);
    }

    public Color getFillColor() {
        return new Color(fillColor, true);
    }

    public void setFillColor(Color fillColor) {
        Color oldColor = new Color(DasColorBar.fillColor);
        DasColorBar.fillColor = fillColor.getRGB();
        this.type.initializeColorTable(240, 0, this.type.getColorCount());
        this.markDirty();
        this.update();
        this.firePropertyChange(PROPERTY_FILL_COLOR, oldColor, fillColor);
    }

    public class ColorBarRepaletteMouseModule
    extends MouseModule {
        DasColorBar colorBar;
        Renderer parent;
        DatumRange range0;
        int lastTopColor;
        int lastBottomColor;
        boolean animated0;
        int state;
        int STATE_IGNORE = 300;
        int STATE_TOP = 200;
        int STATE_BOTTOM = 100;
        private EventListenerList listenerList = null;

        public String getLabel() {
            return "Repalette";
        }

        public ColorBarRepaletteMouseModule(Renderer parent, DasColorBar colorBar) {
            if (colorBar.isHorizontal()) {
                throw new IllegalArgumentException("Axis orientation is not vertical");
            }
            if (parent == null) {
                throw new IllegalArgumentException("Parent is null");
            }
            this.parent = parent;
            this.dragRenderer = new HorizontalSliceSelectionRenderer(parent.getParent());
            this.colorBar = colorBar;
        }

        private void setColorBar(int y) {
            int bottomColor;
            int topColor;
            DasRow row = this.colorBar.getRow();
            double alpha = (double)(row.getDMaximum() - y) / (1.0 * (double)row.getHeight());
            if (this.state == this.STATE_TOP) {
                topColor = (int)(240.0 * alpha);
                topColor = Math.max(13, topColor);
                bottomColor = 0;
            } else if (this.state == this.STATE_BOTTOM) {
                topColor = 240;
                bottomColor = (int)(240.0 * alpha);
                bottomColor = Math.min(228, bottomColor);
            } else {
                return;
            }
            System.err.println("" + bottomColor + " " + topColor);
            this.lastTopColor = topColor;
            this.lastBottomColor = bottomColor;
            this.colorBar.type.initializeColorTable(240, bottomColor, this.lastTopColor);
            this.colorBar.image = null;
            this.colorBar.type.image = null;
            this.colorBar.repaint();
            this.parent.refreshImage();
        }

        public void mouseReleased(MouseEvent e) {
            if (this.state != this.STATE_IGNORE) {
                this.colorBar.setAnimated(this.animated0);
                int lastTopColor = this.lastTopColor;
                double a0 = (double)this.lastBottomColor / 240.0;
                double a1 = (double)lastTopColor / 240.0;
                DatumRange dr = DasColorBar.this.isLog() ? DatumRangeUtil.rescaleLog(this.range0, a0, a1) : DatumRangeUtil.rescale(this.range0, a0, a1);
                this.colorBar.setDatumRange(dr);
                this.colorBar.type.initializeColorTable(240, 0, 240);
                this.colorBar.image = null;
                this.colorBar.type.image = null;
                this.colorBar.repaint();
                this.parent.refreshImage();
            }
        }

        public void mousePointSelected(MousePointSelectionEvent e) {
            this.setColorBar(e.getY());
        }

        public synchronized void addDataRangeSelectionListener(DataRangeSelectionListener listener) {
            if (this.listenerList == null) {
                this.listenerList = new EventListenerList();
            }
            this.listenerList.add(DataRangeSelectionListener.class, listener);
        }

        public synchronized void removeDataRangeSelectionListener(DataRangeSelectionListener listener) {
            this.listenerList.remove(DataRangeSelectionListener.class, listener);
        }

        private void fireDataRangeSelectionListenerDataRangeSelected(DataRangeSelectionEvent event) {
            if (this.listenerList == null) {
                return;
            }
            Object[] listeners = this.listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != DataRangeSelectionListener.class) continue;
                ((DataRangeSelectionListener)listeners[i + 1]).dataRangeSelected(event);
            }
        }

        public void mousePressed(MouseEvent e) {
            super.mousePressed(e);
            if (DasColorBar.this.getColumn().contains(e.getX() + DasColorBar.this.getX())) {
                this.state = e.getY() + DasColorBar.this.getY() > DasColorBar.this.getRow().getDMiddle() ? this.STATE_BOTTOM : this.STATE_TOP;
                this.animated0 = this.colorBar.isAnimated();
                this.colorBar.setAnimated(false);
                this.range0 = this.colorBar.getDatumRange();
            } else {
                this.state = this.STATE_IGNORE;
            }
        }
    }

    public static final class Type
    implements Enumeration,
    Displayable {
        public static final Type COLOR_WEDGE = new Type("color_wedge");
        public static final Type GRAYSCALE = new Type("grayscale");
        public static final Type INVERSE_GRAYSCALE = new Type("inverse_grayscale");
        public static final Type WRAPPED_COLOR_WEDGE = new Type("wrapped_color_wedge");
        private BufferedImage image;
        private int[] colorTable;
        private final String desc;
        private Icon icon;

        private Type(String desc) {
            this.desc = desc;
        }

        public Icon getListIcon() {
            this.maybeInitializeIcon();
            return this.icon;
        }

        public void maybeInitializeIcon() {
            if (this.icon == null) {
                this.icon = new ImageIcon(this.getVerticalScaledImage(16, 16));
            }
        }

        public String toString() {
            return this.desc;
        }

        public String getListLabel() {
            return this.desc;
        }

        public int getColorCount() {
            this.maybeInitializeColorTable();
            return this.colorTable.length - 1;
        }

        public int getRGB(int index) {
            this.maybeInitializeColorTable();
            return this.colorTable[index];
        }

        public BufferedImage getHorizontalScaledImage(int width, int height) {
            this.maybeInitializeImage();
            BufferedImage scaled = new BufferedImage(width, height, 1);
            AffineTransform at = new AffineTransform();
            at.scale((double)width / (double)this.getColorCount(), height);
            at.rotate(-1.5707963267948966);
            at.translate(-1.0, 0.0);
            AffineTransformOp op = new AffineTransformOp(at, 1);
            op.filter(this.image, scaled);
            return scaled;
        }

        public BufferedImage getVerticalScaledImage(int width, int height) {
            this.maybeInitializeImage();
            BufferedImage scaled = new BufferedImage(width, height, 1);
            AffineTransform at = new AffineTransform();
            at.scale(width, -((double)height) / (double)this.getColorCount());
            at.translate(0.0, -((double)this.getColorCount()));
            AffineTransformOp op = new AffineTransformOp(at, 1);
            op.filter(this.image, scaled);
            return scaled;
        }

        private void maybeInitializeImage() {
            if (this.image == null) {
                this.maybeInitializeColorTable();
                this.image = new BufferedImage(1, this.getColorCount(), 1);
                this.image.setRGB(0, 0, 1, this.getColorCount(), this.colorTable, 0, 1);
            }
        }

        private static int[] makeColorTable(int[] index, int[] red, int[] green, int[] blue, int ncolor, int bottom, int top) {
            int[] colorTable = new int[ncolor];
            int ii = 0;
            for (int i = 0; i < ncolor - 1; ++i) {
                double a;
                float comp = (i - bottom) * 255 / (top - bottom);
                if (comp > (float)index[ii + 1]) {
                    ++ii;
                }
                if (ii >= index.length - 1) {
                    a = 1.0;
                    ii = index.length - 2;
                } else {
                    a = (double)(comp - (float)index[ii]) / (double)(index[ii + 1] - index[ii]);
                }
                if (a > 1.0) {
                    a = 1.0;
                }
                if (a < 0.0) {
                    a = 0.0;
                }
                double rr = ((double)red[ii] * (1.0 - a) + (double)red[ii + 1] * a) / 255.0;
                double gg = ((double)green[ii] * (1.0 - a) + (double)green[ii + 1] * a) / 255.0;
                double bb = ((double)blue[ii] * (1.0 - a) + (double)blue[ii + 1] * a) / 255.0;
                colorTable[i] = new Color((float)rr, (float)gg, (float)bb).getRGB();
            }
            colorTable[ncolor - 1] = fillColor;
            return colorTable;
        }

        private void maybeInitializeColorTable() {
            if (this.colorTable == null) {
                this.initializeColorTable(240, 0, 240);
            }
        }

        private void initializeColorTable(int size, int bottom, int top) {
            if (this == COLOR_WEDGE) {
                this.initializeColorWedge(size, bottom, top);
            } else if (this == GRAYSCALE) {
                this.initializeGrayScale(size, bottom, top);
            } else if (this == INVERSE_GRAYSCALE) {
                this.initializeInverseGrayScale(size, bottom, top);
            } else if (this == WRAPPED_COLOR_WEDGE) {
                this.initializeWrappedColorWedge(size, bottom, top);
            }
        }

        private void initializeColorWedge(int size, int bottom, int top) {
            int[] index = new int[]{0, 30, 63, 126, 162, 192, 221, 255};
            int[] red = new int[]{0, 0, 0, 0, 255, 255, 255, 255};
            int[] green = new int[]{0, 0, 255, 255, 255, 185, 84, 0};
            int[] blue = new int[]{137, 255, 255, 0, 0, 0, 0, 0};
            this.colorTable = Type.makeColorTable(index, red, green, blue, size, bottom, top);
            this.colorTable[0] = this.colorTable[0] & 0xFFFFFF00 | 1;
        }

        private void initializeBlueToOrange(int size, int bottom, int top) {
            int[] index = new int[]{0, 23, 46, 69, 92, 115, 139, 162, 185, 208, 231, 255};
            int[] red = new int[]{0, 25, 50, 101, 153, 204, 255, 255, 255, 255, 255, 255};
            int[] green = new int[]{42, 101, 153, 204, 237, 255, 255, 238, 204, 153, 102, 42};
            int[] blue = new int[]{255, 255, 255, 255, 255, 255, 204, 153, 101, 50, 25, 0};
            this.colorTable = Type.makeColorTable(index, red, green, blue, size, bottom, top);
            this.colorTable[0] = this.colorTable[0] & 0xFFFFFF00 | 1;
        }

        private void initializeWrappedColorWedge(int size, int bottom, int top) {
            int[] index = new int[]{0, 32, 64, 96, 128, 160, 192, 224, 255};
            int[] red = new int[]{225, 0, 0, 0, 255, 255, 255, 255, 255};
            int[] green = new int[]{0, 0, 255, 255, 255, 185, 84, 0, 0};
            int[] blue = new int[]{225, 255, 255, 0, 0, 0, 0, 0, 255};
            this.colorTable = Type.makeColorTable(index, red, green, blue, size, bottom, top);
        }

        private void initializeInverseGrayScale(int size, int bottom, int top) {
            int[] index = new int[]{0, 255};
            int[] red = new int[]{0, 255};
            int[] green = new int[]{0, 255};
            int[] blue = new int[]{0, 255};
            this.colorTable = Type.makeColorTable(index, red, green, blue, size, bottom, top);
        }

        private void initializeGrayScale(int size, int bottom, int top) {
            int[] index = new int[]{0, 255};
            int[] red = new int[]{255, 0};
            int[] green = new int[]{255, 0};
            int[] blue = new int[]{255, 0};
            this.colorTable = Type.makeColorTable(index, red, green, blue, size, bottom, top);
        }

        public static Type parse(String s) {
            if (s.equals("color_wedge")) {
                return COLOR_WEDGE;
            }
            if (s.equals("grayscale")) {
                return GRAYSCALE;
            }
            if (s.equals("inverse_grayscale")) {
                return INVERSE_GRAYSCALE;
            }
            throw new IllegalArgumentException("invalid DasColorBar.Type string: " + s);
        }
    }

    protected class ColorBarLayoutManager
    extends DasAxis.AxisLayoutManager {
        protected ColorBarLayoutManager() {
            super(DasColorBar.this);
        }

        public void layoutContainer(Container parent) {
            super.layoutContainer(parent);
            int x = Math.round(DasColorBar.this.getColumn().getDMinimum());
            int y = Math.round(DasColorBar.this.getRow().getDMinimum());
            int width = Math.round(DasColorBar.this.getColumn().getDMaximum()) - x;
            int height = Math.round(DasColorBar.this.getRow().getDMaximum()) - y;
            Rectangle rc = new Rectangle(x - DasColorBar.this.getX(), y - DasColorBar.this.getY(), width, height);
            Rectangle bounds = DasColorBar.this.primaryInputPanel.getBounds();
            bounds.add(rc);
            DasColorBar.this.primaryInputPanel.setBounds(bounds);
        }
    }
}

