/*
 * Decompiled with CFR 0.152.
 */
package org.das2.graph;

import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.das2.DasApplication;
import org.das2.DasNameException;
import org.das2.components.propertyeditor.Editable;
import org.das2.components.propertyeditor.PropertyEditor;
import org.das2.event.DasMouseInputAdapter;
import org.das2.event.MouseModule;
import org.das2.graph.DasCanvas;
import org.das2.graph.DasColumn;
import org.das2.graph.DasRow;
import org.das2.graph.event.DasUpdateEvent;
import org.das2.graph.event.DasUpdateListener;
import org.das2.system.DasLogger;

public abstract class DasCanvasComponent
extends JComponent
implements Editable {
    private Logger logger = DasLogger.getLogger(DasLogger.GUI_LOG);
    private static final MouseListener currentComponentListener = new MouseAdapter(){

        public void mousePressed(MouseEvent e) {
            DasCanvas canvas;
            DasCanvasComponent dcc = e.getSource() instanceof DasCanvasComponent ? (DasCanvasComponent)e.getComponent() : (DasCanvasComponent)SwingUtilities.getAncestorOfClass(DasCanvasComponent.class, e.getComponent());
            CanvasComponentAction.currentCanvasComponent = dcc;
            DasCanvas.CanvasAction.currentCanvas = canvas = dcc.getCanvas();
        }
    };
    public static final Action PROPERTIES_ACTION = new CanvasComponentAction("Properties"){

        public void actionPerformed(ActionEvent e) {
            if (2.getCurrentComponent() != null) {
                2.getCurrentComponent().showProperties();
            }
        }
    };
    private DasRow row;
    private DasColumn column;
    private ResizeListener rl;
    protected DasMouseInputAdapter mouseAdapter;
    private String dasName;
    private org.das2.event.DasUpdateEvent devt;
    boolean dirty = true;

    public DasCanvasComponent() {
        this.setOpaque(false);
        this.rl = new ResizeListener();
        this.row = DasRow.NULL;
        this.column = DasColumn.NULL;
        this.setDasMouseInputAdapter(new DasMouseInputAdapter(this));
        try {
            String name = DasApplication.getDefaultApplication().suggestNameFor(this);
            this.setDasName(name);
        }
        catch (DasNameException dasNameException) {
            // empty catch block
        }
    }

    public void addMouseModule(MouseModule module) {
        this.mouseAdapter.addMouseModule(module);
    }

    public void removeMouseModule(MouseModule module) {
        this.mouseAdapter.removeMouseModule(module);
    }

    public DasRow getRow() {
        return this.row;
    }

    public DasColumn getColumn() {
        return this.column;
    }

    public void resize() {
        if (this.column == DasColumn.NULL || this.row == DasRow.NULL) {
            this.logger.warning("Null row and/or column in resize: row=" + this.row + " column=" + this.column);
        } else {
            this.setBounds(this.column.getDMinimum(), this.row.getDMinimum(), this.column.getDMaximum() - this.column.getDMinimum(), this.row.getDMaximum() - this.row.getDMinimum());
        }
    }

    public void setBounds(int x, int y, int width, int height) {
        if (this.getDasName().startsWith("plot_")) {
            // empty if block
        }
        super.setBounds(x, y, width, height);
    }

    public void setBounds(Rectangle r) {
        super.setBounds(r);
    }

    public void setRow(DasRow r) {
        if (this.row == r) {
            return;
        }
        DasRow oldValue = this.row;
        if (this.row != DasRow.NULL) {
            this.row.removepwUpdateListener(this.rl);
        }
        this.row = r;
        if (this.row != DasRow.NULL) {
            this.row.addpwUpdateListener(this.rl);
        }
        this.firePropertyChange("row", oldValue, r);
    }

    public void setColumn(DasColumn c) {
        if (this.column == c) {
            return;
        }
        DasColumn oldValue = this.column;
        if (this.column != DasColumn.NULL) {
            this.column.removepwUpdateListener(this.rl);
        }
        this.column = c;
        if (this.column != DasColumn.NULL) {
            this.column.addpwUpdateListener(this.rl);
        }
        this.firePropertyChange("column", oldValue, c);
    }

    public void showProperties() {
        PropertyEditor editor = new PropertyEditor(this);
        editor.showDialog(this);
    }

    public String toString() {
        return this.getClass().getName() + "'" + this.getDasName() + "'";
    }

    protected void updateImmediately() {
        this.logger.finer("updateImmediately for " + this.getClass().getName());
    }

    public void update() {
        this.logger.finer("update for " + this.getClass().getName());
        EventQueue eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
        if (this.devt == null) {
            this.devt = new org.das2.event.DasUpdateEvent(this);
        }
        eventQueue.postEvent(this.devt);
    }

    protected void processEvent(AWTEvent e) {
        super.processEvent(e);
        if (e instanceof org.das2.event.DasUpdateEvent) {
            this.processDasUpdateEvent((org.das2.event.DasUpdateEvent)e);
        }
    }

    protected void processDasUpdateEvent(org.das2.event.DasUpdateEvent e) {
        if (this.isDisplayable()) {
            if (this.isDirty()) {
                this.markClean();
                this.updateImmediately();
            }
            this.resize();
            this.repaint();
        }
    }

    protected AWTEvent coalesceEvents(AWTEvent existingEvent, AWTEvent newEvent) {
        if (existingEvent instanceof org.das2.event.DasUpdateEvent && newEvent instanceof org.das2.event.DasUpdateEvent) {
            return existingEvent;
        }
        return super.coalesceEvents(existingEvent, newEvent);
    }

    protected void installComponent() {
    }

    protected void uninstallComponent() {
    }

    public Font getFont() {
        return this.getParent() == null ? super.getFont() : this.getParent().getFont();
    }

    public double getEmSize() {
        return this.getFont().getSize2D();
    }

    void markDirty() {
        this.dirty = true;
    }

    boolean isDirty() {
        return this.dirty;
    }

    void markClean() {
        this.dirty = false;
    }

    public DasCanvas getCanvas() {
        return (DasCanvas)this.getParent();
    }

    public String getDasName() {
        return this.dasName;
    }

    public void setDasName(String name) throws DasNameException {
        if (name.equals(this.dasName)) {
            return;
        }
        String oldName = this.dasName;
        this.dasName = name;
        DasApplication app = DasApplication.getDefaultApplication();
        if (app != null) {
            app.getNameContext().put(name, this);
            if (oldName != null) {
                app.getNameContext().remove(oldName);
            }
        }
        this.firePropertyChange("name", oldName, name);
    }

    public Shape getActiveRegion() {
        int x = this.getColumn().getDMinimum();
        int y = this.getRow().getDMinimum();
        int width = this.getColumn().getDMaximum() - x;
        int height = this.getRow().getDMaximum() - y;
        return new Rectangle(x, y, width, height);
    }

    public boolean acceptContext(int x, int y) {
        return true;
    }

    public DasMouseInputAdapter getMouseAdapter() {
        return this.mouseAdapter;
    }

    public Action[] getActions() {
        return new Action[]{PROPERTIES_ACTION};
    }

    public DasMouseInputAdapter getDasMouseInputAdapter() {
        return this.mouseAdapter;
    }

    public synchronized void setDasMouseInputAdapter(DasMouseInputAdapter dasMouseInputAdapter) {
        if (this.mouseAdapter != null) {
            this.removeMouseListener(this.mouseAdapter);
            this.removeMouseMotionListener(this.mouseAdapter);
            this.removeMouseListener(currentComponentListener);
            this.removeKeyListener(this.mouseAdapter.getKeyAdapter());
            this.removeMouseWheelListener(this.mouseAdapter);
        }
        this.mouseAdapter = dasMouseInputAdapter;
        if (!DasApplication.getDefaultApplication().isHeadless()) {
            this.addMouseListener(this.mouseAdapter);
            this.addMouseMotionListener(this.mouseAdapter);
            this.addMouseListener(currentComponentListener);
            this.addKeyListener(this.mouseAdapter.getKeyAdapter());
            this.addMouseWheelListener(this.mouseAdapter);
        }
    }

    private class ResizeListener
    implements DasUpdateListener {
        private ResizeListener() {
        }

        public void update(DasUpdateEvent e) {
            DasCanvasComponent.this.logger.fine("component row or column moved: " + e.getSource());
            DasCanvasComponent.this.markDirty();
            DasCanvasComponent.this.update();
        }
    }

    protected static abstract class CanvasComponentAction
    extends DasCanvas.CanvasAction {
        private static DasCanvasComponent currentCanvasComponent;

        public CanvasComponentAction(String label) {
            super(label);
        }

        public static DasCanvasComponent getCurrentComponent() {
            return currentCanvasComponent;
        }
    }
}

