/*
 * Decompiled with CFR 0.152.
 */
package org.das2.graph;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.EventListenerList;
import org.das2.DasApplication;
import org.das2.DasException;
import org.das2.DasNameException;
import org.das2.DasProperties;
import org.das2.DasPropertyException;
import org.das2.NameContext;
import org.das2.dasml.FormBase;
import org.das2.dataset.DataSetDescriptor;
import org.das2.dataset.DataSetUpdateEvent;
import org.das2.dataset.DataSetUpdateListener;
import org.das2.dataset.DataSetUtil;
import org.das2.dataset.VectorDataSet;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.datum.DatumVector;
import org.das2.datum.InconvertibleUnitsException;
import org.das2.datum.TimeLocationUnits;
import org.das2.datum.TimeUtil;
import org.das2.datum.Units;
import org.das2.datum.format.DatumFormatter;
import org.das2.datum.format.DefaultDatumFormatterFactory;
import org.das2.event.DataRangeSelectionEvent;
import org.das2.event.DataRangeSelectionListener;
import org.das2.event.HorizontalRangeSelectorMouseModule;
import org.das2.event.MouseModule;
import org.das2.event.TimeRangeSelectionEvent;
import org.das2.event.TimeRangeSelectionListener;
import org.das2.event.VerticalRangeSelectorMouseModule;
import org.das2.event.ZoomPanMouseModule;
import org.das2.graph.DasCanvasComponent;
import org.das2.graph.DasColumn;
import org.das2.graph.DasDevicePosition;
import org.das2.graph.DasPlot;
import org.das2.graph.DasRow;
import org.das2.graph.DataRange;
import org.das2.graph.GraphUtil;
import org.das2.graph.TickVDescriptor;
import org.das2.system.DasLogger;
import org.das2.util.DasExceptionHandler;
import org.das2.util.DasMath;
import org.das2.util.GrannyTextRenderer;
import org.das2.util.monitor.NullProgressMonitor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DasAxis
extends DasCanvasComponent
implements DataRangeSelectionListener,
TimeRangeSelectionListener,
Cloneable {
    public static final String PROP_LABEL = "label";
    public static final String PROP_LOG = "log";
    public static final String PROP_OPPOSITE_AXIS_VISIBLE = "oppositeAxisVisible";
    public static final String PROP_BOUNDS = "bounds";
    public static final int TOP = 1;
    public static final int BOTTOM = 2;
    public static final int LEFT = 3;
    public static final int RIGHT = 4;
    public static final int HORIZONTAL = 2;
    public static final int VERTICAL = 3;
    public static final int UP = 995;
    public static final int DOWN = 996;
    private static final String SCAN_PREVIOUS_LABEL = "<< scan";
    private static final String SCAN_NEXT_LABEL = "scan >>";
    public static String PROP_UNITS = "units";
    protected DataRange dataRange;
    public static String PROPERTY_TICKS = "ticks";
    private DatumFormatter userDatumFormatter = null;
    double at_m;
    double at_b;
    private int orientation;
    private int tickDirection = 1;
    protected String axisLabel = "";
    protected TickVDescriptor tickV;
    protected boolean autoTickV = true;
    private boolean ticksVisible = true;
    private boolean tickLabelsVisible = true;
    private boolean oppositeAxisVisible = false;
    protected DatumFormatter datumFormatter = DefaultDatumFormatterFactory.getInstance().defaultFormatter();
    private MouseModule zoom = null;
    private PropertyChangeListener dataRangePropertyListener;
    protected JPanel primaryInputPanel;
    protected JPanel secondaryInputPanel;
    private ScanButton scanPrevious;
    private ScanButton scanNext;
    private boolean animated = "on".equals(DasProperties.getInstance().get("visualCues"));
    private Rectangle blLineRect;
    private Rectangle trLineRect;
    private Rectangle blTickRect;
    private Rectangle trTickRect;
    private Rectangle blLabelRect;
    private Rectangle trLabelRect;
    private Rectangle blTitleRect;
    private Rectangle trTitleRect;
    private boolean flipped;
    private EventListenerList timeRangeListenerList = null;
    private TimeRangeSelectionEvent lastProcessedEvent = null;
    private DataSetDescriptor dsd;
    private VectorDataSet[] tcaData = new VectorDataSet[0];
    private String dataset = "";
    private boolean drawTca;
    public static String PROPERTY_DATUMRANGE = "datumRange";
    private static boolean DEBUG_GRAPHICS = false;
    private static final Color[] DEBUG_COLORS = DEBUG_GRAPHICS ? new Color[]{Color.BLACK, Color.RED, Color.GREEN, Color.BLUE, Color.GRAY, Color.CYAN, Color.MAGENTA, Color.YELLOW} : null;
    private int debugColorIndex = 0;
    private DasPlot dasPlot;
    private JMenu favoritesMenu;
    private JMenu backMenu;
    private static final Logger logger = DasLogger.getLogger(DasLogger.GRAPHICS_LOG);
    private final DataSetUpdateListener tcaListener = new DataSetUpdateListener(){

        public void dataSetUpdated(DataSetUpdateEvent e) {
            VectorDataSet ds = (VectorDataSet)e.getDataSet();
            if (ds == null) {
                logger.warning("" + e.getException());
                return;
            }
            logger.fine("got TCADataSet");
            List itemList = (List)ds.getProperty("plane-list");
            VectorDataSet[] newData = new VectorDataSet[itemList.size()];
            newData[0] = ds;
            for (int i = 1; i < itemList.size(); ++i) {
                newData[i] = (VectorDataSet)ds.getPlanarView((String)itemList.get(i));
            }
            DasAxis.access$702(DasAxis.this, newData);
            DasAxis.this.update();
        }
    };
    private String errorMessage;
    private static final Pattern pattern = Pattern.compile("\\([eEfF]\\d+.\\d+\\)");
    protected String formatString = "";
    public static final String PROP_FORMATSTRING = "formatString";
    protected boolean flipLabel = false;
    public static final String PROP_FLIPLABEL = "flipLabel";

    public DatumFormatter getUserDatumFormatter() {
        return this.userDatumFormatter;
    }

    public void setUserDatumFormatter(DatumFormatter userDatumFormatter) {
        this.userDatumFormatter = userDatumFormatter;
        this.updateTickV();
        this.repaint();
    }

    public DasAxis(Datum min, Datum max, int orientation) {
        this(min, max, orientation, false);
    }

    public DasAxis(Datum min, Datum max, int orientation, boolean log) {
        this(orientation);
        this.dataRange = new DataRange(this, min, max, log);
        this.addListenersToDataRange(this.dataRange, this.dataRangePropertyListener);
        this.copyFavorites();
        this.copyHistory();
    }

    protected DasAxis(DataRange range, int orientation) {
        this(orientation);
        this.dataRange = range;
        this.addListenersToDataRange(range, this.dataRangePropertyListener);
        this.copyFavorites();
        this.copyHistory();
    }

    private void addListenersToDataRange(DataRange range, PropertyChangeListener listener) {
        range.addPropertyChangeListener(PROP_LOG, listener);
        range.addPropertyChangeListener("minimum", listener);
        range.addPropertyChangeListener("maximum", listener);
        range.addPropertyChangeListener(DataRange.PROPERTY_DATUMRANGE, listener);
        range.addPropertyChangeListener("history", listener);
        range.addPropertyChangeListener("favorites", listener);
    }

    public DasAxis(DatumRange range, int orientation) {
        this(range.min(), range.max(), orientation);
    }

    private DasAxis(int orientation) {
        this.setOpaque(false);
        this.setOrientationInternal(orientation);
        this.installMouseModules();
        if (!DasApplication.getDefaultApplication().isHeadless()) {
            this.backMenu = new JMenu("Back");
            this.mouseAdapter.addMenuItem(this.backMenu);
            this.favoritesMenu = new JMenu("Favorites");
            this.mouseAdapter.addMenuItem(this.favoritesMenu);
        }
        this.dataRangePropertyListener = this.createDataRangePropertyListener();
        this.setLayout(new AxisLayoutManager());
        this.maybeInitializeInputPanels();
        this.maybeInitializeScanButtons();
        this.add(this.primaryInputPanel);
        this.add(this.secondaryInputPanel);
    }

    public void addToFavorites(DatumRange range) {
        this.dataRange.addToFavorites(range);
        this.copyFavorites();
    }

    private void copyFavorites() {
        if (DasApplication.getDefaultApplication().isHeadless()) {
            return;
        }
        this.favoritesMenu.removeAll();
        List favorites = this.dataRange.getFavorites();
        for (final DatumRange r : favorites) {
            AbstractAction action = new AbstractAction(r.toString()){

                public void actionPerformed(ActionEvent e) {
                    DasAxis.this.setDatumRange(r);
                }
            };
            JMenuItem menuItem = new JMenuItem(action);
            this.favoritesMenu.add(menuItem);
        }
        AbstractAction action = new AbstractAction("add to favorites"){

            public void actionPerformed(ActionEvent e) {
                DasAxis.this.addToFavorites(DasAxis.this.getDatumRange());
            }
        };
        JMenuItem addItem = new JMenuItem(action);
        this.favoritesMenu.add(addItem);
    }

    private void copyHistory() {
        if (DasApplication.getDefaultApplication().isHeadless()) {
            return;
        }
        this.backMenu.removeAll();
        List history = this.dataRange.getHistory();
        int ii = 0;
        Iterator i = history.iterator();
        while (i.hasNext()) {
            final int ipop = ii++;
            DatumRange r = (DatumRange)i.next();
            AbstractAction action = new AbstractAction(r.toString()){

                public void actionPerformed(ActionEvent e) {
                    DasAxis.this.dataRange.popHistory(ipop);
                    DasAxis.this.setDataRangePrev();
                }
            };
            JMenuItem menuItem = new JMenuItem(action);
            this.backMenu.add(menuItem);
        }
    }

    private void maybeInitializeInputPanels() {
        if (this.primaryInputPanel == null) {
            this.primaryInputPanel = new JPanel();
            this.primaryInputPanel.setOpaque(false);
        }
        if (this.secondaryInputPanel == null) {
            this.secondaryInputPanel = new JPanel();
            this.secondaryInputPanel.setOpaque(false);
        }
    }

    private void maybeInitializeScanButtons() {
        if (!DasApplication.getDefaultApplication().isHeadless()) {
            this.scanPrevious = new ScanButton(SCAN_PREVIOUS_LABEL);
            this.scanNext = new ScanButton(SCAN_NEXT_LABEL);
            ActionListener al = this.createScanActionListener();
            this.scanPrevious.addActionListener(al);
            this.scanNext.addActionListener(al);
            this.add(this.scanPrevious);
            this.add(this.scanNext);
        }
    }

    private ActionListener createScanActionListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String command = e.getActionCommand();
                DasLogger.getLogger(DasLogger.GUI_LOG).fine("event " + command);
                if (command.equals(DasAxis.SCAN_PREVIOUS_LABEL)) {
                    DasAxis.this.scanPrevious();
                } else if (command.equals(DasAxis.SCAN_NEXT_LABEL)) {
                    DasAxis.this.scanNext();
                }
            }
        };
    }

    private PropertyChangeListener createDataRangePropertyListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                String propertyName = e.getPropertyName();
                Object oldValue = e.getOldValue();
                Object newValue = e.getNewValue();
                if (propertyName.equals(DasAxis.PROP_LOG)) {
                    DasAxis.this.update();
                    DasAxis.this.firePropertyChange(DasAxis.PROP_LOG, oldValue, newValue);
                } else if (propertyName.equals("minimum")) {
                    DasAxis.this.update();
                    DasAxis.this.firePropertyChange("dataMinimum", oldValue, newValue);
                } else if (propertyName.equals("maximum")) {
                    DasAxis.this.update();
                    DasAxis.this.firePropertyChange("dataMaximum", oldValue, newValue);
                } else if (propertyName.equals("favorites")) {
                    DasAxis.this.copyFavorites();
                } else if (propertyName.equals(DataRange.PROPERTY_DATUMRANGE)) {
                    DasAxis.this.update();
                    DasAxis.this.firePropertyChange(PROPERTY_DATUMRANGE, oldValue, newValue);
                } else if (propertyName.equals("history") && !DasAxis.this.dataRange.valueIsAdjusting()) {
                    DasAxis.this.copyHistory();
                }
                DasAxis.this.markDirty();
            }
        };
    }

    private void installMouseModules() {
        if (this.zoom instanceof HorizontalRangeSelectorMouseModule) {
            ((HorizontalRangeSelectorMouseModule)this.zoom).removeDataRangeSelectionListener(this);
            this.mouseAdapter.removeMouseModule(this.zoom);
        } else if (this.zoom instanceof VerticalRangeSelectorMouseModule) {
            ((VerticalRangeSelectorMouseModule)this.zoom).removeDataRangeSelectionListener(this);
            this.mouseAdapter.removeMouseModule(this.zoom);
        }
        if (this.isHorizontal()) {
            this.zoom = new HorizontalRangeSelectorMouseModule(this, this);
            ((HorizontalRangeSelectorMouseModule)this.zoom).addDataRangeSelectionListener(this);
            this.mouseAdapter.addMouseModule(this.zoom);
            this.mouseAdapter.setPrimaryModule(this.zoom);
            ZoomPanMouseModule zoomPan = new ZoomPanMouseModule((DasCanvasComponent)this, this, null);
            this.mouseAdapter.addMouseModule(zoomPan);
            this.mouseAdapter.setSecondaryModule(zoomPan);
        } else {
            this.zoom = new VerticalRangeSelectorMouseModule(this, this);
            ((VerticalRangeSelectorMouseModule)this.zoom).addDataRangeSelectionListener(this);
            this.mouseAdapter.addMouseModule(this.zoom);
            this.mouseAdapter.setPrimaryModule(this.zoom);
            ZoomPanMouseModule zoomPan = new ZoomPanMouseModule((DasCanvasComponent)this, null, this);
            this.mouseAdapter.addMouseModule(zoomPan);
            this.mouseAdapter.setSecondaryModule(zoomPan);
        }
    }

    public void setOrientation(int orientation) {
        boolean oldIsHorizontal = this.isHorizontal();
        this.setOrientationInternal(orientation);
        if (oldIsHorizontal != this.isHorizontal()) {
            this.installMouseModules();
        }
    }

    private void setOrientationInternal(int orientation) {
        this.orientation = orientation;
        if (orientation == 1) {
            this.setTickDirection(995);
        } else if (orientation == 2) {
            this.setTickDirection(996);
        } else if (orientation == 3) {
            this.setTickDirection(4);
        } else if (orientation == 4) {
            this.setTickDirection(3);
        } else {
            throw new IllegalArgumentException("Invalid value for orientation");
        }
    }

    public void setDatumRange(DatumRange dr) {
        if (this.getUnits().isConvertableTo(dr.getUnits())) {
            this.setDataRange(dr.min(), dr.max());
        } else {
            Units oldUnits = this.getUnits();
            this.resetRange(dr);
            this.firePropertyChange(PROP_UNITS, oldUnits, dr.getUnits());
        }
    }

    public DatumRange getDatumRange() {
        return this.dataRange.getDatumRange();
    }

    protected boolean rangeIsAcceptable(DatumRange dr) {
        return dr.min().lt(dr.max());
    }

    public void setDataRange(Datum minimum, Datum maximum) {
        double max;
        double min;
        Units units = this.dataRange.getUnits();
        if (minimum.getUnits() != units) {
            minimum = minimum.convertTo(units);
            maximum = maximum.convertTo(units);
        }
        DatumRange newRange = new DatumRange(minimum, maximum);
        logger.fine("enter dasAxis.setDataRange( " + newRange + " )");
        if (!this.rangeIsAcceptable(newRange)) {
            logger.warning("invalid range ignored");
            return;
        }
        double min0 = this.dataRange.getMinimum();
        double max0 = this.dataRange.getMaximum();
        if (this.dataRange.isLog()) {
            min = DasMath.log10(minimum.doubleValue(this.getUnits()));
            max = DasMath.log10(maximum.doubleValue(this.getUnits()));
        } else {
            min = minimum.doubleValue(this.getUnits());
            max = maximum.doubleValue(this.getUnits());
        }
        if (!this.valueIsAdjusting()) {
            this.animateChange(min0, max0, min, max);
        }
        DatumRange oldRange = this.dataRange.getDatumRange();
        this.dataRange.setRange(newRange);
        this.update();
        this.createAndFireRangeSelectionEvent();
        this.firePropertyChange(PROPERTY_DATUMRANGE, oldRange, newRange);
    }

    public void clearHistory() {
        this.dataRange.clearHistory();
    }

    private void createAndFireRangeSelectionEvent() {
        if (this.getUnits() instanceof TimeLocationUnits) {
            logger.fine("firing rangeSelectionEvent");
            TimeRangeSelectionEvent e = new TimeRangeSelectionEvent(this, new DatumRange(this.getDataMinimum(), this.getDataMaximum()));
            this.fireTimeRangeSelectionListenerTimeRangeSelected(e);
        }
    }

    public void setDataRangePrev() {
        logger.fine("enter dasAxis.setDataRangePrev()");
        DatumRange oldRange = this.dataRange.getDatumRange();
        double min0 = this.dataRange.getMinimum();
        double max0 = this.dataRange.getMaximum();
        this.dataRange.setRangePrev();
        DatumRange newRange = this.dataRange.getDatumRange();
        double min1 = this.dataRange.getMinimum();
        double max1 = this.dataRange.getMaximum();
        this.animateChange(min0, max0, min1, max1);
        this.update();
        this.createAndFireRangeSelectionEvent();
        this.firePropertyChange(PROPERTY_DATUMRANGE, oldRange, newRange);
    }

    public void setDataRangeForward() {
        logger.fine("enter dasAxis.setDataRangeForward()");
        double min0 = this.dataRange.getMinimum();
        double max0 = this.dataRange.getMaximum();
        DatumRange oldRange = this.dataRange.getDatumRange();
        this.dataRange.setRangeForward();
        DatumRange newRange = this.dataRange.getDatumRange();
        double min1 = this.dataRange.getMinimum();
        double max1 = this.dataRange.getMaximum();
        this.animateChange(min0, max0, min1, max1);
        this.update();
        this.createAndFireRangeSelectionEvent();
        this.firePropertyChange(PROPERTY_DATUMRANGE, oldRange, newRange);
    }

    public void setDataRangeZoomOut() {
        logger.fine("enter dasAxis.setDataRangeZoomOut()");
        double t1 = this.dataRange.getMinimum();
        double t2 = this.dataRange.getMaximum();
        double delta = t2 - t1;
        double min = t1 - delta;
        double max = t2 + delta;
        this.animateChange(t1, t2, min, max);
        DatumRange oldRange = this.dataRange.getDatumRange();
        this.dataRange.setRange(min, max);
        DatumRange newRange = this.dataRange.getDatumRange();
        this.update();
        this.createAndFireRangeSelectionEvent();
        this.firePropertyChange(PROPERTY_DATUMRANGE, oldRange, newRange);
    }

    public DataRange getDataRange() {
        return this.dataRange;
    }

    protected void deviceRangeChanged() {
    }

    public Datum getDataMinimum() {
        return this.dataRange.getDatumRange().min();
    }

    public Datum getDataMaximum() {
        return this.dataRange.getDatumRange().max();
    }

    public DatumRange getRange() {
        return this.dataRange.getDatumRange();
    }

    public double getDataMaximum(Units units) {
        return this.getDataMaximum().doubleValue(units);
    }

    public double getDataMinimum(Units units) {
        return this.getDataMinimum().doubleValue(units);
    }

    public void setDataMaximum(Datum max) {
        this.dataRange.setMaximum(max);
        this.update();
    }

    public void setDataMinimum(Datum min) {
        this.dataRange.setMinimum(min);
        this.update();
    }

    public boolean isLog() {
        return this.dataRange.isLog();
    }

    public void setLog(boolean log) {
        boolean oldLog = this.isLog();
        DatumRange range = this.getDatumRange();
        this.dataRange.setLog(log);
        this.update();
        if (log != oldLog) {
            this.firePropertyChange(PROP_LOG, oldLog, log);
        }
        if (!range.equals(this.getDatumRange())) {
            this.firePropertyChange(PROPERTY_DATUMRANGE, range, this.getDatumRange());
        }
    }

    public Units getUnits() {
        return this.dataRange.getUnits();
    }

    public void setUnits(Units newUnits) {
        this.dataRange.setUnits(newUnits);
    }

    public synchronized void resetRange(DatumRange range) {
        if (range.getUnits() != this.getUnits()) {
            if (this.dasPlot != null) {
                this.dasPlot.invalidateCacheImage();
            }
            logger.finest("replaceRange(" + range + ")");
            this.dataRange.resetRange(range);
        } else {
            this.dataRange.setRange(range);
        }
        this.updateTickV();
        this.markDirty();
        this.update();
    }

    public void setOppositeAxisVisible(boolean visible) {
        if (visible == this.oppositeAxisVisible) {
            return;
        }
        boolean oldValue = this.oppositeAxisVisible;
        this.oppositeAxisVisible = visible;
        this.revalidate();
        this.repaint();
        this.firePropertyChange(PROP_OPPOSITE_AXIS_VISIBLE, oldValue, visible);
    }

    public boolean isOppositeAxisVisible() {
        return this.oppositeAxisVisible;
    }

    public void setLabel(String t) {
        if (t == null) {
            throw new NullPointerException("axis label cannot be null");
        }
        String oldValue = this.axisLabel;
        this.axisLabel = t;
        this.update();
        this.firePropertyChange(PROP_LABEL, oldValue, t);
    }

    public String getLabel() {
        return this.axisLabel;
    }

    public boolean isAnimated() {
        return this.animated;
    }

    public void setAnimated(boolean animated) {
        this.animated = animated;
    }

    public boolean getDrawTca() {
        return this.drawTca;
    }

    public void setDrawTca(boolean b) {
        boolean oldValue = this.drawTca;
        if (b && this.getOrientation() != 2) {
            throw new IllegalArgumentException("Vertical time axes cannot have annotations");
        }
        if (this.drawTca == b) {
            return;
        }
        this.drawTca = b;
        this.markDirty();
        this.update();
        this.firePropertyChange("showTca", oldValue, b);
    }

    public String getDataPath() {
        return this.dataset;
    }

    public void setDataPath(String dataset) {
        if (dataset == null) {
            throw new NullPointerException("null dataPath string not allowed");
        }
        String oldValue = this.dataset;
        if (dataset.equals(this.dataset)) {
            return;
        }
        this.dataset = dataset;
        if (dataset.equals("")) {
            this.dsd = null;
        } else {
            try {
                this.dsd = DataSetDescriptor.create(dataset);
            }
            catch (DasException de) {
                DasExceptionHandler.handle(de);
            }
        }
        this.markDirty();
        this.update();
        this.firePropertyChange("dataPath", oldValue, dataset);
    }

    public void setDataSetDescriptor(DataSetDescriptor dsdAux) {
        if (dsdAux == null) {
            throw new NullPointerException("null DataSetDescriptor not allowed");
        }
        DataSetDescriptor oldVal = this.dsd;
        this.dsd = dsdAux;
        this.markDirty();
        this.update();
        String oldDataset = this.dataset;
        this.dataset = this.dsd.getDataSetID();
        this.firePropertyChange("dataSetDescriptor", oldVal, this.dsd);
        this.firePropertyChange("dataPath", oldDataset, this.dataset);
    }

    public DataSetDescriptor getDataSetDescriptor() {
        return this.dsd;
    }

    private void updateTCADataSet() {
        Datum iinterval;
        Datum data_maximum;
        Datum data_minimum;
        logger.fine("updateTCADataSet");
        double[] tickV = this.getTickV().tickV.toDoubleArray(this.getUnits());
        if (tickV.length == 1) {
            data_minimum = Datum.create(tickV[0], this.getTickV().units);
            data_maximum = Datum.create(tickV[0], this.getTickV().units);
            iinterval = data_maximum.subtract(data_minimum);
        } else {
            data_minimum = Datum.create(tickV[0], this.getTickV().units);
            data_maximum = Datum.create(tickV[tickV.length - 1], this.getTickV().units);
            iinterval = data_maximum.subtract(data_minimum).divide(tickV.length - 1);
        }
        data_maximum = data_maximum.add(iinterval);
        Datum interval = iinterval;
        this.tcaData = null;
        this.dsd.requestDataSet(data_minimum, data_maximum.add(Datum.create(1.0, Units.seconds)), interval, new NullProgressMonitor(), this.getCanvas(), this.tcaListener);
    }

    public final int getDevicePosition() {
        if (this.orientation == 2) {
            return this.getRow().getDMaximum();
        }
        if (this.orientation == 1) {
            return this.getRow().getDMinimum();
        }
        if (this.orientation == 3) {
            return this.getColumn().getDMinimum();
        }
        return this.getColumn().getDMaximum();
    }

    public int getDLength() {
        if (this.isHorizontal()) {
            return this.getColumn().getWidth();
        }
        return this.getRow().getHeight();
    }

    public DasAxis getMasterAxis() {
        return this.dataRange.getCreator();
    }

    public void attachTo(DasAxis axis) {
        DataRange oldRange = this.dataRange;
        this.dataRange = axis.dataRange;
        oldRange.removePropertyChangeListener(PROP_LOG, this.dataRangePropertyListener);
        oldRange.removePropertyChangeListener("minimum", this.dataRangePropertyListener);
        oldRange.removePropertyChangeListener("maximum", this.dataRangePropertyListener);
        oldRange.removePropertyChangeListener(DataRange.PROPERTY_DATUMRANGE, this.dataRangePropertyListener);
        this.dataRange.addPropertyChangeListener(PROP_LOG, this.dataRangePropertyListener);
        this.dataRange.addPropertyChangeListener("minimum", this.dataRangePropertyListener);
        this.dataRange.addPropertyChangeListener("maximum", this.dataRangePropertyListener);
        this.dataRange.addPropertyChangeListener(DataRange.PROPERTY_DATUMRANGE, this.dataRangePropertyListener);
        if (oldRange.isLog() != this.dataRange.isLog()) {
            this.firePropertyChange(PROP_LOG, oldRange.isLog(), this.dataRange.isLog());
        }
        this.firePropertyChange("minimum", oldRange.getMinimum(), this.dataRange.getMinimum());
        this.firePropertyChange("maximum", oldRange.getMaximum(), this.dataRange.getMaximum());
        this.copyFavorites();
        this.copyHistory();
    }

    public void detach() {
        DataRange newRange;
        this.dataRange.removePropertyChangeListener(PROP_LOG, this.dataRangePropertyListener);
        this.dataRange.removePropertyChangeListener("minimum", this.dataRangePropertyListener);
        this.dataRange.removePropertyChangeListener("maximum", this.dataRangePropertyListener);
        this.dataRange.removePropertyChangeListener(DataRange.PROPERTY_DATUMRANGE, this.dataRangePropertyListener);
        this.dataRange = newRange = new DataRange(this, Datum.create(this.dataRange.getMinimum(), this.dataRange.getUnits()), Datum.create(this.dataRange.getMaximum(), this.dataRange.getUnits()), this.dataRange.isLog());
        this.dataRange.addPropertyChangeListener(PROP_LOG, this.dataRangePropertyListener);
        this.dataRange.addPropertyChangeListener("minimum", this.dataRangePropertyListener);
        this.dataRange.addPropertyChangeListener("maximum", this.dataRangePropertyListener);
        this.dataRange.addPropertyChangeListener(DataRange.PROPERTY_DATUMRANGE, this.dataRangePropertyListener);
        this.copyFavorites();
        this.copyHistory();
    }

    public boolean isAttached() {
        return this != this.getMasterAxis();
    }

    public TickVDescriptor getTickV() {
        if (this.tickV == null) {
            this.updateTickV();
        }
        return this.tickV;
    }

    public void setTickV(TickVDescriptor tickV) {
        this.checkTickV(tickV);
        this.tickV = tickV;
        if (tickV == null) {
            this.autoTickV = true;
            this.updateTickV();
        } else {
            this.autoTickV = false;
        }
        this.update();
    }

    private void checkTickV(TickVDescriptor tickV) throws IllegalArgumentException {
    }

    private void updateTickVLog() {
        double min = this.getDataMinimum().doubleValue(this.getUnits());
        double max = this.getDataMaximum().doubleValue(this.getUnits());
        double dMinTick = DasMath.roundNFractionalDigits(DasMath.log10(min), 4);
        int minTick = (int)Math.ceil(dMinTick);
        double dMaxTick = DasMath.roundNFractionalDigits(DasMath.log10(max), 4);
        int maxTick = (int)Math.floor(dMaxTick);
        GrannyTextRenderer idlt = new GrannyTextRenderer();
        idlt.setString(this.getTickLabelFont(), "10!U-10");
        int nTicksMax = this.isHorizontal() ? (int)Math.floor((double)this.getColumn().getWidth() / idlt.getWidth()) : (int)Math.floor((double)this.getRow().getHeight() / idlt.getHeight());
        nTicksMax = nTicksMax < 7 ? nTicksMax : 7;
        this.tickV = TickVDescriptor.bestTickVLogNew(this.getDataMinimum(), this.getDataMaximum(), 3, nTicksMax, true);
        this.datumFormatter = this.resolveFormatter(this.tickV);
    }

    private void updateTickVLinear() {
        int nTicksMax;
        int axisSize;
        int tickSizePixels;
        if (this.isHorizontal()) {
            tickSizePixels = (int)((double)this.getFontMetrics(this.getTickLabelFont()).stringWidth("0.0000") * 1.5);
            axisSize = this.getColumn().getWidth();
            nTicksMax = axisSize / tickSizePixels;
        } else {
            tickSizePixels = this.getFontMetrics(this.getTickLabelFont()).getHeight() + 6;
            axisSize = this.getRow().getHeight();
            nTicksMax = axisSize / tickSizePixels;
        }
        nTicksMax = nTicksMax < 7 ? nTicksMax : 7;
        this.tickV = TickVDescriptor.bestTickVLinear(this.getDataMinimum(), this.getDataMaximum(), 3, nTicksMax, false);
        DatumFormatter tdf = this.resolveFormatter(this.tickV);
        boolean once = true;
        while (once) {
            int tickSizePixels2;
            Rectangle maxBounds = this.getMaxBounds(tdf, this.tickV);
            if (this.isHorizontal()) {
                tickSizePixels2 = (int)((double)maxBounds.width + this.getEmSize() * 2.0);
                nTicksMax = axisSize / tickSizePixels2;
            } else {
                tickSizePixels2 = maxBounds.height;
                nTicksMax = axisSize / tickSizePixels2;
            }
            this.tickV = TickVDescriptor.bestTickVLinear(this.getDataMinimum(), this.getDataMaximum(), 3, nTicksMax, true);
            this.datumFormatter = this.resolveFormatter(this.tickV);
            once = false;
        }
    }

    private DatumFormatter resolveFormatter(TickVDescriptor tickV) {
        return this.getUserDatumFormatter() == null ? tickV.getFormatter() : this.getUserDatumFormatter();
    }

    private Rectangle getMaxBounds(DatumFormatter tdf, TickVDescriptor tickV) {
        String[] granny = tdf.axisFormat(tickV.tickV, this.getDatumRange());
        GrannyTextRenderer idlt = new GrannyTextRenderer();
        Rectangle bounds = new Rectangle();
        for (int i = 0; i < granny.length; ++i) {
            idlt.setString(this.getTickLabelFont(), granny[i]);
            bounds.add(idlt.getBounds());
        }
        return bounds;
    }

    private void updateTickVTime() {
        DatumRange dr = this.getDatumRange();
        Datum pixel = dr.width().divide(this.getDLength());
        if (this.isHorizontal()) {
            String item;
            FontMetrics fm;
            int width;
            String item2;
            FontMetrics fm2;
            int width2;
            this.tickV = TickVDescriptor.bestTickVTime(dr.min().subtract(pixel), dr.max().add(pixel), 3, 8, false);
            DatumFormatter tdf = this.resolveFormatter(this.tickV);
            Rectangle bounds = this.getMaxBounds(tdf, this.tickV);
            int tickSizePixels = (int)((double)bounds.width + this.getEmSize() * 2.0);
            if (this.drawTca && (width2 = (fm2 = this.getFontMetrics(this.getTickLabelFont())).stringWidth(item2 = DasAxis.format(99999.99, "(f8.2)")) + (int)(this.getEmSize() * 2.0)) > tickSizePixels) {
                tickSizePixels = width2;
            }
            int axisSize = this.getColumn().getWidth();
            int nTicksMax = Math.max(2, axisSize / tickSizePixels);
            this.tickV = TickVDescriptor.bestTickVTime(this.getDataMinimum(), this.getDataMaximum(), 2, nTicksMax, false);
            tdf = this.resolveFormatter(this.tickV);
            bounds = this.getMaxBounds(tdf, this.tickV);
            tickSizePixels = (int)(bounds.getWidth() + this.getEmSize() * 2.0);
            if (this.drawTca && (width = (fm = this.getFontMetrics(this.getTickLabelFont())).stringWidth(item = DasAxis.format(99999.99, "(f8.2)"))) > tickSizePixels) {
                tickSizePixels = width;
            }
            nTicksMax = nTicksMax > 1 ? nTicksMax : 2;
            nTicksMax = nTicksMax < 10 ? nTicksMax : 10;
            boolean overlap = true;
            while (overlap && nTicksMax > 2) {
                this.tickV = TickVDescriptor.bestTickVTime(this.getDataMinimum(), this.getDataMaximum(), 2, nTicksMax, false);
                if (this.tickV.getMajorTicks().getLength() <= 1) {
                    System.err.println("about to assert error: " + this.tickV.getMajorTicks());
                }
                assert (this.tickV.getMajorTicks().getLength() > 1);
                tdf = this.resolveFormatter(this.tickV);
                bounds = this.getMaxBounds(tdf, this.tickV);
                tickSizePixels = (int)(bounds.getWidth() + this.getEmSize() * 2.0);
                double x0 = this.transform(this.tickV.getMajorTicks().get(0));
                double x1 = this.transform(this.tickV.getMajorTicks().get(1));
                if (x1 - x0 > (double)tickSizePixels) {
                    overlap = false;
                    continue;
                }
                --nTicksMax;
            }
            this.tickV = TickVDescriptor.bestTickVTime(this.getDataMinimum(), this.getDataMaximum(), 2, nTicksMax, true);
        } else {
            int tickSizePixels = this.getFontMetrics(this.getTickLabelFont()).getHeight();
            int axisSize = this.getRow().getHeight();
            int nTicksMax = axisSize / tickSizePixels;
            nTicksMax = nTicksMax > 1 ? nTicksMax : 2;
            nTicksMax = nTicksMax < 10 ? nTicksMax : 10;
            this.tickV = TickVDescriptor.bestTickVTime(this.getDataMinimum(), this.getDataMaximum(), 3, nTicksMax, true);
        }
        this.datumFormatter = this.resolveFormatter(this.tickV);
        if (this.drawTca && !this.dataset.equals("") && this.dsd != null) {
            this.updateTCADataSet();
        }
    }

    public synchronized void updateTickV() {
        if (!this.valueIsAdjusting() && this.autoTickV) {
            TickVDescriptor oldTicks = this.tickV;
            if (this.getUnits() instanceof TimeLocationUnits) {
                this.updateTickVTime();
            } else if (this.dataRange.isLog()) {
                this.updateTickVLog();
            } else {
                this.updateTickVLinear();
            }
            this.firePropertyChange(PROPERTY_TICKS, oldTicks, this.tickV);
        }
    }

    private void checkState() {
        double dmin = this.getDataMinimum(this.dataRange.getUnits());
        double dmax = this.getDataMaximum(this.dataRange.getUnits());
        String em = "";
        if (Double.isNaN(dmin)) {
            em = em + "dmin is NaN, ";
        }
        if (Double.isNaN(dmax)) {
            em = em + "dmax is NaN, ";
        }
        if (Double.isInfinite(dmin)) {
            em = em + "dmin is infinite, ";
        }
        if (Double.isInfinite(dmax)) {
            em = em + "dmax is infinite, ";
        }
        if (dmin >= dmax) {
            em = em + "min => max, ";
        }
        if (this.dataRange.isLog() && dmin <= 0.0) {
            em = em + "min<= 0 and log, ";
        }
        this.errorMessage = em.length() == 0 ? null : em;
    }

    protected void paintComponent(Graphics graphics) {
        Rectangle clip;
        logger.fine("enter DasAxis.paintComponent");
        logger.fine("DasAxis clip=" + graphics.getClip() + " @ " + this.getX() + "," + this.getY());
        Graphics2D g = (Graphics2D)graphics.create();
        g.translate(-this.getX(), -this.getY());
        g.setColor(this.getForeground());
        if (DEBUG_GRAPHICS) {
            g.setStroke(new BasicStroke(3.0f, 0, 0, 1.0f, new float[]{3.0f, 3.0f}, 0.0f));
            g.setColor(Color.BLUE);
            if (this.blLabelRect != null) {
                g.draw(this.blLabelRect);
            }
            g.setColor(Color.RED);
            if (this.blLineRect != null) {
                g.draw(this.blLineRect);
            }
            g.setColor(Color.GREEN);
            if (this.blTickRect != null) {
                g.draw(this.blTickRect);
            }
            g.setColor(Color.LIGHT_GRAY);
            if (this.blTitleRect != null) {
                g.draw(this.blTitleRect);
            }
            g.setColor(Color.BLUE);
            if (this.trLabelRect != null) {
                g.draw(this.trLabelRect);
            }
            g.setColor(Color.RED);
            if (this.trLineRect != null) {
                g.draw(this.trLineRect);
            }
            g.setColor(Color.GREEN);
            if (this.trTickRect != null) {
                g.draw(this.trTickRect);
            }
            g.setColor(Color.LIGHT_GRAY);
            if (this.trTitleRect != null) {
                g.draw(this.trTitleRect);
            }
            g.setStroke(new BasicStroke(1.0f));
            g.setColor(DEBUG_COLORS[this.debugColorIndex]);
            ++this.debugColorIndex;
            if (this.debugColorIndex >= DEBUG_COLORS.length) {
                this.debugColorIndex = 0;
            }
        }
        if (this.tickV == null || this.tickV.tickV.getUnits().isConvertableTo(this.getUnits())) {
            if (this.isHorizontal()) {
                this.paintHorizontalAxis(g);
            } else {
                this.paintVerticalAxis(g);
            }
        }
        if ((clip = g.getClipBounds()) == null) {
            clip = new Rectangle(this.getX(), this.getY(), this.getWidth(), this.getHeight());
        }
        if (this.drawTca && this.getOrientation() == 2 && this.tcaData != null && this.blLabelRect != null && this.blLabelRect.intersects(clip)) {
            int position = this.getRow().getDMaximum();
            int DMin = this.getColumn().getDMinimum();
            Font tickLabelFont = this.getTickLabelFont();
            FontMetrics tickLabelFontMetrics = this.getFontMetrics(tickLabelFont);
            int tickLength = tickLabelFont.getSize() * 2 / 3;
            int tick_label_gap = tickLabelFontMetrics.stringWidth(" ");
            int lineHeight = tickLabelFont.getSize() + this.getLineSpacing();
            int baseLine = position + tickLength + tick_label_gap + tickLabelFont.getSize();
            int rightEdge = DMin - tickLabelFontMetrics.stringWidth("0000") - tick_label_gap;
            GrannyTextRenderer idlt = new GrannyTextRenderer();
            for (int i = 0; i < this.tcaData.length; ++i) {
                idlt.setString(g, (String)this.tcaData[i].getProperty(PROP_LABEL));
                int width = (int)Math.floor(idlt.getWidth() + 0.5);
                int leftEdge = rightEdge - width;
                idlt.draw(g, leftEdge, baseLine += lineHeight);
            }
        }
        g.dispose();
        this.getDasMouseInputAdapter().paint(graphics);
    }

    protected void paintHorizontalAxis(Graphics2D g) {
        try {
            int tickLength;
            int tickPosition;
            int i;
            Rectangle clip = g.getClipBounds();
            if (clip == null) {
                clip = new Rectangle(this.getX(), this.getY(), this.getWidth(), this.getHeight());
            }
            boolean bottomLine = (this.orientation == 2 || this.oppositeAxisVisible) && this.blLineRect != null && this.blLineRect.intersects(clip);
            boolean bottomTicks = (this.orientation == 2 || this.oppositeAxisVisible) && this.blTickRect != null && this.blTickRect.intersects(clip);
            boolean bottomTickLabels = this.orientation == 2 && this.tickLabelsVisible && this.blLabelRect != null && this.blLabelRect.intersects(clip);
            boolean bottomLabel = this.orientation == 2 && !this.axisLabel.equals("") && this.blTitleRect != null && this.blTitleRect.intersects(clip);
            boolean topLine = (this.orientation == 1 || this.oppositeAxisVisible) && this.trLineRect != null && this.trLineRect.intersects(clip);
            boolean topTicks = (this.orientation == 1 || this.oppositeAxisVisible) && this.trTickRect != null && this.trTickRect.intersects(clip);
            boolean topTickLabels = this.orientation == 1 && this.tickLabelsVisible && this.trLabelRect != null && this.trLabelRect.intersects(clip);
            boolean topLabel = this.orientation == 1 && !this.axisLabel.equals("") && this.trTitleRect != null && this.trTitleRect.intersects(clip);
            int topPosition = this.getRow().getDMinimum() - 1;
            int bottomPosition = this.getRow().getDMaximum();
            int DMax = this.getColumn().getDMaximum();
            int DMin = this.getColumn().getDMinimum();
            Font labelFont = this.getTickLabelFont();
            TickVDescriptor ticks = this.getTickV();
            if (bottomLine) {
                g.drawLine(DMin, bottomPosition, DMax, bottomPosition);
            }
            if (topLine) {
                g.drawLine(DMin, topPosition, DMax, topPosition);
            }
            int tickLengthMajor = labelFont.getSize() * 2 / 3;
            int tickLengthMinor = tickLengthMajor / 2;
            String[] labels = this.tickFormatter(ticks.tickV, this.getDatumRange());
            for (i = 0; i < ticks.tickV.getLength(); ++i) {
                Datum tick1 = ticks.tickV.get(i);
                tickPosition = (int)Math.floor(this.transform(tick1));
                if (DMin > tickPosition || tickPosition > DMax) continue;
                tickLength = tickLengthMajor;
                if (bottomTicks) {
                    g.drawLine(tickPosition, bottomPosition, tickPosition, bottomPosition + tickLength);
                }
                if (bottomTickLabels) {
                    this.drawLabel(g, tick1, labels[i], i, tickPosition, bottomPosition + tickLength);
                }
                if (topTicks) {
                    g.drawLine(tickPosition, topPosition, tickPosition, topPosition - tickLength);
                }
                if (!topTickLabels) continue;
                this.drawLabel(g, tick1, labels[i], i, tickPosition, topPosition - tickLength + 1);
            }
            for (i = 0; i < ticks.minorTickV.getLength(); ++i) {
                Datum tick = ticks.minorTickV.get(i);
                tickPosition = (int)Math.floor(this.transform(tick));
                if (DMin > tickPosition || tickPosition > DMax) continue;
                tickLength = tickLengthMinor;
                if (bottomTicks) {
                    g.drawLine(tickPosition, bottomPosition, tickPosition, bottomPosition + tickLength);
                }
                if (!topTicks) continue;
                g.drawLine(tickPosition, topPosition, tickPosition, topPosition - tickLength);
            }
            if (!this.axisLabel.equals("")) {
                int baseline;
                int leftEdge;
                Graphics2D g2 = (Graphics2D)g.create();
                int titlePositionOffset = this.getTitlePositionOffset();
                GrannyTextRenderer gtr = new GrannyTextRenderer();
                gtr.setString(g2, this.axisLabel);
                int titleWidth = (int)gtr.getWidth();
                g2.setFont(this.getLabelFont());
                if (bottomLabel) {
                    leftEdge = DMin + (DMax - DMin - titleWidth) / 2;
                    baseline = bottomPosition + titlePositionOffset;
                    gtr.draw(g2, leftEdge, baseline);
                }
                if (topLabel) {
                    leftEdge = DMin + (DMax - DMin - titleWidth) / 2;
                    baseline = topPosition - titlePositionOffset;
                    gtr.draw(g2, leftEdge, baseline);
                }
                g2.dispose();
            }
        }
        catch (InconvertibleUnitsException inconvertibleUnitsException) {
            // empty catch block
        }
    }

    protected void paintVerticalAxis(Graphics2D g) {
        try {
            int tickLength;
            int i;
            Rectangle clip = g.getClipBounds();
            if (clip == null) {
                clip = new Rectangle(this.getX(), this.getY(), this.getWidth(), this.getHeight());
            }
            boolean leftLine = (this.orientation == 3 || this.oppositeAxisVisible) && this.blLineRect != null && this.blLineRect.intersects(clip);
            boolean leftTicks = (this.orientation == 3 || this.oppositeAxisVisible) && this.blTickRect != null && this.blTickRect.intersects(clip);
            boolean leftTickLabels = this.orientation == 3 && this.tickLabelsVisible && this.blLabelRect != null && this.blLabelRect.intersects(clip);
            boolean leftLabel = this.orientation == 3 && !this.axisLabel.equals("") && this.blTitleRect != null && this.blTitleRect.intersects(clip);
            boolean rightLine = (this.orientation == 4 || this.oppositeAxisVisible) && this.trLineRect != null && this.trLineRect.intersects(clip);
            boolean rightTicks = (this.orientation == 4 || this.oppositeAxisVisible) && this.trTickRect != null && this.trTickRect.intersects(clip);
            boolean rightTickLabels = this.orientation == 4 && this.tickLabelsVisible && this.trLabelRect != null && this.trLabelRect.intersects(clip);
            boolean rightLabel = this.orientation == 4 && !this.axisLabel.equals("") && this.trTitleRect != null && this.trTitleRect.intersects(clip);
            int leftPosition = this.getColumn().getDMinimum() - 1;
            int rightPosition = this.getColumn().getDMaximum();
            int DMax = this.getRow().getDMaximum();
            int DMin = this.getRow().getDMinimum();
            Font labelFont = this.getTickLabelFont();
            TickVDescriptor ticks = this.getTickV();
            if (leftLine) {
                g.drawLine(leftPosition, DMin, leftPosition, DMax);
            }
            if (rightLine) {
                g.drawLine(rightPosition, DMin, rightPosition, DMax);
            }
            int tickLengthMajor = labelFont.getSize() * 2 / 3;
            int tickLengthMinor = tickLengthMajor / 2;
            String[] labels = this.tickFormatter(ticks.tickV, this.getDatumRange());
            for (i = 0; i < ticks.tickV.getLength(); ++i) {
                Datum tick1 = ticks.tickV.get(i);
                int tickPosition = (int)Math.floor(this.transform(tick1));
                if (DMin > tickPosition || tickPosition > DMax) continue;
                tickLength = tickLengthMajor;
                if (leftTicks) {
                    g.drawLine(leftPosition, tickPosition, leftPosition - tickLength, tickPosition);
                }
                if (leftTickLabels) {
                    this.drawLabel(g, tick1, labels[i], i, leftPosition - tickLength, tickPosition);
                }
                if (rightTicks) {
                    g.drawLine(rightPosition, tickPosition, rightPosition + tickLength, tickPosition);
                }
                if (!rightTickLabels) continue;
                this.drawLabel(g, tick1, labels[i], i, rightPosition + tickLength, tickPosition);
            }
            for (i = 0; i < ticks.minorTickV.getLength(); ++i) {
                tickLength = tickLengthMinor;
                double tick1 = ticks.minorTickV.doubleValue(i, this.getUnits());
                int tickPosition = (int)Math.floor(this.transform(tick1, ticks.units));
                if (DMin > tickPosition || tickPosition > DMax) continue;
                tickLength = tickLengthMinor;
                if (leftTicks) {
                    g.drawLine(leftPosition, tickPosition, leftPosition - tickLength, tickPosition);
                }
                if (!rightTicks) continue;
                g.drawLine(rightPosition, tickPosition, rightPosition + tickLength, tickPosition);
            }
            if (!this.axisLabel.equals("")) {
                int baseline;
                int leftEdge;
                Graphics2D g2 = (Graphics2D)g.create();
                int titlePositionOffset = this.getTitlePositionOffset();
                GrannyTextRenderer gtr = new GrannyTextRenderer();
                gtr.setString(g2, this.axisLabel);
                int titleWidth = (int)gtr.getWidth();
                g2.setFont(this.getLabelFont());
                if (leftLabel) {
                    g2.rotate(-1.5707963267948966);
                    leftEdge = -DMax + (DMax - DMin - titleWidth) / 2;
                    baseline = leftPosition - titlePositionOffset;
                    gtr.draw(g2, leftEdge, baseline);
                }
                if (rightLabel) {
                    if (this.flipLabel) {
                        g2.rotate(-1.5707963267948966);
                        leftEdge = DMin + (DMax - DMin + titleWidth) / 2;
                        baseline = rightPosition + titlePositionOffset;
                        gtr.draw(g2, -leftEdge, baseline);
                        g2.getClipBounds();
                    } else {
                        g2.rotate(1.5707963267948966);
                        leftEdge = DMin + (DMax - DMin - titleWidth) / 2;
                        baseline = -rightPosition - titlePositionOffset;
                        gtr.draw(g2, leftEdge, baseline);
                    }
                }
                g2.dispose();
            }
        }
        catch (InconvertibleUnitsException inconvertibleUnitsException) {
            // empty catch block
        }
    }

    protected int getTitlePositionOffset() {
        Font tickLabelFont = this.getTickLabelFont();
        FontMetrics fm = this.getFontMetrics(tickLabelFont);
        Font labelFont = this.getLabelFont();
        int tickLength = tickLabelFont.getSize() * 2 / 3;
        GrannyTextRenderer gtr = new GrannyTextRenderer();
        gtr.setString(labelFont, this.axisLabel);
        int offset = this.orientation == 2 ? tickLabelFont.getSize() + tickLength + fm.stringWidth(" ") + labelFont.getSize() + labelFont.getSize() / 2 : (this.orientation == 1 ? tickLength + fm.stringWidth(" ") + labelFont.getSize() + labelFont.getSize() / 2 + (int)gtr.getDescent() : (this.orientation == 3 ? this.getColumn().getDMinimum() - this.blLabelRect.x + labelFont.getSize() / 2 + (int)gtr.getDescent() : this.trLabelRect.x + this.trLabelRect.width - this.getColumn().getDMaximum() + labelFont.getSize() / 2 + (int)(this.flipLabel ? gtr.getAscent() : gtr.getDescent())));
        if (this.getOrientation() == 2 && this.drawTca && this.tcaData != null) {
            offset += this.tcaData.length * (tickLabelFont.getSize() + this.getLineSpacing());
            offset += tickLabelFont.getSize() + this.getLineSpacing();
        }
        return offset;
    }

    public int getLineSpacing() {
        return this.getTickLabelFont().getSize() / 4;
    }

    protected void drawLabel(Graphics2D g, Datum value, String label, int index, int x, int y) {
        if (!this.tickLabelsVisible) {
            return;
        }
        g.setFont(this.getTickLabelFont());
        GrannyTextRenderer idlt = new GrannyTextRenderer();
        idlt.setString(g, label);
        int width = (int)(this.isHorizontal() ? idlt.getLineOneWidth() : idlt.getWidth());
        int height = (int)idlt.getHeight();
        int ascent = (int)idlt.getAscent();
        int tick_label_gap = this.getFontMetrics(this.getTickLabelFont()).stringWidth(" ");
        if (this.orientation == 2) {
            x -= width / 2;
            y += this.getTickLabelFont().getSize() + tick_label_gap;
        } else if (this.orientation == 1) {
            x -= width / 2;
            y = (int)((double)y - ((double)tick_label_gap + idlt.getDescent()));
        } else if (this.orientation == 3) {
            x -= width + tick_label_gap;
            y += ascent - height / 2;
        } else {
            x += tick_label_gap;
            y += ascent - height / 2;
        }
        Color c = g.getColor();
        idlt.draw(g, x, y);
        if (this.orientation == 2 && this.drawTca && this.tcaData != null) {
            this.drawTCAItems(g, value, x, y, width);
        }
    }

    private void drawTCAItems(Graphics g, Datum value, int x, int y, int width) {
        if (this.tcaData == null || this.tcaData.length == 0) {
            return;
        }
        int baseLine = y;
        int leftEdge = x;
        int rightEdge = leftEdge + width;
        int index = DataSetUtil.closestColumn(this.tcaData[0], value);
        if (index < 0 || index > this.tcaData[0].getXLength()) {
            return;
        }
        double pixelSize = this.getDatumRange().width().divide(this.getDLength()).doubleValue(this.getUnits().getOffsetUnits());
        if (this.tcaData[0].getXLength() == 0) {
            g.drawString("tca data is empty", leftEdge, baseLine);
            return;
        }
        double tcaValue = this.tcaData[0].getXTagDouble(index, this.getUnits());
        double xTagWidth = DataSetUtil.guessXTagWidth(this.tcaData[0]).doubleValue(this.getUnits().getOffsetUnits());
        double limit = Math.max(xTagWidth, pixelSize);
        if (Math.abs(tcaValue - value.doubleValue(this.getUnits())) > limit) {
            return;
        }
        Font tickLabelFont = this.getTickLabelFont();
        FontMetrics fm = this.getFontMetrics(tickLabelFont);
        int lineHeight = tickLabelFont.getSize() + this.getLineSpacing();
        for (int i = 0; i < this.tcaData.length; ++i) {
            String item = DasAxis.format(this.tcaData[i].getDouble(index, this.tcaData[i].getYUnits()), "(f8.2)");
            width = fm.stringWidth(item);
            leftEdge = rightEdge - width;
            g.drawString(item, leftEdge, baseLine += lineHeight);
        }
    }

    public Font getTickLabelFont() {
        return this.getFont();
    }

    public void setTickLabelFont(Font tickLabelFont) {
    }

    public Font getLabelFont() {
        return this.getFont();
    }

    public void setLabelFont(Font labelFont) {
    }

    public Memento getMemento() {
        Memento result = new Memento();
        result.range = this.getDatumRange();
        if (this.isHorizontal()) {
            if (this.getColumn() != DasColumn.NULL) {
                result.dmin = this.getColumn().getDMinimum();
                result.dmax = this.getColumn().getDMaximum();
            } else {
                result.dmin = 0;
                result.dmax = 0;
            }
        } else if (this.getRow() != DasRow.NULL) {
            result.dmin = this.getRow().getDMinimum();
            result.dmax = this.getRow().getDMaximum();
        } else {
            result.dmin = 0;
            result.dmax = 0;
        }
        result.log = this.isLog();
        result.flipped = this.flipped;
        result.axis = this;
        return result;
    }

    public AffineTransform getAffineTransform(Memento memento, AffineTransform at) {
        double dmin1;
        if (at == null) {
            return null;
        }
        if (memento.log != this.isLog()) {
            return null;
        }
        if (memento.flipped != this.flipped) {
            return null;
        }
        if (!memento.range.getUnits().isConvertableTo(this.getUnits())) {
            return null;
        }
        double dmin0 = this.transform(memento.range.min());
        double dmax0 = this.transform(memento.range.max());
        if (!(this.isHorizontal() ^ this.flipped)) {
            double tmp = dmin0;
            dmin0 = dmax0;
            dmax0 = tmp;
        }
        if (!this.isHorizontal()) {
            dmin1 = this.getRow().getDMinimum();
            double dmax1 = this.getRow().getDMaximum();
            double scaley = (dmin0 - dmax0) / (dmin1 - dmax1);
            double transy = -1.0 * dmin1 * scaley + dmin0;
            at.translate(0.0, transy);
            at.scale(1.0, scaley);
        } else {
            dmin1 = this.getColumn().getDMinimum();
            double dmax1 = this.getColumn().getDMaximum();
            double scalex = (dmin0 - dmax0) / (dmin1 - dmax1);
            double transx = -1.0 * dmin1 * scalex + dmin0;
            at.translate(transx, 0.0);
            at.scale(scalex, 1.0);
        }
        if (at.getDeterminant() == 0.0) {
            return null;
        }
        return at;
    }

    public Object clone() {
        try {
            DasAxis result = (DasAxis)super.clone();
            result.dataRange = (DataRange)result.dataRange.clone();
            return result;
        }
        catch (CloneNotSupportedException e) {
            throw new Error("Assertion failure");
        }
    }

    private void setTickDirection(int direction) {
        if (direction == 995 || direction == 4) {
            this.tickDirection = -1;
        } else if (direction == 996 || direction == 3) {
            this.tickDirection = 1;
        } else {
            throw new IllegalArgumentException("Invalid tick direction");
        }
    }

    private int getMaxLabelWidth() {
        try {
            Font f = this.getTickLabelFont();
            TickVDescriptor ticks = this.getTickV();
            DatumVector tickv = ticks.tickV;
            int size = Integer.MIN_VALUE;
            Graphics g = this.getGraphics();
            for (int i = 0; i < tickv.getLength(); ++i) {
                String label = this.tickFormatter(tickv.get(i));
                GrannyTextRenderer idlt = new GrannyTextRenderer();
                idlt.setString(f, label);
                int labelSize = (int)Math.round(idlt.getWidth());
                if (labelSize <= size) continue;
                size = labelSize;
            }
            return size;
        }
        catch (InconvertibleUnitsException ex) {
            return 10;
        }
    }

    protected int getMaxLabelWidth(FontMetrics fm) {
        try {
            TickVDescriptor ticks = this.getTickV();
            DatumVector tickv = ticks.tickV;
            int size = Integer.MIN_VALUE;
            Graphics g = this.getGraphics();
            for (int i = 0; i < tickv.getLength(); ++i) {
                String label = this.tickFormatter(tickv.get(i));
                GrannyTextRenderer idlt = new GrannyTextRenderer();
                idlt.setString(g, label);
                int labelSize = (int)Math.round(idlt.getWidth());
                if (labelSize <= size) continue;
                size = labelSize;
            }
            return size;
        }
        catch (InconvertibleUnitsException ex) {
            return 10;
        }
    }

    public void resize() {
        this.resetTransform();
        Rectangle oldBounds = this.getBounds();
        this.setBounds(this.getAxisBounds());
        this.invalidate();
        if (this.tickV == null || this.tickV.tickV.getUnits().isConvertableTo(this.getUnits())) {
            this.validate();
        }
        this.firePropertyChange(PROP_BOUNDS, oldBounds, this.getBounds());
    }

    protected synchronized Rectangle getLabelBounds(Rectangle bounds) {
        String[] labels = this.tickFormatter(this.getTickV().tickV, this.getDatumRange());
        int majorTickLength = (int)this.getEmSize();
        GrannyTextRenderer gtr = new GrannyTextRenderer();
        Font labelFont = this.getLabelFont();
        int tickLen = (int)this.getEmSize();
        double dmin = this.transform(this.getDataMinimum());
        double dmax = this.transform(this.getDataMaximum());
        DatumVector ticks = this.getTickV().tickV;
        for (int i = 0; i < labels.length; ++i) {
            Datum d = ticks.get(i);
            DatumRange dr = this.getDatumRange();
            if (!DatumRangeUtil.sloppyContains(dr, d)) continue;
            gtr.setString(labelFont, labels[i]);
            Rectangle rmin = gtr.getBounds();
            Rectangle rmax = new Rectangle(rmin);
            double flw = gtr.getLineOneWidth();
            if (this.isHorizontal()) {
                if (this.getOrientation() == 2) {
                    rmin.translate((int)(dmin - flw / 2.0), this.getRow().bottom() + tickLen + labelFont.getSize());
                    rmax.translate((int)(dmax - flw / 2.0), this.getRow().bottom() + tickLen + labelFont.getSize());
                } else {
                    rmin.translate((int)(dmin - flw / 2.0), this.getRow().top() - tickLen - (int)rmin.getHeight());
                    rmin.translate((int)(dmax - flw / 2.0), this.getRow().top() - tickLen - (int)rmax.getHeight());
                }
                bounds.add(rmin);
                bounds.add(rmax);
                continue;
            }
            if (this.getOrientation() == 3) {
                rmin.translate(-((int)rmin.getWidth()) - tickLen + this.getColumn().left(), (int)(dmin + this.getEmSize() / 2.0));
                rmax.translate(-((int)rmax.getWidth()) - tickLen + this.getColumn().left(), (int)(dmax + this.getEmSize() / 2.0));
            } else {
                rmin.translate(tickLen + this.getColumn().right(), (int)(dmin + this.getEmSize() / 2.0));
                rmax.translate(tickLen + this.getColumn().right(), (int)(dmax + this.getEmSize() / 2.0));
            }
            bounds.add(rmin);
            bounds.add(rmax);
        }
        return bounds;
    }

    protected Rectangle getAxisBounds() {
        Rectangle bounds = this.isHorizontal() ? this.getHorizontalAxisBounds() : this.getVerticalAxisBounds();
        if (this.getOrientation() == 2 && this.areTickLabelsVisible()) {
            if (this.drawTca && this.tcaData != null && this.tcaData.length != 0) {
                int DMin = this.getColumn().getDMinimum();
                int DMax = this.getColumn().getDMaximum();
                Font tickLabelFont = this.getTickLabelFont();
                int tick_label_gap = this.getFontMetrics(tickLabelFont).stringWidth(" ");
                int tcaHeight = (tickLabelFont.getSize() + this.getLineSpacing()) * this.tcaData.length;
                int maxLabelWidth = this.getMaxLabelWidth();
                bounds.height += tcaHeight;
                this.blLabelRect.height += tcaHeight;
                if (this.blTitleRect != null) {
                    this.blTitleRect.y += tcaHeight;
                }
                GrannyTextRenderer idlt = new GrannyTextRenderer();
                idlt.setString(tickLabelFont, "SCET");
                int tcaLabelWidth = (int)Math.floor(idlt.getWidth() + 0.5);
                for (int i = 0; i < this.tcaData.length; ++i) {
                    idlt.setString(tickLabelFont, (String)this.tcaData[i].getProperty(PROP_LABEL));
                    int width = (int)Math.floor(idlt.getWidth() + 0.5);
                    tcaLabelWidth = Math.max(tcaLabelWidth, width);
                }
                if ((tcaLabelWidth += 50) > 0) {
                    int tcaLabelSpace = DMin - tcaLabelWidth - tick_label_gap;
                    int minX = Math.min(tcaLabelSpace - maxLabelWidth / 2, bounds.x);
                    int maxX = bounds.x + bounds.width;
                    bounds.x = minX;
                    bounds.width = maxX - minX;
                    this.blLabelRect.x = minX;
                    this.blLabelRect.width = maxX - minX;
                }
            }
            for (int i = 0; i < this.tickV.tickV.getLength(); ++i) {
            }
        }
        return bounds;
    }

    private Rectangle getHorizontalAxisBounds() {
        int height;
        int width;
        int y;
        int x;
        int height2;
        int width2;
        int y2;
        int x2;
        int topPosition = this.getRow().getDMinimum() - 1;
        int bottomPosition = this.getRow().getDMaximum();
        DasColumn range = this.getColumn();
        int DMax = range.getDMaximum();
        int DMin = range.getDMinimum();
        int DWidth = DMax - DMin;
        boolean bottomTicks = this.orientation == 2 || this.oppositeAxisVisible;
        boolean bottomTickLabels = this.orientation == 2 && this.tickLabelsVisible;
        boolean bottomLabel = bottomTickLabels && !this.axisLabel.equals("");
        boolean topTicks = this.orientation == 1 || this.oppositeAxisVisible;
        boolean topTickLabels = this.orientation == 1 && this.tickLabelsVisible;
        boolean topLabel = topTickLabels && !this.axisLabel.equals("");
        Font tickLabelFont = this.getTickLabelFont();
        int tickSize = tickLabelFont.getSize() * 2 / 3;
        if (bottomTicks) {
            if (this.blLineRect == null) {
                this.blLineRect = new Rectangle();
            }
            this.blLineRect.setBounds(DMin, bottomPosition, DWidth + 1, 1);
        }
        if (topTicks) {
            if (this.trLineRect == null) {
                this.trLineRect = new Rectangle();
            }
            this.trLineRect.setBounds(DMin, topPosition, DWidth + 1, 1);
        }
        if (bottomTicks) {
            x2 = DMin;
            y2 = bottomPosition + 1;
            width2 = DWidth;
            height2 = tickSize;
            this.blTickRect = DasAxis.setRectangleBounds(this.blTickRect, x2, y2, width2 + 1, height2);
        }
        if (topTicks) {
            x2 = DMin;
            y2 = topPosition - tickSize;
            width2 = DWidth;
            height2 = tickSize;
            this.trTickRect = DasAxis.setRectangleBounds(this.trTickRect, x2, y2, width2 + 1, height2);
        }
        if (bottomTickLabels) {
            this.blLabelRect = this.getLabelBounds(new Rectangle(DMin, this.blTickRect.y, DWidth, 10));
        }
        if (topTickLabels) {
            this.trLineRect = this.getLabelBounds(new Rectangle(DMin, topPosition - 10, DWidth, 10));
        }
        Font labelFont = this.getLabelFont();
        GrannyTextRenderer gtr = new GrannyTextRenderer();
        gtr.setString(labelFont, this.getLabel());
        int labelSpacing = (int)gtr.getHeight() + labelFont.getSize() / 2;
        if (bottomLabel) {
            x = DMin;
            y = this.blLabelRect.y + this.blLabelRect.height;
            width = DMax - DMin;
            height = labelSpacing;
            this.blTitleRect = DasAxis.setRectangleBounds(this.blTitleRect, x, y, width, height);
        }
        if (topLabel) {
            x = DMin;
            y = this.trLabelRect.y - labelSpacing;
            width = DMax - DMin;
            height = labelSpacing;
            this.trTitleRect = DasAxis.setRectangleBounds(this.trTitleRect, x, y, width, height);
        }
        Rectangle bounds = new Rectangle(this.orientation == 2 ? this.blLineRect : this.trLineRect);
        if (bottomTicks) {
            bounds.add(this.blLineRect);
            bounds.add(this.blTickRect);
        }
        if (bottomTickLabels) {
            bounds.add(this.blLabelRect);
        }
        if (bottomLabel) {
            bounds.add(this.blTitleRect);
        }
        if (topTicks) {
            bounds.add(this.trLineRect);
            bounds.add(this.trTickRect);
        }
        if (topTickLabels) {
            bounds.add(this.trLabelRect);
        }
        if (topLabel) {
            bounds.add(this.trTitleRect);
        }
        if (this.scanPrevious != null && this.scanNext != null) {
            Dimension prevSize = this.scanPrevious.getPreferredSize();
            Dimension nextSize = this.scanPrevious.getPreferredSize();
            int minX = Math.min(DMin - prevSize.width, bounds.x);
            int maxX = Math.max(DMax + nextSize.width, bounds.x + bounds.width);
            bounds.x = minX;
            bounds.width = maxX - minX;
        }
        return bounds;
    }

    private Rectangle getVerticalAxisBounds() {
        int height;
        int width;
        int y;
        int x;
        int height2;
        int width2;
        int y2;
        int x2;
        boolean leftTicks = this.orientation == 3 || this.oppositeAxisVisible;
        boolean leftTickLabels = this.orientation == 3 && this.tickLabelsVisible;
        boolean leftLabel = this.orientation == 3 && !this.axisLabel.equals("");
        boolean rightTicks = this.orientation == 4 || this.oppositeAxisVisible;
        boolean rightTickLabels = this.orientation == 4 && this.tickLabelsVisible;
        boolean rightLabel = this.orientation == 4 && !this.axisLabel.equals("");
        int leftPosition = this.getColumn().getDMinimum() - 1;
        int rightPosition = this.getColumn().getDMaximum();
        int DMax = this.getRow().getDMaximum();
        int DMin = this.getRow().getDMinimum();
        int DWidth = DMax - DMin;
        Font tickLabelFont = this.getTickLabelFont();
        int tickSize = tickLabelFont.getSize() * 2 / 3;
        if (leftTicks) {
            if (this.blLineRect == null) {
                this.blLineRect = new Rectangle();
            }
            this.blLineRect.setBounds(leftPosition, DMin, 1, DWidth + 1);
        }
        if (rightTicks) {
            if (this.trLineRect == null) {
                this.trLineRect = new Rectangle();
            }
            this.trLineRect.setBounds(rightPosition, DMin, 1, DWidth + 1);
        }
        if (leftTicks) {
            x2 = leftPosition - tickSize;
            y2 = DMin;
            width2 = tickSize;
            height2 = DWidth;
            this.blTickRect = DasAxis.setRectangleBounds(this.blTickRect, x2, y2, width2, height2 + 1);
        }
        if (rightTicks) {
            x2 = rightPosition + 1;
            y2 = DMin;
            width2 = tickSize;
            height2 = DWidth;
            this.trTickRect = DasAxis.setRectangleBounds(this.trTickRect, x2, y2, width2, height2 + 1);
        }
        if (leftTickLabels) {
            this.blLabelRect = this.getLabelBounds(new Rectangle(this.blTickRect.x - 10, DMin, 10, DWidth));
        }
        if (rightTickLabels) {
            this.trLabelRect = this.getLabelBounds(new Rectangle(this.trTickRect.x + this.trTickRect.width, DMin, 10, DWidth));
        }
        Font labelFont = this.getLabelFont();
        GrannyTextRenderer gtr = new GrannyTextRenderer();
        gtr.setString(labelFont, this.getLabel());
        int labelSpacing = (int)gtr.getHeight() + labelFont.getSize() / 2;
        if (leftLabel) {
            x = this.blLabelRect.x - labelSpacing;
            y = DMin;
            width = labelSpacing;
            height = DWidth;
            this.blTitleRect = DasAxis.setRectangleBounds(this.blTitleRect, x, y, width, height);
        }
        if (rightLabel) {
            x = this.trLabelRect.x + this.trLabelRect.width;
            y = DMin;
            width = labelSpacing;
            height = DWidth;
            this.trTitleRect = DasAxis.setRectangleBounds(this.trTitleRect, x, y, width, height);
        }
        Rectangle bounds = new Rectangle(this.orientation == 3 ? this.blLineRect : this.trLineRect);
        if (leftTicks) {
            bounds.add(this.blLineRect);
            bounds.add(this.blTickRect);
        }
        if (leftTickLabels) {
            bounds.add(this.blLabelRect);
        }
        if (leftLabel) {
            bounds.add(this.blTitleRect);
        }
        if (rightTicks) {
            bounds.add(this.trLineRect);
            bounds.add(this.trTickRect);
        }
        if (rightTickLabels) {
            bounds.add(this.trLabelRect);
        }
        if (rightLabel) {
            bounds.add(this.trTitleRect);
        }
        return bounds;
    }

    private static Rectangle setRectangleBounds(Rectangle rc, int x, int y, int width, int height) {
        if (rc == null) {
            return new Rectangle(x, y, width, height);
        }
        rc.setBounds(x, y, width, height);
        return rc;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public boolean isHorizontal() {
        return this.orientation == 2 || this.orientation == 1;
    }

    public int getTickDirection() {
        return this.tickDirection;
    }

    public DatumFormatter getDatumFormatter() {
        return this.datumFormatter;
    }

    public double transform(Datum datum) {
        return this.transform(datum.doubleValue(this.getUnits()), this.getUnits());
    }

    protected double transformFast(double data, Units units) {
        if (this.dataRange.isLog()) {
            data = data <= 0.0 ? this.dataRange.getMinimum() - 3.0 : DasMath.log10(data);
        }
        double result = this.at_m * data + this.at_b;
        return result;
    }

    protected double transform(double data, Units units) {
        if (this.isHorizontal()) {
            DasColumn range = this.getColumn();
            return this.transform(data, units, range.getDMinimum(), range.getDMaximum());
        }
        DasRow range = this.getRow();
        return this.transform(data, units, range.getDMaximum(), range.getDMinimum());
    }

    protected double transform(double data, Units units, int dmin, int dmax) {
        if (units != this.dataRange.getUnits()) {
            data = units.convertDoubleTo(this.dataRange.getUnits(), data);
        }
        double device_range = dmax - dmin;
        if (this.dataRange.isLog()) {
            data = data <= 0.0 ? -1.0E308 : DasMath.log10(data);
        }
        double minimum = this.dataRange.getMinimum();
        double maximum = this.dataRange.getMaximum();
        double data_range = maximum - minimum;
        double result = this.flipped ? (double)dmax - device_range * (data - minimum) / data_range : device_range * (data - minimum) / data_range + (double)dmin;
        if (result > 10000.0) {
            result = 10000.0;
        }
        if (result < -10000.0) {
            result = -10000.0;
        }
        return result;
    }

    public Datum invTransform(double idata) {
        DasDevicePosition range = this.isHorizontal() ? this.getColumn() : this.getRow();
        double alpha = (idata - (double)range.getDMinimum()) / (double)this.getDLength();
        if (!this.isHorizontal()) {
            alpha = 1.0 - alpha;
        }
        if (this.flipped) {
            alpha = 1.0 - alpha;
        }
        double minimum = this.dataRange.getMinimum();
        double maximum = this.dataRange.getMaximum();
        double data_range = maximum - minimum;
        double data = data_range * alpha + minimum;
        double resolution = data_range / (double)this.getDLength();
        if (this.dataRange.isLog()) {
            data = DasMath.exp10(data);
            resolution = data * (DasMath.exp10(resolution) - 1.0);
        }
        Datum result = Datum.create(data, this.dataRange.getUnits(), resolution);
        return result;
    }

    protected String tickFormatter(Datum d) {
        return this.datumFormatter.grannyFormat(d, d.getUnits());
    }

    protected String[] tickFormatter(DatumVector tickV, DatumRange datumRange) {
        return this.datumFormatter.axisFormat(tickV, datumRange);
    }

    public void dataRangeSelected(DataRangeSelectionEvent e) {
        this.setDataRange(e.getMinimum(), e.getMaximum());
    }

    public Datum findTick(Datum xDatum, double direction, boolean minor) {
        return this.getTickV().findTick(xDatum, direction, minor);
    }

    private void animateChange(double min0, double max0, double min1, double max1) {
        if (this.animated && EventQueue.isDispatchThread()) {
            DataRange tempRange;
            logger.fine("animate axis");
            boolean drawTca0 = this.getDrawTca();
            this.setDrawTca(false);
            long t0 = System.currentTimeMillis();
            long frames = 0L;
            DataRange dataRange0 = this.dataRange;
            this.dataRange = tempRange = DataRange.getAnimationDataRange(this.dataRange.getDatumRange(), this.dataRange.isLog());
            double transitionTime = 300.0;
            double alpha = (double)(System.currentTimeMillis() - t0) / transitionTime;
            while (alpha < 1.0) {
                alpha = (double)(System.currentTimeMillis() - t0) / transitionTime;
                double[] aa = new double[]{0.0, 0.3, 0.85, 1.0};
                double[] aa1 = new double[]{0.0, 0.05, 0.9, 1.0};
                double f1 = DasMath.findex(aa, alpha, 0);
                double a1 = DasMath.interpolate(aa1, f1);
                double a0 = 1.0 - a1;
                tempRange.setRange(min0 * a0 + min1 * a1, max0 * a0 + max1 * a1);
                this.paintImmediately(0, 0, this.getWidth(), this.getHeight());
                if (this.dasPlot != null) {
                    this.dasPlot.paintImmediately(0, 0, this.dasPlot.getWidth(), this.dasPlot.getHeight());
                }
                ++frames;
            }
            logger.fine("animation frames/sec= " + 1000.0 * (double)frames / transitionTime);
            this.setDrawTca(drawTca0);
            this.dataRange = dataRange0;
        }
    }

    protected void updateImmediately() {
        super.updateImmediately();
        logger.finer("" + this.getDatumRange() + " " + this.isLog());
        this.resetTransform();
        this.updateTickV();
    }

    public boolean areTickLabelsVisible() {
        return this.tickLabelsVisible;
    }

    public boolean isTickLabelsVisible() {
        return this.tickLabelsVisible;
    }

    public void setTickLabelsVisible(boolean b) {
        if (this.tickLabelsVisible == b) {
            return;
        }
        boolean oldValue = this.ticksVisible;
        this.tickLabelsVisible = b;
        this.update();
        this.firePropertyChange("tickLabelsVisible", oldValue, b);
    }

    protected void installComponent() {
        super.installComponent();
    }

    protected void uninstallComponent() {
        super.uninstallComponent();
    }

    static DasAxis processAxisElement(Element element, FormBase form) throws DasPropertyException, DasNameException, ParseException {
        String columnString;
        Datum dataMaximum;
        Datum dataMinimum;
        String max;
        String min;
        String name = element.getAttribute("name");
        boolean log = element.getAttribute(PROP_LOG).equals("true");
        if ("TIME".equals(element.getAttribute("units"))) {
            min = element.getAttribute("dataMinimum");
            max = element.getAttribute("dataMaximum");
            dataMinimum = min == null || min.equals("") ? TimeUtil.create("1979-02-26") : TimeUtil.create(min);
            dataMaximum = max == null || max.equals("") ? TimeUtil.create("1979-02-27") : TimeUtil.create(max);
        } else {
            min = element.getAttribute("dataMinimum");
            max = element.getAttribute("dataMaximum");
            dataMinimum = min == null || min.equals("") ? Datum.create(1.0) : Datum.create(Double.parseDouble(min));
            dataMaximum = max == null || max.equals("") ? Datum.create(10.0) : Datum.create(Double.parseDouble(max));
        }
        int orientation = DasAxis.parseOrientationString(element.getAttribute("orientation"));
        DasAxis axis = new DasAxis(dataMinimum, dataMaximum, orientation, log);
        String rowString = element.getAttribute("row");
        if (!rowString.equals("")) {
            DasRow row = (DasRow)form.checkValue(rowString, DasRow.class, "<row>");
            axis.setRow(row);
        }
        if (!(columnString = element.getAttribute("column")).equals("")) {
            DasColumn column = (DasColumn)form.checkValue(columnString, DasColumn.class, "<column>");
            axis.setColumn(column);
        }
        axis.setLabel(element.getAttribute(PROP_LABEL));
        axis.setOppositeAxisVisible(!element.getAttribute(PROP_OPPOSITE_AXIS_VISIBLE).equals("false"));
        axis.setTickLabelsVisible(!element.getAttribute("tickLabelsVisible").equals("false"));
        axis.setDasName(name);
        DasApplication app = form.getDasApplication();
        NameContext nc = app.getNameContext();
        nc.put(name, axis);
        return axis;
    }

    protected static String orientationToString(int i) {
        switch (i) {
            case 1: {
                return "top";
            }
            case 2: {
                return "bottom";
            }
            case 3: {
                return "left";
            }
            case 4: {
                return "right";
            }
        }
        throw new IllegalStateException("invalid orienation: " + i);
    }

    protected static int parseOrientationString(String orientationString) {
        if (orientationString.equals("horizontal")) {
            return 2;
        }
        if (orientationString.equals("vertical")) {
            return 3;
        }
        if (orientationString.equals("left")) {
            return 3;
        }
        if (orientationString.equals("right")) {
            return 4;
        }
        if (orientationString.equals("top")) {
            return 1;
        }
        if (orientationString.equals("bottom")) {
            return 2;
        }
        throw new IllegalArgumentException("Invalid orientation: " + orientationString);
    }

    public Element getDOMElement(Document document) {
        Element element = this.isAttached() ? document.createElement("attachedaxis") : document.createElement("axis");
        if (this.isAttached()) {
            element.setAttribute("ref", this.getMasterAxis().getDasName());
        } else {
            String minimumStr = this.getDataMinimum().toString();
            element.setAttribute("dataMinimum", minimumStr);
            String maximumStr = this.getDataMaximum().toString();
            element.setAttribute("dataMaximum", maximumStr);
        }
        element.setAttribute("name", this.getDasName());
        element.setAttribute("row", this.getRow().getDasName());
        element.setAttribute("column", this.getColumn().getDasName());
        element.setAttribute(PROP_LABEL, this.getLabel());
        element.setAttribute(PROP_LOG, Boolean.toString(this.isLog()));
        element.setAttribute("tickLabelsVisible", Boolean.toString(this.areTickLabelsVisible()));
        element.setAttribute(PROP_OPPOSITE_AXIS_VISIBLE, Boolean.toString(this.isOppositeAxisVisible()));
        element.setAttribute("animated", Boolean.toString(this.isAnimated()));
        element.setAttribute("orientation", DasAxis.orientationToString(this.getOrientation()));
        return element;
    }

    public DasAxis createAttachedAxis() {
        return new DasAxis(this.dataRange, this.getOrientation());
    }

    public DasAxis createAttachedAxis(int orientation) {
        return new DasAxis(this.dataRange, orientation);
    }

    static DasAxis processAttachedaxisElement(Element element, FormBase form) throws DasPropertyException, DasNameException {
        String columnString;
        String name = element.getAttribute("name");
        DasAxis ref = (DasAxis)form.checkValue(element.getAttribute("ref"), DasAxis.class, "<attachedaxis>");
        int orientation = element.getAttribute("orientation").equals("horizontal") ? 2 : 3;
        DasAxis axis = ref.createAttachedAxis(orientation);
        String rowString = element.getAttribute("row");
        if (!rowString.equals("")) {
            DasRow row = (DasRow)form.checkValue(rowString, DasRow.class, "<row>");
            axis.setRow(row);
        }
        if (!(columnString = element.getAttribute("column")).equals("")) {
            DasColumn column = (DasColumn)form.checkValue(columnString, DasColumn.class, "<column>");
            axis.setColumn(column);
        }
        axis.setDataPath(element.getAttribute("dataPath"));
        axis.setDrawTca(element.getAttribute("showTca").equals("true"));
        axis.setLabel(element.getAttribute(PROP_LABEL));
        axis.setOppositeAxisVisible(!element.getAttribute(PROP_OPPOSITE_AXIS_VISIBLE).equals("false"));
        axis.setTickLabelsVisible(!element.getAttribute("tickLabelsVisible").equals("false"));
        axis.setDasName(name);
        DasApplication app = form.getDasApplication();
        NameContext nc = app.getNameContext();
        nc.put(name, axis);
        return axis;
    }

    public void setPlot(DasPlot p) {
        this.dasPlot = p;
    }

    public static DasAxis createNamedAxis(String name) {
        DasAxis axis = new DasAxis(Datum.create(1.0, Units.dimensionless), Datum.create(10.0, Units.dimensionless), 2);
        if (name == null) {
            name = "axis_" + Integer.toHexString(System.identityHashCode(axis));
        }
        try {
            axis.setDasName(name);
        }
        catch (DasNameException dne) {
            DasExceptionHandler.handle(dne);
        }
        return axis;
    }

    public void scanPrevious() {
        Datum delta = this.getDataMaximum().subtract(this.getDataMinimum()).multiply(1.0);
        Datum tmin = this.getDataMinimum().subtract(delta);
        Datum tmax = this.getDataMaximum().subtract(delta);
        this.setDataRange(tmin, tmax);
    }

    public void scanNext() {
        Datum delta = this.getDataMaximum().subtract(this.getDataMinimum()).multiply(1.0);
        Datum tmin = this.getDataMinimum().add(delta);
        Datum tmax = this.getDataMaximum().add(delta);
        this.setDataRange(tmin, tmax);
    }

    public Shape getActiveRegion() {
        Rectangle primaryBounds = this.primaryInputPanel.getBounds();
        primaryBounds.translate(this.getX(), this.getY());
        if (this.oppositeAxisVisible) {
            Rectangle secondaryBounds = this.secondaryInputPanel.getBounds();
            secondaryBounds.translate(this.getX(), this.getY());
            GeneralPath path = new GeneralPath(primaryBounds);
            path.setWindingRule(0);
            path.append(secondaryBounds, false);
            return path;
        }
        return primaryBounds;
    }

    public void addMouseWheelListener(MouseWheelListener l) {
        this.maybeInitializeInputPanels();
        this.primaryInputPanel.addMouseWheelListener(l);
        this.secondaryInputPanel.addMouseWheelListener(l);
    }

    public void removeMouseWheelListener(MouseWheelListener l) {
        this.maybeInitializeInputPanels();
        this.primaryInputPanel.removeMouseWheelListener(l);
        this.secondaryInputPanel.removeMouseWheelListener(l);
    }

    public void addMouseListener(MouseListener l) {
        this.maybeInitializeInputPanels();
        this.primaryInputPanel.addMouseListener(l);
        this.secondaryInputPanel.addMouseListener(l);
    }

    public void removeMouseListener(MouseListener l) {
        this.maybeInitializeInputPanels();
        this.primaryInputPanel.removeMouseListener(l);
        this.secondaryInputPanel.removeMouseListener(l);
    }

    public void addMouseMotionListener(MouseMotionListener l) {
        this.maybeInitializeInputPanels();
        this.primaryInputPanel.addMouseMotionListener(l);
        this.secondaryInputPanel.addMouseMotionListener(l);
    }

    public void removeMouseMotionListener(MouseMotionListener l) {
        this.maybeInitializeInputPanels();
        this.primaryInputPanel.removeMouseMotionListener(l);
        this.secondaryInputPanel.removeMouseMotionListener(l);
    }

    public void timeRangeSelected(TimeRangeSelectionEvent e) {
        if (e.getSource() != this && !e.equals(this.lastProcessedEvent)) {
            this.setDatumRange(e.getRange());
            this.lastProcessedEvent = e;
        }
    }

    public synchronized void addTimeRangeSelectionListener(TimeRangeSelectionListener listener) {
        if (this.timeRangeListenerList == null) {
            this.timeRangeListenerList = new EventListenerList();
        }
        this.timeRangeListenerList.add(TimeRangeSelectionListener.class, listener);
    }

    public synchronized void removeTimeRangeSelectionListener(TimeRangeSelectionListener listener) {
        this.timeRangeListenerList.remove(TimeRangeSelectionListener.class, listener);
    }

    private void fireTimeRangeSelectionListenerTimeRangeSelected(TimeRangeSelectionEvent event) {
        if (this.timeRangeListenerList == null) {
            return;
        }
        Object[] listeners = this.timeRangeListenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TimeRangeSelectionListener.class) continue;
            String logmsg = "fire event: " + this.getClass().getName() + "-->" + listeners[i + 1].getClass().getName() + " " + event;
            DasLogger.getLogger(DasLogger.GUI_LOG).fine(logmsg);
            ((TimeRangeSelectionListener)listeners[i + 1]).timeRangeSelected(event);
        }
    }

    static DasAxis processTimeaxisElement(Element element, FormBase form) throws DasPropertyException, DasNameException, DasException, ParseException {
        String columnString;
        String name = element.getAttribute("name");
        Datum timeMinimum = TimeUtil.create(element.getAttribute("timeMinimum"));
        Datum timeMaximum = TimeUtil.create(element.getAttribute("timeMaximum"));
        int orientation = DasAxis.parseOrientationString(element.getAttribute("orientation"));
        DasAxis timeaxis = new DasAxis(timeMinimum, timeMaximum, orientation);
        String rowString = element.getAttribute("row");
        if (!rowString.equals("")) {
            DasRow row = (DasRow)form.checkValue(rowString, DasRow.class, "<row>");
            timeaxis.setRow(row);
        }
        if (!(columnString = element.getAttribute("column")).equals("")) {
            DasColumn column = (DasColumn)form.checkValue(columnString, DasColumn.class, "<column>");
            timeaxis.setColumn(column);
        }
        timeaxis.setDataPath(element.getAttribute("dataPath"));
        timeaxis.setDrawTca(element.getAttribute("showTca").equals("true"));
        timeaxis.setLabel(element.getAttribute(PROP_LABEL));
        timeaxis.setOppositeAxisVisible(!element.getAttribute(PROP_OPPOSITE_AXIS_VISIBLE).equals("false"));
        timeaxis.setTickLabelsVisible(!element.getAttribute("tickLabelsVisible").equals("false"));
        timeaxis.setDasName(name);
        DasApplication app = form.getDasApplication();
        NameContext nc = app.getNameContext();
        nc.put(name, timeaxis);
        return timeaxis;
    }

    private static String format(double d, String f) {
        String result;
        DecimalFormat form;
        int i;
        Matcher m = pattern.matcher(f);
        if (!m.matches()) {
            throw new IllegalArgumentException("\"" + f + "\" is not a valid format specifier");
        }
        int length = Integer.parseInt(f.substring(2, f.indexOf(46)));
        int fracLength = Integer.parseInt(f.substring(f.indexOf(46) + 1, f.indexOf(41)));
        char[] buf = new char[length];
        if (f.charAt(1) == 'f' || f.charAt(1) == 'F') {
            for (i = 0; i < length - fracLength - 2; ++i) {
                buf[i] = 35;
            }
            buf[i] = 48;
            buf[++i] = 46;
            ++i;
            while (i < length) {
                buf[i] = 48;
                ++i;
            }
            form = new DecimalFormat(new String(buf));
            result = form.format(d);
        } else {
            for (i = 0; i < length - fracLength - 6; ++i) {
                buf[i] = 35;
            }
            buf[i] = 48;
            buf[++i] = 46;
            ++i;
            while (i < length - 5) {
                buf[i] = 48;
                ++i;
            }
            buf[i] = 69;
            buf[i + 1] = d > -1.0 && d < 1.0 ? 45 : 43;
            buf[i + 2] = 48;
            buf[i + 3] = 48;
            form = new DecimalFormat(new String(buf));
            result = form.format(d);
        }
        if (result.length() > length) {
            Arrays.fill(buf, '*');
            return new String(buf);
        }
        while (result.length() < length) {
            result = " " + result;
        }
        return result;
    }

    public String toString() {
        String retValue = super.toString() + "(" + this.getUnits() + ")";
        return retValue;
    }

    public boolean isFlipped() {
        return this.flipped;
    }

    public void setFlipped(boolean b) {
        this.update();
        this.flipped = b;
    }

    public String getFormat() {
        return this.formatString;
    }

    public boolean isFlipLabel() {
        return this.flipLabel;
    }

    public void setFlipLabel(boolean flipLabel) {
        boolean oldFlipLabel = this.flipLabel;
        this.flipLabel = flipLabel;
        this.repaint();
        this.firePropertyChange(PROP_FLIPLABEL, oldFlipLabel, flipLabel);
    }

    public void setFormat(String formatString) {
        try {
            String oldFormatString = this.formatString;
            this.formatString = formatString;
            if (formatString.equals("")) {
                this.setUserDatumFormatter(null);
            } else {
                this.setUserDatumFormatter(this.getUnits().getDatumFormatterFactory().newFormatter(formatString));
            }
            this.updateTickV();
            this.repaint();
            this.firePropertyChange(PROP_FORMATSTRING, oldFormatString, formatString);
        }
        catch (ParseException e) {
            this.setUserDatumFormatter(null);
        }
    }

    private void resetTransform() {
        DasDevicePosition pos = this.isHorizontal() ? this.getColumn() : this.getRow();
        double dmin = pos.getDMinimum();
        double dmax = pos.getDMaximum();
        if (this.isFlipped()) {
            double t = dmin;
            dmin = dmax;
            dmax = t;
        }
        double[] at = GraphUtil.getSlopeIntercept(this.dataRange.getMinimum(), dmin, this.dataRange.getMaximum(), dmax);
        this.at_m = at[0];
        this.at_b = at[1];
    }

    public Lock mutatorLock() {
        return this.dataRange.mutatorLock();
    }

    public boolean valueIsAdjusting() {
        return this.dataRange.valueIsAdjusting();
    }

    static /* synthetic */ VectorDataSet[] access$702(DasAxis x0, VectorDataSet[] x1) {
        x0.tcaData = x1;
        return x1;
    }

    private static class ScanButton
    extends JButton {
        private boolean hover;
        private boolean pressed;

        public ScanButton(String text) {
            this.setOpaque(true);
            this.setContentAreaFilled(false);
            this.setText(text);
            this.setFocusable(false);
            this.setBorder(new CompoundBorder(new LineBorder(Color.BLACK), new EmptyBorder(2, 2, 2, 2)));
            this.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent e) {
                    if (e.getButton() == 1) {
                        ScanButton.this.setForeground(Color.LIGHT_GRAY);
                        ScanButton.this.pressed = true;
                        ScanButton.this.repaint();
                    }
                }

                public void mouseReleased(MouseEvent e) {
                    if (e.getButton() == 1) {
                        ScanButton.this.setForeground(Color.BLACK);
                        ScanButton.this.pressed = false;
                        ScanButton.this.repaint();
                    }
                }

                public void mouseEntered(MouseEvent e) {
                    ScanButton.this.hover = true;
                    ScanButton.this.repaint();
                }

                public void mouseExited(MouseEvent e) {
                    ScanButton.this.hover = false;
                    ScanButton.this.repaint();
                }
            });
        }

        protected void paintComponent(Graphics g) {
            if (this.hover || this.pressed) {
                Graphics2D g2 = (Graphics2D)g;
                g2.setColor(Color.white);
                g2.fillRect(0, 0, this.getWidth(), this.getHeight());
                Object aaHint = g2.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
                Object aaOn = RenderingHints.VALUE_ANTIALIAS_ON;
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, aaOn);
                super.paintComponent(g2);
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, aaHint);
            }
        }

        protected void paintBorder(Graphics g) {
            if (this.hover || this.pressed) {
                super.paintBorder(g);
            }
        }
    }

    protected class AxisLayoutManager
    implements LayoutManager {
        protected AxisLayoutManager() {
        }

        public void addLayoutComponent(String name, Component comp) {
        }

        public void layoutContainer(Container parent) {
            if (DasAxis.this != parent) {
                throw new IllegalArgumentException();
            }
            if (DasAxis.this.isHorizontal()) {
                this.horizontalLayout();
            } else {
                this.verticalLayout();
            }
            if (DasAxis.this.drawTca && DasAxis.this.getOrientation() == 2 && DasAxis.this.tcaData != null) {
                Rectangle bounds = DasAxis.this.primaryInputPanel.getBounds();
                int tcaHeight = (DasAxis.this.getTickLabelFont().getSize() + DasAxis.this.getLineSpacing()) * DasAxis.this.tcaData.length;
                bounds.height += tcaHeight;
                DasAxis.this.primaryInputPanel.setBounds(bounds);
            }
        }

        protected void horizontalLayout() {
            int topPosition = DasAxis.this.getRow().getDMinimum() - 1;
            int bottomPosition = DasAxis.this.getRow().getDMaximum();
            int DMax = DasAxis.this.getColumn().getDMaximum();
            int DMin = DasAxis.this.getColumn().getDMinimum();
            boolean bottomTicks = DasAxis.this.orientation == 2 || DasAxis.this.oppositeAxisVisible;
            boolean bottomTickLabels = DasAxis.this.orientation == 2 && DasAxis.this.tickLabelsVisible;
            boolean topTicks = DasAxis.this.orientation == 1 || DasAxis.this.oppositeAxisVisible;
            boolean topTickLabels = DasAxis.this.orientation == 1 && DasAxis.this.tickLabelsVisible;
            Rectangle bottomBounds = null;
            Rectangle topBounds = null;
            Font tickLabelFont = DasAxis.this.getTickLabelFont();
            int tickSize = tickLabelFont.getSize() * 2 / 3;
            if (bottomTicks) {
                bottomBounds = new Rectangle(DMin, bottomPosition, DMax - DMin + 1, 1);
            }
            if (topTicks) {
                topBounds = new Rectangle(DMin, topPosition, DMax - DMin + 1, 1);
            }
            if (bottomTicks) {
                bottomBounds.height += tickSize;
            }
            if (topTicks) {
                topBounds.height += tickSize;
                topBounds.y -= tickSize;
            }
            int tick_label_gap = DasAxis.this.getFontMetrics(tickLabelFont).stringWidth(" ");
            if (bottomTickLabels) {
                bottomBounds.height += tickLabelFont.getSize() * 3 / 2 + tick_label_gap;
            }
            if (topTickLabels) {
                topBounds.y -= tickLabelFont.getSize() * 3 / 2 + tick_label_gap;
                topBounds.height += tickLabelFont.getSize() * 3 / 2 + tick_label_gap;
            }
            Rectangle primaryBounds = DasAxis.this.orientation == 2 ? bottomBounds : topBounds;
            Rectangle secondaryBounds = DasAxis.this.orientation == 2 ? topBounds : bottomBounds;
            primaryBounds.translate(-DasAxis.this.getX(), -DasAxis.this.getY());
            if (DasAxis.this.oppositeAxisVisible) {
                secondaryBounds.translate(-DasAxis.this.getX(), -DasAxis.this.getY());
            }
            DasAxis.this.primaryInputPanel.setBounds(primaryBounds);
            if (DasAxis.this.oppositeAxisVisible) {
                DasAxis.this.secondaryInputPanel.setBounds(secondaryBounds);
            } else {
                DasAxis.this.secondaryInputPanel.setBounds(-100, -100, 0, 0);
            }
            if (DasAxis.this.scanPrevious != null && DasAxis.this.scanNext != null) {
                Dimension preferred = DasAxis.this.scanPrevious.getPreferredSize();
                int x = DMin - preferred.width - DasAxis.this.getX();
                int y = (DasAxis.this.orientation == 2 ? bottomPosition : topPosition - preferred.height) - DasAxis.this.getY();
                DasAxis.this.scanPrevious.setBounds(x, y, preferred.width, preferred.height);
                preferred = DasAxis.this.scanNext.getPreferredSize();
                x = DMax - DasAxis.this.getX();
                DasAxis.this.scanNext.setBounds(x, y, preferred.width, preferred.height);
            }
        }

        protected void verticalLayout() {
            boolean leftTicks = DasAxis.this.orientation == 3 || DasAxis.this.oppositeAxisVisible;
            boolean leftTickLabels = DasAxis.this.orientation == 3 && DasAxis.this.tickLabelsVisible;
            boolean rightTicks = DasAxis.this.orientation == 4 || DasAxis.this.oppositeAxisVisible;
            boolean rightTickLabels = DasAxis.this.orientation == 4 && DasAxis.this.tickLabelsVisible;
            int leftPosition = DasAxis.this.getColumn().getDMinimum() - 1;
            int rightPosition = DasAxis.this.getColumn().getDMaximum();
            int DMax = DasAxis.this.getRow().getDMaximum();
            int DMin = DasAxis.this.getRow().getDMinimum();
            Rectangle leftBounds = null;
            Rectangle rightBounds = null;
            Font tickLabelFont = DasAxis.this.getTickLabelFont();
            int tickSize = tickLabelFont.getSize() * 2 / 3;
            if (leftTicks) {
                leftBounds = new Rectangle(leftPosition, DMin, 1, DMax - DMin + 1);
            }
            if (rightTicks) {
                rightBounds = new Rectangle(rightPosition, DMin, 1, DMax - DMin + 1);
            }
            if (leftTicks) {
                leftBounds.width += tickSize;
                leftBounds.x -= tickSize;
            }
            if (rightTicks) {
                rightBounds.width += tickSize;
            }
            int maxLabelWidth = DasAxis.this.getMaxLabelWidth();
            int tick_label_gap = DasAxis.this.getFontMetrics(tickLabelFont).stringWidth(" ");
            if (leftTickLabels) {
                leftBounds.x -= maxLabelWidth + tick_label_gap;
                leftBounds.width += maxLabelWidth + tick_label_gap;
            }
            if (rightTickLabels) {
                rightBounds.width += maxLabelWidth + tick_label_gap;
            }
            Rectangle primaryBounds = DasAxis.this.orientation == 3 ? leftBounds : rightBounds;
            Rectangle secondaryBounds = DasAxis.this.orientation == 3 ? rightBounds : leftBounds;
            primaryBounds.translate(-DasAxis.this.getX(), -DasAxis.this.getY());
            if (DasAxis.this.oppositeAxisVisible) {
                secondaryBounds.translate(-DasAxis.this.getX(), -DasAxis.this.getY());
            }
            DasAxis.this.primaryInputPanel.setBounds(primaryBounds);
            if (DasAxis.this.oppositeAxisVisible) {
                DasAxis.this.secondaryInputPanel.setBounds(secondaryBounds);
            } else {
                DasAxis.this.secondaryInputPanel.setBounds(-100, -100, 0, 0);
            }
        }

        public Dimension minimumLayoutSize(Container parent) {
            return new Dimension();
        }

        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension();
        }

        public void removeLayoutComponent(Component comp) {
        }
    }

    public static class Memento {
        private DatumRange range;
        private int dmin;
        private int dmax;
        private boolean log;
        private boolean flipped;
        private DasAxis axis;

        public boolean equals(Object o) {
            Memento m = (Memento)o;
            return this == m || this.range.equals(m.range) && this.dmin == m.dmin && this.dmax == m.dmax && this.log == m.log && this.flipped == m.flipped && this.axis == m.axis;
        }

        public String toString() {
            return (this.log ? "log " : "") + this.range.toString() + " " + (this.dmax - this.dmin) + " pixels @ " + this.dmin;
        }
    }

    public static interface Lock {
        public void lock();

        public void unlock();
    }
}

