/*
 * Decompiled with CFR 0.152.
 */
package org.das2.graph;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import org.das2.graph.DasCanvasComponent;
import org.das2.graph.DasColumn;
import org.das2.util.GrannyTextRenderer;

public class AttachedLabel
extends DasCanvasComponent
implements Cloneable {
    public static final int TOP = 1;
    public static final int BOTTOM = 2;
    public static final int LEFT = 3;
    public static final int RIGHT = 4;
    public static final int HORIZONTAL = 2;
    public static final int VERTICAL = 3;
    private int orientation;
    protected String axisLabel = "";
    private Rectangle blTitleRect;
    private Rectangle trTitleRect;
    private double emOffset;
    private boolean rot90 = false;
    private static int[] rot90map = new int[]{0, 4, 3, 1, 2};
    private static int[] rot90unMap = new int[]{0, 3, 4, 2, 1};
    private static final boolean DEBUG_GRAPHICS = false;
    private static final Color[] DEBUG_COLORS = null;
    private int debugColorIndex = 0;

    public AttachedLabel(String label, int orientation, double emOffset) {
        this.orientation = orientation;
        this.emOffset = emOffset;
        this.axisLabel = label;
        this.setOpaque(false);
    }

    public void setOrientation(int orientation) {
        boolean oldIsHorizontal = this.isHorizontal();
        this.setOrientationInternal(orientation);
    }

    private void setOrientationInternal(int orientation) {
        this.orientation = orientation;
    }

    public void setLabel(String t) {
        if (t == null) {
            throw new NullPointerException("axis label cannot be null");
        }
        String oldValue = this.axisLabel;
        this.axisLabel = t;
        this.update();
        this.firePropertyChange("label", oldValue, t);
    }

    public String getLabel() {
        return this.axisLabel;
    }

    public final int getDevicePosition() {
        if (this.orientation == 2) {
            return this.getRow().getDMaximum();
        }
        if (this.orientation == 1) {
            return this.getRow().getDMinimum();
        }
        if (this.orientation == 3) {
            return this.getColumn().getDMinimum();
        }
        return this.getColumn().getDMaximum();
    }

    public int getDLength() {
        if (this.isHorizontal()) {
            return this.getColumn().getWidth();
        }
        return this.getRow().getHeight();
    }

    protected void paintComponent(Graphics graphics) {
        Graphics2D g = (Graphics2D)graphics.create();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g.translate(-this.getX(), -this.getY());
        g.setColor(this.getForeground());
        if (this.isHorizontal()) {
            this.paintHorizontalLabel(g);
        } else {
            this.paintVerticalLabel(g);
        }
        g.dispose();
        this.getDasMouseInputAdapter().paint(graphics);
    }

    protected void paintHorizontalLabel(Graphics2D g) {
        Rectangle clip = g.getClipBounds();
        if (clip == null) {
            clip = new Rectangle(this.getX(), this.getY(), this.getWidth(), this.getHeight());
        }
        boolean bottomLabel = this.orientation == 2 && !this.axisLabel.equals("") && this.blTitleRect != null && this.blTitleRect.intersects(clip);
        boolean topLabel = this.orientation == 1 && !this.axisLabel.equals("") && this.trTitleRect != null && this.trTitleRect.intersects(clip);
        int topPosition = this.getRow().getDMinimum() - 1;
        int bottomPosition = this.getRow().getDMaximum();
        int DMax = this.getColumn().getDMaximum();
        int DMin = this.getColumn().getDMinimum();
        Font labelFont = this.getLabelFont();
        int tickLengthMajor = labelFont.getSize() * 2 / 3;
        int tickLengthMinor = tickLengthMajor / 2;
        if (!this.axisLabel.equals("")) {
            int baseline;
            int leftEdge;
            Graphics2D g2 = (Graphics2D)g.create();
            int titlePositionOffset = this.getTitlePositionOffset();
            GrannyTextRenderer gtr = new GrannyTextRenderer();
            gtr.setString(g, this.axisLabel);
            int titleWidth = (int)gtr.getWidth();
            g2.setFont(this.getLabelFont());
            if (bottomLabel) {
                leftEdge = DMin + (DMax - DMin - titleWidth) / 2;
                baseline = bottomPosition + titlePositionOffset;
                if (this.rot90) {
                    g2.rotate(Math.PI, leftEdge, baseline);
                    g2.translate(-gtr.getWidth(), gtr.getAscent());
                }
                gtr.draw(g2, leftEdge, baseline);
            }
            if (topLabel) {
                leftEdge = DMin + (DMax - DMin - titleWidth) / 2;
                baseline = topPosition - titlePositionOffset;
                gtr.draw(g2, leftEdge, baseline);
            }
            g2.dispose();
        }
    }

    protected void paintVerticalLabel(Graphics2D g) {
        Rectangle clip = g.getClipBounds();
        if (clip == null) {
            clip = new Rectangle(this.getX(), this.getY(), this.getWidth(), this.getHeight());
        }
        boolean leftLabel = this.orientation == 3 && !this.axisLabel.equals("") && this.blTitleRect != null && this.blTitleRect.intersects(clip);
        boolean rightLabel = this.orientation == 4 && !this.axisLabel.equals("") && this.trTitleRect != null && this.trTitleRect.intersects(clip);
        int leftPosition = this.getColumn().getDMinimum() - 1;
        int rightPosition = this.getColumn().getDMaximum();
        int DMax = this.getRow().getDMaximum();
        int DMin = this.getRow().getDMinimum();
        Font labelFont = this.getLabelFont();
        int tickLengthMajor = labelFont.getSize() * 2 / 3;
        int tickLengthMinor = tickLengthMajor / 2;
        if (!this.axisLabel.equals("")) {
            int baseline;
            int leftEdge;
            Graphics2D g2 = (Graphics2D)g.create();
            int titlePositionOffset = this.getTitlePositionOffset();
            GrannyTextRenderer gtr = new GrannyTextRenderer();
            gtr.setString(g, this.axisLabel);
            int titleWidth = (int)gtr.getWidth();
            g2.setFont(this.getLabelFont());
            if (leftLabel) {
                g2.rotate(-1.5707963267948966);
                leftEdge = -DMax + (DMax - DMin - titleWidth) / 2;
                baseline = leftPosition - titlePositionOffset;
                gtr.draw(g2, leftEdge, baseline);
            }
            if (rightLabel) {
                g2.rotate(1.5707963267948966);
                leftEdge = DMin + (DMax - DMin - titleWidth) / 2;
                baseline = -rightPosition - titlePositionOffset;
                if (this.rot90) {
                    g2.rotate(Math.PI, leftEdge, baseline);
                    g2.translate(-gtr.getWidth(), gtr.getAscent());
                }
                gtr.draw(g2, leftEdge, baseline);
            }
            g2.dispose();
        }
    }

    protected int getTitlePositionOffset() {
        Font labelFont = this.getLabelFont();
        GrannyTextRenderer gtr = new GrannyTextRenderer();
        gtr.setString(labelFont, this.axisLabel);
        int offset = (int)Math.ceil(this.emOffset * (double)labelFont.getSize());
        this.orientation = rot90map[this.orientation];
        if (this.orientation == 2) {
            offset = (int)((double)offset + gtr.getAscent());
        }
        this.orientation = rot90unMap[this.orientation];
        return offset;
    }

    public Font getLabelFont() {
        return this.getFont();
    }

    public void setLabelFont(Font labelFont) {
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new Error("Assertion failure");
        }
    }

    public void resize() {
        this.setBounds(this.getLabelBounds());
        this.invalidate();
        this.validate();
    }

    protected Rectangle getLabelBounds() {
        Rectangle bounds = this.isHorizontal() ? this.getHorizontalLabelBounds() : this.getVerticalLabelBounds();
        return bounds;
    }

    private Rectangle getHorizontalLabelBounds() {
        int height;
        int width;
        int y;
        int x;
        int topPosition = this.getRow().getDMinimum() - 1;
        int bottomPosition = this.getRow().getDMaximum();
        DasColumn range = this.getColumn();
        int DMax = range.getDMaximum();
        int DMin = range.getDMinimum();
        boolean bottomLabel = this.orientation == 2 && !this.axisLabel.equals("");
        boolean topLabel = this.orientation == 1 && !this.axisLabel.equals("");
        Font labelFont = this.getLabelFont();
        GrannyTextRenderer gtr = new GrannyTextRenderer();
        gtr.setString(labelFont, this.getLabel());
        int offset = this.getTitlePositionOffset();
        if (bottomLabel) {
            x = 0;
            y = this.getRow().getDMaximum() + offset - (int)Math.ceil(gtr.getAscent());
            width = this.getCanvas().getWidth();
            height = (int)Math.ceil(gtr.getHeight());
            this.blTitleRect = AttachedLabel.setRectangleBounds(this.blTitleRect, x, y, width, height);
        }
        if (topLabel) {
            x = 0;
            y = this.getRow().getDMinimum() - offset - (int)Math.ceil(gtr.getAscent());
            width = this.getCanvas().getWidth();
            height = (int)Math.ceil(gtr.getHeight());
            this.trTitleRect = AttachedLabel.setRectangleBounds(this.trTitleRect, x, y, width, height);
        }
        Rectangle bounds = new Rectangle(this.orientation == 2 ? this.blTitleRect : this.trTitleRect);
        return bounds;
    }

    private Rectangle getVerticalLabelBounds() {
        int height;
        int width;
        int y;
        int x;
        boolean leftLabel = this.orientation == 3 && !this.axisLabel.equals("");
        boolean rightLabel = this.orientation == 4 && !this.axisLabel.equals("");
        int leftPosition = this.getColumn().getDMinimum() - 1;
        int rightPosition = this.getColumn().getDMaximum();
        int DMax = this.getRow().getDMaximum();
        int DMin = this.getRow().getDMinimum();
        int offset = this.getTitlePositionOffset();
        Font labelFont = this.getLabelFont();
        GrannyTextRenderer gtr = new GrannyTextRenderer();
        gtr.setString(labelFont, this.getLabel());
        if (leftLabel) {
            x = this.getColumn().getDMinimum() - offset - (int)Math.ceil(gtr.getAscent());
            y = 0;
            width = (int)Math.ceil(gtr.getHeight());
            height = this.getCanvas().getHeight();
            this.blTitleRect = AttachedLabel.setRectangleBounds(this.blTitleRect, x, y, width, height);
        }
        if (rightLabel) {
            x = this.getColumn().getDMaximum() + offset - (int)Math.ceil(gtr.getDescent());
            y = 0;
            width = (int)Math.ceil(gtr.getHeight());
            height = this.getCanvas().getHeight();
            this.trTitleRect = AttachedLabel.setRectangleBounds(this.trTitleRect, x, y, width, height);
        }
        Rectangle bounds = new Rectangle(this.orientation == 3 ? this.blTitleRect : this.trTitleRect);
        return bounds;
    }

    private static Rectangle setRectangleBounds(Rectangle rc, int x, int y, int width, int height) {
        if (rc == null) {
            return new Rectangle(x, y, width, height);
        }
        rc.setBounds(x, y, width, height);
        return rc;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public boolean isHorizontal() {
        return this.orientation == 2 || this.orientation == 1;
    }

    protected static String orientationToString(int i) {
        switch (i) {
            case 1: {
                return "top";
            }
            case 2: {
                return "bottom";
            }
            case 3: {
                return "left";
            }
            case 4: {
                return "right";
            }
        }
        throw new IllegalStateException("invalid orienation: " + i);
    }

    protected static int parseOrientationString(String orientationString) {
        if (orientationString.equals("horizontal")) {
            return 2;
        }
        if (orientationString.equals("vertical")) {
            return 3;
        }
        if (orientationString.equals("left")) {
            return 3;
        }
        if (orientationString.equals("right")) {
            return 4;
        }
        if (orientationString.equals("top")) {
            return 1;
        }
        if (orientationString.equals("bottom")) {
            return 2;
        }
        throw new IllegalArgumentException("Invalid orientation: " + orientationString);
    }

    public Shape getActiveRegion() {
        return this.getLabelBounds();
    }

    public double getEmOffset() {
        return this.emOffset;
    }

    public void setEmOffset(double emOffset) {
        this.emOffset = emOffset;
    }
}

