/*
 * Decompiled with CFR 0.152.
 */
package org.das2.fsm;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.das2.dataset.CacheTag;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.system.DasLogger;
import org.das2.util.TimeParser;
import org.das2.util.filesystem.FileObject;
import org.das2.util.filesystem.FileSystem;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;
import org.das2.util.monitor.SubTaskMonitor;

public class FileStorageModelNew {
    private Pattern pattern;
    private Pattern absPattern;
    private String regex;
    FileStorageModelNew parent;
    FileSystem root;
    TimeParser timeParser;
    String template;
    static Logger logger = DasLogger.getLogger(DasLogger.SYSTEM_LOG);
    HashMap fileNameMap = null;

    private int toTimeUtilEnum(int i) {
        if (i < 100 || i > 300) {
            throw new IllegalArgumentException("enumeration is not of the correct type");
        }
        if ((i %= 100) == 0) {
            i = 1;
        }
        return i;
    }

    private DatumRange getDatumRangeFor(String filename) {
        try {
            if (this.pattern.matcher(filename).matches()) {
                this.timeParser.parse(filename);
                return this.timeParser.getTimeRange();
            }
            throw new IllegalArgumentException("file name (" + filename + ") doesn't match model specification (" + this.regex + ")");
        }
        catch (ParseException e) {
            IllegalArgumentException e2 = new IllegalArgumentException("file name (" + filename + ") doesn't match model specification (" + this.regex + "), parse error in field", e);
            throw e2;
        }
        catch (NumberFormatException e) {
            IllegalArgumentException e2 = new IllegalArgumentException("file name (" + filename + ") doesn't match model specification (" + this.regex + "), parse error in field", e);
            throw e2;
        }
    }

    public String getFilenameFor(Datum start, Datum end) {
        return this.timeParser.format(start, end);
    }

    public String[] getNamesFor(DatumRange targetRange) throws IOException {
        return this.getNamesFor(targetRange, new NullProgressMonitor());
    }

    public String[] getNamesFor(DatumRange targetRange, ProgressMonitor monitor) throws IOException {
        String listRegex;
        FileSystem[] fileSystems;
        String[] names;
        if (this.parent != null) {
            names = this.parent.getNamesFor(targetRange);
            fileSystems = new FileSystem[names.length];
            for (int i = 0; i < names.length; ++i) {
                try {
                    URL url = new URL(this.root.getRootURL(), names[i]);
                    fileSystems[i] = FileSystem.create(url);
                    continue;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            String parentRegex = FileStorageModelNew.getParentRegex(this.regex);
            listRegex = this.regex.substring(parentRegex.length() + 1);
        } else {
            fileSystems = new FileSystem[]{this.root};
            names = new String[]{""};
            listRegex = this.regex;
        }
        ArrayList<String> list = new ArrayList<String>();
        monitor.setTaskSize(fileSystems.length * 10);
        monitor.started();
        for (int i = 0; i < fileSystems.length; ++i) {
            monitor.setTaskProgress(i * 10);
            String[] files1 = fileSystems[i].listDirectory("/", listRegex);
            for (int j = 0; j < files1.length; ++j) {
                String ff;
                String string = ff = names[i].equals("") ? files1[j] : names[i] + "/" + files1[j];
                if (ff.endsWith("/")) {
                    ff = ff.substring(0, ff.length() - 1);
                }
                try {
                    if (this.getDatumRangeFor(ff).intersects(targetRange)) {
                        list.add(ff);
                    }
                }
                catch (IllegalArgumentException e) {
                    logger.fine("ignoring file " + ff);
                }
                monitor.setTaskProgress(i * 10 + j * 10 / files1.length);
            }
        }
        monitor.finished();
        return list.toArray(new String[list.size()]);
    }

    public static CacheTag getCacheTagFor(FileStorageModelNew fsm, DatumRange range, String[] names) {
        Datum min = range.min();
        Datum max = range.max();
        for (int i = 0; i < names.length; ++i) {
            DatumRange r = fsm.getRangeFor(names[i]);
            min = min.gt(range.min()) ? r.min() : min;
            max = max.lt(range.max()) ? r.max() : max;
        }
        return new CacheTag(min, max, null);
    }

    public static CacheTag getCacheTagFor(FileStorageModelNew fsm, DatumRange range, File[] files) {
        String[] names = new String[files.length];
        for (int i = 0; i < files.length; ++i) {
            names[i] = fsm.getNameFor(files[i]);
        }
        return FileStorageModelNew.getCacheTagFor(fsm, range, names);
    }

    public File[] getFilesFor(DatumRange targetRange) throws IOException {
        return this.getFilesFor(targetRange, new NullProgressMonitor());
    }

    public DatumRange getRangeFor(String name) {
        return this.getDatumRangeFor(name);
    }

    public boolean containsFile(File file) {
        if (!this.fileNameMap.containsKey(file)) {
            return false;
        }
        String result = (String)this.fileNameMap.get(file);
        String name = this.getNameFor(file);
        Matcher m = this.pattern.matcher(name);
        return m.matches();
    }

    public String getNameFor(File file) {
        String result = (String)this.fileNameMap.get(file);
        if (result == null) {
            throw new IllegalArgumentException("File didn't come from this FileStorageModel");
        }
        return result;
    }

    public File[] getFilesFor(DatumRange targetRange, ProgressMonitor monitor) throws IOException {
        String[] names = this.getNamesFor(targetRange);
        File[] files = new File[names.length];
        if (this.fileNameMap == null) {
            this.fileNameMap = new HashMap();
        }
        if (names.length > 0) {
            monitor.setTaskSize(names.length * 10);
        }
        monitor.started();
        for (int i = 0; i < names.length; ++i) {
            try {
                FileObject o = this.root.getFileObject(names[i]);
                files[i] = o.getFile(SubTaskMonitor.create(monitor, i * 10, (i + 1) * 10));
                this.fileNameMap.put(files[i], names[i]);
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        monitor.finished();
        return files;
    }

    private static int countGroups(String regex) {
        boolean result = false;
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher("");
        return m.groupCount();
    }

    private static String getParentRegex(String regex) {
        String dirRegex;
        String[] s = regex.split("/");
        if (s.length > 1) {
            dirRegex = s[0];
            for (int i = 1; i < s.length - 2; ++i) {
                dirRegex = dirRegex + "/" + s[i];
            }
        } else {
            dirRegex = null;
        }
        String fileRegex = s[s.length - 1];
        return dirRegex;
    }

    public static FileStorageModelNew create(FileSystem root, String template) {
        int i = template.lastIndexOf("/");
        int i2 = template.lastIndexOf("%", i);
        if (i2 != -1) {
            String parentTemplate = template.substring(0, i);
            FileStorageModelNew parentFSM = FileStorageModelNew.create(root, parentTemplate);
            return new FileStorageModelNew(parentFSM, root, template);
        }
        return new FileStorageModelNew(null, root, template);
    }

    public static FileStorageModelNew create(FileSystem root, String template, String fieldName, TimeParser.FieldHandler fieldHandler) {
        int i = template.lastIndexOf("/");
        int i2 = template.lastIndexOf("%", i);
        if (i2 != -1) {
            String parentTemplate = template.substring(0, i);
            FileStorageModelNew parentFSM = FileStorageModelNew.create(root, parentTemplate);
            return new FileStorageModelNew(parentFSM, root, template, fieldName, fieldHandler);
        }
        return new FileStorageModelNew(null, root, template, fieldName, fieldHandler);
    }

    private FileStorageModelNew(FileStorageModelNew parent, FileSystem root, String template, String fieldName, TimeParser.FieldHandler fieldHandler) {
        this.root = root;
        this.parent = parent;
        this.template = template;
        this.timeParser = TimeParser.create(template, fieldName, fieldHandler);
        this.regex = this.timeParser.getRegex();
        this.pattern = Pattern.compile(this.regex);
    }

    private FileStorageModelNew(FileStorageModelNew parent, FileSystem root, String template) {
        this.root = root;
        this.parent = parent;
        this.template = template;
        this.timeParser = TimeParser.create(template);
        this.regex = this.timeParser.getRegex();
        this.pattern = Pattern.compile(this.regex);
    }

    public String toString() {
        return String.valueOf(this.root) + this.regex;
    }
}

