/*
 * Decompiled with CFR 0.152.
 */
package org.das2.event;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import org.das2.event.DragRenderer;
import org.das2.event.MouseDragEvent;
import org.das2.graph.DasCanvasComponent;
import org.das2.graph.DasRow;

public class VerticalSliceSelectionRenderer
implements DragRenderer {
    DasCanvasComponent parent;
    Rectangle dirtyBounds;

    public VerticalSliceSelectionRenderer(DasCanvasComponent parent) {
        this.parent = parent;
        this.dirtyBounds = new Rectangle();
    }

    private void drawCrossHair(Graphics g0, Point p) {
        Graphics g = g0.create();
        g.setColor(new Color(0, 0, 0));
        g.setXORMode(Color.white);
        DasRow row = this.parent.getRow();
        g.drawLine(p.x, row.getDMinimum(), p.x, row.getDMaximum());
        g.dispose();
    }

    public Rectangle[] renderDrag(Graphics g, Point p1, Point p2) {
        this.drawCrossHair(g, p2);
        this.dirtyBounds.setRect(p2.x, 0.0, 1.0, this.parent.getHeight());
        return new Rectangle[]{this.dirtyBounds};
    }

    public MouseDragEvent getMouseDragEvent(Object o, Point p1, Point p2, boolean isModified) {
        return null;
    }

    public void clear(Graphics g) {
        this.parent.paintImmediately(this.dirtyBounds);
    }

    public boolean isPointSelection() {
        return true;
    }

    public boolean isUpdatingDragSelection() {
        return false;
    }
}

