/*
 * Decompiled with CFR 0.152.
 */
package org.das2.event;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.das2.DasException;
import org.das2.dataset.AverageTableRebinner;
import org.das2.dataset.ClippedTableDataSet;
import org.das2.dataset.DataSet;
import org.das2.dataset.DataSetConsumer;
import org.das2.dataset.DataSetUpdateEvent;
import org.das2.dataset.DataSetUpdateListener;
import org.das2.dataset.DataSetUtil;
import org.das2.dataset.NoDataInIntervalException;
import org.das2.dataset.RebinDescriptor;
import org.das2.dataset.SingleVectorDataSet;
import org.das2.dataset.TableDataSet;
import org.das2.dataset.TableDataSetConsumer;
import org.das2.dataset.VectorDataSet;
import org.das2.dataset.VectorDataSetBuilder;
import org.das2.dataset.test.PolynomialDataSetDescriptor;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.Units;
import org.das2.event.BoxRenderer;
import org.das2.event.BoxSelectionEvent;
import org.das2.event.BoxSelectorMouseModule;
import org.das2.event.DataPointSelectionEvent;
import org.das2.event.DataPointSelectionListener;
import org.das2.event.DataPointSelectorMouseModule;
import org.das2.event.HorizontalSliceSelectionRenderer;
import org.das2.event.VerticalSliceSelectionRenderer;
import org.das2.graph.DasAxis;
import org.das2.graph.DasCanvas;
import org.das2.graph.DasColumn;
import org.das2.graph.DasPlot;
import org.das2.graph.DasRow;
import org.das2.graph.Psym;
import org.das2.graph.PsymConnector;
import org.das2.graph.SymColor;
import org.das2.graph.SymbolLineRenderer;
import org.das2.math.QuadFitUtil;
import org.das2.system.DasLogger;
import org.das2.util.DasMath;

public class PeakDetectorMouseModule
extends BoxSelectorMouseModule {
    DasAxis xaxis;
    DasAxis yaxis;
    DataSetConsumer dataSetConsumer;
    DatumRange xrange;
    DatumRange yrange;
    String lastComment;
    PeakSlicer peakSlicer;
    static Logger logger = DasLogger.getLogger(DasLogger.GUI_LOG);
    private transient ArrayList dataSetUpdateListenerList;
    private Datum levelMin = Units.dB.createDatum(-3.0);
    private Datum xResolution = Units.milliseconds.createDatum(500);

    public PeakDetectorMouseModule(DasPlot parent, DataSetConsumer consumer) {
        super(parent, parent.getXAxis(), parent.getYAxis(), consumer, new BoxRenderer(parent, true), "Peak Detector");
        this.dataSetConsumer = consumer;
    }

    protected void fireBoxSelectionListenerBoxSelected(BoxSelectionEvent event) {
        final DatumRange xrange0 = this.xrange;
        final DatumRange yrange0 = this.yrange;
        this.xrange = event.getXRange();
        this.yrange = event.getYRange();
        this.lastComment = event.getPlane("keyChar") != null ? (String)event.getPlane("keyChar") : null;
        Runnable run = new Runnable(){

            public void run() {
                try {
                    PeakDetectorMouseModule.this.recalculate();
                }
                catch (RuntimeException ex) {
                    PeakDetectorMouseModule.this.xrange = xrange0;
                    PeakDetectorMouseModule.this.yrange = yrange0;
                    throw ex;
                }
            }
        };
        new Thread(run).start();
    }

    private RebinDescriptor getRebinDescriptor(DatumRange range) {
        double res = this.xResolution.doubleValue(Units.microseconds);
        double min = range.min().doubleValue(Units.us2000);
        min = Math.floor(min / res);
        double max = range.max().doubleValue(Units.us2000);
        max = Math.ceil(max / res);
        int nbin = (int)(max - min);
        RebinDescriptor ddx = new RebinDescriptor(min * res, max * res, Units.us2000, nbin, false);
        return ddx;
    }

    private VectorDataSet toDb(VectorDataSet ds, Datum reference) {
        Units refUnits = reference.getUnits();
        double refValue = reference.doubleValue(refUnits);
        Units yunits = Units.dB;
        Units xunits = ds.getXUnits();
        VectorDataSetBuilder builder = new VectorDataSetBuilder(xunits, yunits);
        for (int i = 0; i < ds.getXLength(); ++i) {
            builder.insertY(ds.getXTagDouble(i, xunits), 10.0 * DasMath.log10(ds.getDouble(i, refUnits) / refValue));
        }
        return builder.toVectorDataSet();
    }

    private FitDescriptor doDigitize(TableDataSet tds, int i) {
        VectorDataSet slice = tds.getXSlice(i);
        int peakIndex = PeakDetectorMouseModule.peakIndex(slice, this.yrange.min(), this.yrange.max());
        if (peakIndex != -1) {
            VectorDataSet spec = this.toDb(slice, slice.getDatum(peakIndex));
            double[] fit = this.getFit(spec, peakIndex);
            if (fit != null) {
                double peakx = QuadFitUtil.quadPeak(fit);
                double peaky = fit[0] + fit[1] * peakx + fit[2] * peakx * peakx;
                double halfWidth = QuadFitUtil.quadHalfWidth(fit, 3.0);
                FitDescriptor result = new FitDescriptor();
                result.halfWidth = tds.getYUnits().getOffsetUnits().createDatum(halfWidth);
                result.peakX = tds.getYUnits().createDatum(peakx);
                result.time = tds.getXTagDatum(i);
                result.digitizedDataSet = spec;
                result.fitCoef = fit;
                return result;
            }
            return null;
        }
        return null;
    }

    private TableDataSet conditionData(TableDataSet tds, DatumRange range) throws NoDataInIntervalException {
        AverageTableRebinner rebinner = new AverageTableRebinner();
        RebinDescriptor ddx = this.getRebinDescriptor(range);
        try {
            tds = (TableDataSet)rebinner.rebin(tds, ddx, null);
        }
        catch (NoDataInIntervalException e) {
            throw e;
        }
        catch (DasException e) {
            throw new RuntimeException(e);
        }
        return tds;
    }

    private void recalculate() {
        TableDataSet tds = (TableDataSet)this.dataSetConsumer.getConsumedDataSet();
        tds = new ClippedTableDataSet(tds, this.xrange, this.yrange);
        DatumRange range = DataSetUtil.xRange(tds);
        try {
            tds = this.conditionData(tds, range);
        }
        catch (NoDataInIntervalException ex) {
            return;
        }
        VectorDataSetBuilder builder = new VectorDataSetBuilder(tds.getXUnits(), tds.getYUnits());
        builder.addPlane("halfWidth", tds.getYUnits());
        for (int i = 0; i < tds.getXLength(); ++i) {
            FitDescriptor fit = this.doDigitize(tds, i);
            if (fit == null) continue;
            builder.insertY(fit.time, fit.peakX);
            builder.insertY(fit.time, fit.halfWidth, "halfWidth");
        }
        String comment = "West:" + this.levelMin;
        if (this.lastComment != null) {
            comment = this.lastComment + " " + comment;
        }
        builder.setProperty("comment", comment);
        builder.setProperty("xTagWidth", this.xResolution);
        VectorDataSet vds = builder.toVectorDataSet();
        this.fireDataSetUpdateListenerDataSetUpdated(new DataSetUpdateEvent((Object)this, (DataSet)vds));
    }

    private static int peakIndex(VectorDataSet ds, Datum min, Datum max) {
        Datum yMax = ds.getYUnits().createDatum(Double.NEGATIVE_INFINITY);
        int iMax = -1;
        int i0 = -1;
        int i1 = -1;
        for (int i = 0; i < ds.getXLength(); ++i) {
            Datum y = ds.getDatum(i);
            Datum x = ds.getXTagDatum(i);
            if (!x.ge(min) || !x.lt(max)) continue;
            if (i0 == -1) {
                i0 = i;
            }
            i1 = i;
            if (!y.gt(yMax)) continue;
            yMax = y;
            iMax = i;
        }
        if (iMax == i0 || iMax == i1) {
            iMax = -1;
        }
        return iMax;
    }

    private static int[] findFive(VectorDataSet ds, int peakIndex) {
        double yLowPrev;
        Units yUnits = ds.getYUnits();
        int[] indices = new int[7];
        indices[0] = peakIndex;
        int nIndex = 1;
        double yHighPrev = yLowPrev = ds.getDouble(peakIndex, yUnits);
        for (int i = 1; i <= 3 && nIndex < 5; ++i) {
            double yHigh;
            double yLow = peakIndex - i >= 0 ? ds.getDouble(peakIndex - i, yUnits) : Double.POSITIVE_INFINITY;
            double d = yHigh = peakIndex + i < ds.getXLength() ? ds.getDouble(peakIndex + i, yUnits) : Double.POSITIVE_INFINITY;
            if (yLow < yLowPrev) {
                indices[nIndex++] = peakIndex - i;
                yLowPrev = yLow;
            } else {
                yLowPrev = Double.NEGATIVE_INFINITY;
            }
            if (yHigh < yHighPrev) {
                indices[nIndex++] = peakIndex + i;
                yHighPrev = yHigh;
                continue;
            }
            yHighPrev = Double.NEGATIVE_INFINITY;
        }
        Arrays.sort(indices, 0, nIndex);
        int[] result = new int[nIndex];
        System.arraycopy(indices, 0, result, 0, nIndex);
        return result;
    }

    private double[] getFit(VectorDataSet slice, int jMax) {
        Datum y = slice.getXTagDatum(jMax);
        Datum z = slice.getDatum(jMax);
        Units xUnits = slice.getXUnits();
        Units yUnits = Units.dB;
        int[] indices = PeakDetectorMouseModule.findFive(slice, jMax);
        int peakOfFive = Arrays.binarySearch(indices, jMax);
        double[] px = new double[indices.length];
        double[] py = new double[indices.length];
        double[] w = new double[indices.length];
        for (int iIndex = 0; iIndex < indices.length; ++iIndex) {
            px[iIndex] = slice.getXTagDouble(indices[iIndex], xUnits);
            py[iIndex] = slice.getDouble(indices[iIndex], yUnits);
            w[iIndex] = Units.dB.convertDoubleTo(Units.dimensionless, py[iIndex]);
        }
        double threeDown = py[peakOfFive] - this.levelMin.doubleValue(Units.dB);
        if (threeDown < py[0] && threeDown < py[py.length - 1]) {
            return null;
        }
        double[] c = QuadFitUtil.quadfit(px, py, w);
        if (c[2] >= -0.0) {
            return null;
        }
        double peak = QuadFitUtil.quadPeak(c);
        if (peak < slice.getXTagDouble(0, xUnits) || peak > slice.getXTagDouble(slice.getXLength() - 1, xUnits)) {
            return null;
        }
        return c;
    }

    public DataPointSelectionListener getSlicer(DasPlot plot, TableDataSetConsumer consumer) {
        DasAxis sourceYAxis = plot.getYAxis();
        DasAxis sourceZAxis = consumer.getZAxis();
        DatumRange range = sourceYAxis.getDatumRange();
        DasAxis xAxis = sourceYAxis.createAttachedAxis(2);
        this.peakSlicer = new PeakSlicer(plot, xAxis);
        return this.peakSlicer;
    }

    public synchronized void addDataSetUpdateListener(DataSetUpdateListener listener) {
        if (this.dataSetUpdateListenerList == null) {
            this.dataSetUpdateListenerList = new ArrayList();
        }
        this.dataSetUpdateListenerList.add(listener);
    }

    public synchronized void removeDataSetUpdateListener(DataSetUpdateListener listener) {
        if (this.dataSetUpdateListenerList != null) {
            this.dataSetUpdateListenerList.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireDataSetUpdateListenerDataSetUpdated(DataSetUpdateEvent event) {
        ArrayList list;
        PeakDetectorMouseModule peakDetectorMouseModule = this;
        synchronized (peakDetectorMouseModule) {
            if (this.dataSetUpdateListenerList == null) {
                return;
            }
            list = (ArrayList)this.dataSetUpdateListenerList.clone();
        }
        for (int i = 0; i < list.size(); ++i) {
            ((DataSetUpdateListener)list.get(i)).dataSetUpdated(event);
        }
    }

    public Datum getLevelMin() {
        return this.levelMin;
    }

    public void setLevelMin(Datum levelMin) {
        this.levelMin = levelMin;
        this.recalculate();
    }

    public Datum getXResolution() {
        return this.xResolution;
    }

    public void setXResolution(Datum xResolution) {
        this.xResolution = xResolution;
    }

    private class PeakSlicer
    implements DataPointSelectionListener {
        DataPointSelectionEvent lastSelectedPoint;
        FitDescriptor fit;
        Datum yValue;
        Datum xValue;
        int selectedRecord;
        SymbolLineRenderer levelRenderer;
        SymbolLineRenderer fitRenderer;
        SymbolLineRenderer fitPointRenderer;
        DasPlot topPlot;
        JFrame frame;
        Action prevAction = new AbstractAction("<< Prev"){

            public void actionPerformed(ActionEvent e) {
                Datum xnew = PeakSlicer.this.xValue.subtract(PeakDetectorMouseModule.this.xResolution);
                DataPointSelectionEvent evNew = new DataPointSelectionEvent(this, xnew, PeakSlicer.this.yValue);
                PeakSlicer.this.dataPointSelected(evNew);
            }
        };
        Action nextAction = new AbstractAction("Next >>"){

            public void actionPerformed(ActionEvent e) {
                Datum xnew = PeakSlicer.this.xValue.add(PeakDetectorMouseModule.this.xResolution);
                DataPointSelectionEvent evNew = new DataPointSelectionEvent(this, xnew, PeakSlicer.this.yValue);
                PeakSlicer.this.dataPointSelected(evNew);
            }
        };

        PeakSlicer(DasPlot parent, DasAxis xaxis) {
            this.frame = new JFrame("Peak Slice");
            JPanel contentPanel = new JPanel();
            contentPanel.setLayout(new BorderLayout());
            DasCanvas canvas = new DasCanvas(300, 300);
            contentPanel.add((Component)canvas, "Center");
            Box npBox = Box.createHorizontalBox();
            npBox.add(new JButton(this.prevAction));
            npBox.add(new JButton(this.nextAction));
            contentPanel.add((Component)npBox, "North");
            this.frame.getContentPane().add(contentPanel);
            this.frame.pack();
            this.frame.setVisible(false);
            this.frame.setDefaultCloseOperation(1);
            DasColumn col = DasColumn.create(canvas);
            DasRow row1 = DasRow.create(canvas, 0, 1);
            DasAxis yaxis = new DasAxis(new DatumRange(0.001, 1.0, Units.dimensionless), 3);
            yaxis.setLog(true);
            PeakDasPlot plot = new PeakDasPlot(xaxis, yaxis);
            plot.getYAxis().setLabel("level");
            plot.getXAxis().setTickLabelsVisible(false);
            this.levelRenderer = new SymbolLineRenderer();
            this.fitRenderer = new SymbolLineRenderer();
            this.fitRenderer = new SymbolLineRenderer();
            this.fitRenderer.setColor(SymColor.blue);
            this.fitPointRenderer = new SymbolLineRenderer();
            this.fitPointRenderer.setColor(SymColor.red);
            this.fitPointRenderer.setPsymConnector(PsymConnector.NONE);
            this.fitPointRenderer.setPsym(Psym.TRIANGLES);
            this.fitPointRenderer.setSymSize(3.0);
            plot.addRenderer(this.fitRenderer);
            plot.addRenderer(this.levelRenderer);
            this.topPlot = plot;
            DataPointSelectorMouseModule tweakSlicer = new DataPointSelectorMouseModule(this.topPlot, this.levelRenderer, new VerticalSliceSelectionRenderer(this.topPlot), "tweak cutoff"){

                public void keyPressed(KeyEvent event) {
                    System.err.print(event);
                    if (event.getKeyCode() != 40 && event.getKeyCode() == 38) {
                        Datum xnew = PeakSlicer.this.xValue.subtract(PeakDetectorMouseModule.this.xResolution);
                        DataPointSelectionEvent evNew = new DataPointSelectionEvent(this, xnew, PeakSlicer.this.yValue);
                        PeakSlicer.this.dataPointSelected(evNew);
                    }
                }
            };
            tweakSlicer.setDragEvents(true);
            tweakSlicer.addDataPointSelectionListener(new DataPointSelectionListener(){

                public void dataPointSelected(DataPointSelectionEvent e) {
                    Datum x = e.getX();
                    HashMap<String, Object> properties = new HashMap<String, Object>();
                    if (e.getPlane("keyChar") != null) {
                        properties.put("comment", e.getPlane("keyChar"));
                    } else {
                        properties.put("comment", "tweak");
                    }
                    PeakDetectorMouseModule.this.fireDataSetUpdateListenerDataSetUpdated(new DataSetUpdateEvent((Object)this, (DataSet)new SingleVectorDataSet(PeakSlicer.this.xValue, e.getX(), properties)));
                }
            });
            this.topPlot.addMouseModule(tweakSlicer);
            this.topPlot.getDasMouseInputAdapter().setPrimaryModule(tweakSlicer);
            DataPointSelectorMouseModule levelSlicer = new DataPointSelectorMouseModule(this.topPlot, this.levelRenderer, new HorizontalSliceSelectionRenderer(this.topPlot), "peak S/N level");
            levelSlicer.addDataPointSelectionListener(new DataPointSelectionListener(){

                public void dataPointSelected(DataPointSelectionEvent e) {
                    Datum y = e.getY();
                    PeakDetectorMouseModule.this.setLevelMin(y);
                }
            });
            levelSlicer.setDragEvents(false);
            levelSlicer.setKeyEvents(false);
            levelSlicer.setReleaseEvents(true);
            this.topPlot.addMouseModule(levelSlicer);
            canvas.add(plot, row1, col);
        }

        public void dataPointSelected(DataPointSelectionEvent event) {
            logger.fine("got DataPointSelectionEvent: " + event.getX());
            this.lastSelectedPoint = event;
            TableDataSet tds = (TableDataSet)PeakDetectorMouseModule.this.dataSetConsumer.getConsumedDataSet();
            this.xValue = event.getX();
            this.yValue = event.getY();
            if (PeakDetectorMouseModule.this.xrange == null) {
                return;
            }
            DatumRange range = new DatumRange(event.getX(), event.getX());
            try {
                tds = PeakDetectorMouseModule.this.conditionData(tds, range);
            }
            catch (NoDataInIntervalException ex) {
                return;
            }
            logger.fine("find closest column ");
            int i = DataSetUtil.closestColumn(tds, event.getX());
            this.xValue = tds.getXTagDatum(i);
            this.topPlot.setTitle("" + this.xValue);
            logger.fine("doDigitize");
            this.fit = PeakDetectorMouseModule.this.doDigitize(tds, i);
            if (this.fit != null) {
                this.levelRenderer.setDataSet(this.fit.digitizedDataSet);
                Datum resLimit = this.topPlot.getXAxis().invTransform(1.0).subtract(this.topPlot.getXAxis().invTransform(0.0));
                PolynomialDataSetDescriptor dsd = new PolynomialDataSetDescriptor(this.fit.fitCoef, this.fit.peakX.getUnits(), this.fit.digitizedDataSet.getYUnits(), resLimit);
                dsd.setYMin(this.fit.digitizedDataSet.getYUnits().createDatum(-5));
                this.fitRenderer.setDataSetDescriptor(dsd);
            }
            this.showPopup();
        }

        private void showPopup() {
            if (!this.frame.isVisible()) {
                this.frame.setVisible(true);
            }
        }

        class PeakDasPlot
        extends DasPlot {
            PeakDasPlot(DasAxis x, DasAxis y) {
                super(x, y);
            }

            protected void drawContent(Graphics2D g) {
                super.drawContent(g);
                if (PeakSlicer.this.fit != null) {
                    g.setColor(Color.GRAY);
                    int ix = (int)this.getXAxis().transform(PeakSlicer.this.fit.peakX);
                    g.drawLine(ix, 0, ix, this.getHeight());
                    int iy = (int)this.getYAxis().transform(Units.dB.createDatum(-3));
                    g.drawLine(0, iy, this.getWidth(), iy);
                    g.setColor(Color.pink);
                    ix = (int)this.getXAxis().transform(PeakSlicer.this.yValue);
                    g.drawLine(ix, 0, ix, this.getHeight());
                }
            }
        }
    }

    class FitDescriptor {
        Datum time;
        Datum peakX;
        Datum halfWidth;
        double[] fitCoef;
        int[] fitPoints;
        VectorDataSet digitizedDataSet;

        FitDescriptor() {
        }
    }
}

