/*
 * Decompiled with CFR 0.152.
 */
package org.das2.event;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import org.das2.event.DragRenderer;
import org.das2.event.Gesture;
import org.das2.event.MouseDragEvent;
import org.das2.graph.DasCanvasComponent;

public class GesturesRenderer
implements DragRenderer {
    DasCanvasComponent parent;
    Rectangle dirtyBounds;

    public GesturesRenderer(DasCanvasComponent parent) {
        this.parent = parent;
        this.dirtyBounds = new Rectangle();
    }

    public MouseDragEvent getMouseDragEvent(Object source, Point p1, Point p2, boolean isModified) {
        Gesture g = null;
        double dx = p2.x - p1.x;
        double dy = -1 * (p2.y - p1.y);
        double angle = Math.atan2(dy, dx) * 180.0 / Math.PI;
        double radius = Math.sqrt(dy * dy + dx * dx);
        int width = ((Component)source).getWidth();
        int xOffset = ((Component)source).getLocation().x;
        if (radius < 20.0 && radius > 4.0) {
            if (p1.x - xOffset < 10 && p1.x - xOffset >= 0 && p2.x - xOffset < 0) {
                g = Gesture.SCANPREV;
            } else if (p1.x - xOffset > width - 10 && p1.x - xOffset < width && p2.x - xOffset >= width) {
                g = Gesture.SCANNEXT;
            } else if (Math.abs(angle) > 160.0) {
                g = Gesture.BACK;
            } else if (-110.0 < angle && angle < -70.0) {
                g = Gesture.ZOOMOUT;
            } else if (Math.abs(angle) < 30.0) {
                g = Gesture.FORWARD;
            }
        } else {
            g = Gesture.UNDEFINED;
        }
        return new MouseDragEvent(source, g);
    }

    public Rectangle[] renderDrag(Graphics g1, Point p1, Point p2) {
        Graphics2D g = (Graphics2D)g1;
        double dx = p2.x - p1.x;
        double dy = -1 * (p2.y - p1.y);
        double angle = Math.atan2(dy, dx) * 180.0 / Math.PI;
        double radius = Math.sqrt(dy * dy + dx * dx);
        int width = this.parent.getWidth();
        boolean xOffset = false;
        if (radius > 4.0) {
            Color color0 = g.getColor();
            for (int i = 0; i < 2; ++i) {
                if (i == 0) {
                    g.setColor(new Color(255, 255, 255, 100));
                    g.setStroke(new BasicStroke(3.0f, 1, 1));
                } else {
                    g.setColor(color0);
                    g.setStroke(new BasicStroke());
                }
                if (Math.abs(angle) > 160.0) {
                    g.drawLine(p1.x, p1.y, p1.x - 5, p1.y);
                    g.drawLine(p1.x - 5, p1.y, p1.x - 3, p1.y - 2);
                    g.drawLine(p1.x - 5, p1.y, p1.x - 3, p1.y + 2);
                    continue;
                }
                if (-110.0 < angle && angle < -70.0) {
                    g.drawLine(p1.x, p1.y, p1.x, p1.y + 5);
                    g.drawLine(p1.x - 2, p1.y + 3, p1.x, p1.y + 5);
                    g.drawLine(p1.x + 2, p1.y + 3, p1.x, p1.y + 5);
                    continue;
                }
                if (!(Math.abs(angle) < 30.0)) continue;
                g.drawLine(p1.x, p1.y, p1.x + 5, p1.y);
                g.drawLine(p1.x + 5, p1.y, p1.x + 3, p1.y - 2);
                g.drawLine(p1.x + 5, p1.y, p1.x + 3, p1.y + 2);
            }
        }
        this.dirtyBounds.setRect(p1.x - 10, p1.y - 10, 20.0, 20.0);
        return new Rectangle[]{this.dirtyBounds};
    }

    public void clear(Graphics g) {
        this.parent.paintImmediately(this.dirtyBounds);
    }

    protected Rectangle getDirtyBounds() {
        return this.dirtyBounds;
    }

    public boolean isPointSelection() {
        return false;
    }

    public boolean isUpdatingDragSelection() {
        return false;
    }

    public boolean isGesture(Point p1, Point p2) {
        double dy = -1 * (p2.y - p1.y);
        double dx = p2.x - p1.x;
        double radius = Math.sqrt(dy * dy + dx * dx);
        return radius < 20.0;
    }
}

