/*
 * Decompiled with CFR 0.152.
 */
package org.das2.event;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.text.DecimalFormat;
import org.das2.datum.Datum;
import org.das2.event.DragRenderer;
import org.das2.event.LabelDragRenderer;
import org.das2.event.MouseDragEvent;
import org.das2.graph.DasAxis;
import org.das2.graph.DasCanvasComponent;

public class FrequencyDragRenderer
extends LabelDragRenderer
implements DragRenderer,
KeyListener {
    DasCanvasComponent parent;
    DasAxis axis;
    int ncycles;
    private boolean horizontal;
    double period;
    private PropertyChangeSupport pcs;

    public FrequencyDragRenderer(DasCanvasComponent parent, DasAxis axis) {
        super(parent);
        this.parent = parent;
        parent.addKeyListener(this);
        this.axis = axis;
        this.dirtyBounds = new Rectangle();
        this.ncycles = 1;
    }

    public Rectangle[] renderDrag(Graphics g1, Point p1, Point p2) {
        int t;
        Rectangle myDirtyBounds = new Rectangle();
        this.horizontal = this.axis.isHorizontal();
        Graphics2D g = (Graphics2D)g1;
        int x1 = p1.x;
        int x2 = p2.x;
        int y1 = p1.y;
        int y2 = p2.y;
        if (this.horizontal && x2 < x1) {
            t = x2;
            x2 = x1;
            x1 = t;
        }
        if (!this.horizontal && y2 < y1) {
            y1 = t = y2;
        }
        int width = this.horizontal ? x2 - x1 : y2 - y1;
        Color color0 = g.getColor();
        Stroke stroke0 = g.getStroke();
        g.setColor(new Color(255, 255, 255, 128));
        g.setStroke(new BasicStroke(3.0f, 1, 1));
        this.internalRender(g, myDirtyBounds, x1, x2, y1, y2);
        g.setStroke(stroke0);
        g.setColor(color0);
        this.internalRender(g, myDirtyBounds, x1, x2, y1, y2);
        Datum periodDatum = this.horizontal ? this.axis.invTransform(x2).subtract(this.axis.invTransform(x1)) : this.axis.invTransform(y2).subtract(this.axis.invTransform(y1));
        double oldPeriod = this.period;
        this.period = periodDatum.doubleValue(periodDatum.getUnits());
        this.fireChange(oldPeriod, this.period);
        double freq = (double)this.ncycles / this.period;
        DecimalFormat df = new DecimalFormat("0.00");
        this.setLabel("T:" + periodDatum + " f:" + df.format(freq) + "" + periodDatum.getUnits() + "!A-1");
        super.renderDrag(g1, p1, p2);
        return new Rectangle[]{this.dirtyBounds, myDirtyBounds};
    }

    private void internalRender(Graphics2D g, Rectangle dirtyBounds, int x1, int x2, int y1, int y2) {
        double width;
        double d = width = this.horizontal ? (double)(x2 - x1) : (double)(y2 - y1);
        if (this.horizontal) {
            if (width > 6.0) {
                g.drawLine(x1 + 3, y2, x2 - 3, y2);
            }
            g.drawLine(x1, y2 + 2, x1, y2 - 2);
            g.drawLine(x2, y2 + 2, x2, y2 - 2);
            dirtyBounds.setRect(x1 - 2, y2 - 5, 4.0, 10.0);
        } else {
            if (width > 6.0) {
                g.drawLine(x2, y1 + 3, x2, y2 - 3);
            }
            g.drawLine(x2 + 2, y1, x2 - 2, y1);
            g.drawLine(x2 + 2, y2, x2 - 2, y2);
            dirtyBounds.setRect(x2 - 5, y1 - 2, 10.0, 4.0);
        }
        double rwidth = width / (double)this.ncycles;
        if (width > (double)(3 * this.ncycles)) {
            double ii;
            double start = this.horizontal ? (double)x2 + rwidth : (double)y2 + rwidth;
            int limit = this.horizontal ? this.axis.getColumn().getWidth() : this.axis.getRow().getHeight();
            for (ii = start; ii < (double)limit; ii += rwidth) {
                if (this.horizontal) {
                    g.drawLine((int)ii, y2 + 2, (int)ii, y2 - 2);
                    dirtyBounds.add((int)ii + 2, y2 - 5);
                    continue;
                }
                g.drawLine(x2 + 2, (int)ii, x2, (int)ii);
                dirtyBounds.add(x2 - 5, (int)ii + 2);
            }
            for (ii = start = this.horizontal ? (double)x2 - rwidth : (double)y2 - rwidth; ii > 0.0; ii -= rwidth) {
                if (this.horizontal) {
                    g.drawLine((int)ii, y2 + 2, (int)ii, y2 - 2);
                    dirtyBounds.add((int)ii - 2, y2 - 5);
                    continue;
                }
                g.drawLine(x2 + 2, (int)ii, x2, (int)ii);
                dirtyBounds.add(x2 - 5, (int)ii - 2);
            }
        }
    }

    public boolean isPointSelection() {
        return false;
    }

    public void clear(Graphics g) {
        this.parent.paintImmediately(this.dirtyBounds);
    }

    public boolean isUpdatingDragSelection() {
        return false;
    }

    public MouseDragEvent getMouseDragEvent(Object source, Point p1, Point p2, boolean isModified) {
        return null;
    }

    public void keyPressed(KeyEvent e) {
        int keyCode = e.getKeyCode();
        System.out.println(e);
        if (e.getKeyChar() == '1') {
            this.ncycles = 1;
        } else if (e.getKeyChar() == '2') {
            this.ncycles = 2;
        } else if (e.getKeyChar() == '3') {
            this.ncycles = 3;
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    private void fireChange(final double oldPeriod, final double newPeriod) {
        if (this.pcs != null) {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    FrequencyDragRenderer.this.pcs.firePropertyChange("period", new Double(oldPeriod), new Double(newPeriod));
                }
            });
        }
    }

    public void addPropertyChangeListener(String p, PropertyChangeListener l) {
        if (this.pcs == null) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(p, l);
    }

    public void removePropertyChangeListener(String p, PropertyChangeListener l) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(p, l);
        }
    }
}

