/*
 * Decompiled with CFR 0.152.
 */
package org.das2.event;

import java.awt.Point;
import java.util.EventObject;

public class DasSelectionEvent
extends EventObject {
    protected Point dot;
    protected Point mark;
    protected boolean isShiftDown;
    protected boolean clearSelection;
    protected Type selectionType;
    private Point selectionEnd;
    private Type selectionMode = Type.POINT_SELECTION;
    private Point selectionStart;

    public DasSelectionEvent(Object source, Type selectionType, boolean isShiftDown, Point dot, Point mark) {
        super(source);
        this.selectionType = selectionType;
        this.isShiftDown = isShiftDown;
        this.dot = new Point(dot);
        this.mark = new Point(mark);
        this.clearSelection = false;
    }

    public Point getDot() {
        return new Point(this.dot);
    }

    public Point getMark() {
        return new Point(this.mark);
    }

    public int getDotX() {
        return this.dot.x;
    }

    public int getDotY() {
        return this.dot.y;
    }

    public int getMarkX() {
        return this.mark.x;
    }

    public int getMarkY() {
        return this.mark.y;
    }

    public boolean isShiftDown() {
        return this.isShiftDown;
    }

    public boolean shouldClearSelection() {
        return this.clearSelection;
    }

    public void clearSelection() {
        this.clearSelection = true;
    }

    public Type getSelectionType() {
        return this.selectionType;
    }

    public static class Type {
        public static final Type AREA_SELECTION = new Type("AREA_SELECTION", false);
        public static final Type POINT_SELECTION = new Type("POINT_SELECTION", true);
        public static final Type VERTICAL_SLICE_SELECTION = new Type("VERTICAL_SLICE_SELECTION", true);
        public static final Type HORIZONTAL_SLICE_SELECTION = new Type("HORIZONTAL_SLICE_SELECTION", true);
        public static final Type VERTICAL_RANGE_SELECTION = new Type("VERTICAL_RANGE_SELECTION", false);
        public static final Type HORIZONTAL_RANGE_SELECTION = new Type("HORIZONTAL_RANGE_SELECTION", false);
        public static final Type NO_SELECTION = new Type("NO_SELECTION", false);
        private String type;
        private boolean single;

        private Type(String type, boolean single) {
            this.type = type;
            this.single = single;
        }

        public String toString() {
            return this.type;
        }

        public boolean isSingleSelection() {
            return this.single;
        }

        public boolean equals(Object o) {
            return this == o;
        }
    }
}

