/*
 * Decompiled with CFR 0.152.
 */
package org.das2.event;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import org.das2.DasProperties;
import org.das2.components.propertyeditor.Editable;
import org.das2.dataset.DataSet;
import org.das2.dataset.DataSetConsumer;
import org.das2.dataset.DataSetUtil;
import org.das2.dataset.TableDataSet;
import org.das2.dataset.TableDataSetConsumer;
import org.das2.dataset.TableUtil;
import org.das2.dataset.VectorDataSet;
import org.das2.datum.Datum;
import org.das2.datum.format.DatumFormatter;
import org.das2.datum.format.DefaultDatumFormatterFactory;
import org.das2.event.CrossHairMouseModule;
import org.das2.event.DragRenderer;
import org.das2.event.LabelDragRenderer;
import org.das2.graph.DasAxis;
import org.das2.graph.DasPlot;
import org.das2.graph.Renderer;

public class CrossHairRenderer
extends LabelDragRenderer
implements DragRenderer,
Editable {
    protected int xInitial;
    protected int yInitial;
    protected DasAxis XAxis;
    protected DasAxis YAxis;
    protected DasPlot parent;
    private int ix = 0;
    private int iy = 0;
    private int context;
    private DatumFormatter nfx;
    private DatumFormatter nfy;
    private DatumFormatter nfz;
    private FontMetrics fm;
    private int dxMax = -999999;
    private Rectangle hDirtyBounds;
    private Rectangle vDirtyBounds;
    private Point crossHairLocation = null;
    private DataSetConsumer dataSetConsumer;
    private List<CrossHairMouseModule.InfoItem> infoItems = new ArrayList<CrossHairMouseModule.InfoItem>();
    private boolean allPlanesReport;
    private boolean debugging;
    private boolean snapping;
    private boolean multiLine = false;

    public CrossHairRenderer(DasPlot parent, DataSetConsumer dataSetConsumer, DasAxis xAxis, DasAxis yAxis) {
        super(parent);
        this.XAxis = xAxis;
        this.YAxis = yAxis;
        this.parent = parent;
        this.dataSetConsumer = dataSetConsumer;
        this.hDirtyBounds = new Rectangle();
        this.vDirtyBounds = new Rectangle();
    }

    void addInfoItem(CrossHairMouseModule.InfoItem item) {
        this.infoItems.add(item);
    }

    void removeInfoItem(CrossHairMouseModule.InfoItem item) {
        this.infoItems.remove(item);
    }

    private DatumFormatter addResolutionToFormat(DatumFormatter nfz) throws ParseException {
        String[] ss;
        String formatString = nfz.toString();
        String result = formatString.indexOf(69) == -1 ? formatString + "00" : ((ss = formatString.split("E"))[0].indexOf(46) == -1 ? ss[0] + ".00" + "E0" : ss[0] + "00" + "E0");
        return DefaultDatumFormatterFactory.getInstance().newFormatter(result);
    }

    private String getZString(TableDataSet tds, Datum x, Datum y, int[] ij) {
        int i = DataSetUtil.closestColumn(tds, x);
        int j = TableUtil.closestRow(tds, tds.tableOfIndex(i), y);
        Datum zValue = tds.getDatum(i, j);
        if (ij != null) {
            ij[0] = i;
            ij[1] = j;
        }
        try {
            if (this.dataSetConsumer instanceof TableDataSetConsumer) {
                this.nfz = ((TableDataSetConsumer)this.dataSetConsumer).getZAxis().getDatumFormatter();
                this.nfz = this.addResolutionToFormat(this.nfz);
            } else {
                this.nfz = DefaultDatumFormatterFactory.getInstance().newFormatter("0.000");
            }
        }
        catch (ParseException pe) {
            DasProperties.getLogger().severe("failure to create formatter");
            DasAxis axis = ((TableDataSetConsumer)this.dataSetConsumer).getZAxis();
            axis.getUnits().getDatumFormatterFactory().defaultFormatter();
        }
        String result = zValue.isFill() ? "fill" : this.nfz.grannyFormat(zValue);
        if (this.allPlanesReport) {
            if (this.debugging) {
                result = result + "!c" + tds.toString();
            }
            String[] planeIds = tds.getPlaneIds();
            for (int iplane = 0; iplane < planeIds.length; ++iplane) {
                if (planeIds[iplane].equals("")) continue;
                result = result + "!c";
                result = result + planeIds[iplane] + ":" + this.nfz.grannyFormat(((TableDataSet)tds.getPlanarView(planeIds[iplane])).getDatum(i, j));
                if (!this.debugging) continue;
                result = result + " " + ((TableDataSet)tds.getPlanarView(planeIds[iplane])).toString();
            }
            if (this.debugging) {
                result = result + "!ci:" + i + " j:" + j;
            }
        }
        return result;
    }

    private int closestPointVector(VectorDataSet ds, Datum x, Datum y) {
        double x1;
        int i;
        int end;
        int start;
        Boolean xmono = (Boolean)ds.getProperty("xMonotonic");
        DasAxis xa = this.XAxis == null ? this.parent.getXAxis() : this.XAxis;
        DasAxis ya = this.YAxis == null ? this.parent.getYAxis() : this.YAxis;
        Point2D.Double me = new Point2D.Double(xa.transform(x), ya.transform(y));
        if (xmono != null && xmono.equals(Boolean.TRUE)) {
            start = DataSetUtil.getPreviousColumn(ds, xa.getDataMinimum());
            end = DataSetUtil.getNextColumn(ds, xa.getDataMaximum());
        } else {
            start = 0;
            end = ds.getXLength();
        }
        int bestIndex = -1;
        double bestXDist = Double.POSITIVE_INFINITY;
        double bestDist = Double.POSITIVE_INFINITY;
        int comparisons = 0;
        for (i = start; i < end; i += 100) {
            x1 = xa.transform(ds.getXTagDatum(i));
            double dist = Math.abs(x1 - me.getX());
            if (!(dist < bestXDist)) continue;
            bestXDist = dist;
        }
        for (i = start; i < end; ++i) {
            x1 = xa.transform(ds.getXTagDatum(i));
            if (!(Math.abs(x1 - me.getX()) <= bestXDist)) continue;
            Point2D.Double them = new Point2D.Double(x1, ya.transform(ds.getDatum(i)));
            double dist = me.distance(them);
            ++comparisons;
            if (!(dist < bestDist)) continue;
            bestIndex = i;
            bestDist = dist;
            bestXDist = Math.abs(x1 - me.getX());
        }
        return bestIndex;
    }

    public Rectangle[] renderDrag(Graphics g1, Point p1, Point p2) {
        DasAxis ya;
        Renderer[] rends;
        Graphics2D g = (Graphics2D)g1;
        g.setRenderingHints(DasProperties.getRenderingHints());
        DataSet ds = this.dataSetConsumer != null ? this.dataSetConsumer.getConsumedDataSet() : ((rends = this.parent.getRenderers()).length > 0 ? rends[0].getConsumedDataSet() : null);
        Object superDirty = null;
        Datum x = null;
        Datum y = null;
        DasAxis xa = this.XAxis == null ? this.parent.getXAxis() : this.XAxis;
        DasAxis dasAxis = ya = this.YAxis == null ? this.parent.getYAxis() : this.YAxis;
        if (this.crossHairLocation == null) {
            x = xa.invTransform(p2.x);
            y = ya.invTransform(p2.y);
            this.nfy = y.getFormatter();
            this.nfx = x.getFormatter();
            String xAsString = this.nfx.format(x);
            String yAsString = this.nfy.format(y);
            String nl = this.multiLine ? "!c" : " ";
            String report = "x:" + xAsString + nl + "y:" + yAsString;
            if (ds != null) {
                if (ds instanceof TableDataSet) {
                    String zAsString;
                    TableDataSet tds = (TableDataSet)ds;
                    if (tds != null && this.snapping) {
                        int[] ij = new int[2];
                        zAsString = this.getZString(tds, x, y, ij);
                        x = tds.getXTagDatum(ij[0]);
                        xAsString = this.nfx.format(x);
                        y = tds.getYTagDatum(tds.tableOfIndex(ij[0]), ij[1]);
                        yAsString = this.nfy.format(y);
                    } else {
                        zAsString = this.getZString(tds, x, y, null);
                    }
                    report = "x:" + xAsString + nl + "y:" + yAsString + nl + "z:" + zAsString;
                } else {
                    if (ds == null && this.dataSetConsumer instanceof DasPlot && ((DasPlot)this.dataSetConsumer).getRenderers().length > 0) {
                        ds = ((DasPlot)this.dataSetConsumer).getRenderer(0).getDataSet();
                    }
                    if (ds != null && this.snapping) {
                        VectorDataSet vds = (VectorDataSet)ds;
                        if (vds.getXLength() == 0) {
                            yAsString = "(empty dataset)";
                        } else {
                            int i = this.closestPointVector(vds, x, y);
                            x = vds.getXTagDatum(i);
                            y = vds.getDatum(i);
                            xAsString = this.nfx.format(x);
                            yAsString = this.nfy.format(y);
                            if (this.allPlanesReport) {
                                String result = yAsString;
                                String[] planeIds = vds.getPlaneIds();
                                for (int iplane = 0; iplane < planeIds.length; ++iplane) {
                                    if (planeIds[iplane].equals("")) continue;
                                    result = result + "!c";
                                    result = result + planeIds[iplane] + ":" + this.nfy.grannyFormat(((VectorDataSet)vds.getPlanarView(planeIds[iplane])).getDatum(i));
                                    if (!this.debugging) continue;
                                    result = result + " " + ((VectorDataSet)vds.getPlanarView(planeIds[iplane])).toString();
                                }
                                yAsString = result;
                            }
                        }
                    }
                    report = "x:" + xAsString + nl + "y:" + yAsString;
                }
            }
            StringBuilder builder = new StringBuilder(report);
            for (CrossHairMouseModule.InfoItem item : this.infoItems) {
                builder.append("!C");
                item.label(x, y, builder);
            }
            report = builder.toString();
            this.setLabel(report);
            super.renderDrag(g, p1, p2);
        }
        if (this.snapping && x != null && y != null) {
            Point p3 = new Point((int)xa.transform(x), (int)ya.transform(y));
            this.drawCrossHair(g, p3);
        } else {
            this.drawCrossHair(g, p2);
        }
        return new Rectangle[]{this.hDirtyBounds, this.vDirtyBounds, this.dirtyBounds};
    }

    private void drawCrossHair(Graphics g0, Point p) {
        Graphics2D g = (Graphics2D)g0.create();
        g.setClip(null);
        Color color0 = Color.black;
        g.setColor(color0);
        Dimension d = this.parent.getCanvas().getSize();
        this.hDirtyBounds.setBounds(0, p.y - 1, d.width, 3);
        Stroke stroke0 = g.getStroke();
        g.setColor(ghostColor);
        g.setStroke(new BasicStroke(3.0f));
        g.drawLine(0, p.y, d.width, p.y);
        g.drawLine(p.x, 0, p.x, d.height);
        g.setColor(color0);
        g.setStroke(stroke0);
        g.drawLine(0, p.y, d.width, p.y);
        this.vDirtyBounds.setBounds(p.x - 1, 0, 3, d.height);
        g.drawLine(p.x, 0, p.x, d.height);
        g.dispose();
    }

    public void clear(Graphics g) {
        super.clear(g);
        this.parent.paintImmediately(this.hDirtyBounds);
        this.parent.paintImmediately(this.vDirtyBounds);
    }

    public boolean isPointSelection() {
        return true;
    }

    public boolean isUpdatingDragSelection() {
        return false;
    }

    public boolean isAllPlanesReport() {
        return this.allPlanesReport;
    }

    public void setAllPlanesReport(boolean allPlanesReport) {
        this.allPlanesReport = allPlanesReport;
    }

    public boolean isDebugging() {
        return this.debugging;
    }

    public void setDebugging(boolean debugging) {
        this.debugging = debugging;
    }

    public Rectangle[] getDirtyBounds() {
        return new Rectangle[]{this.dirtyBounds, this.hDirtyBounds, this.vDirtyBounds};
    }

    public boolean isSnapping() {
        return this.snapping;
    }

    public void setSnapping(boolean b) {
        this.snapping = b;
    }

    public boolean isMultiLine() {
        return this.multiLine;
    }

    public void setMultiLine(boolean multiLine) {
        this.multiLine = multiLine;
    }
}

