/*
 * Decompiled with CFR 0.152.
 */
package org.das2.event;

import javax.swing.event.EventListenerList;
import org.das2.dataset.DataSet;
import org.das2.dataset.DataSetConsumer;
import org.das2.datum.Datum;
import org.das2.event.CrossHairRenderer;
import org.das2.event.DataPointSelectionEvent;
import org.das2.event.DataPointSelectionListener;
import org.das2.event.DragRenderer;
import org.das2.event.MouseModule;
import org.das2.event.MousePointSelectionEvent;
import org.das2.graph.DasAxis;
import org.das2.graph.DasPlot;
import org.das2.graph.Renderer;

public class CrossHairMouseModule
extends MouseModule {
    private DasAxis xaxis;
    private DasAxis yaxis;
    private DasPlot plot;
    protected DataPointSelectionEvent de;
    DataSetConsumer dataSetConsumer;
    private EventListenerList listenerList = null;

    public CrossHairMouseModule(DasPlot parent, DasAxis xaxis, DasAxis yaxis) {
        this(parent, parent, xaxis, yaxis);
    }

    public CrossHairMouseModule(DasPlot parent, DataSetConsumer dataSetConsumer, DasAxis xAxis, DasAxis yAxis) {
        super(parent, new CrossHairRenderer(parent, dataSetConsumer, xAxis, yAxis), "Crosshair Digitizer");
        this.plot = parent;
        this.dataSetConsumer = dataSetConsumer;
        this.xaxis = xAxis;
        this.yaxis = yAxis;
        this.de = new DataPointSelectionEvent(this, null, null);
    }

    public static CrossHairMouseModule create(DasPlot parent) {
        DasAxis xaxis = null;
        DasAxis yaxis = null;
        return new CrossHairMouseModule(parent, null, xaxis, yaxis);
    }

    public void addInfoItem(InfoItem i) {
        DragRenderer dr = this.getDragRenderer();
        if (dr instanceof CrossHairRenderer) {
            ((CrossHairRenderer)dr).addInfoItem(i);
        }
    }

    public void removeInfoItem(InfoItem i) {
        DragRenderer dr = this.getDragRenderer();
        if (dr instanceof CrossHairRenderer) {
            ((CrossHairRenderer)dr).removeInfoItem(i);
        }
    }

    private DataSet getContextDataSet() {
        Renderer[] rends;
        DataSet ds = this.dataSetConsumer != null ? this.dataSetConsumer.getConsumedDataSet() : ((rends = ((DasPlot)this.parent).getRenderers()).length > 0 ? rends[0].getConsumedDataSet() : null);
        return ds;
    }

    protected DataPointSelectionEvent getDataPointSelectionEvent(MousePointSelectionEvent e) {
        this.de.setDataSet(this.getContextDataSet());
        DasAxis xa = this.xaxis == null ? this.plot.getXAxis() : this.xaxis;
        DasAxis ya = this.yaxis == null ? this.plot.getYAxis() : this.yaxis;
        this.de.set(xa.invTransform(e.getX()), ya.invTransform(e.getY()));
        return this.de;
    }

    public void mousePointSelected(MousePointSelectionEvent e) {
        this.fireDataPointSelectionListenerDataPointSelected(this.getDataPointSelectionEvent(e));
    }

    public synchronized void addDataPointSelectionListener(DataPointSelectionListener listener) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(DataPointSelectionListener.class, listener);
    }

    public synchronized void removeDataPointSelectionListener(DataPointSelectionListener listener) {
        this.listenerList.remove(DataPointSelectionListener.class, listener);
    }

    protected void fireDataPointSelectionListenerDataPointSelected(DataPointSelectionEvent event) {
        if (this.listenerList == null) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != DataPointSelectionListener.class) continue;
            ((DataPointSelectionListener)listeners[i + 1]).dataPointSelected(event);
        }
    }

    public static abstract class InfoItem {
        public abstract void label(Datum var1, Datum var2, StringBuilder var3);

        public Datum[] snap(Datum x, Datum y) {
            return null;
        }
    }
}

