/*
 * Decompiled with CFR 0.152.
 */
package org.das2.event;

import java.awt.Container;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import org.das2.dataset.DataSetConsumer;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.datum.Units;
import org.das2.event.BoxRangeSelectorMouseModule;
import org.das2.event.BoxZoomDialog;
import org.das2.event.Gesture;
import org.das2.event.MouseBoxEvent;
import org.das2.event.MouseDragEvent;
import org.das2.graph.DasAxis;
import org.das2.graph.DasCanvasComponent;
import org.das2.graph.GraphUtil;

public class BoxZoomMouseModule
extends BoxRangeSelectorMouseModule {
    DatumRange xrange;
    DatumRange yrange;
    JDialog dialog;
    JLabel xrangeLabel;
    JLabel yrangeLabel;
    JCheckBox autoUpdateCB;
    JCheckBox constrainProportionsCB;
    BoxZoomDialog bzdialog;
    boolean autoUpdate = true;
    boolean constrainProportions = false;
    private boolean popupDisabled;

    public BoxZoomMouseModule(DasCanvasComponent parent, DataSetConsumer consumer, DasAxis xAxis, DasAxis yAxis) {
        super(parent, consumer, xAxis, yAxis);
        this.setLabel("Box Zoom");
    }

    JDialog getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog((Frame)null);
            this.dialog.setLocationRelativeTo(this.parent);
            Container content = this.dialog.getContentPane();
            this.bzdialog = new BoxZoomDialog(this);
            content.add(this.bzdialog);
            this.dialog.pack();
        }
        this.bzdialog.setAutoBoxZoom(this.autoUpdate);
        this.bzdialog.setDisablePopup(this.popupDisabled);
        this.bzdialog.setConstrainProportions(this.constrainProportions);
        if (!this.popupDisabled || !this.autoUpdate) {
            this.dialog.setVisible(true);
        }
        return this.dialog;
    }

    protected void guiChanged() {
        this.autoUpdate = this.bzdialog.isAutoBoxZoom();
        this.popupDisabled = this.bzdialog.isDisablePopup();
        this.constrainProportions = this.bzdialog.isConstrainProportions();
    }

    Action getZoomYAction() {
        return new AbstractAction("<html><center>z<br>o<br>o<br>m<br>Y</center></html>"){

            public void actionPerformed(ActionEvent e) {
                if (BoxZoomMouseModule.this.yrange != null) {
                    BoxZoomMouseModule.this.yAxis.setDatumRange(BoxZoomMouseModule.this.yrange);
                }
            }
        };
    }

    Action getZoomXAction() {
        return new AbstractAction("zoom X"){

            public void actionPerformed(ActionEvent e) {
                if (BoxZoomMouseModule.this.xrange != null) {
                    BoxZoomMouseModule.this.xAxis.setDatumRange(BoxZoomMouseModule.this.xrange);
                }
            }
        };
    }

    Action getZoomBoxAction() {
        return new AbstractAction("<html><center>Zoom<br>Box</center></html>"){

            public void actionPerformed(ActionEvent e) {
                BoxZoomMouseModule.this.zoomBox();
            }
        };
    }

    protected void zoomBox() {
        if (this.yrange != null) {
            this.yAxis.setDatumRange(this.yrange);
        }
        if (this.xrange != null) {
            this.xAxis.setDatumRange(this.xrange);
        }
    }

    public void mouseRangeSelected(MouseDragEvent e0) {
        if (e0 instanceof MouseBoxEvent) {
            MouseBoxEvent e = (MouseBoxEvent)e0;
            this.xrange = GraphUtil.invTransformRange(this.xAxis, e.getXMinimum(), e.getXMaximum());
            this.yrange = GraphUtil.invTransformRange(this.yAxis, e.getYMinimum(), e.getYMaximum());
            if (this.constrainProportions) {
                double aspect = (double)this.yAxis.getHeight() / (double)this.xAxis.getWidth();
                DatumRange mx = new DatumRange(e.getXMinimum(), e.getXMaximum(), Units.dimensionless);
                DatumRange my = new DatumRange(e.getYMinimum(), e.getYMaximum(), Units.dimensionless);
                double mouseAspect = my.width().divide(mx.width()).doubleValue(Units.dimensionless);
                if (mouseAspect > aspect) {
                    double f = mouseAspect / aspect;
                    mx = DatumRangeUtil.rescale(my, 0.5 - f / 2.0, 0.5 + f / 2.0);
                } else {
                    double f = aspect / mouseAspect;
                    my = DatumRangeUtil.rescale(my, 0.5 - f / 2.0, 0.5 + f / 2.0);
                }
                this.xrange = GraphUtil.invTransformRange(this.xAxis, mx.min().doubleValue(Units.dimensionless), mx.max().doubleValue(Units.dimensionless));
                this.yrange = GraphUtil.invTransformRange(this.yAxis, my.max().doubleValue(Units.dimensionless), my.min().doubleValue(Units.dimensionless));
            } else {
                this.xrange = GraphUtil.invTransformRange(this.xAxis, e.getXMinimum(), e.getXMaximum());
                this.yrange = GraphUtil.invTransformRange(this.yAxis, e.getYMaximum(), e.getYMinimum());
            }
            if (!this.autoUpdate) {
                this.getDialog();
                this.bzdialog.setXRange(this.xrange.toString());
                this.bzdialog.setYRange(this.yrange.toString());
            } else {
                this.zoomBox();
            }
        } else if (e0.isGesture()) {
            if (e0.getGesture() == Gesture.ZOOMOUT) {
                this.xAxis.setDataRangeZoomOut();
                this.yAxis.setDataRangeZoomOut();
            } else if (e0.getGesture() == Gesture.BACK) {
                this.xAxis.setDataRangePrev();
                this.yAxis.setDataRangePrev();
            } else if (e0.getGesture() == Gesture.FORWARD) {
                this.xAxis.setDataRangeForward();
                this.yAxis.setDataRangeForward();
            }
        }
    }

    public boolean isAutoUpdate() {
        return this.autoUpdate;
    }

    public void setAutoUpdate(boolean autoUpdate) {
        if (this.bzdialog != null) {
            this.bzdialog.setAutoBoxZoom(autoUpdate);
        }
        this.autoUpdate = autoUpdate;
    }

    public boolean isConstrainProportions() {
        return this.constrainProportions;
    }

    public void setConstrainProportions(boolean constrainProportions) {
        if (this.bzdialog != null) {
            this.bzdialog.setConstrainProportions(constrainProportions);
        }
        this.constrainProportions = constrainProportions;
    }

    public boolean isPopupDisabled() {
        return this.popupDisabled;
    }

    public void setPopupDisabled(boolean popupDisabled) {
        if (this.bzdialog != null) {
            this.bzdialog.setDisablePopup(popupDisabled);
        }
        this.popupDisabled = popupDisabled;
    }
}

