/*
 * Decompiled with CFR 0.152.
 */
package org.das2.event;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import javax.swing.event.EventListenerList;
import org.das2.dataset.DataSetConsumer;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.event.BoxRenderer;
import org.das2.event.BoxSelectionEvent;
import org.das2.event.BoxSelectionListener;
import org.das2.event.DragRenderer;
import org.das2.event.MouseBoxEvent;
import org.das2.event.MouseDragEvent;
import org.das2.event.MouseModule;
import org.das2.graph.DasAxis;
import org.das2.graph.DasCanvasComponent;
import org.das2.graph.DasPlot;

public class BoxSelectorMouseModule
extends MouseModule {
    DasAxis xaxis;
    DasAxis yaxis;
    DataSetConsumer dataSetConsumer;
    EventListenerList listenerList = null;
    MouseDragEvent lastMouseEvent;
    boolean tweakable = false;
    BoxSelectionEvent lastSelectionEvent = null;
    private boolean dragEvents = false;
    private boolean keyEvents = false;
    private boolean releaseEvents = true;

    public static BoxSelectorMouseModule create(DasPlot parent, String label) {
        return new BoxSelectorMouseModule(parent, parent.getXAxis(), parent.getYAxis(), null, new BoxRenderer(parent), label);
    }

    public BoxSelectorMouseModule(DasCanvasComponent parent, DasAxis xAxis, DasAxis yAxis, DataSetConsumer consumer, DragRenderer dragRenderer, String label) {
        super(parent, dragRenderer, label);
        this.xaxis = xAxis;
        this.yaxis = yAxis;
        this.dataSetConsumer = consumer;
    }

    public void setTweakable(boolean b) {
        this.tweakable = b;
    }

    private Datum[] checkTweak(Point p) {
        double nx = DatumRangeUtil.normalize(this.lastSelectionEvent.getXRange(), this.xaxis.invTransform(p.getX()));
        double ny = DatumRangeUtil.normalize(this.lastSelectionEvent.getYRange(), this.yaxis.invTransform(p.getY()));
        System.err.println("" + nx + " " + ny);
        Datum otherx = null;
        Datum othery = null;
        if (nx >= 0.0 && nx < 0.1) {
            otherx = this.lastSelectionEvent.getXRange().max();
        } else if (nx > 0.9 && nx < 1.0) {
            otherx = this.lastSelectionEvent.getXRange().min();
        }
        if (ny >= 0.0 && ny < 0.1) {
            othery = this.lastSelectionEvent.getYRange().max();
        } else if (ny > 0.9 && ny < 1.0) {
            othery = this.lastSelectionEvent.getYRange().min();
        }
        Datum[] otherCorner = new Datum[]{otherx, othery};
        return otherCorner;
    }

    public void mousePressed(MouseEvent e) {
        if (this.tweakable && this.lastSelectionEvent != null) {
            Point p = new Point(e.getPoint());
            p.translate(e.getComponent().getX(), e.getComponent().getY());
            Datum[] otherCorner = this.checkTweak(p);
            if (otherCorner[0] != null && otherCorner[1] != null) {
                double p1x = this.xaxis.transform(otherCorner[0]);
                double p2x = this.yaxis.transform(otherCorner[1]);
                Point p1 = new Point((int)p1x, (int)p2x);
                ((BoxRenderer)this.dragRenderer).setDragStart(p1);
            } else {
                ((BoxRenderer)this.dragRenderer).setDragStart(null);
            }
        }
    }

    public void mouseMoved(MouseEvent e) {
        Cursor c = null;
        if (this.tweakable && this.lastSelectionEvent != null) {
            Point p = new Point(e.getPoint());
            p.translate(e.getComponent().getX(), e.getComponent().getY());
            Datum[] otherCorner = this.checkTweak(p);
            if (otherCorner[0] != null && otherCorner[1] != null) {
                c = new Cursor(13);
            }
        }
        this.parent.getCanvas().setCursor(c);
    }

    private BoxSelectionEvent getBoxSelectionEvent(MouseDragEvent mde) {
        Datum t;
        Datum max;
        Datum min;
        MouseBoxEvent e = (MouseBoxEvent)mde;
        DatumRange xrange = null;
        DatumRange yrange = null;
        Datum x = null;
        Datum y = null;
        Datum sx = null;
        Datum sy = null;
        if (this.xaxis != null) {
            min = this.xaxis.invTransform(e.getXMinimum());
            if (min.gt(max = this.xaxis.invTransform(e.getXMaximum()))) {
                t = min;
                min = max;
                max = t;
            }
            xrange = new DatumRange(min, max);
            x = this.xaxis.invTransform(e.getPoint().x);
            sx = this.xaxis.invTransform(e.getPressPoint().x);
        }
        if (this.yaxis != null) {
            min = this.yaxis.invTransform(e.getYMinimum());
            if (min.gt(max = this.yaxis.invTransform(e.getYMaximum()))) {
                t = min;
                min = max;
                max = t;
            }
            yrange = new DatumRange(min, max);
            y = this.yaxis.invTransform(e.getPoint().y);
            sy = this.yaxis.invTransform(e.getPressPoint().y);
        }
        BoxSelectionEvent evt = new BoxSelectionEvent(this, xrange, yrange);
        evt.setStart(sx, sy);
        evt.setFinish(x, y);
        this.lastSelectionEvent = evt;
        return evt;
    }

    public void mouseRangeSelected(MouseDragEvent e) {
        this.lastMouseEvent = e;
        if (this.keyEvents) {
            this.parent.requestFocus();
        }
        if (this.dragEvents) {
            this.fireBoxSelectionListenerBoxSelected(this.getBoxSelectionEvent(e));
        }
    }

    public void keyPressed(KeyEvent e) {
        int keyCode = e.getKeyCode();
        if (this.lastMouseEvent != null) {
            BoxSelectionEvent dpse = this.getBoxSelectionEvent(this.lastMouseEvent);
            HashMap<String, String> planes = new HashMap<String, String>();
            planes.put("keyChar", String.valueOf(e.getKeyChar()));
            dpse = new BoxSelectionEvent(this, dpse.getXRange(), dpse.getYRange(), planes);
            this.fireBoxSelectionListenerBoxSelected(dpse);
        }
    }

    public synchronized void addBoxSelectionListener(BoxSelectionListener listener) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(BoxSelectionListener.class, listener);
    }

    public synchronized void removeBoxSelectionListener(BoxSelectionListener listener) {
        this.listenerList.remove(BoxSelectionListener.class, listener);
    }

    protected void fireBoxSelectionListenerBoxSelected(BoxSelectionEvent event) {
        if (this.listenerList == null) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != BoxSelectionListener.class) continue;
            ((BoxSelectionListener)listeners[i + 1]).BoxSelected(event);
        }
    }

    public boolean isDragEvents() {
        return this.dragEvents;
    }

    public void setDragEvents(boolean dragEvents) {
        this.dragEvents = dragEvents;
    }

    public boolean isKeyEvents() {
        return this.keyEvents;
    }

    public void setKeyEvents(boolean keyEvents) {
        this.keyEvents = keyEvents;
    }

    public void mouseReleased(MouseEvent e) {
        super.mouseReleased(e);
        if (this.releaseEvents) {
            this.fireBoxSelectionListenerBoxSelected(this.getBoxSelectionEvent(this.lastMouseEvent));
        }
    }

    public boolean isReleaseEvents() {
        return this.releaseEvents;
    }

    public void setReleaseEvents(boolean releaseEvents) {
        this.releaseEvents = releaseEvents;
    }
}

