/*
 * Decompiled with CFR 0.152.
 */
package org.das2.event;

import java.util.HashMap;
import org.das2.dataset.DataSet;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.event.DasEvent;

public class BoxSelectionEvent
extends DasEvent {
    private DatumRange xrange;
    private DatumRange yrange;
    private Datum finishx;
    private Datum finishy;
    private Datum startx;
    private Datum starty;
    private DataSet ds;
    private HashMap planes;

    public BoxSelectionEvent(Object source, Datum xMin, Datum xMax, Datum yMin, Datum yMax) {
        this(source, xMin.le(xMax) ? new DatumRange(xMin, xMax) : new DatumRange(xMax, xMin), yMin.le(yMax) ? new DatumRange(yMin, yMax) : new DatumRange(yMax, yMin));
    }

    public BoxSelectionEvent(Object source, DatumRange xrange, DatumRange yrange) {
        this(source, xrange, yrange, null);
    }

    public BoxSelectionEvent(Object source, DatumRange xrange, DatumRange yrange, HashMap planes) {
        super(source);
        this.xrange = xrange;
        this.yrange = yrange;
        this.planes = planes;
    }

    public void setFinish(Datum x, Datum y) {
        this.finishx = x;
        this.finishy = y;
    }

    public Datum getFinishX() {
        return this.finishx;
    }

    public Datum getFinishY() {
        return this.finishy;
    }

    public void setStart(Datum x, Datum y) {
        this.startx = x;
        this.starty = y;
    }

    public Datum getStartX() {
        return this.startx;
    }

    public Datum getStartY() {
        return this.starty;
    }

    public Datum getXMinimum() {
        if (this.xrange != null) {
            return this.xrange.min();
        }
        return null;
    }

    public Datum getXMaximum() {
        if (this.xrange != null) {
            return this.xrange.max();
        }
        return null;
    }

    public Datum getYMinimum() {
        if (this.yrange != null) {
            return this.yrange.min();
        }
        return null;
    }

    public Datum getYMaximum() {
        if (this.yrange != null) {
            return this.yrange.max();
        }
        return null;
    }

    public DatumRange getXRange() {
        return this.xrange;
    }

    public DatumRange getYRange() {
        return this.yrange;
    }

    public Object getPlane(String plane) {
        return this.planes == null ? null : this.planes.get(plane);
    }

    public String[] getPlaneIds() {
        if (this.planes == null) {
            return new String[0];
        }
        return this.planes.keySet().toArray(new String[this.planes.keySet().size()]);
    }

    public void setDataSet(DataSet ds) {
        this.ds = ds;
    }

    public DataSet getDataSet() {
        return this.ds;
    }

    public String toString() {
        return "[BoxSelectionEvent x: " + this.xrange + ", y: " + this.yrange + "]";
    }
}

