/*
 * Decompiled with CFR 0.152.
 */
package org.das2.event;

import javax.swing.event.EventListenerList;
import org.das2.dataset.DataSetConsumer;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.event.BoxGesturesRenderer;
import org.das2.event.BoxSelectionEvent;
import org.das2.event.BoxSelectionListener;
import org.das2.event.MouseBoxEvent;
import org.das2.event.MouseDragEvent;
import org.das2.event.MouseModule;
import org.das2.graph.DasAxis;
import org.das2.graph.DasCanvasComponent;
import org.das2.graph.DasPlot;

public class BoxRangeSelectorMouseModule
extends MouseModule {
    protected DasAxis xAxis;
    protected DasAxis yAxis;
    private DataSetConsumer consumer;
    private EventListenerList listenerList = new EventListenerList();

    public BoxRangeSelectorMouseModule(DasCanvasComponent parent, DataSetConsumer consumer, DasAxis xAxis, DasAxis yAxis) {
        super(parent, new BoxGesturesRenderer(parent), "Box Selection");
        if (!xAxis.isHorizontal()) {
            throw new IllegalArgumentException("X Axis orientation is not horizontal");
        }
        if (yAxis.isHorizontal()) {
            throw new IllegalArgumentException("Y Axis orientation is not vertical");
        }
        this.xAxis = xAxis;
        this.yAxis = yAxis;
        this.consumer = consumer;
    }

    public static BoxRangeSelectorMouseModule create(DasPlot parent) {
        BoxRangeSelectorMouseModule result = new BoxRangeSelectorMouseModule(parent, null, parent.getXAxis(), parent.getYAxis());
        return result;
    }

    public void mouseRangeSelected(MouseDragEvent e0) {
        if (e0 instanceof MouseBoxEvent) {
            MouseBoxEvent e = (MouseBoxEvent)e0;
            Datum xMin = this.xAxis.invTransform(e.getXMinimum());
            Datum xMax = this.xAxis.invTransform(e.getXMaximum());
            Datum yMin = this.yAxis.invTransform(e.getYMaximum());
            Datum yMax = this.yAxis.invTransform(e.getYMinimum());
            BoxSelectionEvent evt = new BoxSelectionEvent(this, new DatumRange(xMin, xMax), new DatumRange(yMin, yMax));
            if (this.consumer != null) {
                evt.setDataSet(this.consumer.getConsumedDataSet());
            }
            this.fireBoxSelected(evt);
        }
    }

    public void addBoxSelectionListener(BoxSelectionListener listener) {
        this.listenerList.add(BoxSelectionListener.class, listener);
    }

    public void removeBoxSelectionListener(BoxSelectionListener listener) {
        this.listenerList.remove(BoxSelectionListener.class, listener);
    }

    protected void fireBoxSelected(BoxSelectionEvent event) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != BoxSelectionListener.class) continue;
            ((BoxSelectionListener)listeners[i + 1]).BoxSelected(event);
        }
    }
}

