/*
 * Decompiled with CFR 0.152.
 */
package org.das2.event;

import javax.swing.event.EventListenerList;
import org.das2.dataset.DataSetConsumer;
import org.das2.dataset.TableDataSetConsumer;
import org.das2.event.AngleSelectionDragRenderer;
import org.das2.event.DataPointSelectionEvent;
import org.das2.event.MouseBoxEvent;
import org.das2.event.MouseDragEvent;
import org.das2.event.MouseModule;
import org.das2.graph.DasAxis;
import org.das2.graph.DasPlot;
import org.das2.graph.Renderer;

public class AngleSlicerMouseModule
extends MouseModule {
    private DasAxis xaxis;
    private DasAxis yaxis;
    private TableDataSetConsumer dataSetConsumer;
    private DataPointSelectionEvent de;
    private EventListenerList listenerList = null;

    public AngleSlicerMouseModule(DasPlot parent, TableDataSetConsumer dataSetConsumer, DasAxis xaxis, DasAxis yaxis) {
        this(parent, (DataSetConsumer)dataSetConsumer, xaxis, yaxis);
    }

    protected AngleSlicerMouseModule(DasPlot parent, DataSetConsumer dataSetConsumer, DasAxis xaxis, DasAxis yaxis) {
        super(parent, new AngleSelectionDragRenderer(), "Angle Slice");
        if (!(dataSetConsumer instanceof TableDataSetConsumer)) {
            throw new IllegalArgumentException("dataSetConsumer must be an XTaggedYScanDataSetConsumer");
        }
        this.dataSetConsumer = (TableDataSetConsumer)dataSetConsumer;
        this.xaxis = xaxis;
        this.yaxis = yaxis;
        this.de = new DataPointSelectionEvent(this, null, null);
    }

    public static AngleSlicerMouseModule create(DasPlot parent) {
        DasAxis xaxis = parent.getXAxis();
        DasAxis yaxis = parent.getYAxis();
        return new AngleSlicerMouseModule(parent, parent, xaxis, yaxis);
    }

    public static AngleSlicerMouseModule create(Renderer renderer) {
        DasPlot parent = renderer.getParent();
        DasAxis xaxis = parent.getXAxis();
        DasAxis yaxis = parent.getYAxis();
        return new AngleSlicerMouseModule(parent, renderer, xaxis, yaxis);
    }

    public void mouseRangeSelected(MouseDragEvent e0) {
        MouseBoxEvent e = (MouseBoxEvent)e0;
    }
}

