/*
 * Decompiled with CFR 0.152.
 */
package org.das2.datum.swing;

import java.text.ParseException;
import javax.swing.JFormattedTextField;
import org.das2.datum.Datum;
import org.das2.datum.Units;
import org.das2.datum.format.DatumFormatter;
import org.das2.datum.format.DefaultDatumFormatterFactory;

public class DatumJFormatterFactory
extends JFormattedTextField.AbstractFormatterFactory {
    DatumFormatter format;
    SwingFormatter wrapper;
    Units units;
    Units implicitUnits = Units.dimensionless;

    public DatumJFormatterFactory() {
        this(DefaultDatumFormatterFactory.getInstance().defaultFormatter());
    }

    public DatumJFormatterFactory(DatumFormatter format) {
        this.format = format;
        this.wrapper = new SwingFormatter();
    }

    public void explicitUnits(Units u) {
        this.units = u;
    }

    public JFormattedTextField.AbstractFormatter getFormatter(JFormattedTextField tf) {
        return this.wrapper;
    }

    private class SwingFormatter
    extends JFormattedTextField.AbstractFormatter {
        private SwingFormatter() {
        }

        public Object stringToValue(String text) throws ParseException {
            Units u = DatumJFormatterFactory.this.units != null ? DatumJFormatterFactory.this.units : DatumJFormatterFactory.this.implicitUnits;
            return u.parse(text);
        }

        public String valueToString(Object value) throws ParseException {
            Datum datum = (Datum)value;
            if (datum == null) {
                throw new ParseException("Null values not allowed.", -1);
            }
            DatumJFormatterFactory.this.implicitUnits = datum.getUnits();
            if (DatumJFormatterFactory.this.units != null) {
                return DatumJFormatterFactory.this.format.format(datum, DatumJFormatterFactory.this.units);
            }
            return DatumJFormatterFactory.this.format.format(datum);
        }
    }
}

