/*
 * Decompiled with CFR 0.152.
 */
package org.das2.datum.format;

import java.text.Format;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.TimeUtil;
import org.das2.datum.format.DatumFormatter;

public class TimeDatumFormatter
extends DatumFormatter {
    private static final int YEAR_FIELD_INDEX = 0;
    private static final int MONTH_FIELD_INDEX = 1;
    private static final int DAY_FIELD_INDEX = 2;
    private static final int DOY_FIELD_INDEX = 3;
    private static final int HOUR_FIELD_INDEX = 4;
    private static final int MINUTE_FIELD_INDEX = 5;
    private static final int SECONDS_FIELD_INDEX = 6;
    private static final int TIMESTAMP_FIELD_COUNT = 7;
    public static final TimeDatumFormatter DEFAULT;
    public static final TimeDatumFormatter DAYS;
    public static final TimeDatumFormatter YEARS;
    public static final TimeDatumFormatter MONTHS;
    public static final TimeDatumFormatter HOURS;
    public static final TimeDatumFormatter MINUTES;
    public static final TimeDatumFormatter SECONDS;
    public static final TimeDatumFormatter MILLISECONDS;
    public static final TimeDatumFormatter MICROSECONDS;
    public static final TimeDatumFormatter NANOSECONDS;
    private String formatString;
    private MessageFormat format;
    private int[] scaleSeconds;

    public TimeDatumFormatter(String formatString) throws ParseException {
        this.formatString = formatString;
        this.format = formatString.contains("%") ? new MessageFormat(this.parseTimeFormatStringPercent(formatString)) : new MessageFormat(this.parseTimeFormatString(formatString));
    }

    public static TimeDatumFormatter formatterForScale(int scale, DatumRange context) {
        try {
            if (context != null) {
                switch (scale) {
                    case 1: {
                        return YEARS;
                    }
                    case 2: {
                        return MONTHS;
                    }
                    case 3: {
                        return DAYS;
                    }
                    case 4: {
                        return MINUTES;
                    }
                    case 5: {
                        return MINUTES;
                    }
                    case 6: {
                        return SECONDS;
                    }
                    case 7: {
                        return MILLISECONDS;
                    }
                    case 8: {
                        return MICROSECONDS;
                    }
                    case 9: {
                        return NANOSECONDS;
                    }
                }
                throw new IllegalArgumentException("unsupported scale: " + scale);
            }
            switch (scale) {
                case 1: {
                    return YEARS;
                }
                case 2: {
                    return MONTHS;
                }
                case 3: {
                    return DAYS;
                }
                case 4: {
                    return HOURS;
                }
                case 5: {
                    return new TimeDatumFormatter("yyyy-MM-dd HH:mm");
                }
                case 6: {
                    return new TimeDatumFormatter("yyyy-MM-dd HH:mm:ss");
                }
                case 7: {
                    return new TimeDatumFormatter("yyyy-MM-dd HH:mm:ss.SSS");
                }
                case 8: {
                    return new TimeDatumFormatter("yyyy-MM-dd HH:mm:ss.SSSSSS");
                }
                case 9: {
                    return new TimeDatumFormatter("yyyy-MM-dd HH:mm:ss.SSSSSSSSS");
                }
            }
            throw new IllegalArgumentException("unsupported scale: " + scale);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return this.formatString;
    }

    public String format(Datum datum) {
        if (datum.isFill()) {
            return "fill";
        }
        TimeUtil.TimeStruct ts = TimeUtil.toTimeStruct(datum);
        Number[] array = this.timeStructToArray(ts);
        return this.format.format(array);
    }

    protected Format getFormat() {
        return this.format;
    }

    protected String parseTimeFormatString(String input) throws ParseException {
        String formatPattern = "(([yMDdHmsS])\\2*)";
        String delimiterPattern = "([-/:.,_ \t]+)";
        String literalPattern = "('(?:[^']|'')*')";
        Pattern token = Pattern.compile("(([yMDdHmsS])\\2*)|([-/:.,_ \t]+)|('(?:[^']|'')*')");
        int from = 0;
        StringBuffer formatString = new StringBuffer();
        Matcher matcher = token.matcher(input);
        while (matcher.find(from)) {
            int start = matcher.start();
            if (start > from) {
                char[] dots = new char[start + 1];
                Arrays.fill(dots, from, start, '.');
                dots[from] = 94;
                dots[start] = 94;
                StringBuffer errorString = new StringBuffer("Unrecognized sub-pattern\n");
                errorString.append(input).append("\n");
                errorString.append(dots);
                throw new ParseException(errorString.toString(), from);
            }
            String format = matcher.group(1);
            String delimiter = matcher.group(3);
            String literal = matcher.group(4);
            if (format != null) {
                switch (format.charAt(0)) {
                    case 'y': {
                        TimeDatumFormatter.appendSubFormat(formatString, 0, format.length());
                        break;
                    }
                    case 'M': {
                        TimeDatumFormatter.appendSubFormat(formatString, 1, format.length());
                        break;
                    }
                    case 'D': {
                        TimeDatumFormatter.appendSubFormat(formatString, 3, format.length());
                        break;
                    }
                    case 'd': {
                        TimeDatumFormatter.appendSubFormat(formatString, 2, format.length());
                        break;
                    }
                    case 'H': {
                        TimeDatumFormatter.appendSubFormat(formatString, 4, format.length());
                        break;
                    }
                    case 'm': {
                        TimeDatumFormatter.appendSubFormat(formatString, 5, format.length());
                        break;
                    }
                    case 's': {
                        TimeDatumFormatter.appendSubFormat(formatString, 6, format.length());
                        break;
                    }
                    case 'S': {
                        int digitCount = format.length();
                        int fieldIndex = this.addScaleFactor(digitCount);
                        TimeDatumFormatter.appendSubFormat(formatString, fieldIndex, digitCount);
                        break;
                    }
                }
            } else if (delimiter != null) {
                formatString.append(delimiter);
            } else if (literal != null) {
                literal = literal.substring(1, literal.length() - 1);
                literal = literal.replaceAll("''", "'");
                formatString.append(literal);
            }
            from = matcher.end();
        }
        return formatString.toString();
    }

    protected String parseTimeFormatStringPercent(String format) throws ParseException {
        StringBuffer formatString = new StringBuffer();
        String[] ss = format.split("%");
        formatString.append(ss[0]);
        int offset = ss[0].length();
        for (int i = 1; i < ss.length; ++i) {
            ++offset;
            char c = ss[i].charAt(0);
            switch (c) {
                case 'Y': {
                    TimeDatumFormatter.appendSubFormat(formatString, 0, 4);
                    break;
                }
                case 'y': {
                    TimeDatumFormatter.appendSubFormat(formatString, 0, 2);
                    break;
                }
                case 'j': {
                    TimeDatumFormatter.appendSubFormat(formatString, 3, 3);
                    break;
                }
                case 'm': {
                    TimeDatumFormatter.appendSubFormat(formatString, 1, 2);
                    break;
                }
                case 'd': {
                    TimeDatumFormatter.appendSubFormat(formatString, 2, 2);
                    break;
                }
                case 'H': {
                    TimeDatumFormatter.appendSubFormat(formatString, 4, 2);
                    break;
                }
                case 'M': {
                    TimeDatumFormatter.appendSubFormat(formatString, 5, 2);
                    break;
                }
                case 'S': {
                    TimeDatumFormatter.appendSubFormat(formatString, 6, 2);
                    break;
                }
                case '{': {
                    int i1 = ss[i].indexOf(125);
                    String spec = ss[i].substring(1, i1);
                    if (spec.equals("milli")) {
                        int digitCount = 3;
                        int fieldIndex = this.addScaleFactor(digitCount);
                        TimeDatumFormatter.appendSubFormat(formatString, fieldIndex, digitCount);
                        ss[i] = ss[i].substring(i1);
                        break;
                    }
                    throw new ParseException("bad format code: {" + spec + "}", offset);
                }
                default: {
                    throw new ParseException("bad format code: " + c, offset);
                }
            }
            formatString.append(ss[i].substring(1));
            offset += ss[i].length();
        }
        return formatString.toString();
    }

    private static void appendSubFormat(StringBuffer buffer, int fieldIndex, int count) {
        buffer.append("{").append(fieldIndex).append(",number,");
        for (int i = 0; i < count; ++i) {
            buffer.append('0');
        }
        buffer.append("}");
    }

    private int addScaleFactor(int scale) {
        if (this.scaleSeconds == null) {
            this.scaleSeconds = new int[1];
        } else {
            int[] temp = new int[this.scaleSeconds.length + 1];
            System.arraycopy(this.scaleSeconds, 0, temp, 0, this.scaleSeconds.length);
            this.scaleSeconds = temp;
        }
        this.scaleSeconds[this.scaleSeconds.length - 1] = scale;
        return 7 + this.scaleSeconds.length - 1;
    }

    private Number[] timeStructToArray(TimeUtil.TimeStruct ts) {
        int secondsFieldCount = this.scaleSeconds == null ? 0 : this.scaleSeconds.length;
        int maxScale = this.scaleSeconds == null ? 10 : (int)Math.pow(10.0, TimeDatumFormatter.max(this.scaleSeconds));
        int fieldCount = 7 + secondsFieldCount;
        Number[] array = new Number[fieldCount];
        int seconds = (int)Math.round(ts.seconds * (double)maxScale) / maxScale;
        double fracSeconds = ts.seconds - (double)seconds;
        ts.seconds = seconds;
        ts.micros = (int)(fracSeconds * 1000000.0);
        TimeUtil.carry(ts);
        array[0] = new Integer(ts.year);
        array[1] = new Integer(ts.month);
        array[2] = new Integer(ts.day);
        array[3] = new Integer(ts.doy);
        array[4] = new Integer(ts.hour);
        array[5] = new Integer(ts.minute);
        array[6] = new Integer((int)ts.seconds);
        for (int i = 7; i < array.length; ++i) {
            int value = (int)Math.round(fracSeconds * Math.pow(10.0, this.scaleSeconds[i - 7]));
            array[i] = new Integer(value);
        }
        return array;
    }

    private static int max(int[] list) {
        int max = Integer.MIN_VALUE;
        for (int i = 0; i < list.length; ++i) {
            max = Math.max(max, list[i]);
        }
        return max;
    }

    static {
        try {
            DEFAULT = new TimeDatumFormatter("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
            YEARS = new TimeDatumFormatter("yyyy");
            MONTHS = new TimeDatumFormatter("yyyy-MM");
            DAYS = new TimeDatumFormatter("yyyy-MM-dd");
            HOURS = new TimeDatumFormatter("yyyy-MM-dd HH:'00'");
            MINUTES = new TimeDatumFormatter("HH:mm");
            SECONDS = new TimeDatumFormatter("HH:mm:ss");
            MILLISECONDS = new TimeDatumFormatter("HH:mm:ss.SSS");
            MICROSECONDS = new TimeDatumFormatter("HH:mm:ss.SSSSSS");
            NANOSECONDS = new TimeDatumFormatter("HH:mm:ss.SSSSSSSSS");
        }
        catch (ParseException pe) {
            throw new RuntimeException(pe);
        }
    }
}

