/*
 * Decompiled with CFR 0.152.
 */
package org.das2.datum.format;

import java.text.DecimalFormat;
import org.das2.datum.Datum;
import org.das2.datum.Units;
import org.das2.datum.format.DatumFormatter;
import org.das2.util.DasMath;
import org.das2.util.NumberFormatUtil;

public class LatinPrefixDatumFormatter
extends DatumFormatter {
    private DecimalFormat format;
    int digits;
    int exponent;

    public LatinPrefixDatumFormatter(int digits) {
        this.digits = digits;
    }

    public String format(Datum datum) {
        return this.format(datum, datum.getUnits()) + " " + datum.getUnits();
    }

    public String format(Datum datum, Units units) {
        String expString;
        double x = datum.doubleValue(units);
        if (x == 0.0) {
            return "0.";
        }
        int exponent = (int)DasMath.log10(1.000001 * Math.abs(x)) / 3 * 3;
        switch (exponent) {
            case -18: {
                expString = "a";
                break;
            }
            case -15: {
                expString = "f";
                break;
            }
            case -12: {
                expString = "p";
                break;
            }
            case -9: {
                expString = "n";
                break;
            }
            case -6: {
                expString = "\u03bc";
                break;
            }
            case -3: {
                expString = "m";
                break;
            }
            case 0: {
                expString = "";
                break;
            }
            case 3: {
                expString = "k";
                break;
            }
            case 6: {
                expString = "M";
                break;
            }
            case 9: {
                expString = "G";
                break;
            }
            case 12: {
                expString = "T";
                break;
            }
            default: {
                expString = "";
                exponent = 0;
            }
        }
        int sign = x < 0.0 ? -1 : 1;
        double exp = DasMath.exp10(exponent);
        double mant = x / exp;
        int mantFracDigits = this.digits - (int)DasMath.log10(mant);
        StringBuffer buff = new StringBuffer(this.digits + 2).append("0");
        if (this.digits > 1) {
            buff.append('.');
        }
        for (int i = 0; i < mantFracDigits; ++i) {
            buff.append('0');
        }
        String mantFormatString = buff.toString();
        DecimalFormat mantFormat = NumberFormatUtil.getDecimalFormat(buff.toString());
        return mantFormat.format(mant) + expString;
    }

    public String toString() {
        return "EngineeringFormatter(" + this.digits + " sig fig)";
    }
}

