/*
 * Decompiled with CFR 0.152.
 */
package org.das2.datum.format;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumVector;
import org.das2.datum.Units;
import org.das2.datum.format.DatumFormatter;
import org.das2.util.DasMath;
import org.das2.util.NumberFormatUtil;

public class DefaultDatumFormatter
extends DatumFormatter {
    private String formatString;
    private NumberFormat format;

    protected DefaultDatumFormatter() {
    }

    public DefaultDatumFormatter(String formatString) throws ParseException {
        if (formatString.equals("")) {
            this.formatString = "";
            this.format = null;
        } else {
            this.formatString = formatString;
            this.format = NumberFormatUtil.getDecimalFormat(formatString);
        }
    }

    public String format(Datum datum) {
        return this.format(datum, datum.getUnits()) + " " + datum.getUnits();
    }

    public String format(Datum datum, Units units) {
        String result;
        double d = datum.doubleValue(units);
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            return "" + d;
        }
        if (this.format == null) {
            double resolution = datum.getResolution(units.getOffsetUnits());
            result = this.formatLimitedResolution(d, resolution);
        } else {
            result = this.format.format(datum.doubleValue(units));
        }
        return result;
    }

    public String grannyFormat(Datum datum, Units units) {
        String formt = this.format(datum, units);
        if (formt.indexOf("E") != -1) {
            int iE = formt.indexOf("E");
            StringBuffer granny = new StringBuffer(formt.length() + 4);
            String mant = formt.substring(0, iE);
            if (Double.parseDouble(mant) != 1.0) {
                granny.append(mant).append("\u00d7");
            }
            granny.append("10").append("!A").append(formt.substring(iE + 1)).append("!N");
            formt = granny.toString();
        }
        return formt;
    }

    public String[] axisFormat(DatumVector datums, DatumRange context) {
        int iE;
        String res1;
        int i;
        Units units = context.getUnits();
        String[] result = new String[datums.getLength()];
        for (int i2 = 0; i2 < result.length; ++i2) {
            result[i2] = this.format(datums.get(i2), units);
        }
        boolean hasMant = false;
        for (i = 0; i < result.length; ++i) {
            String mant;
            res1 = result[i];
            if (res1.indexOf("E") == -1 || Double.parseDouble(mant = res1.substring(0, iE = res1.indexOf("E"))) == 1.0) continue;
            hasMant = true;
        }
        for (i = 0; i < result.length; ++i) {
            res1 = result[i];
            if (res1.indexOf("E") == -1) continue;
            iE = res1.indexOf("E");
            StringBuffer granny = new StringBuffer(res1.length() + 4);
            String mant = res1.substring(0, iE);
            if (hasMant) {
                granny.append(mant).append("\u00d7");
            }
            granny.append("10").append("!A").append(res1.substring(iE + 1)).append("!N");
            result[i] = granny.toString();
        }
        return result;
    }

    public String grannyFormat(Datum datum) {
        return this.grannyFormat(datum, datum.getUnits()) + " " + datum.getUnits();
    }

    public String toString() {
        return this.formatString;
    }

    private String formatLimitedResolution(double d, double resolution) {
        String result;
        if (resolution == 0.0 && Double.toString(d).length() > 7) {
            resolution = d / 10000.0;
        }
        if (resolution > 0.0) {
            int scale = (int)Math.ceil(-1.0 * DasMath.log10(resolution) - 1.0E-5);
            int exp = d != 0.0 ? (int)DasMath.log10(Math.abs(d)) : 0;
            if (scale >= 0) {
                DecimalFormat f;
                if (exp <= -5 || exp >= 5) {
                    f = NumberFormatUtil.getDecimalFormat("0E0");
                    f.setMinimumFractionDigits(scale + exp - 1);
                    f.setMaximumFractionDigits(scale + exp - 1);
                } else {
                    f = NumberFormatUtil.getDecimalFormat("0");
                    f.setMinimumFractionDigits(scale);
                    f.setMaximumFractionDigits(scale);
                }
                result = f.format(d);
            } else {
                DecimalFormat f;
                double round = DasMath.exp10(-1 * scale);
                d = (double)Math.round(d / round) * round;
                if (exp <= -5 || exp >= 5) {
                    f = NumberFormatUtil.getDecimalFormat("0E0");
                    f.setMinimumFractionDigits(scale + exp + 1);
                    f.setMaximumFractionDigits(scale + exp + 1);
                } else {
                    f = NumberFormatUtil.getDecimalFormat("0");
                }
                result = f.format(d);
            }
        } else {
            result = Double.toString(d);
        }
        return result;
    }
}

