/*
 * Decompiled with CFR 0.152.
 */
package org.das2.datum;

import org.das2.datum.Datum;
import org.das2.datum.EnumerationUnits;
import org.das2.datum.Units;
import org.das2.datum.UnitsConverter;

public class UnitsUtil {
    public static final boolean isRatiometric(Units unit) {
        return unit != Units.dimensionless && unit.isConvertableTo(Units.logERatio);
    }

    public static final boolean isTimeLocation(Units unit) {
        return unit.isConvertableTo(Units.us2000);
    }

    public static final boolean isRatioMeasurement(Units unit) {
        return !(unit instanceof EnumerationUnits) && unit.getOffsetUnits() == unit;
    }

    public static final boolean isIntervalMeasurement(Units unit) {
        return !(unit instanceof EnumerationUnits) && unit.getOffsetUnits() != unit;
    }

    public static final boolean isNominalMeasurement(Units unit) {
        return false;
    }

    public static final boolean isOrdinalMeasurement(Units unit) {
        return unit instanceof EnumerationUnits;
    }

    public static Units getInverseUnit(Units unit) {
        if (unit == Units.seconds) {
            return Units.hertz;
        }
        if (unit == Units.hertz) {
            return Units.seconds;
        }
        if (unit == Units.dimensionless) {
            return Units.dimensionless;
        }
        if (unit == Units.milliseconds) {
            return Units.kiloHertz;
        }
        if (unit == Units.microseconds) {
            return Units.megaHertz;
        }
        throw new IllegalArgumentException("units not supported: " + unit);
    }

    public static String divideToString(Datum aDatum, Datum bDatum) {
        try {
            Datum result = UnitsUtil.divide(aDatum, bDatum);
            return String.valueOf(result);
        }
        catch (IllegalArgumentException e) {
            Units aUnits = aDatum.getUnits();
            Units bUnits = bDatum.getUnits();
            double a = aDatum.doubleValue(aUnits);
            double b = bDatum.doubleValue(bUnits);
            return "" + a / b + " " + aUnits + " / " + bUnits;
        }
    }

    public static Datum divide(Datum aDatum, Datum bDatum) {
        Units bInvUnits;
        Units bUnits = bDatum.getUnits();
        Units aUnits = aDatum.getUnits();
        try {
            bInvUnits = UnitsUtil.getInverseUnit(bUnits);
        }
        catch (IllegalArgumentException e) {
            bInvUnits = null;
        }
        double a = aDatum.doubleValue(aUnits);
        double b = bDatum.doubleValue(bUnits);
        if (bUnits == Units.dimensionless) {
            return aUnits.createDatum(a / b);
        }
        if (aUnits == Units.dimensionless) {
            return bInvUnits.createDatum(a / b);
        }
        if (!bUnits.isConvertableTo(aUnits)) {
            throw new IllegalArgumentException("unable to calculate, b units not convertable to a");
        }
        UnitsConverter uc = bUnits.getConverter(aUnits);
        return Units.dimensionless.createDatum(a / uc.convert(b));
    }
}

