/*
 * Decompiled with CFR 0.152.
 */
package org.das2.datum;

import org.das2.datum.Units;

public abstract class UnitsConverter {
    public static final UnitsConverter IDENTITY = new UnitsConverter(){

        public UnitsConverter getInverse() {
            return this;
        }

        public double convert(double value) {
            return value;
        }

        public String toString() {
            return "IDENTITY UnitsConverter";
        }
    };
    public static final UnitsConverter TERA = new ScaleOffset(1.0E-12, 0.0);
    public static final UnitsConverter GIGA = new ScaleOffset(1.0E-9, 0.0);
    public static final UnitsConverter MEGA = new ScaleOffset(1.0E-6, 0.0);
    public static final UnitsConverter KILO = new ScaleOffset(0.001, 0.0);
    public static final UnitsConverter MILLI = new ScaleOffset(1000.0, 0.0);
    public static final UnitsConverter MICRO = new ScaleOffset(1000000.0, 0.0);
    public static final UnitsConverter NANO = new ScaleOffset(1.0E9, 0.0);
    public static final UnitsConverter PICO = new ScaleOffset(1.0E12, 0.0);
    protected UnitsConverter inverse;

    protected UnitsConverter() {
    }

    protected UnitsConverter(UnitsConverter inverse) {
        this.inverse = inverse;
    }

    public abstract UnitsConverter getInverse();

    public abstract double convert(double var1);

    public Number convert(Number number) {
        double value = number.doubleValue();
        value = this.convert(value);
        if (number instanceof Integer) {
            return new Integer((int)value);
        }
        if (number instanceof Long) {
            return new Long((long)value);
        }
        return new Double(value);
    }

    public UnitsConverter append(UnitsConverter that) {
        return new Appended(this, that);
    }

    public static UnitsConverter getConverter(Units fromUnits, Units toUnits) {
        return Units.getConverter(fromUnits, toUnits);
    }

    public static class Appended
    extends UnitsConverter {
        UnitsConverter[] converters;

        public Appended(UnitsConverter uc1, UnitsConverter uc2) {
            int i;
            UnitsConverter[] a1 = Appended.ucToArray(uc1);
            UnitsConverter[] a2 = Appended.ucToArray(uc2);
            this.converters = new UnitsConverter[a1.length + a2.length];
            for (i = 0; i < a1.length; ++i) {
                this.converters[i] = a1[i];
            }
            for (i = 0; i < a2.length; ++i) {
                this.converters[i + a1.length] = a2[i];
            }
        }

        private Appended(UnitsConverter[] array, UnitsConverter inverse) {
            super(inverse);
            this.converters = array;
        }

        public double convert(double value) {
            for (int i = 0; i < this.converters.length; ++i) {
                value = this.converters[i].convert(value);
            }
            return value;
        }

        public Number convert(Number value) {
            for (int i = 0; i < this.converters.length; ++i) {
                value = this.converters[i].convert(value);
            }
            return value;
        }

        public UnitsConverter getInverse() {
            if (this.inverse == null) {
                int length = this.converters.length;
                UnitsConverter[] inverseArray = new UnitsConverter[length];
                for (int i = 0; i < length; ++i) {
                    inverseArray[i] = this.converters[length - i - 1].getInverse();
                }
                this.inverse = new Appended(inverseArray, (UnitsConverter)this);
            }
            return this.inverse;
        }

        private static UnitsConverter[] ucToArray(UnitsConverter uc) {
            if (uc instanceof Appended) {
                return ((Appended)uc).converters;
            }
            return new UnitsConverter[]{uc};
        }
    }

    public static class ScaleOffset
    extends UnitsConverter {
        private final double offset;
        private final double scale;
        private final int hashCode;

        public ScaleOffset(double scale, double offset) {
            this(scale, offset, null);
        }

        private ScaleOffset(double scale, double offset, UnitsConverter inverse) {
            super(inverse);
            this.scale = scale;
            this.offset = offset;
            this.hashCode = this.computeHashCode();
        }

        private int computeHashCode() {
            long scaleBits = Double.doubleToLongBits(this.scale);
            long offsetBits = Double.doubleToLongBits(this.offset);
            long code = 1859L + 13L * scaleBits + offsetBits;
            int a = (int)(code >> 32);
            int b = (int)(0xFFFFFFFFL & code);
            return a + b;
        }

        public UnitsConverter getInverse() {
            if (this.inverse == null) {
                this.inverse = new ScaleOffset(1.0 / this.scale, -(this.offset / this.scale), this);
            }
            return this.inverse;
        }

        public double convert(double value) {
            return this.scale * value + this.offset;
        }

        public UnitsConverter append(UnitsConverter that) {
            if (this.equals(IDENTITY)) {
                return that;
            }
            if (that.equals(IDENTITY)) {
                return this;
            }
            if (that instanceof ScaleOffset) {
                ScaleOffset so = (ScaleOffset)that;
                double aScale = this.scale * so.scale;
                double aOffset = this.offset * so.scale + so.offset;
                return new ScaleOffset(aScale, aOffset);
            }
            return super.append(that);
        }

        public boolean equals(Object o) {
            if (!(o instanceof ScaleOffset)) {
                return false;
            }
            ScaleOffset that = (ScaleOffset)o;
            return this.scale == that.scale && this.offset == that.offset;
        }

        public String toString() {
            return this.getClass().getName() + "[scale=" + this.scale + ",offset=" + this.offset + "]";
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

