/*
 * Decompiled with CFR 0.152.
 */
package org.das2.datum;

import org.das2.datum.Datum;
import org.das2.datum.Units;

public class TimeContext {
    public static TimeContext MILLISECONDS = new TimeContext("milliseconds", 1.1574074074074074E-8);
    public static TimeContext SECONDS = new TimeContext("seconds", 1.1574074074074073E-5);
    public static TimeContext MINUTES = new TimeContext("minutes", 6.944444444444445E-4);
    public static TimeContext HOURS = new TimeContext("hours", 0.041666666666666664);
    public static TimeContext DAYS = new TimeContext("days", 1.0);
    public static TimeContext WEEKS = new TimeContext("weeks", 7.0);
    public static TimeContext MONTHS = new TimeContext("months", 30.0);
    public static TimeContext YEARS = new TimeContext("years", 365.0);
    public static TimeContext DECADES = new TimeContext("decades", 3650.0);
    String s;
    double ordinal;

    public TimeContext(String s, double ordinal) {
        this.s = s;
        this.ordinal = ordinal;
    }

    public boolean gt(TimeContext tc) {
        return this.ordinal > tc.ordinal;
    }

    public boolean le(TimeContext tc) {
        return this.ordinal <= tc.ordinal;
    }

    public String toString() {
        return this.s;
    }

    public static TimeContext getContext(Datum t1, Datum t2) {
        double seconds = t2.subtract(t1).doubleValue(Units.seconds);
        TimeContext context = seconds < 1.0 ? MILLISECONDS : (seconds < 60.0 ? SECONDS : (seconds < 3600.0 ? MINUTES : (seconds < 86400.0 ? HOURS : (seconds <= 864000.0 ? DAYS : DAYS))));
        return context;
    }
}

