/*
 * Decompiled with CFR 0.152.
 */
package org.das2.datum;

import java.text.ParseException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.das2.datum.Datum;
import org.das2.datum.DatumVector;
import org.das2.datum.EnumerationUnits;
import org.das2.datum.LocationUnits;
import org.das2.datum.TimeLocationUnits;
import org.das2.datum.Units;
import org.das2.datum.format.DatumFormatter;
import org.das2.datum.format.DatumFormatterFactory;
import org.das2.datum.format.DefaultDatumFormatterFactory;
import org.das2.datum.format.EnumerationDatumFormatterFactory;
import org.das2.datum.format.ExponentialDatumFormatter;
import org.das2.datum.format.TimeDatumFormatter;
import org.das2.system.DasLogger;
import org.das2.util.DasMath;

public final class DatumUtil {
    private static final String zeros100 = "0.0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";

    private DatumUtil() {
    }

    public static DatumFormatter bestFormatter(DatumVector datums) {
        Units units;
        double[] array;
        if (datums.getUnits() instanceof EnumerationUnits) {
            return EnumerationDatumFormatterFactory.getInstance().defaultFormatter();
        }
        if (datums.getUnits() instanceof TimeLocationUnits) {
            Datum t1 = datums.get(0);
            int nticks = datums.getLength();
            Datum t2 = datums.get(nticks - 1);
            return DatumUtil.bestTimeFormatter(t1, t2, nticks - 1);
        }
        if (datums.getUnits() instanceof LocationUnits) {
            array = new double[datums.getLength()];
            units = ((LocationUnits)datums.get(0).getUnits()).getOffsetUnits();
            array[0] = 0.0;
            for (int i = 1; i < datums.getLength(); ++i) {
                array[i] = datums.get(i).subtract(datums.get(0)).doubleValue(units);
            }
        } else {
            units = datums.getUnits();
            array = datums.toDoubleArray(units);
        }
        double limit = DasMath.exp10((int)DasMath.log10(DasMath.max(array)) - 7);
        double gcd = DasMath.gcd(array, limit);
        int smallestExp = 99;
        int ismallestExp = -1;
        for (int j = 0; j < datums.getLength(); ++j) {
            int ee;
            double d = datums.get(j).doubleValue(units);
            if (!(Math.abs(d) > gcd * 0.1) || (ee = (int)Math.floor(0.05 + DasMath.log10(Math.abs(d)))) >= smallestExp) continue;
            smallestExp = ee;
            ismallestExp = j;
        }
        Datum resolution = units.createDatum(gcd);
        Datum base = datums.get(ismallestExp);
        if (base.lt(units.createDatum(0.0))) {
            base = base.multiply(-1.0);
        }
        return DatumUtil.bestFormatter(base, base.add(resolution), 1);
    }

    public static int fractionalDigits(Datum resolution) {
        int nzero;
        int DOUBLE_DIGITS = 10;
        double d = Math.abs(resolution.doubleValue());
        int e = (int)Math.floor(DasMath.log10(d) + 1.0E-4);
        long i = (long)(d / DasMath.exp10(e - (DOUBLE_DIGITS - 1)) + 0.5);
        for (nzero = 1; nzero < 16 && (double)i % DasMath.exp10(nzero) == 0.0; ++nzero) {
        }
        return DOUBLE_DIGITS - 1 - --nzero - e;
    }

    public static DatumFormatter limitLogResolutionFormatter(Datum minimum, Datum maximum, int nsteps) {
        Units units = minimum.getUnits();
        if (units instanceof TimeLocationUnits) {
            return DatumUtil.bestTimeFormatter(minimum, maximum, nsteps);
        }
        double logmin = DasMath.log10(minimum.doubleValue(units));
        double logmax = DasMath.log10(maximum.doubleValue(units));
        double percent = (DasMath.exp10((logmax - logmin) / (double)nsteps) - 1.0) * 100.0;
        int nFraction = 2 - (int)Math.floor(0.05 + DasMath.log10(percent));
        nFraction = nFraction < 0 ? 0 : nFraction;
        String formatString = DatumUtil.exp(nFraction);
        DatumFormatterFactory factory = units.getDatumFormatterFactory();
        try {
            return factory.newFormatter(formatString);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public static DatumFormatter limitResolutionFormatter(Datum minimum, Datum maximum, int nsteps) {
        Units units = minimum.getUnits();
        if (units instanceof TimeLocationUnits) {
            return DatumUtil.bestTimeFormatter(minimum, maximum, nsteps);
        }
        Datum resolution = maximum.subtract(minimum).divide(nsteps);
        double discernable = resolution.doubleValue(units);
        int nFraction = -1 * (int)Math.floor(0.05 + DasMath.log10(discernable));
        nFraction = nFraction < 0 ? 0 : nFraction;
        String formatString = DatumUtil.zeros(nFraction);
        DatumFormatterFactory factory = units.getDatumFormatterFactory();
        try {
            return factory.newFormatter(formatString);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public static DatumFormatter bestFormatter(Datum minimum, Datum maximum, int nsteps) {
        Units units = minimum.getUnits();
        if (maximum.lt(minimum)) {
            Datum tmp = maximum;
            maximum = minimum;
            minimum = tmp;
        }
        if (units instanceof TimeLocationUnits) {
            return DatumUtil.bestTimeFormatter(minimum, maximum, nsteps);
        }
        DatumFormatterFactory factory = minimum.getUnits().getDatumFormatterFactory();
        try {
            if (!(factory instanceof DefaultDatumFormatterFactory)) {
                return factory.defaultFormatter();
            }
            int fracDigits = DatumUtil.fractionalDigits(maximum.subtract(minimum).divide(nsteps));
            int smallestExp = 99;
            double discernable = DasMath.exp10(-1 * fracDigits);
            Datum step = maximum.subtract(minimum).divide(nsteps);
            double dstep = step.doubleValue(units.getOffsetUnits());
            for (int j = 0; j < nsteps; ++j) {
                int ee;
                double d = minimum.add(step.multiply(j)).doubleValue(units);
                if (!(Math.abs(d) > discernable * 0.1) || (ee = (int)Math.floor(0.05 + DasMath.log10(Math.abs(d)))) >= smallestExp) continue;
                smallestExp = ee;
            }
            if (smallestExp < -60 || smallestExp > 60) {
                return DefaultDatumFormatterFactory.getInstance().defaultFormatter();
            }
            if (smallestExp < -3 || smallestExp > 3) {
                return new ExponentialDatumFormatter(smallestExp - -1 * fracDigits + 1, smallestExp);
            }
            int nFraction = -1 * (int)Math.floor(0.05 + DasMath.log10(discernable));
            nFraction = nFraction < 0 ? 0 : nFraction;
            String formatString = DatumUtil.zeros(nFraction);
            return factory.newFormatter(formatString);
        }
        catch (ParseException pe) {
            Logger logger = DasLogger.getLogger();
            RuntimeException re = new RuntimeException(pe);
            logger.log(Level.SEVERE, pe.getMessage(), re);
            throw re;
        }
    }

    private static String exp(int power) {
        StringBuffer buffer = new StringBuffer(power + 4);
        for (int i = 0; i < power - 1; ++i) {
            buffer.append('#');
        }
        buffer.append("0.#E0");
        return buffer.toString();
    }

    public static String zeros(int count) {
        if (count < 0) {
            return "0";
        }
        if (count <= 100) {
            return zeros100.substring(0, count + 2);
        }
        StringBuffer buff = new StringBuffer(count + 2).append("0.");
        for (int index = 0; index < count; ++index) {
            buff.append('0');
        }
        return buff.toString();
    }

    public static DatumFormatter bestTimeFormatter(Datum minimum, Datum maximum, int nsteps) {
        double secondsPerStep = maximum.subtract(minimum).doubleValue(Units.seconds) / (double)nsteps;
        double daysPerStep = secondsPerStep / 86400.0;
        if (secondsPerStep < 1.0) {
            return TimeDatumFormatter.MILLISECONDS;
        }
        if (secondsPerStep < 60.0) {
            return TimeDatumFormatter.SECONDS;
        }
        if (secondsPerStep < 3600.0) {
            return TimeDatumFormatter.MINUTES;
        }
        if (secondsPerStep < 86400.0) {
            return TimeDatumFormatter.HOURS;
        }
        if (secondsPerStep < 2419200.0) {
            return TimeDatumFormatter.DAYS;
        }
        if (secondsPerStep < 3.15576E7) {
            return TimeDatumFormatter.MONTHS;
        }
        return TimeDatumFormatter.YEARS;
    }

    public static Datum parse(String s) throws ParseException {
        Units units;
        String[] ss = s.trim().split("\\s");
        if (ss.length == 1) {
            units = Units.dimensionless;
        } else {
            try {
                units = Units.getByName(ss[1]);
            }
            catch (IllegalArgumentException e) {
                throw new ParseException(e.getMessage(), 0);
            }
        }
        return Datum.create(Double.parseDouble(ss[0]), units);
    }

    public static Datum parseValid(String s) {
        try {
            return DatumUtil.parse(s);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public static Datum createValid(String s) {
        return Datum.create(Double.parseDouble(s), Units.dimensionless);
    }

    public static double[] doubleValues(Datum[] datums, Units units) {
        double[] result = new double[datums.length];
        for (int j = 0; j < datums.length; ++j) {
            result[j] = datums[j].doubleValue(units);
        }
        return result;
    }

    public static double[] doubleValues(Datum[] datums, Units[] unitsArray) {
        double[] result = new double[datums.length];
        for (int j = 0; j < datums.length; ++j) {
            result[j] = datums[j].doubleValue(unitsArray[j]);
        }
        return result;
    }

    public static Datum asOrderOneUnits(Datum d) {
        Units dunits = d.getUnits();
        if (dunits == Units.dimensionless) {
            return d;
        }
        if (dunits == Units.dB) {
            return d;
        }
        if (dunits instanceof LocationUnits) {
            return d;
        }
        Units[] conversions = dunits.getConvertableUnits();
        double bestScore = 0.0;
        Datum bestDatum = d;
        for (int i = 0; i < conversions.length; ++i) {
            Datum dd = d.convertTo(conversions[i]);
            Number n = dd.getValue();
            double nn = Math.abs(n.doubleValue());
            double score = nn > 20.0 ? 20.0 / nn : nn;
            if (!(score > bestScore)) continue;
            bestScore = score;
            bestDatum = dd;
        }
        return bestDatum;
    }
}

