/*
 * Decompiled with CFR 0.152.
 */
package org.das2.dataset.test;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.das2.DasException;
import org.das2.dataset.DataSet;
import org.das2.dataset.DataSetDescriptor;
import org.das2.dataset.DataSetUpdateEvent;
import org.das2.dataset.WritableTableDataSet;
import org.das2.datum.Datum;
import org.das2.datum.Units;
import org.das2.graph.DasAxis;
import org.das2.util.monitor.ProgressMonitor;

public class MendelbrotDataSetDescriptor
extends DataSetDescriptor {
    DasAxis yAxis;
    int limit = 200;
    int overSampleFactor = 1;

    public MendelbrotDataSetDescriptor(DasAxis yAxis) {
        this.yAxis = yAxis;
        yAxis.addPropertyChangeListener(this.getPropertyChangeListener());
        this.setDefaultCaching(false);
    }

    private PropertyChangeListener getPropertyChangeListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                MendelbrotDataSetDescriptor.this.fireDataSetUpdateEvent(new DataSetUpdateEvent((Object)MendelbrotDataSetDescriptor.this));
            }
        };
    }

    private float punktfarbe(double xwert, double ywert) {
        int j;
        double r = 0.0;
        double i = 0.0;
        double m = 0.0;
        int MAX = this.limit;
        for (j = 0; j < MAX && m < 4.0; ++j) {
            m = r * r - i * i;
            i = 2.0 * r * i + ywert;
            r = m + xwert;
        }
        if (j == MAX) {
            j = 0;
        }
        return (float)j / (float)MAX;
    }

    protected DataSet getDataSetImpl(Datum start, Datum end, Datum resolution, ProgressMonitor monitor) throws DasException {
        int ix;
        double xstart = start.doubleValue(Units.dimensionless);
        double xend = end.doubleValue(Units.dimensionless);
        double xresolution = resolution.doubleValue(Units.dimensionless) / (double)this.overSampleFactor;
        double ystart = this.yAxis.getDataMinimum(Units.dimensionless);
        double yend = this.yAxis.getDataMaximum(Units.dimensionless);
        int _ny = this.yAxis.getRow().getHeight();
        double yresolution = (yend - ystart) / (double)(_ny * this.overSampleFactor);
        int ny = (int)((yend - ystart) / yresolution);
        int nx = (int)((xend - xstart) / xresolution);
        WritableTableDataSet result = WritableTableDataSet.newSimple(nx, Units.dimensionless, ny, Units.dimensionless, Units.dimensionless);
        double[][] z = new double[nx][ny];
        monitor.setTaskSize(ny);
        monitor.started();
        for (int iy = 0; iy < ny && !monitor.isCancelled(); ++iy) {
            monitor.setTaskProgress(iy);
            for (ix = 0; ix < nx; ++ix) {
                result.setDouble(ix, iy, this.punktfarbe(xstart + (double)ix * xresolution, ystart + (double)iy * yresolution), Units.dimensionless);
            }
        }
        monitor.finished();
        double[] xtags = new double[nx];
        for (ix = 0; ix < nx; ++ix) {
            result.setXTagDouble(ix, xstart + ((double)ix + 0.5) * xresolution, Units.dimensionless);
        }
        double[] ytags = new double[ny];
        for (int iy = 0; iy < ny; ++iy) {
            result.setYTagDouble(0, iy, ystart + ((double)iy + 0.5) * yresolution, Units.dimensionless);
        }
        result.setProperty("xTagWidth", resolution.multiply(2.0));
        result.setProperty("yTagWidth", Units.dimensionless.createDatum(yresolution).multiply(2.0));
        return result;
    }

    public Units getXUnits() {
        return Units.dimensionless;
    }

    public void setLimit(int limit) {
        if (this.limit != limit) {
            this.limit = limit;
            this.fireDataSetUpdateEvent(new DataSetUpdateEvent((Object)this));
        }
    }

    public int getLimit() {
        return this.limit;
    }

    public int getOverSampleFactor() {
        return this.overSampleFactor;
    }

    public void setOverSampleFactor(int overSampleFactor) {
        if (this.overSampleFactor != overSampleFactor) {
            this.overSampleFactor = overSampleFactor;
            this.fireDataSetUpdateEvent(new DataSetUpdateEvent((Object)this));
        }
    }
}

