/*
 * Decompiled with CFR 0.152.
 */
package org.das2.dataset.test;

import java.util.logging.Logger;
import org.das2.DasException;
import org.das2.dataset.DataSet;
import org.das2.dataset.DataSetDescriptor;
import org.das2.dataset.RebinDescriptor;
import org.das2.dataset.WritableTableDataSet;
import org.das2.datum.Units;
import org.das2.graph.DasAxis;
import org.das2.graph.DasPlot;
import org.das2.graph.DataLoader;
import org.das2.graph.Renderer;
import org.das2.system.DasLogger;
import org.das2.system.RequestProcessor;
import org.das2.util.monitor.ProgressMonitor;

public class MendelbrotDataLoader
extends DataLoader {
    int limit = 200;
    int overSampleFactor = 1;
    DataLoader.Request currentRequest;
    DataLoader.Request completedRequest;
    Logger logger = DasLogger.getLogger(DasLogger.GRAPHICS_LOG, "MendelBrotDataLoader");

    public MendelbrotDataLoader(Renderer r) {
        super(r);
    }

    private final float punktfarbe(double xwert, double ywert) {
        int j;
        double r = 0.0;
        double i = 0.0;
        double m = 0.0;
        int MAX = this.limit;
        for (j = 0; j < MAX && m < 4.0; ++j) {
            m = r * r - i * i;
            i = 2.0 * r * i + ywert;
            r = m + xwert;
        }
        if (j == MAX) {
            j = 0;
        }
        return j;
    }

    public void update() {
        if (this.isActive()) {
            DasPlot p = this.getRenderer().getParent();
            if (p == null) {
                return;
            }
            DasAxis xAxis = p.getXAxis();
            DasAxis yAxis = p.getYAxis();
            if (xAxis.valueIsAdjusting() || yAxis.valueIsAdjusting()) {
                return;
            }
            final RebinDescriptor xRebinDescriptor = new RebinDescriptor(xAxis.getDataMinimum(), xAxis.getDataMaximum(), xAxis.getColumn().getWidth(), xAxis.isLog());
            final RebinDescriptor yRebinDescriptor = new RebinDescriptor(yAxis.getDataMinimum(), yAxis.getDataMaximum(), yAxis.getRow().getHeight(), yAxis.isLog());
            if (this.currentRequest != null) {
                if (!xAxis.getMemento().equals(this.currentRequest.xmem) && !yAxis.getMemento().equals(this.currentRequest.ymem)) {
                    this.logger.fine("cancel old request");
                    this.currentRequest.monitor.cancel();
                } else {
                    this.logger.fine("ignore repeat request");
                    return;
                }
            }
            final String taskDescription = "mendelbrot x:" + xAxis.getMemento() + " y:" + yAxis.getMemento();
            if (this.completedRequest != null && xAxis.getMemento().equals(this.completedRequest.xmem) && yAxis.getMemento().equals(this.completedRequest.ymem)) {
                this.logger.fine("ignore satisfied request " + taskDescription);
                return;
            }
            this.currentRequest = new DataLoader.Request(this, this.getMonitor(taskDescription), xAxis.getMemento(), yAxis.getMemento());
            Runnable run = new Runnable(){

                public void run() {
                    try {
                        MendelbrotDataLoader.this.logger.fine("calculate dataset for " + taskDescription);
                        DataSet result = MendelbrotDataLoader.this.getDataSet(xRebinDescriptor, yRebinDescriptor, MendelbrotDataLoader.this.getMonitor(taskDescription), taskDescription);
                        System.err.println(result.getProperty("TaskDescription"));
                        MendelbrotDataLoader.this.getRenderer().setDataSet(result);
                        MendelbrotDataLoader.this.completedRequest = MendelbrotDataLoader.this.currentRequest;
                        MendelbrotDataLoader.this.logger.fine("completed " + taskDescription);
                        MendelbrotDataLoader.this.currentRequest = null;
                    }
                    catch (DasException e) {
                        MendelbrotDataLoader.this.getRenderer().setException(e);
                    }
                }
            };
            RequestProcessor.invokeAfter(run, this.getRenderer());
        }
    }

    private DataSet getDataSet(RebinDescriptor ddx, RebinDescriptor ddy, ProgressMonitor monitor, String desc) throws DasException {
        int ix;
        double xstart = ddx.binCenter(0, Units.dimensionless);
        double xend = ddx.binCenter(ddx.numberOfBins() - 1, Units.dimensionless);
        double xresolution = ddx.binWidth() / (double)this.overSampleFactor;
        double ystart = ddy.binCenter(0, Units.dimensionless);
        double yend = ddy.binCenter(ddy.numberOfBins() - 1, Units.dimensionless);
        double yresolution = ddy.binWidth() / (double)this.overSampleFactor;
        int ny = (int)(1.5 + (yend - ystart) / yresolution);
        int nx = (int)(1.5 + (xend - xstart) / xresolution);
        WritableTableDataSet result = WritableTableDataSet.newSimple(nx, Units.dimensionless, ny, Units.dimensionless, Units.dimensionless);
        double[][] z = new double[nx][ny];
        monitor.setTaskSize(ny);
        monitor.started();
        for (int iy = 0; iy < ny && !monitor.isCancelled(); ++iy) {
            monitor.setTaskProgress(iy);
            for (ix = 0; ix < nx; ++ix) {
                result.setDouble(ix, iy, this.punktfarbe(xstart + (double)ix * xresolution, ystart + (double)iy * yresolution), Units.dimensionless);
            }
        }
        monitor.finished();
        double[] xtags = new double[nx];
        for (ix = 0; ix < nx; ++ix) {
            result.setXTagDouble(ix, xstart + (double)ix * xresolution, Units.dimensionless);
        }
        double[] ytags = new double[ny];
        for (int iy = 0; iy < ny; ++iy) {
            result.setYTagDouble(0, iy, ystart + (double)iy * yresolution, Units.dimensionless);
        }
        result.setProperty("xTagWidth", Units.dimensionless.createDatum(yresolution * 2.0));
        result.setProperty("yTagWidth", Units.dimensionless.createDatum(yresolution * 2.0));
        result.setProperty("TaskDescription", desc);
        return result;
    }

    public void setLimit(int limit) {
        if (this.limit != limit) {
            this.limit = limit;
            this.update();
        }
    }

    public int getLimit() {
        return this.limit;
    }

    public int getOverSampleFactor() {
        return this.overSampleFactor;
    }

    public void setOverSampleFactor(int overSampleFactor) {
        if (this.overSampleFactor != overSampleFactor) {
            this.overSampleFactor = overSampleFactor;
            this.completedRequest = null;
            this.update();
        }
    }

    public DataSetDescriptor getDataSetDescriptor() {
        return null;
    }

    public void setDataSetDescriptor(DataSetDescriptor dsd) {
    }
}

