/*
 * Decompiled with CFR 0.152.
 */
package org.das2.dataset;

import java.util.HashMap;
import java.util.Map;
import org.das2.dataset.DataSet;
import org.das2.dataset.TableDataSet;
import org.das2.dataset.VectorDataSet;
import org.das2.datum.Datum;
import org.das2.datum.DatumVector;
import org.das2.datum.Units;

public class WeightsTableDataSet
implements TableDataSet {
    TableDataSet source;
    Units sourceUnits;
    double fill;

    public static TableDataSet create(TableDataSet source) {
        if (source.getPlanarView("weights") != null) {
            return (TableDataSet)source.getPlanarView("weights");
        }
        return new WeightsTableDataSet(source);
    }

    private WeightsTableDataSet(TableDataSet source) {
        this.source = source;
        this.sourceUnits = source.getZUnits();
        this.fill = source.getZUnits().getFillDouble();
    }

    public Datum getDatum(int i, int j) {
        return Units.dimensionless.createDatum(this.getDouble(i, j, Units.dimensionless));
    }

    public double getDouble(int i, int j, Units units) {
        return this.sourceUnits.isFill(this.source.getDouble(i, j, this.sourceUnits)) ? 0.0 : 1.0;
    }

    public double[] getDoubleScan(int i, Units units) {
        throw new IllegalStateException("not implemented");
    }

    public int getInt(int i, int j, Units units) {
        return this.source.getDouble(i, j, this.sourceUnits) != this.fill ? 1 : 0;
    }

    public DataSet getPlanarView(String planeID) {
        return this;
    }

    public String[] getPlaneIds() {
        return new String[]{""};
    }

    public Map getProperties() {
        return new HashMap();
    }

    public Object getProperty(String name) {
        return null;
    }

    public DatumVector getScan(int i) {
        throw new IllegalStateException("not implemented");
    }

    public int getXLength() {
        return this.source.getXLength();
    }

    public VectorDataSet getXSlice(int i) {
        throw new IllegalStateException("not implemented");
    }

    public Datum getXTagDatum(int i) {
        return this.source.getXTagDatum(i);
    }

    public double getXTagDouble(int i, Units units) {
        return this.source.getXTagDouble(i, units);
    }

    public int getXTagInt(int i, Units units) {
        return this.source.getXTagInt(i, units);
    }

    public Units getXUnits() {
        return this.source.getXUnits();
    }

    public int getYLength(int table) {
        return this.source.getYLength(table);
    }

    public VectorDataSet getYSlice(int j, int table) {
        throw new IllegalStateException("not implemented");
    }

    public Datum getYTagDatum(int table, int j) {
        return this.source.getYTagDatum(table, j);
    }

    public double getYTagDouble(int table, int j, Units units) {
        return this.source.getYTagDouble(table, j, units);
    }

    public int getYTagInt(int table, int j, Units units) {
        return this.source.getYTagInt(table, j, units);
    }

    public DatumVector getYTags(int table) {
        return this.source.getYTags(table);
    }

    public Units getYUnits() {
        return this.source.getYUnits();
    }

    public Units getZUnits() {
        return Units.dimensionless;
    }

    public int tableCount() {
        return this.source.tableCount();
    }

    public int tableEnd(int table) {
        return this.source.tableEnd(table);
    }

    public int tableOfIndex(int i) {
        return this.source.tableOfIndex(i);
    }

    public int tableStart(int table) {
        return this.source.tableStart(table);
    }

    public Object getProperty(int table, String name) {
        return this.source.getProperty(table, name);
    }
}

