/*
 * Decompiled with CFR 0.152.
 */
package org.das2.dataset;

import org.das2.dataset.DataSetUtil;
import org.das2.dataset.TableDataSet;
import org.das2.dataset.TableUtil;
import org.das2.dataset.TagMapTableDataSet;
import org.das2.datum.Datum;
import org.das2.datum.Units;
import org.das2.datum.UnitsUtil;
import org.das2.util.DasMath;

public class TableDataSetGridder {
    private static Datum yTagGcd(TableDataSet tds, int itable, Datum error) {
        Units units = tds.getYUnits();
        double[] ytag = tds.getYTags(itable).toDoubleArray(units);
        double gcd = DasMath.gcd(ytag, error.doubleValue(units.getOffsetUnits()));
        return units.getOffsetUnits().createDatum(gcd);
    }

    private static Datum yTagGcdLog(TableDataSet tds, int itable, Datum error) {
        Units units = tds.getYUnits();
        double[] ytag = new double[tds.getYLength(itable) - 1];
        if (!UnitsUtil.isRatiometric(error.getUnits())) {
            throw new IllegalArgumentException("error units must be ratiometric");
        }
        for (int i = 0; i < ytag.length; ++i) {
            ytag[i] = Math.log(tds.getYTagDouble(itable, i + 1, units) / tds.getYTagDouble(itable, i, units));
        }
        double gcd = DasMath.gcd(ytag, error.doubleValue(Units.logERatio));
        return Units.logERatio.createDatum(gcd);
    }

    private static Datum xTagGcd(TableDataSet ds, int itable, Datum error) {
        Units units = ds.getXUnits();
        int istart = ds.tableStart(itable);
        int iend = ds.tableEnd(itable);
        double[] xtag = new double[iend - istart - 1];
        double base = ds.getXTagDouble(istart, units);
        for (int i = 0; i < xtag.length - 1; ++i) {
            xtag[i] = ds.getXTagDouble(i + istart + 1, units) - ds.getXTagDouble(i + istart, units);
        }
        double gcd = DasMath.gcd(xtag, error.doubleValue(units.getOffsetUnits()));
        return units.getOffsetUnits().createDatum(gcd);
    }

    public static TableDataSet gridLog(TableDataSet tds, Datum xerror, Datum yerror) {
        if (tds.tableCount() > 1) {
            throw new IllegalArgumentException("only simple tables for now");
        }
        int itable = 0;
        Datum xTagGcd = TableDataSetGridder.xTagGcd(tds, itable, xerror);
        Datum yTagGcd = TableDataSetGridder.yTagGcdLog(tds, itable, yerror);
        Units xunits = tds.getXUnits();
        Units yunits = tds.getYUnits();
        double tagWidth = DataSetUtil.guessXTagWidth(tds).doubleValue(xunits.getOffsetUnits());
        double dx = xTagGcd.doubleValue(xunits.getOffsetUnits());
        double xbase = tds.getXTagDouble(tds.tableStart(itable), xunits) - tagWidth / 2.0 - dx / 2.0;
        int nx = (int)((tds.getXTagDouble(tds.tableEnd(itable) - 1, xunits) + tagWidth / 2.0 - xbase) / dx + 1.0);
        int[] imap = new int[nx];
        for (int i = tds.tableStart(itable); i < tds.tableEnd(itable); ++i) {
            double xtag = tds.getXTagDouble(i, xunits);
            int i0 = (int)((xtag - tagWidth / 2.0 - xbase) / dx);
            int i1 = (int)((xtag + tagWidth / 2.0 - xbase) / dx);
            for (int k = i0; k <= i1; ++k) {
                imap[k] = i;
            }
        }
        double dy = yTagGcd.doubleValue(Units.logERatio);
        tagWidth = TableUtil.guessYTagWidth(tds).doubleValue(Units.logERatio);
        double ybase = Math.log(tds.getYTagDouble(itable, 0, yunits)) - tagWidth / 2.0 - dy / 2.0;
        int ny = (int)((Math.log(tds.getYTagDouble(itable, tds.getYLength(itable) - 1, yunits)) + tagWidth / 2.0 - ybase) / dy + 1.0);
        int[] jmap = new int[ny];
        for (int i = 0; i < tds.getYLength(itable); ++i) {
            double tag = Math.log(tds.getYTagDouble(itable, i, yunits));
            int i0 = (int)((tag - tagWidth / 2.0 - ybase) / dy);
            int i1 = (int)((tag + tagWidth / 2.0 - ybase) / dy);
            for (int k = i0; k <= i1; ++k) {
                jmap[k] = i;
            }
        }
        int[] tableMap = new int[nx];
        for (int j = 0; j < nx; ++j) {
            tableMap[j] = 0;
        }
        return new TagMapTableDataSet(tds, imap, new int[][]{jmap}, tableMap);
    }
}

