/*
 * Decompiled with CFR 0.152.
 */
package org.das2.dataset;

import java.util.HashMap;
import java.util.Map;
import org.das2.dataset.DataSet;
import org.das2.dataset.TableDataSet;
import org.das2.dataset.VectorDataSet;
import org.das2.dataset.XSliceDataSet;
import org.das2.dataset.YSliceDataSet;
import org.das2.datum.Datum;
import org.das2.datum.DatumVector;
import org.das2.datum.Units;

public class SimpleTableDataSet
implements TableDataSet {
    double[] z;
    double[] x;
    double[] y;
    final int nx;
    final int ny;
    Units xunits;
    Units yunits;
    Units zunits;
    Map properties;
    TableDataSet auxPlane;
    String auxPlaneName;

    public SimpleTableDataSet(double[] x, double[] y, double[] z, Units xunits, Units yunits, Units zunits) {
        this.z = z;
        this.x = x;
        this.y = y;
        this.nx = x.length;
        this.ny = y.length;
        this.xunits = xunits;
        this.yunits = yunits;
        this.zunits = zunits;
        this.auxPlaneName = null;
    }

    public SimpleTableDataSet(double[] x, double[] y, double[] z, Units xunits, Units yunits, Units zunits, String planeName, TableDataSet planeData) {
        this(x, y, z, xunits, yunits, zunits);
        this.auxPlaneName = planeName;
        this.auxPlane = planeData;
    }

    private final int indexOf(int i, int j) {
        return i * this.ny + j;
    }

    public Datum getDatum(int i, int j) {
        return Datum.create(this.z[this.indexOf(i, j)], this.zunits);
    }

    public double getDouble(int i, int j, Units units) {
        return this.zunits.convertDoubleTo(units, this.z[this.indexOf(i, j)]);
    }

    public double[] getDoubleScan(int i, Units units) {
        throw new UnsupportedOperationException();
    }

    public int getInt(int i, int j, Units units) {
        throw new UnsupportedOperationException();
    }

    public DataSet getPlanarView(String planeID) {
        if (planeID.equals(this.auxPlaneName)) {
            return this.auxPlane;
        }
        return null;
    }

    public String[] getPlaneIds() {
        return new String[0];
    }

    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    public Object getProperty(int table, String name) {
        return this.getProperty(name);
    }

    public DatumVector getScan(int i) {
        throw new UnsupportedOperationException();
    }

    public int getXLength() {
        return this.x.length;
    }

    public VectorDataSet getXSlice(int i) {
        return new XSliceDataSet(this, i);
    }

    public Datum getXTagDatum(int i) {
        return Datum.create(this.x[i], this.xunits);
    }

    public double getXTagDouble(int i, Units units) {
        return this.xunits.convertDoubleTo(units, this.x[i]);
    }

    public int getXTagInt(int i, Units units) {
        throw new UnsupportedOperationException();
    }

    public Units getXUnits() {
        return this.xunits;
    }

    public int getYLength(int table) {
        return this.y.length;
    }

    public VectorDataSet getYSlice(int j, int table) {
        return new YSliceDataSet(this, j, table);
    }

    public Datum getYTagDatum(int table, int j) {
        return Datum.create(this.y[j], this.yunits);
    }

    public double getYTagDouble(int table, int j, Units units) {
        return this.yunits.convertDoubleTo(units, this.y[j]);
    }

    public void setYTagDouble(int table, int j, double yvalue, Units units) {
        this.y[j] = units.convertDoubleTo(this.yunits, yvalue);
    }

    public int getYTagInt(int table, int j, Units units) {
        throw new UnsupportedOperationException();
    }

    public DatumVector getYTags(int table) {
        return DatumVector.newDatumVector(this.y, this.yunits);
    }

    public Units getYUnits() {
        return this.yunits;
    }

    public Units getZUnits() {
        return this.zunits;
    }

    public int tableCount() {
        return 1;
    }

    public int tableEnd(int table) {
        return this.x.length;
    }

    public int tableOfIndex(int i) {
        return 0;
    }

    public int tableStart(int table) {
        return 0;
    }

    public Map getProperties() {
        return new HashMap(this.properties);
    }
}

