/*
 * Decompiled with CFR 0.152.
 */
package org.das2.dataset;

import org.das2.dataset.QernalTableRebinner;
import org.das2.dataset.RebinDescriptor;
import org.das2.datum.Datum;

public class NoInterpolateQernalFactory
implements QernalTableRebinner.QernalFactory {
    public QernalTableRebinner.Qernal getQernal(RebinDescriptor ddx, RebinDescriptor ddy, Datum xTagWidth, Datum yTagWidth) {
        return new EnlargeQernal(1, 1, 1, 1, ddx.numberOfBins(), ddy.numberOfBins());
    }

    class NoEnlargeQernal
    implements QernalTableRebinner.Qernal {
        int nx;
        int ny;

        private NoEnlargeQernal(int nx, int ny) {
            this.nx = nx;
            this.ny = ny;
        }

        public void apply(int x, int y, double value, double weight, double[][] ss, double[][] ww) {
            if (x >= 0 && x < this.nx && y >= 0 && y < this.ny) {
                double[] dArray = ss[x];
                int n = y;
                dArray[n] = dArray[n] + value * weight;
                double[] dArray2 = ww[x];
                int n2 = y;
                dArray2[n2] = dArray2[n2] + weight;
            }
        }
    }

    class EnlargeQernal
    implements QernalTableRebinner.Qernal {
        int dx0;
        int dx1;
        int dy0;
        int dy1;
        int nx;
        int ny;

        private EnlargeQernal(int dx0, int dx1, int dy0, int dy1, int nx, int ny) {
            this.dx0 = dx0;
            this.dx1 = dx1;
            this.dy0 = dy0;
            this.dy1 = dy1;
            this.nx = nx;
            this.ny = ny;
        }

        public void apply(int x, int y, double value, double weight, double[][] ss, double[][] ww) {
            int x0 = x - this.dx0;
            int x1 = x + this.dx1 + 1;
            int y0 = y - this.dy0;
            int y1 = y + this.dy1 + 1;
            if (x0 < 0) {
                x0 = 0;
            } else if (x0 > this.nx) {
                x0 = this.nx;
            }
            if (x1 < 0) {
                x1 = 0;
            } else if (x1 > this.nx) {
                x1 = this.nx;
            }
            if (y0 < 0) {
                y0 = 0;
            } else if (y0 > this.ny) {
                y0 = this.ny;
            }
            if (y1 < 0) {
                y1 = 0;
            } else if (y1 > this.ny) {
                y1 = this.ny;
            }
            for (int i = x0; i < x1; ++i) {
                int j = y0;
                while (j < y1) {
                    double[] dArray = ss[i];
                    int n = j;
                    dArray[n] = dArray[n] + value * weight;
                    double[] dArray2 = ww[i];
                    int n2 = j++;
                    dArray2[n2] = dArray2[n2] + weight;
                }
            }
        }
    }
}

