/*
 * Decompiled with CFR 0.152.
 */
package org.das2.dataset;

import java.util.Map;
import org.das2.dataset.DataSet;
import org.das2.dataset.DataSetUtil;
import org.das2.dataset.RebinDescriptor;
import org.das2.dataset.TableDataSet;
import org.das2.dataset.TableUtil;
import org.das2.dataset.VectorDataSet;
import org.das2.dataset.XSliceDataSet;
import org.das2.dataset.YSliceDataSet;
import org.das2.datum.Datum;
import org.das2.datum.DatumVector;
import org.das2.datum.Units;
import org.das2.datum.UnitsUtil;

public class NearestNeighborTableDataSet
implements TableDataSet {
    TableDataSet source;
    int[] imap;
    int[][] jmap;
    int[] itableMap;
    RebinDescriptor ddX;
    RebinDescriptor ddY;

    NearestNeighborTableDataSet(TableDataSet source, RebinDescriptor ddX, RebinDescriptor ddY) {
        this.imap = new int[ddX.numberOfBins()];
        if (ddY == null) {
            if (source.tableCount() > 1) {
                throw new IllegalArgumentException();
            }
            this.jmap = new int[source.tableCount()][source.getYLength(0)];
        } else {
            this.jmap = new int[source.tableCount()][ddY.numberOfBins()];
        }
        this.itableMap = new int[ddX.numberOfBins()];
        this.ddX = ddX;
        this.ddY = ddY;
        this.source = source;
        if (source.getXLength() == 0) {
            for (int i = 0; i < this.imap.length; ++i) {
                this.imap[i] = -1;
            }
        } else {
            Datum xTagWidth = (Datum)source.getProperty("xTagWidth");
            Datum yTagWidth = (Datum)source.getProperty("yTagWidth");
            if (xTagWidth == null) {
                xTagWidth = DataSetUtil.guessXTagWidth(source);
            }
            if (yTagWidth == null) {
                yTagWidth = TableUtil.guessYTagWidth(source);
            }
            DatumVector xx = ddX.binCentersDV();
            double[] yy = ddY == null ? TableUtil.getYTagArrayDouble(source, 0, source.getYUnits()) : ddY.binCenters();
            int itable0 = -1;
            int guess = 0;
            for (int i = 0; i < this.imap.length; ++i) {
                int j;
                int itable;
                this.imap[i] = DataSetUtil.closestColumn((DataSet)source, xx.get(i), guess);
                guess = this.imap[i];
                Datum xclose = source.getXTagDatum(this.imap[i]);
                Units xunits = xTagWidth.getUnits();
                if (Math.abs(xclose.subtract(xx.get(i)).doubleValue(xunits)) > xTagWidth.doubleValue(xunits) / 1.9) {
                    this.imap[i] = -1;
                    continue;
                }
                this.itableMap[i] = itable = source.tableOfIndex(this.imap[i]);
                if (itable0 == itable) continue;
                if (ddY == null) {
                    for (j = 0; j < this.jmap[itable].length; ++j) {
                        this.jmap[itable][j] = j;
                    }
                } else {
                    for (j = 0; j < this.jmap[itable].length; ++j) {
                        this.jmap[itable][j] = TableUtil.closestRow(source, itable, yy[j], ddY.getUnits());
                        Units yunits = yTagWidth.getUnits();
                        if (UnitsUtil.isRatiometric(yunits)) {
                            double yclose = source.getYTagDouble(itable, this.jmap[itable][j], ddY.getUnits());
                            if (!(Math.abs(Math.log(yy[j] / yclose)) > yTagWidth.doubleValue(Units.logERatio) / 1.9)) continue;
                            this.jmap[itable][j] = -1;
                            continue;
                        }
                        Datum yclose = source.getYTagDatum(itable, this.jmap[itable][j]);
                        if (!(Math.abs(yclose.subtract(yy[j], ddY.getUnits()).doubleValue(yunits)) > yTagWidth.doubleValue(yunits) / 1.9)) continue;
                        this.jmap[itable][j] = -1;
                    }
                }
                itable0 = itable;
            }
        }
    }

    public Datum getDatum(int i, int j) {
        if (this.imap[i] != -1 && this.jmap[this.itableMap[i]][j] != -1) {
            return this.source.getDatum(this.imap[i], this.jmap[this.itableMap[i]][j]);
        }
        return this.source.getZUnits().createDatum(this.source.getZUnits().getFillDouble());
    }

    public double getDouble(int i, int j, Units units) {
        try {
            if (this.imap[i] != -1 && this.jmap[this.itableMap[i]][j] != -1) {
                return this.source.getDouble(this.imap[i], this.jmap[this.itableMap[i]][j], units);
            }
            return this.source.getZUnits().getFillDouble();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            System.err.println("here: " + e);
            throw new RuntimeException(e);
        }
    }

    public int getInt(int i, int j, Units units) {
        if (this.imap[i] != -1 && this.jmap[this.itableMap[i]][j] != -1) {
            return this.source.getInt(this.imap[i], this.jmap[this.itableMap[i]][j], units);
        }
        return this.source.getZUnits().getFillInt();
    }

    public DataSet getPlanarView(String planeID) {
        TableDataSet ds = (TableDataSet)this.source.getPlanarView(planeID);
        if (ds != null) {
            return new NearestNeighborTableDataSet(ds, this.ddX, this.ddY);
        }
        return null;
    }

    public String[] getPlaneIds() {
        return this.source.getPlaneIds();
    }

    public Object getProperty(String name) {
        return this.source.getProperty(name);
    }

    public Map getProperties() {
        return this.source.getProperties();
    }

    public int getXLength() {
        return this.imap.length;
    }

    public VectorDataSet getXSlice(int i) {
        return new XSliceDataSet(this, i);
    }

    public VectorDataSet getYSlice(int j, int table) {
        return new YSliceDataSet(this, j, table);
    }

    public Datum getXTagDatum(int i) {
        return this.ddX.getUnits().createDatum(this.getXTagDouble(i, this.ddX.getUnits()));
    }

    public double getXTagDouble(int i, Units units) {
        return this.ddX.binCenter(i, units);
    }

    public int getXTagInt(int i, Units units) {
        return (int)this.getXTagDouble(i, units);
    }

    public Units getXUnits() {
        return this.ddX.getUnits();
    }

    public int getYLength(int table) {
        if (this.ddY == null) {
            return this.source.getYLength(table);
        }
        return this.ddY.numberOfBins();
    }

    public Datum getYTagDatum(int table, int j) {
        if (this.ddY == null) {
            return this.source.getYTagDatum(table, j);
        }
        return this.ddY.getUnits().createDatum(this.getYTagDouble(table, j, this.ddY.getUnits()));
    }

    public double getYTagDouble(int table, int j, Units units) {
        if (this.ddY == null) {
            return this.source.getYTagDouble(table, j, units);
        }
        return this.ddY.binCenter(j, units);
    }

    public int getYTagInt(int table, int j, Units units) {
        return (int)this.getYTagDouble(table, j, units);
    }

    public Units getYUnits() {
        if (this.ddY == null) {
            return this.source.getYUnits();
        }
        return this.ddY.getUnits();
    }

    public Units getZUnits() {
        return this.source.getZUnits();
    }

    public int tableCount() {
        return 1;
    }

    public int tableEnd(int table) {
        return this.ddX.numberOfBins();
    }

    public int tableOfIndex(int i) {
        return 0;
    }

    public int tableStart(int table) {
        return 0;
    }

    public String toString() {
        return "NearestNeighborTableDataSet " + TableUtil.toString(this);
    }

    public double[] getDoubleScan(int i, Units units) {
        int yLength = this.getYLength(this.tableOfIndex(i));
        double[] array = new double[yLength];
        for (int j = 0; j < yLength; ++j) {
            array[j] = this.getDouble(i, j, units);
        }
        return array;
    }

    public DatumVector getScan(int i) {
        Units zUnits = this.getZUnits();
        return DatumVector.newDatumVector(this.getDoubleScan(i, zUnits), zUnits);
    }

    public DatumVector getYTags(int table) {
        double[] tags = new double[this.getYLength(table)];
        Units yUnits = this.getYUnits();
        for (int j = 0; j < tags.length; ++j) {
            tags[j] = this.getYTagDouble(table, j, yUnits);
        }
        return DatumVector.newDatumVector(tags, yUnits);
    }

    public Object getProperty(int table, String name) {
        return this.getProperty(name);
    }
}

