/*
 * Decompiled with CFR 0.152.
 */
package org.das2.dataset;

import org.das2.dataset.QernalTableRebinner;
import org.das2.dataset.RebinDescriptor;
import org.das2.datum.Datum;

public class GenericQernalFactory
implements QernalTableRebinner.QernalFactory {
    public QernalTableRebinner.Qernal getQernal(RebinDescriptor ddx, RebinDescriptor ddy, Datum xTagWidth, Datum yTagWidth) {
        double[][] qernal = new double[5][5];
        qernal[1][4] = 1.0;
        qernal[3][4] = 1.0;
        qernal[0][1] = 1.0;
        qernal[4][1] = 1.0;
        qernal[1][0] = 1.0;
        qernal[2][0] = 1.0;
        qernal[3][0] = 1.0;
        return new GenericQernal(qernal, 2, 2, ddx.numberOfBins(), ddy.numberOfBins());
    }

    class GenericQernal
    implements QernalTableRebinner.Qernal {
        double[][] qernal;
        int dx0;
        int dx1;
        int dy0;
        int dy1;
        int nx;
        int ny;

        GenericQernal(double[][] qernal, int dx0, int dy0, int nx, int ny) {
            this.qernal = qernal;
            this.dx0 = dx0;
            this.dy0 = dy0;
            this.dy1 = qernal[0].length - dy0 - 1;
            this.dx1 = qernal.length - dx0 - 1;
            this.nx = nx;
            this.ny = ny;
        }

        public void apply(int x, int y, double value, double weight, double[][] ss, double[][] ww) {
            int x0 = x - this.dx0;
            int x1 = x + this.dx1 + 1;
            int y0 = y - this.dy0;
            int y1 = y + this.dy1 + 1;
            if (x0 < 0) {
                x0 = 0;
            } else if (x0 > this.nx) {
                x0 = this.nx;
            }
            if (x1 < 0) {
                x1 = 0;
            } else if (x1 > this.nx) {
                x1 = this.nx;
            }
            if (y0 < 0) {
                y0 = 0;
            } else if (y0 > this.ny) {
                y0 = this.ny;
            }
            if (y1 < 0) {
                y1 = 0;
            } else if (y1 > this.ny) {
                y1 = this.ny;
            }
            for (int i = x0; i < x1; ++i) {
                for (int j = y0; j < y1; ++j) {
                    if (!(weight > ww[i][j])) continue;
                    try {
                        double w = weight * this.qernal[i - x + this.dx0][j - y + this.dy0];
                        double[] dArray = ss[i];
                        int n = j;
                        dArray[n] = dArray[n] + value * w;
                        double[] dArray2 = ww[i];
                        int n2 = j;
                        dArray2[n2] = dArray2[n2] + w;
                        continue;
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
    }
}

