/*
 * Decompiled with CFR 0.152.
 */
package org.das2.dataset;

import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.das2.dataset.AbstractDataSet;
import org.das2.dataset.AbstractVectorDataSet;
import org.das2.dataset.DataSet;
import org.das2.dataset.VectorDataSet;
import org.das2.dataset.VectorUtil;
import org.das2.datum.Datum;
import org.das2.datum.Units;

public final class DefaultVectorDataSet
extends AbstractVectorDataSet
implements DataSet,
VectorDataSet {
    private double[][] yValues;
    private String[] planeIDs;
    private Units[] yUnits;

    public DefaultVectorDataSet(double[] xTags, Units xUnits, double[] yValues, Units yUnits, Map properties) {
        this(xTags, xUnits, yValues, yUnits, null, null, properties);
    }

    public DefaultVectorDataSet(double[] xTags, Units xUnits, double[] yValues, Units yUnits, Map yValuesMap, Map yUnitsMap, Map properties) {
        super(xTags, xUnits, yUnits, properties);
        if (yValuesMap == null ^ yUnitsMap == null) {
            throw new IllegalArgumentException("yValuesMap == null ^ yUnitsMap == null");
        }
        if (yValuesMap != null) {
            if (!((Object)yValuesMap.keySet()).equals(yUnitsMap.keySet())) {
                throw new IllegalArgumentException("mismatched keySets for yValuesMap and yUnitsMap");
            }
            Iterator it = yValuesMap.keySet().iterator();
            while (it.hasNext()) {
                if (it.next() instanceof String) continue;
                throw new IllegalArgumentException("Non-String key found in yValuesMap");
            }
        }
        int planeCount = 1 + (yValuesMap == null ? 0 : yValuesMap.size());
        this.yValues = new double[planeCount][];
        this.yValues[0] = (double[])yValues.clone();
        this.planeIDs = new String[planeCount];
        this.planeIDs[0] = "";
        this.yUnits = new Units[planeCount];
        this.yUnits[0] = yUnits;
        if (yValuesMap != null) {
            int index = 1;
            for (Map.Entry entry : new TreeMap(yValuesMap).entrySet()) {
                String id = (String)entry.getKey();
                double[] values = (double[])entry.getValue();
                this.planeIDs[index] = id;
                this.yValues[index] = (double[])values.clone();
                this.yUnits[index] = (Units)yUnitsMap.get(id);
            }
        }
    }

    DefaultVectorDataSet(double[] xTags, Units xUnits, double[][] yValues, Units[] yUnits, String[] planeIDs, Map properties) {
        super(xTags, xUnits, yUnits[0], properties);
        this.yValues = yValues;
        this.yUnits = yUnits;
        this.planeIDs = planeIDs;
    }

    public Datum getDatum(int i) {
        return Datum.create(this.yValues[0][i], this.getYUnits());
    }

    public double getDouble(int i, Units units) {
        if (this.yUnits[0].isFill(this.yValues[0][i])) {
            return units.getFillDouble();
        }
        return this.getYUnits().getConverter(units).convert(this.yValues[0][i]);
    }

    public int getInt(int i, Units units) {
        return (int)Math.round(this.getDouble(i, units));
    }

    public DataSet getPlanarView(String planeID) {
        int index = -1;
        for (int i = 0; i < this.planeIDs.length; ++i) {
            if (!this.planeIDs[i].equals(planeID)) continue;
            index = i;
            break;
        }
        if (index == -1) {
            return null;
        }
        return new PlanarViewDataSet(index);
    }

    public String[] getPlaneIds() {
        String[] result = new String[this.planeIDs.length];
        System.arraycopy(this.planeIDs, 0, result, 0, this.planeIDs.length);
        return result;
    }

    private class PlanarViewDataSet
    extends AbstractDataSet.ViewDataSet
    implements VectorDataSet {
        private final int index;

        private PlanarViewDataSet(int index) {
            super(DefaultVectorDataSet.this);
            this.index = index;
        }

        public Datum getDatum(int i) {
            return Datum.create(DefaultVectorDataSet.this.yValues[this.index][i], DefaultVectorDataSet.this.yUnits[this.index]);
        }

        public double getDouble(int i, Units units) {
            return DefaultVectorDataSet.this.yUnits[this.index].getConverter(units).convert(DefaultVectorDataSet.this.yValues[this.index][i]);
        }

        public int getInt(int i, Units units) {
            return (int)Math.round(this.getDouble(i, units));
        }

        public Units getYUnits() {
            return DefaultVectorDataSet.this.yUnits[this.index];
        }

        public DataSet getPlanarView(String planeID) {
            PlanarViewDataSet result;
            DataSet dataSet = result = planeID.equals("") ? this : DefaultVectorDataSet.this.getPlanarView(planeID);
            if (result == null) {
                return DefaultVectorDataSet.this.getPlanarView(DefaultVectorDataSet.this.planeIDs[this.index] + "." + planeID);
            }
            return result;
        }

        public String[] getPlaneIds() {
            return new String[0];
        }

        public Object getProperty(String name) {
            Object result = DefaultVectorDataSet.this.getProperty(DefaultVectorDataSet.this.planeIDs[this.index] + "." + name);
            if (result == null) {
                result = DefaultVectorDataSet.this.getProperty(name);
            }
            return result;
        }

        public String toString() {
            return "DefaultVectorDataSet(" + DefaultVectorDataSet.this.planeIDs[this.index] + ") " + VectorUtil.toString(this);
        }
    }
}

