/*
 * Decompiled with CFR 0.152.
 */
package org.das2.dataset;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.das2.DasException;
import org.das2.dataset.DataSet;
import org.das2.dataset.DataSetRebinner;
import org.das2.dataset.DataSetUtil;
import org.das2.dataset.DefaultTableDataSet;
import org.das2.dataset.RebinDescriptor;
import org.das2.dataset.TableDataSet;
import org.das2.dataset.TableUtil;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumVector;
import org.das2.datum.Units;
import org.das2.datum.UnitsUtil;
import org.das2.system.DasLogger;
import org.das2.util.DasMath;

public class AverageNoInterpolateTableRebinner
implements DataSetRebinner {
    Logger logger;
    boolean nearestNeighbor = false;

    private static DatumRange[] getXTagRanges(DataSet ds, int i0, int i1) {
        Datum tagWidth = DataSetUtil.guessXTagWidth(ds).divide(2.0);
        DatumRange[] result = new DatumRange[i1 - i0];
        for (int i = 0; i < i1 - i0; ++i) {
            Datum d = ds.getXTagDatum(i + i0);
            result[i] = new DatumRange(d.subtract(tagWidth), d.add(tagWidth));
        }
        return result;
    }

    private static DatumRange[] getLogYTagRanges(TableDataSet ds, int itable) {
        Datum tagWidth = TableUtil.guessYTagWidth(ds, itable);
        double ratio = DasMath.exp10(tagWidth.doubleValue(Units.log10Ratio) / 2.0);
        Units units = ds.getYUnits();
        DatumRange[] result = new DatumRange[ds.getYLength(itable)];
        for (int i = 0; i < result.length; ++i) {
            Datum d = ds.getYTagDatum(itable, i);
            double dd = d.doubleValue(d.getUnits());
            result[i] = new DatumRange(dd / ratio, dd * ratio, units);
        }
        return result;
    }

    private static DatumRange[] getYTagRanges(TableDataSet ds, int itable) {
        Datum tagWidth = TableUtil.guessYTagWidth(ds, itable).divide(2.0);
        boolean isLog = UnitsUtil.isRatiometric(tagWidth.getUnits());
        if (isLog) {
            return AverageNoInterpolateTableRebinner.getLogYTagRanges(ds, itable);
        }
        DatumRange[] result = new DatumRange[ds.getYLength(itable)];
        for (int i = 0; i < result.length; ++i) {
            Datum d = ds.getYTagDatum(itable, i);
            result[i] = new DatumRange(d.subtract(tagWidth), d.add(tagWidth));
        }
        return result;
    }

    private static DatumRange[] getBinRanges(RebinDescriptor ddx) {
        DatumRange[] result = new DatumRange[ddx.numberOfBins()];
        for (int i = 0; i < ddx.numberOfBins(); ++i) {
            result[i] = new DatumRange(ddx.binStart(i), ddx.binStop(i));
        }
        return result;
    }

    private static BinDescriptor getIdentityBinDescriptor(int size) {
        int n = size;
        int[] inputBin = new int[n];
        int[] outputBin = new int[n];
        double[] weights = new double[n];
        for (int i = 0; i < n; ++i) {
            inputBin[i] = i;
            outputBin[i] = i;
            weights[i] = 1.0;
        }
        BinDescriptor result = new BinDescriptor();
        result.inputBins = inputBin;
        result.outputBins = outputBin;
        result.length = n;
        result.weights = weights;
        return result;
    }

    private static BinDescriptor calcBinDescriptor(DatumRange[] inRanges, DatumRange[] outRanges) {
        int guessCap = inRanges.length + outRanges.length;
        ArrayList<Integer> inBinList = new ArrayList<Integer>(guessCap);
        ArrayList<Integer> outBinList = new ArrayList<Integer>(guessCap);
        ArrayList<Datum> weightList = new ArrayList<Datum>(guessCap);
        int inIdx = 0;
        int outIdx = 0;
        DatumRange inRange = inRanges[inIdx];
        DatumRange outRange = outRanges[outIdx];
        boolean done = false;
        while (!done) {
            if (inRanges[inIdx].intersects(outRanges[outIdx])) {
                inBinList.add(new Integer(inIdx));
                outBinList.add(new Integer(outIdx));
                DatumRange intersection = inRanges[inIdx].intersection(outRanges[outIdx]);
                weightList.add(intersection.width().divide(outRanges[outIdx].width()));
            }
            if (inRanges[inIdx].max().lt(outRanges[outIdx].max())) {
                if (inIdx < inRanges.length - 1) {
                    ++inIdx;
                    continue;
                }
                done = true;
                continue;
            }
            if (outIdx < outRanges.length - 1) {
                ++outIdx;
                continue;
            }
            done = true;
        }
        int n = inBinList.size();
        int[] inputBin = new int[n];
        int[] outputBin = new int[n];
        double[] weights = new double[n];
        for (int i = 0; i < n; ++i) {
            inputBin[i] = (Integer)inBinList.get(i);
            outputBin[i] = (Integer)outBinList.get(i);
            weights[i] = ((Datum)weightList.get(i)).doubleValue(Units.dimensionless);
        }
        BinDescriptor result = new BinDescriptor();
        result.inputBins = inputBin;
        result.outputBins = outputBin;
        result.weights = weights;
        result.length = weights.length;
        return result;
    }

    public DataSet rebin(DataSet ds, RebinDescriptor ddx, RebinDescriptor ddy) throws IllegalArgumentException, DasException {
        Object yTags;
        double[] xTags;
        this.logger = DasLogger.getLogger(DasLogger.DATA_OPERATIONS_LOG);
        this.logger.finest("enter AverageNoInterpolateTableRebinner.rebin");
        this.logger.finest("get RebinDescriptor ranges");
        DatumRange[] xoutRanges = AverageNoInterpolateTableRebinner.getBinRanges(ddx);
        TableDataSet tds = (TableDataSet)ds;
        TableDataSet wds = (TableDataSet)ds.getPlanarView("weights");
        Units units = tds.getZUnits();
        int nx = ddx.numberOfBins();
        int ny = ddy == null ? tds.getYLength(0) : ddy.numberOfBins();
        double[][] sum = new double[nx][ny];
        double[][] weights = new double[nx][ny];
        HashMap ybinDescriptors = new HashMap();
        DatumRange[] youtRanges = null;
        if (ddy != null) {
            this.logger.finest("get Y RebinDescriptor ranges");
            youtRanges = AverageNoInterpolateTableRebinner.getBinRanges(ddy);
        }
        for (int itable = 0; itable < tds.tableCount(); ++itable) {
            double w2;
            double w;
            double z;
            int j;
            int i;
            BinDescriptor ybd;
            this.logger.finest("get xtag ranges");
            DatumRange[] inRanges = AverageNoInterpolateTableRebinner.getXTagRanges(tds, tds.tableStart(itable), tds.tableEnd(itable));
            if (itable == 153) {
                System.err.println("itable=" + itable);
            }
            this.logger.finest("calc X bin descriptor");
            BinDescriptor xbd = AverageNoInterpolateTableRebinner.calcBinDescriptor(inRanges, xoutRanges);
            this.logger.finest("get YTag Ranges");
            if (ddy != null) {
                DatumVector dv = tds.getYTags(itable);
                if (ybinDescriptors.containsKey(dv)) {
                    ybd = (BinDescriptor)ybinDescriptors.get(dv);
                } else {
                    inRanges = AverageNoInterpolateTableRebinner.getYTagRanges(tds, itable);
                    this.logger.finest("calc Y bin descriptor");
                    ybd = AverageNoInterpolateTableRebinner.calcBinDescriptor(inRanges, youtRanges);
                }
            } else {
                if (itable > 1) {
                    throw new IllegalArgumentException("null yRebinDescriptor not allowed for non-simple table datasets.");
                }
                ybd = AverageNoInterpolateTableRebinner.getIdentityBinDescriptor(tds.getYLength(itable));
            }
            this.logger.finest("apply rebinning");
            this.logger.finest("ybd.length=" + ybd.length);
            int x0 = tds.tableStart(itable);
            if (this.nearestNeighbor) {
                for (i = 0; i < xbd.length; ++i) {
                    for (j = 0; j < ybd.length; ++j) {
                        z = tds.getDouble(xbd.inputBins[i] + x0, ybd.inputBins[j], units);
                        w = xbd.weights[i] * ybd.weights[j];
                        double d = wds == null ? (units.isFill(z) ? 0.0 : 1.0) : (w2 = wds.getDouble(xbd.inputBins[i] + x0, ybd.inputBins[j], Units.dimensionless));
                        if (!(w * w2 > weights[xbd.outputBins[i]][ybd.outputBins[j]])) continue;
                        sum[xbd.outputBins[i]][ybd.outputBins[j]] = z;
                        weights[xbd.outputBins[i]][ybd.outputBins[j]] = w * w2;
                    }
                }
                continue;
            }
            for (i = 0; i < xbd.length; ++i) {
                for (j = 0; j < ybd.length; ++j) {
                    z = tds.getDouble(xbd.inputBins[i] + x0, ybd.inputBins[j], units);
                    w = xbd.weights[i] * ybd.weights[j];
                    w2 = wds == null ? (units.isFill(z) ? 0.0 : 1.0) : wds.getDouble(xbd.inputBins[i] + x0, ybd.inputBins[j], Units.dimensionless);
                    try {
                        double[] dArray = sum[xbd.outputBins[i]];
                        int n = ybd.outputBins[j];
                        dArray[n] = dArray[n] + w * w2 * z;
                        double[] dArray2 = weights[xbd.outputBins[i]];
                        int n2 = ybd.outputBins[j];
                        dArray2[n2] = dArray2[n2] + w * w2;
                        continue;
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
        double fill = tds.getZUnits().getFillDouble();
        if (!this.nearestNeighbor) {
            this.logger.finest("normalize");
            for (int i = 0; i < nx; ++i) {
                for (int j = 0; j < ny; ++j) {
                    if (weights[i][j] > 0.0) {
                        double[] dArray = sum[i];
                        int n = j;
                        dArray[n] = dArray[n] / weights[i][j];
                        continue;
                    }
                    sum[i][j] = fill;
                }
            }
        }
        this.logger.finest("calculate dataset");
        double[][][] zValues = new double[][][]{sum, weights};
        int[] tableOffsets = new int[]{0};
        Units[] zUnits = new Units[]{tds.getZUnits(), Units.dimensionless};
        String[] planeIDs = new String[]{"", "weights"};
        HashMap<String, Datum> properties = new HashMap<String, Datum>(ds.getProperties());
        if (ddx != null) {
            properties.put("xTagWidth", ddx.binWidthDatum());
        }
        if (ddy != null) {
            properties.put("yTagWidth", ddy.binWidthDatum());
        }
        if (ddx != null) {
            xTags = ddx.binCenters();
        } else {
            xTags = new double[nx];
            for (int i = 0; i < nx; ++i) {
                xTags[i] = tds.getXTagDouble(i, tds.getXUnits());
            }
        }
        if (ddy != null) {
            yTags = new double[][]{ddy.binCenters()};
        } else {
            yTags = new double[1][ny];
            for (int j = 0; j < ny; ++j) {
                yTags[0][j] = tds.getYTagDouble(0, j, tds.getYUnits());
            }
        }
        DefaultTableDataSet result = new DefaultTableDataSet(xTags, ddx.getUnits(), (double[][])yTags, ddy.getUnits(), (double[][][])zValues, zUnits, planeIDs, tableOffsets, (Map)properties);
        this.logger.finest("done, exiting AverageNoInterpolateTableRebinner.rebin");
        return result;
    }

    public boolean isNearestNeighbor() {
        return this.nearestNeighbor;
    }

    public void setNearestNeighbor(boolean v) {
        this.nearestNeighbor = v;
    }

    static class BinDescriptor {
        int length;
        int[] inputBins;
        int[] outputBins;
        double[] weights;

        BinDescriptor() {
        }

        public String toString() {
            StringBuffer result = new StringBuffer();
            int ll = this.length < 30 ? this.length : 30;
            for (int i = 0; i < ll; ++i) {
                result.append("" + this.inputBins[i] + " * " + this.weights[i] + " -> " + this.outputBins[i] + "\n");
            }
            if (this.length == 0) {
                result.append("(no rebinning)\n");
            } else if (this.length > 30) {
                result.append("(" + (this.length - 30) + " more)");
            }
            return result.toString();
        }
    }
}

