/*
 * Decompiled with CFR 0.152.
 */
package org.das2.dasml;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.ParseException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.das2.beans.AccessLevelBeanInfo;
import org.das2.beans.BeansUtil;
import org.das2.graph.DasCanvasComponent;
import org.das2.system.DasLogger;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SerializeUtil {
    static Set toStringSet = new HashSet();

    public static Element getDOMElement(Document document, Object object) {
        return SerializeUtil.getDOMElement(document, object, new NullProgressMonitor());
    }

    public static Element getDOMElement(Document document, Object object, ProgressMonitor monitor) {
        Logger log = DasLogger.getLogger(DasLogger.SYSTEM_LOG);
        try {
            String elementName = object.getClass().getName();
            elementName = elementName.replaceAll("\\$", "\\_dollar_");
            Element element = null;
            try {
                element = document.createElement(elementName);
            }
            catch (Exception e) {
                System.err.println(e);
                throw new RuntimeException(e);
            }
            BeanInfo info = BeansUtil.getBeanInfo(object.getClass());
            AccessLevelBeanInfo alInfo = BeansUtil.asAccessLevelBeanInfo(info, object.getClass());
            PropertyDescriptor[] properties = alInfo.getPropertyDescriptors(AccessLevelBeanInfo.PersistenceLevel.PERSISTENT);
            String[] propertyNameList = BeansUtil.getPropertyNames(properties);
            HashMap<String, PropertyDescriptor> nameMap = new HashMap<String, PropertyDescriptor>();
            for (int i = 0; i < properties.length; ++i) {
                nameMap.put(properties[i].getName(), properties[i]);
            }
            HashMap serializedObjects = new HashMap();
            if (propertyNameList.length > 0) {
                monitor.setTaskSize(propertyNameList.length);
            }
            monitor.started();
            for (int i = 0; i < propertyNameList.length; ++i) {
                Element propertyElement;
                PropertyDescriptor pd;
                monitor.setTaskProgress(i);
                String propertyName = propertyNameList[i];
                log.fine("serializing property " + propertyName + " of " + elementName);
                if (propertyName.equals("parent")) {
                    log.fine("kludge to avoid cycles in bean graph due to parent property, ignoring");
                }
                if ((pd = (PropertyDescriptor)nameMap.get(propertyName)) == null) {
                    log.warning("unable to locate property: " + propertyName + ", ignoring");
                    continue;
                }
                Method readMethod = pd.getReadMethod();
                if (readMethod == null) {
                    log.fine("skipping property " + propertyName + " of " + elementName + ", failed to find read method.");
                    continue;
                }
                Method writeMethod = pd.getWriteMethod();
                Object value = readMethod.invoke(object, new Object[0]);
                if (value == null) {
                    log.fine("skipping property " + propertyName + " of " + elementName + ", value is null.");
                    continue;
                }
                PropertyEditor editor = BeansUtil.getEditor(pd);
                String textValue = null;
                if (editor != null) {
                    editor.setValue(value);
                    textValue = editor.getAsText();
                }
                if (textValue != null) {
                    if (writeMethod == null) continue;
                    element.setAttribute(propertyName, textValue);
                    continue;
                }
                if (value instanceof DasCanvasComponent) {
                    DasCanvasComponent dcc = (DasCanvasComponent)value;
                    if (serializedObjects.containsKey(dcc.getDasName())) {
                        element.setAttribute(propertyName, dcc.getDasName());
                        continue;
                    }
                    Element propertyElement2 = document.createElement(propertyName);
                    Element child = SerializeUtil.getDOMElement(document, value, new NullProgressMonitor());
                    propertyElement2.appendChild(child);
                    element.appendChild(propertyElement2);
                    serializedObjects.put(dcc.getDasName(), null);
                    continue;
                }
                if (value.getClass().isArray()) {
                    propertyElement = document.createElement(propertyName);
                    for (int j = 0; j < Array.getLength(value); ++j) {
                        Object value1 = Array.get(value, j);
                        Element child = SerializeUtil.getDOMElement(document, value1, new NullProgressMonitor());
                        propertyElement.appendChild(child);
                    }
                    element.appendChild(propertyElement);
                    continue;
                }
                propertyElement = document.createElement(propertyName);
                Element child = SerializeUtil.getDOMElement(document, value, new NullProgressMonitor());
                propertyElement.appendChild(child);
                element.appendChild(propertyElement);
            }
            monitor.finished();
            return element;
        }
        catch (IntrospectionException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private static void processNode(Node node, Object object, String className, Map nameMap) throws IllegalAccessException, ParseException, InvocationTargetException {
        Logger log = DasLogger.getLogger(DasLogger.SYSTEM_LOG);
        String propertyName = node.getNodeName();
        PropertyDescriptor pd = (PropertyDescriptor)nameMap.get(propertyName);
        if (pd == null) {
            log.warning("unable to locate property: " + propertyName + " of " + className + ", ignoring");
            return;
        }
        Method readMethod = pd.getReadMethod();
        Object value = readMethod.invoke(object, new Object[0]);
        PropertyEditor editor = BeansUtil.getEditor(pd);
        String textValue = null;
        if (editor != null) {
            editor.setValue(value);
            textValue = editor.getAsText();
        }
        if (textValue != null) {
            Attr attr = (Attr)node;
            String newTextValue = attr.getValue();
            editor.setAsText(newTextValue);
            Method writeMethod = pd.getWriteMethod();
            if (writeMethod == null) {
                log.warning("read-only property \"" + propertyName + "\" of " + className + " ignored");
                return;
            }
            Object newValue = editor.getValue();
            if (propertyName.equals("dataSetID")) {
                log.fine("kludge to avoid setting dataSetID to null, ignoring");
            }
            if (propertyName.equals("dataSetID") && (value == null || value.equals(""))) {
                log.fine("kludge to avoid setting dataSetID to null, ignoring");
                return;
            }
            writeMethod.invoke(object, newValue);
        } else if (value instanceof DasCanvasComponent) {
            Node propertyNode;
            DasCanvasComponent dcc = (DasCanvasComponent)value;
            for (propertyNode = node.getFirstChild(); propertyNode != null && propertyNode.getNodeType() != 1 && propertyNode.getNodeType() != 3; propertyNode = propertyNode.getNextSibling()) {
            }
            if (propertyNode == null) {
                throw new IllegalStateException("expected element node under " + propertyName);
            }
            if (propertyNode.getNodeType() == 3) {
                return;
            }
            Element propertyElement = (Element)propertyNode;
            SerializeUtil.processElement(propertyElement, value);
        } else if (value.getClass().isArray()) {
            int j = 0;
            for (Node propertyNode = node.getFirstChild(); propertyNode != null; propertyNode = propertyNode.getNextSibling()) {
                while (propertyNode != null && propertyNode.getNodeType() != 1) {
                    propertyNode = propertyNode.getNextSibling();
                }
                if (propertyNode != null) {
                    Element propertyElement = (Element)propertyNode;
                    Object value1 = Array.get(value, j);
                    SerializeUtil.processElement(propertyElement, value1);
                    ++j;
                    continue;
                }
                break;
            }
        } else {
            Node propertyNode;
            for (propertyNode = node.getFirstChild(); propertyNode != null && propertyNode.getNodeType() != 1 && propertyNode.getNodeType() != 3; propertyNode = propertyNode.getNextSibling()) {
            }
            if (propertyNode == null) {
                throw new IllegalStateException("expected element node under " + propertyName);
            }
            if (propertyNode.getNodeType() == 3) {
                return;
            }
            Element propertyElement = (Element)propertyNode;
            SerializeUtil.processElement(propertyElement, value);
        }
    }

    public static void processElement(Element element, Object object) {
        Logger log = DasLogger.getLogger(DasLogger.SYSTEM_LOG);
        try {
            String elementName = element.getTagName();
            elementName = elementName.replaceAll("\\_dollar_", "\\$");
            log.fine("handling " + elementName);
            if (!object.getClass().getName().equals(elementName)) {
                throw new IllegalArgumentException("class name doesn't match: expected " + object.getClass().getName() + ", got " + elementName);
            }
            AccessLevelBeanInfo info = BeansUtil.asAccessLevelBeanInfo(BeansUtil.getBeanInfo(object.getClass()), object.getClass());
            PropertyDescriptor[] properties = info.getPropertyDescriptors(AccessLevelBeanInfo.PersistenceLevel.PERSISTENT);
            String[] propertyNameList = BeansUtil.getPropertyNames(object.getClass());
            HashMap<String, PropertyDescriptor> nameMap = new HashMap<String, PropertyDescriptor>();
            for (int i = 0; i < properties.length; ++i) {
                nameMap.put(properties[i].getName(), properties[i]);
            }
            HashMap serializedObjects = new HashMap();
            NamedNodeMap attrs = element.getAttributes();
            for (int i = 0; i < attrs.getLength(); ++i) {
                Node node = attrs.item(i);
                log.finer("attr: " + node.getNodeType() + "  " + node.getNodeName());
                SerializeUtil.processNode(node, object, elementName, nameMap);
            }
            NodeList children = element.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node node = children.item(i);
                if (node.getNodeType() != 1) continue;
                SerializeUtil.processNode(node, object, elementName, nameMap);
            }
        }
        catch (IntrospectionException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        toStringSet.add(Boolean.class);
        toStringSet.add(Short.class);
        toStringSet.add(Integer.class);
        toStringSet.add(Long.class);
        toStringSet.add(Float.class);
        toStringSet.add(Double.class);
        toStringSet.add(String.class);
    }
}

