/*
 * Decompiled with CFR 0.152.
 */
package org.das2.dasml;

import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.text.ParseException;
import java.util.Arrays;
import javax.swing.BoxLayout;
import org.das2.DasException;
import org.das2.components.propertyeditor.Editable;
import org.das2.dasml.FormBase;
import org.das2.dasml.FormButton;
import org.das2.dasml.FormCheckBox;
import org.das2.dasml.FormChoice;
import org.das2.dasml.FormComponent;
import org.das2.dasml.FormContainer;
import org.das2.dasml.FormList;
import org.das2.dasml.FormRadioButtonGroup;
import org.das2.dasml.FormText;
import org.das2.dasml.FormTextField;
import org.das2.dasml.ParsedExpressionException;
import org.das2.dasml.TransferableFormComponent;
import org.das2.graph.DasCanvas;
import org.das2.graph.dnd.TransferableCanvas;
import org.das2.util.DnDSupport;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class FormPanel
extends FormContainer
implements Editable,
FormComponent {
    public FormPanel() {
        DataFlavor[] flavors = new DataFlavor[]{TransferableFormComponent.BUTTONGROUP_FLAVOR, TransferableFormComponent.BUTTON_FLAVOR, TransferableFormComponent.CHECKBOX_FLAVOR, TransferableFormComponent.CHOICE_FLAVOR, TransferableFormComponent.PANEL_FLAVOR, TransferableFormComponent.TEXTFIELD_FLAVOR, TransferableFormComponent.TEXT_FLAVOR, TransferableCanvas.CANVAS_FLAVOR};
        this.flavorList = Arrays.asList(flavors);
        this.setLayout(new BoxLayout(this, 0));
        this.setBorder(new FormContainer.NoBorder());
    }

    FormPanel(Element element, FormBase form) throws DasException, ParsedExpressionException, SAXException, ParseException {
        DataFlavor[] flavors = new DataFlavor[]{TransferableFormComponent.BUTTONGROUP_FLAVOR, TransferableFormComponent.BUTTON_FLAVOR, TransferableFormComponent.CHECKBOX_FLAVOR, TransferableFormComponent.CHOICE_FLAVOR, TransferableFormComponent.PANEL_FLAVOR, TransferableFormComponent.TEXTFIELD_FLAVOR, TransferableFormComponent.TEXT_FLAVOR, TransferableCanvas.CANVAS_FLAVOR};
        this.flavorList = Arrays.asList(flavors);
        String alignment = element.getAttribute("alignment");
        this.horizontalComponentAlignment = alignment.equals("left") ? 0.0f : (alignment.equals("right") ? 1.0f : 0.5f);
        String direction = element.getAttribute("direction");
        BoxLayout layout = direction.equals("horizontal") ? new BoxLayout(this, 0) : new BoxLayout(this, 1);
        this.setLayout(layout);
        NodeList children = element.getChildNodes();
        int length = children.getLength();
        for (int index = 0; index < length; ++index) {
            Node node = children.item(index);
            if (!(node instanceof Element)) continue;
            String tagName = node.getNodeName();
            if (tagName.equals("panel")) {
                FormPanel p = new FormPanel((Element)node, form);
                this.add(p);
                continue;
            }
            if (tagName.equals("text") || tagName.equals("info")) {
                FormText text = new FormText((Element)node);
                this.add(text);
                continue;
            }
            if (tagName.equals("textfield")) {
                FormTextField textfield = new FormTextField((Element)node, form);
                this.add(textfield);
                continue;
            }
            if (tagName.equals("button")) {
                FormButton button = new FormButton((Element)node, form);
                this.add(button);
                continue;
            }
            if (tagName.equals("checkbox")) {
                FormCheckBox checkbox = new FormCheckBox((Element)node, form);
                this.add(checkbox);
                continue;
            }
            if (tagName.equals("list")) {
                FormList list = new FormList((Element)node, form);
                this.add(list);
                continue;
            }
            if (tagName.equals("choice")) {
                FormChoice choice = new FormChoice((Element)node, form);
                this.add(choice);
                continue;
            }
            if (tagName.equals("glue")) {
                this.add(form.processGlueElement((Element)node));
                continue;
            }
            if (tagName.equals("buttongroup")) {
                this.add(new FormRadioButtonGroup((Element)node, form));
                continue;
            }
            if (!tagName.equals("canvas")) continue;
            DasCanvas canvas = DasCanvas.processCanvasElement((Element)node, form);
            this.add(canvas);
        }
        this.setHasBorder(element.getAttribute("border").equals("true"));
        this.setBorderTitle(element.getAttribute("border-title"));
    }

    public Element getDOMElement(Document document) {
        Element element = document.createElement("panel");
        element.setAttribute("border", Boolean.toString(this.hasBorder()));
        element.setAttribute("border-title", this.getBorderTitle());
        for (int index = 0; index < this.getComponentCount(); ++index) {
            Element child;
            Component comp = this.getComponent(index);
            if (comp instanceof FormComponent) {
                FormComponent formComponent = (FormComponent)((Object)comp);
                child = formComponent.getDOMElement(document);
                element.appendChild(child);
                continue;
            }
            if (!(comp instanceof DasCanvas)) continue;
            DasCanvas canvas = (DasCanvas)comp;
            child = canvas.getDOMElement(document);
            element.appendChild(child);
        }
        return element;
    }

    public DnDSupport getDnDSupport() {
        if (this.dndSupport == null) {
            this.dndSupport = new FormContainer.ContainerDnDSupport(null);
        }
        return this.dndSupport;
    }
}

