/*
 * Decompiled with CFR 0.152.
 */
package org.das2.components.propertyeditor;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.IndexedPropertyDescriptor;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.util.EventObject;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;
import javax.swing.table.TableCellEditor;
import org.das2.beans.BeansUtil;
import org.das2.components.propertyeditor.PropertyTreeNodeInterface;
import org.das2.components.treetable.TreeTableModel;

public class PropertyEditorAdapter
implements TableCellEditor {
    private EventListenerList listenerList = new EventListenerList();
    private PropertyEditor editor;
    private EditorState state;
    private EditorState simple = new SimpleEditor();
    private EditorState custom = new CustomEditor();
    private EditorState cellEditor = new CustomTableCellEditor();

    public void addCellEditorListener(CellEditorListener l) {
        this.listenerList.add(CellEditorListener.class, l);
    }

    public void cancelCellEditing() {
        if (this.state != null) {
            this.state.cancel();
        }
        this.state = null;
        this.fireEditingCanceled();
    }

    public Object getCellEditorValue() {
        return this.editor.getValue();
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean selected, int rowIndex, int columnIndex) {
        TreeTableModel model = (TreeTableModel)table.getModel();
        PropertyTreeNodeInterface node = (PropertyTreeNodeInterface)model.getNodeForRow(rowIndex);
        PropertyDescriptor pd = node.getPropertyDescriptor();
        this.editor = PropertyEditorAdapter.getEditor(pd);
        if (this.editor == null) {
            this.cancelCellEditing();
        } else {
            this.editor.setValue(value);
        }
        this.state = this.editor instanceof TableCellEditor ? this.cellEditor : (this.editor.supportsCustomEditor() ? this.custom : this.simple);
        return this.state.getEditorComponent(table, selected, rowIndex, columnIndex);
    }

    private static PropertyEditor getEditor(PropertyDescriptor pd) {
        PropertyEditor ed;
        block6: {
            if (pd.getPropertyEditorClass() != null) {
                try {
                    Object instance = pd.getPropertyEditorClass().newInstance();
                    if (instance instanceof PropertyEditor) {
                        ed = (PropertyEditor)instance;
                        break block6;
                    }
                    ed = null;
                }
                catch (InstantiationException ie) {
                    ed = null;
                }
                catch (IllegalAccessException iae) {
                    ed = null;
                }
            } else {
                ed = BeansUtil.findEditor(pd instanceof IndexedPropertyDescriptor ? ((IndexedPropertyDescriptor)pd).getIndexedPropertyType() : pd.getPropertyType());
            }
        }
        return ed;
    }

    public boolean isCellEditable(EventObject eventObject) {
        return true;
    }

    public void removeCellEditorListener(CellEditorListener l) {
        this.listenerList.remove(CellEditorListener.class, l);
    }

    public boolean shouldSelectCell(EventObject eventObject) {
        return true;
    }

    public boolean stopCellEditing() {
        boolean stopped = this.state.stop();
        if (stopped) {
            this.fireEditingStopped();
            this.state = null;
        }
        return stopped;
    }

    private void fireEditingCanceled() {
        Class<CellEditorListener> clazz = CellEditorListener.class;
        ChangeEvent e = null;
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = 0; i < listeners.length; i += 2) {
            if (listeners[i] != clazz) continue;
            CellEditorListener l = (CellEditorListener)listeners[i + 1];
            if (e == null) {
                e = new ChangeEvent(this);
            }
            l.editingCanceled(e);
        }
    }

    private void fireEditingStopped() {
        Class<CellEditorListener> clazz = CellEditorListener.class;
        ChangeEvent e = null;
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = 0; i < listeners.length; i += 2) {
            if (listeners[i] != clazz) continue;
            CellEditorListener l = (CellEditorListener)listeners[i + 1];
            if (e == null) {
                e = new ChangeEvent(this);
            }
            l.editingStopped(e);
        }
    }

    private class CustomTableCellEditor
    implements EditorState,
    CellEditorListener {
        private CustomTableCellEditor() {
        }

        public Component getEditorComponent(JTable table, boolean selected, int rowIndex, int columnIndex) {
            TableCellEditor tce = (TableCellEditor)((Object)PropertyEditorAdapter.this.editor);
            Component c = tce.getTableCellEditorComponent(table, PropertyEditorAdapter.this.editor.getValue(), selected, rowIndex, columnIndex);
            tce.addCellEditorListener(this);
            return c;
        }

        public boolean stop() {
            TableCellEditor tce = (TableCellEditor)((Object)PropertyEditorAdapter.this.editor);
            return tce.stopCellEditing();
        }

        public void cancel() {
            TableCellEditor tce = (TableCellEditor)((Object)PropertyEditorAdapter.this.editor);
            tce.cancelCellEditing();
        }

        public void editingStopped(ChangeEvent e) {
            TableCellEditor tce = (TableCellEditor)((Object)PropertyEditorAdapter.this.editor);
            tce.removeCellEditorListener(this);
            PropertyEditorAdapter.this.fireEditingStopped();
        }

        public void editingCanceled(ChangeEvent e) {
            TableCellEditor tce = (TableCellEditor)((Object)PropertyEditorAdapter.this.editor);
            tce.removeCellEditorListener(this);
            PropertyEditorAdapter.this.fireEditingCanceled();
        }
    }

    private class CustomEditor
    implements EditorState,
    ActionListener {
        private JButton button;

        private CustomEditor() {
        }

        public boolean stop() {
            return true;
        }

        public void cancel() {
        }

        public Component getEditorComponent(JTable table, boolean selected, int rowIndex, int columnIndex) {
            this.init();
            String s = PropertyEditorAdapter.this.editor.getAsText();
            if (s == null) {
                s = String.valueOf(PropertyEditorAdapter.this.editor.getValue());
            }
            this.button.setText(s);
            return this.button;
        }

        public void actionPerformed(ActionEvent e) {
            Component customEditor = PropertyEditorAdapter.this.editor.getCustomEditor();
            int result = JOptionPane.showConfirmDialog(this.button, customEditor, "", 2);
            if (result == -1 || result == 2) {
                PropertyEditorAdapter.this.cancelCellEditing();
            } else {
                PropertyEditorAdapter.this.stopCellEditing();
            }
        }

        private void init() {
            if (this.button == null) {
                this.button = new JButton();
                this.button.setBorder(null);
                this.button.addActionListener(this);
            }
        }
    }

    private class SimpleEditor
    implements EditorState,
    ActionListener {
        private JTextField textField;

        private SimpleEditor() {
        }

        public void cancel() {
        }

        public boolean stop() {
            String text = this.textField.getText();
            try {
                PropertyEditorAdapter.this.editor.setAsText(text);
                return true;
            }
            catch (IllegalArgumentException iae) {
                return false;
            }
        }

        public Component getEditorComponent(JTable table, boolean selected, int rowIndex, int columnIndex) {
            this.initTextField();
            this.textField.setText(PropertyEditorAdapter.this.editor.getAsText());
            return this.textField;
        }

        public void actionPerformed(ActionEvent e) {
            PropertyEditorAdapter.this.stopCellEditing();
        }

        private void initTextField() {
            if (this.textField == null) {
                this.textField = new JTextField();
                this.textField.setBorder(null);
                this.textField.addActionListener(this);
            }
        }
    }

    private static interface EditorState {
        public void cancel();

        public boolean stop();

        public Component getEditorComponent(JTable var1, boolean var2, int var3, int var4);
    }
}

