/*
 * Decompiled with CFR 0.152.
 */
package org.das2.components.propertyeditor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringWriter;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.DefaultTreeModel;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.das2.components.propertyeditor.PeerPropertyTreeNode;
import org.das2.components.propertyeditor.PropertyCellRenderer;
import org.das2.components.propertyeditor.PropertyEditorAdapter;
import org.das2.components.propertyeditor.PropertyTreeNode;
import org.das2.components.propertyeditor.PropertyTreeNodeInterface;
import org.das2.components.treetable.TreeTableCellRenderer;
import org.das2.components.treetable.TreeTableModel;
import org.das2.dasml.SerializeUtil;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.graph.DasCanvas;
import org.das2.system.DasLogger;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class PropertyEditor
extends JComponent {
    static final Set editableTypes;
    private JTable table;
    private JButton closeButton;
    private JDialog dialog;
    private Object bean;
    private int focusRow = 0;
    private JPopupMenu popupMenu;
    private Logger logger = DasLogger.getLogger(DasLogger.GUI_LOG);

    private PropertyEditor(PropertyTreeNodeInterface root, Object bean) {
        this.bean = bean;
        this.setLayout(new BorderLayout());
        this.bean = bean;
        DefaultTreeModel treeModel = new DefaultTreeModel(root, true);
        root.setTreeModel(treeModel);
        TreeTableCellRenderer tree = new TreeTableCellRenderer(treeModel);
        tree.setRootVisible(false);
        tree.setShowsRootHandles(true);
        TreeTableModel model = new TreeTableModel(root, tree);
        this.table = new JTable(model);
        this.table.setAutoCreateColumnsFromModel(false);
        this.add((Component)new JScrollPane(this.table, 20, 30), "Center");
        this.initButtonPanel(bean instanceof DasCanvas);
        this.initPopupMenu();
        PropertyCellRenderer valueRenderer = new PropertyCellRenderer();
        PropertyEditorAdapter editor = new PropertyEditorAdapter();
        int cellHeight = 21;
        this.table.setRowHeight(cellHeight);
        tree.setRowHeight(cellHeight);
        tree.setCellRenderer(valueRenderer);
        this.table.getColumnModel().getColumn(0).setCellRenderer(tree);
        this.table.getColumnModel().getColumn(1).setCellRenderer(valueRenderer);
        this.table.getColumnModel().getColumn(0).setMaxWidth(250);
        this.table.getColumnModel().getColumn(0).setPreferredWidth(150);
        this.table.setDefaultEditor(Object.class, editor);
        this.table.addMouseListener(new PropertyTableMouseListener());
        this.table.setSurrendersFocusOnKeystroke(true);
        this.table.addKeyListener(this.getKeyListener());
        this.addActions(this.table);
        this.table.getSelectionModel().addListSelectionListener(this.getListSelectionListener());
    }

    public PropertyEditor(Object bean) {
        this(new PropertyTreeNode(bean), bean);
        if (bean instanceof PropertyTreeNodeInterface) {
            throw new IllegalArgumentException("whoops!");
        }
    }

    public static PropertyEditor createPeersEditor(Object leader, Object[] peers) {
        PropertyTreeNode[] peerNodes = new PropertyTreeNode[peers.length];
        for (int i = 0; i < peers.length; ++i) {
            peerNodes[i] = new PropertyTreeNode(peers[i]);
        }
        PeerPropertyTreeNode root = new PeerPropertyTreeNode(null, new PropertyTreeNode(leader), peerNodes);
        return new PropertyEditor(root, null);
    }

    private void addActions(final JTable table) {
        table.getActionMap().put("MY_EDIT", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                table.editCellAt(PropertyEditor.this.focusRow, 1);
            }
        });
        table.getInputMap().put(KeyStroke.getKeyStroke(10, 0, false), "MY_EDIT");
    }

    private ListSelectionListener getListSelectionListener() {
        return new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                PropertyEditor.this.focusRow = PropertyEditor.this.table.getSelectedRow();
                PropertyEditor.this.logger.fine("focusRow=" + PropertyEditor.this.focusRow);
            }
        };
    }

    private KeyListener getKeyListener() {
        return new KeyAdapter(){

            public void keyReleased(KeyEvent event) {
                PropertyEditor.this.logger.fine(String.valueOf(event));
                if (event.getKeyCode() == 39) {
                    TreeTableModel model = (TreeTableModel)PropertyEditor.this.table.getModel();
                    model.expand(PropertyEditor.this.focusRow);
                } else if (event.getKeyCode() == 37) {
                    TreeTableModel model = (TreeTableModel)PropertyEditor.this.table.getModel();
                    model.collapse(PropertyEditor.this.focusRow);
                }
            }
        };
    }

    private Action createSaveAction(final Object bean) {
        return new AbstractAction("Save"){

            public void actionPerformed(ActionEvent ev) {
                try {
                    JFileChooser chooser = new JFileChooser();
                    chooser.setFileFilter(new FileFilter(){

                        public boolean accept(File f) {
                            return f.toString().matches(".*\\.das2PropertySheet");
                        }

                        public String getDescription() {
                            return "*.das2PropertySheet";
                        }
                    });
                    chooser.setSelectedFile(new File("default.das2PropertySheet"));
                    int result = chooser.showSaveDialog(PropertyEditor.this);
                    if (result == 0) {
                        Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
                        Element element = SerializeUtil.getDOMElement(document, bean);
                        document.appendChild(element);
                        FileOutputStream out = new FileOutputStream(chooser.getSelectedFile());
                        StringWriter writer = new StringWriter();
                        DOMImplementation impl = document.getImplementation();
                        DOMImplementationLS ls = (DOMImplementationLS)impl.getFeature("LS", "3.0");
                        LSSerializer serializer = ls.createLSSerializer();
                        LSOutput output = ls.createLSOutput();
                        output.setEncoding("UTF-8");
                        output.setByteStream(out);
                        serializer.write(document, output);
                        ((OutputStream)out).close();
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    private static Document readDocument(File file) throws IOException, ParserConfigurationException, SAXException {
        FileInputStream in = new FileInputStream(file);
        InputSource source = new InputSource();
        source.setCharacterStream(new InputStreamReader(in));
        ErrorHandler eh = null;
        DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = domFactory.newDocumentBuilder();
        builder.setErrorHandler(eh);
        Document document = builder.parse(source);
        return document;
    }

    private Action createLoadAction(final Object bean) {
        return new AbstractAction("Load"){

            public void actionPerformed(ActionEvent ev) {
                block6: {
                    try {
                        JFileChooser chooser = new JFileChooser();
                        chooser.setFileFilter(new FileFilter(){

                            public boolean accept(File f) {
                                return f.toString().matches(".*\\.das2PropertySheet");
                            }

                            public String getDescription() {
                                return "*.das2PropertySheet";
                            }
                        });
                        int result = chooser.showOpenDialog(PropertyEditor.this);
                        if (result != 0) break block6;
                        try {
                            Document document = PropertyEditor.readDocument(chooser.getSelectedFile());
                            Element element = document.getDocumentElement();
                            SerializeUtil.processElement(element, bean);
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                        catch (ParserConfigurationException e) {
                            throw new RuntimeException(e);
                        }
                        catch (SAXException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        };
    }

    private Action getEditSelectedAction() {
        return new AbstractAction("Edit Selected"){

            public void actionPerformed(ActionEvent e) {
                PropertyEditor p;
                TreeTableModel model = (TreeTableModel)PropertyEditor.this.table.getModel();
                PropertyTreeNodeInterface node = (PropertyTreeNodeInterface)model.getNodeForRow(PropertyEditor.this.focusRow);
                int[] selected = PropertyEditor.this.table.getSelectedRows();
                if (selected.length == 1) {
                    p = new PropertyEditor(node.getValue());
                } else {
                    Object[] peers = new Object[selected.length];
                    for (int i = 0; i < selected.length; ++i) {
                        peers[i] = ((PropertyTreeNode)model.getNodeForRow(selected[i])).getValue();
                    }
                    p = PropertyEditor.createPeersEditor(node.getValue(), peers);
                }
                p.showDialog(PropertyEditor.this);
            }
        };
    }

    private void initPopupMenu() {
        this.popupMenu = new JPopupMenu();
        this.popupMenu.add(this.getEditSelectedAction());
    }

    private void initButtonPanel(boolean saveLoadButton) {
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        if (saveLoadButton) {
            JButton saveButton = new JButton(this.createSaveAction(this.bean));
            buttonPanel.add(saveButton);
            JButton loadButton = new JButton(this.createLoadAction(this.bean));
            buttonPanel.add(loadButton);
        }
        final JButton apply = new JButton("Apply Changes");
        this.closeButton = new JButton("Dismiss");
        ActionListener al = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (e.getSource() == apply) {
                    PropertyEditor.this.globalApplyChanges();
                    PropertyEditor.this.refresh();
                } else if (e.getSource() == PropertyEditor.this.closeButton) {
                    PropertyEditor.this.dismissDialog();
                }
            }
        };
        apply.addActionListener(al);
        this.closeButton.addActionListener(al);
        JButton refresh = new JButton("Refresh");
        refresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PropertyEditor.this.refresh();
            }
        });
        buttonPanel.add(refresh);
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(apply);
        buttonPanel.add(this.closeButton);
        this.add((Component)buttonPanel, "South");
    }

    private void refresh() {
        TreeTableModel model = (TreeTableModel)this.table.getModel();
        PropertyTreeNodeInterface root = (PropertyTreeNodeInterface)model.getRoot();
        root.refresh();
        model.fireTableDataChanged();
    }

    private void globalApplyChanges() {
        TreeTableModel model = (TreeTableModel)this.table.getModel();
        PropertyTreeNodeInterface root = (PropertyTreeNodeInterface)model.getRoot();
        root.flush();
    }

    private void dismissDialog() {
        PropertyTreeNodeInterface root = (PropertyTreeNodeInterface)((TreeTableModel)this.table.getModel()).getRoot();
        if (root.isDirty()) {
            String[] message = new String[]{"You have unsaved changes", "Would you like to apply them?"};
            int result = JOptionPane.showConfirmDialog(this, message, "", 1, 3);
            if (result == 2) {
                return;
            }
            if (result == 0) {
                this.globalApplyChanges();
            }
        }
        this.dialog.setVisible(false);
        this.dialog.dispose();
    }

    public void showModalDialog(Component c) {
        Container top;
        Container container = top = c == null ? null : SwingUtilities.getAncestorOfClass(Window.class, c);
        this.dialog = top instanceof JFrame ? new JDialog((JFrame)top) : (top instanceof JDialog ? new JDialog((JDialog)top) : new JDialog());
        this.dialog.setModal(true);
        this.dialog.setDefaultCloseOperation(0);
        this.dialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                PropertyEditor.this.dismissDialog();
            }
        });
        this.dialog.setContentPane(this);
        this.dialog.pack();
        if (c != null) {
            this.dialog.setLocationRelativeTo(c);
        }
        this.dialog.setVisible(true);
    }

    public void showDialog(Component c) {
        if (this.dialog == null) {
            Container top;
            Container container = top = c == null ? null : SwingUtilities.getAncestorOfClass(Window.class, c);
            this.dialog = top instanceof JFrame ? new JDialog((JFrame)top) : (top instanceof JDialog ? new JDialog((JDialog)top) : new JDialog());
            this.dialog.setDefaultCloseOperation(0);
            this.dialog.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    PropertyEditor.this.dismissDialog();
                }
            });
            this.dialog.setContentPane(this);
            this.dialog.pack();
        }
        if (c != null) {
            this.dialog.setLocationRelativeTo(c);
        }
        this.dialog.setVisible(true);
    }

    public void doLayout() {
        if (SwingUtilities.isDescendingFrom(this, this.dialog)) {
            this.closeButton.setVisible(true);
        } else {
            this.closeButton.setVisible(false);
        }
        super.doLayout();
    }

    static {
        HashSet<Class<Object>> set = new HashSet<Class<Object>>();
        set.add(Byte.TYPE);
        set.add(Short.TYPE);
        set.add(Integer.TYPE);
        set.add(Long.TYPE);
        set.add(Float.TYPE);
        set.add(Double.TYPE);
        set.add(Boolean.TYPE);
        set.add(String.class);
        set.add(Datum.class);
        set.add(DatumRange.class);
        set.add(Color.class);
        editableTypes = Collections.unmodifiableSet(set);
    }

    class PropertyTableMouseListener
    extends MouseAdapter {
        PropertyTableMouseListener() {
        }

        public void mouseClicked(MouseEvent event) {
            Point p = event.getPoint();
            int row = PropertyEditor.this.table.rowAtPoint(p);
            int column = PropertyEditor.this.table.columnAtPoint(p);
            TreeTableModel model = (TreeTableModel)PropertyEditor.this.table.getModel();
            PropertyTreeNodeInterface node = (PropertyTreeNodeInterface)model.getNodeForRow(row);
            PropertyEditor.this.focusRow = row;
            int modifiers = event.getModifiers() & 3;
            if (event.getButton() == 1 && modifiers == 0 && !node.isLeaf()) {
                model.toggleExpanded(row);
            }
        }

        public void mousePressed(MouseEvent event) {
            Point p = event.getPoint();
            PropertyEditor.this.focusRow = PropertyEditor.this.table.rowAtPoint(p);
            if (event.getButton() == 3) {
                PropertyEditor.this.popupMenu.show(PropertyEditor.this.table, event.getX(), event.getY());
            }
        }
    }
}

