/*
 * Decompiled with CFR 0.152.
 */
package org.das2.components;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.datatransfer.StringSelection;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.das2.DasException;
import org.das2.DasIOException;
import org.das2.client.DasServer;

public class DataSetBrowser
extends JPanel
implements DragSourceListener,
DragGestureListener {
    DasServer dasServer;
    JTree tree;
    TreeModel dataSetListTreeModel;

    public DataSetBrowser(DasServer dasServer) {
        this.dasServer = dasServer;
        try {
            this.dataSetListTreeModel = dasServer.getDataSetList();
        }
        catch (DasIOException e) {
            System.out.println(e);
        }
        catch (DasException e) {
            System.out.println(e);
        }
        this.setLayout(new BorderLayout());
        this.tree = new JTree(this.dataSetListTreeModel);
        DragSource ds = DragSource.getDefaultDragSource();
        DragGestureRecognizer dgr = ds.createDefaultDragGestureRecognizer(this.tree, 3, this);
        this.add((Component)new JScrollPane(this.tree), "Center");
    }

    public String getSelectedDataSetId() {
        TreePath tp = this.tree.getLeadSelectionPath();
        TreeNode tn = (TreeNode)tp.getLastPathComponent();
        if (tn.isLeaf()) {
            String s = this.dasServer.getURL() + "?" + tp.getPathComponent(1);
            for (int index = 2; index < tp.getPathCount(); ++index) {
                s = s + "/" + tp.getPathComponent(index);
            }
            return s;
        }
        return null;
    }

    public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
    }

    public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void dragExit(DragSourceEvent dragSourceEvent) {
    }

    public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
        String s = this.getSelectedDataSetId();
        if (s != null) {
            StringSelection t = new StringSelection(s);
            dragGestureEvent.startDrag(null, t, this);
        }
    }

    public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
    }
}

