/*
 * Decompiled with CFR 0.152.
 */
package org.das2.components;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import org.das2.graph.DasCanvas;
import org.das2.graph.DasCanvasComponent;
import org.das2.system.DasLogger;
import org.das2.util.NumberFormatUtil;
import org.das2.util.monitor.ProgressMonitor;

public class DasProgressPanel
implements ProgressMonitor {
    private long taskStartedTime;
    private long currentTaskPosition;
    private long maximumTaskPosition;
    private DecimalFormat transferRateFormat;
    private String transferRateString;
    private JLabel taskLabel;
    private boolean labelDirty = false;
    private JLabel progressMessageLabel;
    private String progressMessageString;
    private boolean progressMessageDirty = false;
    private JLabel kbLabel;
    private JProgressBar progressBar;
    private JFrame jframe = null;
    private boolean isCancelled = false;
    private JButton cancelButton;
    private int cancelCheckFailures = 0;
    private boolean cancelChecked = false;
    private String label;
    private static final int hideInitiallyMilliSeconds = 300;
    private static final int refreshPeriodMilliSeconds = 500;
    private boolean running = false;
    private boolean finished = false;
    private long lastRefreshTime;
    private ArrayList refreshTimeQueue;
    private Thread updateThread;
    private Logger logger = DasLogger.getLogger(DasLogger.SYSTEM_LOG);
    private boolean showProgressRate;
    private JPanel thePanel;
    private boolean componentsInitialized = false;
    private DasCanvasComponent parentComponent;
    private DasCanvas parentCanvas;
    private static int createComponentCount = 0;
    static final boolean useDetails = false;
    Exception source;
    Exception consumer;

    public DasProgressPanel(String label) {
        this.label = label;
        this.transferRateFormat = NumberFormatUtil.getDecimalFormat();
        this.transferRateFormat.setMaximumFractionDigits(2);
        this.maximumTaskPosition = -1L;
        this.lastRefreshTime = Integer.MIN_VALUE;
        this.showProgressRate = true;
        this.isCancelled = false;
        this.running = false;
    }

    private void details() {
        System.err.println("Source: ");
        this.source.printStackTrace();
        System.err.println("Consumer: ");
        this.consumer.printStackTrace();
        if (this.finished) {
            String stateString = "finished";
        } else if (this.running) {
            String stateString = "running";
        } else if (this.isCancelled) {
            String string = "cancelled";
        }
        System.err.println("State: ");
        System.err.println("  running: " + this.running);
        System.err.println("  cancelled: " + this.isCancelled);
        System.err.println("  finished: " + this.finished);
    }

    public Component getComponent() {
        if (!this.componentsInitialized) {
            this.initComponents();
        }
        return this.thePanel;
    }

    public static DasProgressPanel createComponentPanel(DasCanvasComponent component, String initialMessage) {
        DasProgressPanel progressPanel = new DasProgressPanel(initialMessage);
        progressPanel.parentComponent = component;
        return progressPanel;
    }

    public static DasProgressPanel createComponentPanel(DasCanvas canvas, String initialMessage) {
        DasProgressPanel progressPanel = new DasProgressPanel(initialMessage);
        progressPanel.parentCanvas = canvas;
        return progressPanel;
    }

    public boolean isValidateRoot() {
        return true;
    }

    public static DasProgressPanel createFramed(String label) {
        DasProgressPanel result = new DasProgressPanel(label);
        result.jframe = new JFrame("Das Progress Monitor");
        result.initComponents();
        result.jframe.getContentPane().add(result.thePanel);
        result.jframe.pack();
        result.jframe.setVisible(false);
        result.jframe.setDefaultCloseOperation(2);
        return result;
    }

    public void setLabel(String label) {
        this.label = label;
        this.labelDirty = true;
        if (this.thePanel != null) {
            this.thePanel.repaint();
        }
    }

    public String getLabel() {
        return this.label;
    }

    private void initComponents() {
        ++createComponentCount;
        this.taskLabel = new JLabel();
        this.taskLabel.setOpaque(false);
        this.taskLabel.setFont(new Font("Dialog", 1, 18));
        this.taskLabel.setHorizontalAlignment(0);
        this.taskLabel.setText(this.label);
        this.taskLabel.setAlignmentX(0.5f);
        this.progressMessageLabel = new JLabel(){

            public void paint(Graphics g) {
                ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                super.paint(g);
            }
        };
        this.progressMessageLabel.setOpaque(false);
        this.progressMessageLabel.setFont(new Font("Dialog", 1, 8));
        this.progressMessageLabel.setHorizontalAlignment(0);
        this.progressMessageLabel.setText(" ");
        this.progressMessageLabel.setAlignmentX(0.5f);
        this.progressBar = new JProgressBar();
        this.progressBar.setOpaque(false);
        this.progressBar.setMaximumSize(this.progressBar.getPreferredSize());
        this.progressBar.setMinimumSize(this.progressBar.getPreferredSize());
        this.progressBar.setAlignmentX(0.5f);
        this.kbLabel = new JLabel();
        this.kbLabel.setOpaque(false);
        this.kbLabel.setHorizontalAlignment(0);
        this.kbLabel.setText("0 kb");
        this.kbLabel.setAlignmentX(0.5f);
        this.kbLabel.setMaximumSize(this.progressBar.getPreferredSize());
        this.kbLabel.setMinimumSize(this.progressBar.getPreferredSize());
        this.kbLabel.setPreferredSize(this.progressBar.getPreferredSize());
        this.kbLabel.setAlignmentX(0.5f);
        JPanel mainPanel = new JPanel();
        mainPanel.setOpaque(false);
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        mainPanel.add(this.taskLabel);
        mainPanel.add(this.progressMessageLabel);
        mainPanel.add(this.progressBar);
        mainPanel.add(this.kbLabel);
        LineBorder lineBorder = new LineBorder(Color.BLACK, 2);
        EmptyBorder emptyBorder = new EmptyBorder(2, 2, 2, 2);
        CompoundBorder border = new CompoundBorder(lineBorder, emptyBorder);
        this.cancelButton = new JButton("cancel");
        this.cancelButton.setEnabled(false);
        this.cancelButton.setOpaque(false);
        this.cancelButton.setBorder(border);
        this.cancelButton.setFocusPainted(false);
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DasProgressPanel.this.cancel();
            }
        });
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        buttonPanel.setOpaque(false);
        buttonPanel.add(this.cancelButton);
        this.thePanel = new MyPanel();
        this.thePanel.setOpaque(false);
        this.thePanel.setLayout(new BorderLayout());
        this.thePanel.add((Component)mainPanel, "Center");
        this.thePanel.add((Component)buttonPanel, "South");
        if (this.parentComponent != null) {
            this.thePanel.setSize(this.thePanel.getPreferredSize());
            int x = this.parentComponent.getColumn().getDMiddle();
            int y = this.parentComponent.getRow().getDMiddle();
            this.thePanel.setLocation(x - this.thePanel.getWidth() / 2, y - this.thePanel.getHeight() / 2);
            ((Container)this.parentComponent.getCanvas().getGlassPane()).add(this.thePanel);
            this.thePanel.setVisible(false);
        } else if (this.parentCanvas != null) {
            this.thePanel.setSize(this.thePanel.getPreferredSize());
            int x = this.parentCanvas.getWidth() / 2;
            int y = this.parentCanvas.getHeight() / 2;
            this.thePanel.setLocation(x - this.thePanel.getWidth() / 2, y - this.thePanel.getHeight() / 2);
            ((Container)this.parentCanvas.getGlassPane()).add(this.thePanel);
            this.thePanel.setVisible(false);
        }
        this.componentsInitialized = true;
    }

    public synchronized void finished() {
        this.running = false;
        this.finished = true;
        if (this.jframe == null) {
            this.setVisible(false);
        } else {
            this.jframe.dispose();
        }
    }

    public void setTaskProgress(long position) throws IllegalStateException {
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("progressPosition=" + position);
        }
        if (this.isCancelled) {
            this.logger.fine("setTaskProgress called when isCancelled true. consider checking isCancelled before calling setTaskProgress.");
            throw new IllegalStateException("Operation cancelled: developers: consider checking isCancelled before calling setTaskProgress.");
        }
        if (!this.running) {
            throw new IllegalStateException("setTaskProgress called before started");
        }
        if (position != 0L && position < this.currentTaskPosition) {
            this.logger.finest("progress position goes backwards");
        }
        if (!this.cancelChecked) {
            ++this.cancelCheckFailures;
        }
        this.cancelChecked = false;
        if (this.maximumTaskPosition == 0L) {
            throw new IllegalArgumentException("when taskSize is 0, setTaskProgress must not be called.");
        }
        this.currentTaskPosition = position;
        long elapsedTimeMs = System.currentTimeMillis() - this.taskStartedTime;
        if (elapsedTimeMs > 300L && !this.isVisible()) {
            this.setVisible(true);
        }
    }

    private void startUpdateThread() {
        Runnable run = new Runnable(){

            public void run() {
                while (!DasProgressPanel.this.finished) {
                    try {
                        SwingUtilities.invokeAndWait(new Runnable(){

                            public void run() {
                                DasProgressPanel.this.updateUIComponents();
                                DasProgressPanel.this.thePanel.repaint();
                            }
                        });
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger(DasProgressPanel.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    catch (InvocationTargetException ex) {
                        Logger.getLogger(DasProgressPanel.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            }
        };
        this.updateThread = new Thread(run, "progressMonitorUpdateThread");
        this.updateThread.start();
    }

    private void updateUIComponents() {
        boolean cancelEnabled;
        long elapsedTimeMs = System.currentTimeMillis() - this.taskStartedTime;
        long kb = this.currentTaskPosition;
        if (this.maximumTaskPosition == -1L) {
            this.progressBar.setIndeterminate(true);
        } else {
            this.progressBar.setIndeterminate(false);
        }
        if (this.maximumTaskPosition > 0L) {
            this.progressBar.setValue((int)(kb * 100L / this.maximumTaskPosition));
        } else {
            this.progressBar.setValue((int)kb % 100);
        }
        String bytesReadLabel = this.maximumTaskPosition > 0L ? "" + kb + "/" + this.maximumTaskPosition + "" : "" + kb + "";
        if (this.progressMessageDirty) {
            if (this.progressMessageString.length() > 33) {
                int n = this.progressMessageString.length();
                this.progressMessageString = this.progressMessageString.substring(0, 10) + "..." + this.progressMessageString.substring(n - 22, n);
            }
            this.progressMessageLabel.setText(this.progressMessageString);
            this.progressMessageDirty = false;
        }
        if (this.labelDirty) {
            this.taskLabel.setText(this.label);
            this.labelDirty = false;
        }
        if (this.showProgressRate && elapsedTimeMs > 1000L && this.transferRateString != null) {
            double transferRate = (double)this.currentTaskPosition * 1000.0 / (double)elapsedTimeMs;
            this.kbLabel.setText(bytesReadLabel + " " + this.transferRateString);
        } else {
            this.kbLabel.setText(bytesReadLabel);
        }
        boolean bl = cancelEnabled = this.cancelCheckFailures < 2;
        if (cancelEnabled != this.cancelButton.isEnabled()) {
            this.cancelButton.setEnabled(cancelEnabled);
        }
    }

    @Deprecated
    public void setAdditionalInfo(String s) {
        this.transferRateString = s;
    }

    public long getTaskProgress() {
        return this.currentTaskPosition;
    }

    public long getTaskSize() {
        return this.maximumTaskPosition;
    }

    public void setTaskSize(long taskSize) {
        if (taskSize < -1L) {
            throw new IllegalArgumentException("taskSize must be positive, -1, or 0, not " + taskSize);
        }
        if (this.componentsInitialized) {
            this.progressBar.setIndeterminate(false);
        }
        this.maximumTaskPosition = taskSize;
    }

    public synchronized void setVisible(boolean visible) {
        if (!this.componentsInitialized && !visible) {
            return;
        }
        if (!this.componentsInitialized && !this.finished) {
            this.initComponents();
        }
        if (this.thePanel != null) {
            this.thePanel.setVisible(visible);
        }
        if (this.jframe != null) {
            this.jframe.setVisible(visible);
        }
        if (visible) {
            this.startUpdateThread();
        }
    }

    public boolean isVisible() {
        return !this.componentsInitialized || this.thePanel.isVisible();
    }

    public void started() {
        this.taskStartedTime = System.currentTimeMillis();
        this.running = true;
        this.setVisible(false);
        new Thread(new Runnable(){

            public void run() {
                try {
                    Thread.sleep(300L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (DasProgressPanel.this.running) {
                    DasProgressPanel.this.logger.fine("hide time=" + (System.currentTimeMillis() - DasProgressPanel.this.taskStartedTime));
                    DasProgressPanel.this.setVisible(true);
                }
            }
        }, "progressPanelUpdateThread").start();
        if (this.isCancelled) {
            return;
        }
        if (this.maximumTaskPosition > 0L) {
            this.setTaskProgress(0L);
        }
    }

    public void cancel() {
        this.isCancelled = true;
        this.finished();
    }

    public boolean isCancelled() {
        this.cancelCheckFailures = 0;
        this.cancelChecked = true;
        return this.isCancelled;
    }

    public Exception getSource() {
        return this.source;
    }

    public Exception getConsumer() {
        return this.consumer;
    }

    public void setShowProgressRate(boolean showProgressRate) {
        this.showProgressRate = showProgressRate;
    }

    public String toString() {
        if (this.isCancelled) {
            return "cancelled";
        }
        if (this.finished) {
            return "finished";
        }
        if (this.running) {
            return "" + this.currentTaskPosition + " of " + this.maximumTaskPosition;
        }
        return "waiting for start";
    }

    public void setProgressMessage(String message) {
        this.progressMessageString = message;
        this.progressMessageDirty = true;
    }

    public boolean isStarted() {
        return this.running;
    }

    public boolean isFinished() {
        return this.finished;
    }

    class MyPanel
    extends JPanel {
        MyPanel() {
        }

        protected void paintComponent(Graphics g1) {
            Graphics2D g2 = (Graphics2D)g1;
            g2.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED);
            g2.setColor(new Color(-587202561, true));
            Rectangle rect = g2.getClipBounds();
            if (rect == null) {
                g2.fillRect(0, 0, this.getWidth(), this.getHeight());
            } else {
                g2.fillRect(rect.x, rect.y, rect.width, rect.height);
            }
            super.paintComponent(g1);
        }
    }
}

